<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObShadingProp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObShadingProp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Mon May 30 09:59:32 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObShadingProp.i3">ObShadingProp</A></implements></module>;

IMPORT <A HREF="ObAnimHandle.i3">ObAnimHandle</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObLongReal.i3">ObLongReal</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObReal.i3">ObReal</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/Prop.i3">Prop</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../anim3D/src/ShadingProp.i3">ShadingProp</A>,
       <A HREF="../../anim3D/src/ShadingPropProxy.i3">ShadingPropProxy</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../text/src/Text.i3">Text</A>;
</PRE>***************************************************************************
 Wrapper for ShadingProp.Kind                                              
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="NewKind"><procedure>NewKind</procedure></A> (kind : ShadingProp.Kind) : ObValue.Val =
  BEGIN
    CASE kind OF
    | ShadingProp.Kind.Flat       =&gt; RETURN Obliq.NewText (&quot;Flat&quot;);
    | ShadingProp.Kind.Gouraud    =&gt; RETURN Obliq.NewText (&quot;Gouraud&quot;);
    END;
  END NewKind;

EXCEPTION BadKind(TEXT);

PROCEDURE <A NAME="KindToM3"><procedure>KindToM3</procedure></A> (val : ObValue.Val) : ShadingProp.Kind
    RAISES {BadKind} =
  BEGIN
    TYPECASE val OF
    | ObValue.ValText (node) =&gt;
      IF Text.Equal (node.text, &quot;Flat&quot;) THEN
        RETURN ShadingProp.Kind.Flat;
      ELSIF Text.Equal (node.text, &quot;Gouraud&quot;) THEN
        RETURN ShadingProp.Kind.Gouraud;
      ELSE
        RAISE BadKind(&quot;Unknown Shading&quot;);
      END;
    ELSE
      RAISE BadKind(&quot;Shading must be a Text&quot;);
    END;
  END KindToM3;

PROCEDURE <A NAME="GetKind"><procedure>GetKind</procedure></A> (args    : ObValue.ArgArray;
                   idx     : INTEGER;
                   package : ObLib.T;
                   opCode  : ObLib.OpCode;
                   loc     : SynLocation.T) : ShadingProp.Kind
    RAISES {ObValue.Error} =
  BEGIN
    TRY
      RETURN KindToM3 (args[idx]);
    EXCEPT
    | BadKind =&gt;
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN ShadingProp.Kind.Flat; (*  to suppress compiler warning *)
    END;
  END GetKind;
</PRE>***************************************************************************
 Wrapper for ShadingProp.Name                                              
***************************************************************************

<P><PRE>TYPE
  Name = ObProp.Name BRANDED &quot;ObShadingProp.Name&quot; OBJECT END;

PROCEDURE <A NAME="AddNameObj"><procedure>AddNameObj</procedure></A> (pn : ShadingProp.Name) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {NameProto}),
         raw = NEW (Name, what := &quot;&lt;a ShadingProp.Name&gt;&quot;, po := pn) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pn.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddNameObj;

PROCEDURE <A NAME="GetName"><procedure>GetName</procedure></A> (args    : ObValue.ArgArray;
                   idx     : INTEGER;
                   package : ObLib.T;
                   opCode  : ObLib.OpCode;
                   loc     : SynLocation.T) : ShadingProp.Name
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Name (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetName;
</PRE>***************************************************************************
 Wrapper for ShadingProp.Val                                               
***************************************************************************

<P>
<P><PRE>TYPE
  Val = ObProp.Val BRANDED &quot;ObShadingProp.Val&quot; OBJECT END;

PROCEDURE <A NAME="AddValObj"><procedure>AddValObj</procedure></A> (pv : ShadingProp.Val) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {ValProto}),
         raw = NEW (Val, what := &quot;&lt;a ShadingProp.Val&gt;&quot;, po := pv) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pv.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddValObj;

PROCEDURE <A NAME="GetVal"><procedure>GetVal</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : ShadingProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Val (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetVal;

PROCEDURE <A NAME="GetOverloadedVal"><procedure>GetOverloadedVal</procedure></A> (args    : ObValue.ArgArray;
                            idx     : INTEGER;
                            package : ObLib.T;
                            opCode  : ObLib.OpCode;
                            loc     : SynLocation.T) : ShadingProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    TYPECASE args[idx] OF
    | ObValue.ValText (node) =&gt;
      IF Text.Equal (node.text, &quot;Flat&quot;) THEN
        RETURN ShadingProp.NewConst (ShadingProp.Kind.Flat);
      ELSIF Text.Equal (node.text, &quot;Gouraud&quot;) THEN
        RETURN ShadingProp.NewConst (ShadingProp.Kind.Gouraud);
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    | ObValue.ValObj =&gt;
      WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
        TYPECASE raw OF
        | Val (node) =&gt;
          RETURN node.po;
        ELSE
          ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
          RETURN NIL;      (* ... only to suppress compiler warning *)
        END;
      END;
    ELSE
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN NIL;   (* ... only to suppress compiler warning *)
    END;
  END GetOverloadedVal;
</PRE>***************************************************************************
 Wrapper for ShadingProp.Beh                                               
***************************************************************************

<P><PRE>TYPE
  Beh = ObProp.Beh BRANDED &quot;ObShadingProp.Beh&quot; OBJECT END;

PROCEDURE <A NAME="GetBeh"><procedure>GetBeh</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : ShadingProp.Beh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Beh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetBeh;
</PRE>***************************************************************************
 Wrapper for ShadingProp.ConstBeh                                          
***************************************************************************

<P>
<P><PRE>TYPE
  ConstBeh = Beh BRANDED &quot;ObShadingProp.ConstBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddConstBehObj"><procedure>AddConstBehObj</procedure></A> (beh : ShadingProp.ConstBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {ConstBehProto}),
         raw = NEW (ConstBeh, what := &quot;&lt;a ShadingProp.ConstBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddConstBehObj;

PROCEDURE <A NAME="GetConstBeh"><procedure>GetConstBeh</procedure></A> (args    : ObValue.ArgArray;
                       idx     : INTEGER;
                       package : ObLib.T;
                       opCode  : ObLib.OpCode;
                       loc     : SynLocation.T) : ShadingProp.ConstBeh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | ConstBeh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetConstBeh;
</PRE>***************************************************************************
 Wrapper for ShadingProp.SyncBeh                                           
***************************************************************************

<P>
<P><PRE>TYPE
  SyncBeh = Beh BRANDED &quot;ObShadingProp.SyncBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddSyncBehObj"><procedure>AddSyncBehObj</procedure></A> (beh : ShadingProp.SyncBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {SyncBehProto}),
         raw = NEW (SyncBeh, what := &quot;&lt;a ShadingProp.SyncBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddSyncBehObj;

PROCEDURE <A NAME="GetSyncBeh"><procedure>GetSyncBeh</procedure></A> (args    : ObValue.ArgArray;
                       idx     : INTEGER;
                       package : ObLib.T;
                       opCode  : ObLib.OpCode;
                       loc     : SynLocation.T) : ShadingProp.SyncBeh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | SyncBeh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetSyncBeh;
</PRE>***************************************************************************
 Wrapper for ShadingProp.AsyncBeh                                          
***************************************************************************

<P>
<P><PRE>TYPE
  AsyncBeh = Beh BRANDED &quot;ObShadingProp.AsyncBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddAsyncBehObj"><procedure>AddAsyncBehObj</procedure></A> (beh : ShadingProp.AsyncBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {AsyncBehProto}),
         raw = NEW (AsyncBeh, what := &quot;&lt;a ShadingProp.AsyncBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (AsyncBehProxy, obj := obj);
    END;
  END AddAsyncBehObj;

TYPE
  AsyncBehProxy = ShadingPropProxy.AsyncBehProxy BRANDED OBJECT
  OVERRIDES
    compute := AsyncBehCompute;
  END;

PROCEDURE <A NAME="AsyncBehCompute"><procedure>AsyncBehCompute</procedure></A> (proxy : AsyncBehProxy;
                           time  : LONGREAL) : ShadingProp.Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {Obliq.NewReal (time)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;compute&quot;, args) DO
        RETURN KindToM3 (res);
      END;
    EXCEPT
    | BadKind (msg) =&gt;
      RAISE Prop.BadMethod (msg);
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END AsyncBehCompute;
</PRE>***************************************************************************
 Wrapper for ShadingProp.DepBeh                                            
***************************************************************************

<P>
<P><PRE>TYPE
  DepBeh = Beh BRANDED &quot;ObShadingProp.DepBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddDepBehObj"><procedure>AddDepBehObj</procedure></A> (beh : ShadingProp.DepBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {DepBehProto}),
         raw = NEW (DepBeh, what := &quot;&lt;a ShadingProp.DepBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (DepBehProxy, obj := obj);
    END;
  END AddDepBehObj;

TYPE
  DepBehProxy = ShadingPropProxy.DepBehProxy BRANDED OBJECT
  OVERRIDES
    compute := DepBehCompute;
  END;

PROCEDURE <A NAME="DepBehCompute"><procedure>DepBehCompute</procedure></A> (proxy : DepBehProxy;
                         time  : LONGREAL) : ShadingProp.Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {Obliq.NewReal (time)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;compute&quot;, args) DO
        RETURN KindToM3 (res);
      END;
    EXCEPT
    | BadKind (msg) =&gt;
      RAISE Prop.BadMethod (msg);
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END DepBehCompute;
</PRE>***************************************************************************
 Wrapper for ShadingProp.Request                                           
***************************************************************************

<P>
<P><PRE>TYPE
  Request = ObProp.Request BRANDED &quot;ObShadingProp.Request&quot; OBJECT END;

PROCEDURE <A NAME="AddRequestObj"><procedure>AddRequestObj</procedure></A> (req : ShadingProp.Request) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {RequestProto}),
         raw = NEW (Request, what := &quot;&lt;a ShadingProp.Request&gt;&quot;, po := req) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      req.proxy := NEW (RequestProxy, obj := obj);
    END;
  END AddRequestObj;

PROCEDURE <A NAME="GetRequest"><procedure>GetRequest</procedure></A> (args    : ObValue.ArgArray;
                      idx     : INTEGER;
                      package : ObLib.T;
                      opCode  : ObLib.OpCode;
                      loc     : SynLocation.T) : ShadingProp.Request
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Request (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetRequest;

TYPE
  RequestProxy = ShadingPropProxy.RequestProxy BRANDED OBJECT
  OVERRIDES
    value := RequestValue;
  END;

PROCEDURE <A NAME="RequestValue"><procedure>RequestValue</procedure></A> (proxy    : RequestProxy;
                        startval : ShadingProp.Kind;
                        reltime  : REAL) : ShadingProp.Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {NewKind (startval), ObReal.M3ToObliq (reltime)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;value&quot;, args) DO
        RETURN KindToM3 (res);
      END;
    EXCEPT
    | BadKind (msg) =&gt;
      RAISE Prop.BadMethod (msg);
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END RequestValue;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes := NEW (REF OpCodes, NUMBER (Code));
  BEGIN
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;NameBind&quot;,           2, Code.NameBind),
            NewOpCode (&quot;ValGetBeh&quot;,          1, Code.ValGetBeh),
            NewOpCode (&quot;ValSetBeh&quot;,          2, Code.ValSetBeh),
            NewOpCode (&quot;ValGet&quot;,             1, Code.ValGet),
            NewOpCode (&quot;ValValue&quot;,           2, Code.ValValue),
            NewOpCode (&quot;NewConst&quot;,           1, Code.NewConst),
            NewOpCode (&quot;NewSync&quot;,            2, Code.NewSync),
            NewOpCode (&quot;NewAsync&quot;,           1, Code.NewAsync),
            NewOpCode (&quot;NewDep&quot;,             1, Code.NewDep),
            NewOpCode (&quot;ConstBehSet&quot;,        2, Code.ConstBehSet),
            NewOpCode (&quot;NewConstBeh&quot;,        1, Code.NewConstBeh),
            NewOpCode (&quot;SyncBehAddRequest&quot;,  2, Code.SyncBehAddRequest),
            NewOpCode (&quot;SyncBehChange&quot;,      3, Code.SyncBehChange),
            NewOpCode (&quot;NewSyncBeh&quot;,         2, Code.NewSyncBeh),
            NewOpCode (&quot;NewAsyncBeh&quot;,        1, Code.NewAsyncBeh),
            NewOpCode (&quot;NewDepBeh&quot;,          1, Code.NewDepBeh),
            NewOpCode (&quot;NewRequest&quot;,         3, Code.NewRequest)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  NameProto     : ObValue.Val;
  ValProto      : ObValue.Val;
  ConstBehProto : ObValue.Val;
  SyncBehProto  : ObValue.Val;
  AsyncBehProto : ObValue.Val;
  DepBehProto   : ObValue.Val;
  RequestProto  : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** retrieve the prototypes ***)
    loader.load (&quot;ShadingProp.obl&quot;);
    NameProto     := loader.get (&quot;ShadingProp_NameProto&quot;);
    ValProto      := loader.get (&quot;ShadingProp_ValProto&quot;);
    ConstBehProto := loader.get (&quot;ShadingProp_ConstBehProto&quot;);
    SyncBehProto  := loader.get (&quot;ShadingProp_SyncBehProto&quot;);
    AsyncBehProto := loader.get (&quot;ShadingProp_AsyncBehProto&quot;);
    DepBehProto   := loader.get (&quot;ShadingProp_DepBehProto&quot;);
    RequestProto  := loader.get (&quot;ShadingProp_RequestProto&quot;);

    (*** Register the proxy makers ***)
    ShadingPropProxy.NamePM     := AddNameObj;
    ShadingPropProxy.ValPM      := AddValObj;
    ShadingPropProxy.ConstBehPM := AddConstBehObj;
    ShadingPropProxy.SyncBehPM  := AddSyncBehObj;
    ShadingPropProxy.AsyncBehPM := AddAsyncBehObj;
    ShadingPropProxy.DepBehPM   := AddDepBehObj;
    ShadingPropProxy.RequestPM  := AddRequestObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {NameBind,
          ValGetBeh, ValSetBeh, ValGet, ValValue,
             NewConst, NewSync, NewAsync, NewDep,
          ConstBehSet, NewConstBeh,
          SyncBehAddRequest, SyncBehChange, NewSyncBeh,
          NewAsyncBeh,
          NewDepBeh,
          NewRequest};

  OpCode = ObLib.OpCode BRANDED OBJECT
    code: Code;
  END;

  Package = ObLib.T BRANDED OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

CONST
  pkgname = &quot;ShadingProp&quot;;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.NameBind =&gt;
      WITH pn   = GetName (args, 1, self, opCode, loc),
           pv   = GetVal  (args, 2, self, opCode, loc),
           prop = pn.bind (pv) DO
        RETURN prop.proxy.obj;
      END;
    | Code.ValGetBeh =&gt;
      WITH pv = GetVal (args, 1, self, opCode, loc) DO
        RETURN pv.beh.proxy.obj;
      END;
    | Code.ValSetBeh =&gt;
      WITH pv  = GetVal (args, 1, self, opCode, loc),
           beh = GetBeh (args, 2, self, opCode, loc) DO
        pv.beh := beh;
        RETURN ObValue.valOk;
      END;
    | Code.ValGet =&gt;
      WITH pv = GetVal (args, 1, self, opCode, loc) DO
        TRY
          RETURN NewKind (pv.get ());
        EXCEPT
        | Prop.BadMethod =&gt;
          ObValue.RaiseException (ObProp.BadMethod, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.ValValue =&gt;
      WITH pv   = GetVal (args, 1, self, opCode, loc),
           time = ObLongReal.GetArg (args, 2, self, opCode, loc) DO
        TRY
          RETURN NewKind (pv.value (time));
        EXCEPT
        | Prop.BadMethod =&gt;
          ObValue.RaiseException (ObProp.BadMethod, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.NewConst =&gt;
      (*** AddValObj creates the actual Obliq object ***)
      WITH lt  = GetKind (args, 1, self, opCode, loc),
           val = ShadingProp.NewConst (lt) DO
        RETURN val.proxy.obj;
      END;
    | Code.NewSync =&gt;
      WITH ah  = ObAnimHandle.GetT (args, 1, self, opCode, loc),
           lt  = GetKind (args, 2, self, opCode, loc),
           val = ShadingProp.NewSync (ah, lt) DO
        RETURN val.proxy.obj;
      END;
    | Code.NewAsync =&gt;
      WITH beh = NEW (ShadingProp.AsyncBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        WITH val = ShadingProp.NewAsync (beh) DO
          RETURN val.proxy.obj;
        END;
      END;
    | Code.NewDep =&gt;
      WITH beh = NEW (ShadingProp.DepBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        WITH val = ShadingProp.NewDep (beh) DO
          RETURN val.proxy.obj;
        END;
      END;
    | Code.ConstBehSet =&gt;
      WITH beh = GetConstBeh (args, 1, self, opCode, loc),
           lt  = GetKind     (args, 2, self, opCode, loc) DO
        beh.set (lt);
        RETURN ObValue.valOk;
      END;
    | Code.NewConstBeh =&gt;
      WITH lt  = GetKind (args, 1, self, opCode, loc),
           beh = NEW (ShadingProp.ConstBeh).init (lt) DO
        RETURN beh.proxy.obj;
      END;
    | Code.SyncBehAddRequest =&gt;
      WITH beh = GetSyncBeh (args, 1, self, opCode, loc),
           req = GetRequest (args, 2, self, opCode, loc) DO
        TRY
          beh.addRequest (req);
        EXCEPT
        | Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehChange =&gt;
      WITH beh   = GetSyncBeh    (args, 1, self, opCode, loc),
           lt    = GetKind       (args, 2, self, opCode, loc),
           start = ObReal.GetArg (args, 3, self, opCode, loc) DO
        TRY
          beh.change (lt, start);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.NewSyncBeh =&gt;
      WITH ah  = ObAnimHandle.GetT (args, 1, self, opCode, loc),
           lt  = GetKind           (args, 2, self, opCode, loc),
           beh = NEW (ShadingProp.SyncBeh).init (ah, lt) DO
        RETURN beh.proxy.obj;
      END;
    | Code.NewAsyncBeh =&gt;
      WITH beh = NEW (ShadingProp.AsyncBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        RETURN obj;
      END;
    | Code.NewDepBeh =&gt;
      WITH beh   = NEW (ShadingProp.DepBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        RETURN obj;
      END;
    | Code.NewRequest =&gt;
      WITH start = ObReal.GetArg (args, 1, self, opCode, loc),
           dur   = ObReal.GetArg (args, 2, self, opCode, loc),
           req   = NEW (ShadingProp.Request).init (start, dur),
           obj   = NARROW (req.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;value&quot;, args[3]);
        RETURN obj;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObShadingProp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
