<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObSphereGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObSphereGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObSphereGO.i3">ObSphereGO</A></implements></module>;

IMPORT <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="ObInt.i3">ObInt</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRealProp.i3">ObRealProp</A>, <A HREF="ObSurfaceGO.i3">ObSurfaceGO</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>,
       <A HREF="../../anim3D/src/SphereGO.i3">SphereGO</A>, <A HREF="../../anim3D/src/SphereGOProxy.i3">SphereGOProxy</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;SphereGO&quot;;
</PRE>***************************************************************************
 Wrapper for SphereGO.T                                                    
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObSurfaceGO.T BRANDED &quot;ObSphereGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (sphere : SphereGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a SphereGO.T&gt;&quot;, po := sphere) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      sphere.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,         2, Code.New),
            NewOpCode (&quot;NewWithPrec&quot;, 3, Code.NewWithPrec),
            NewOpCode (&quot;Center&quot;,     -1, Code.Center),
            NewOpCode (&quot;Radius&quot;,     -1, Code.Radius),
            NewOpCode (&quot;SetCenter&quot;,   2, Code.SetCenter),
            NewOpCode (&quot;SetRadius&quot;,   2, Code.SetRadius)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    (* DONT KNOW YET WHETHER TO INHIBIT TRANSMISSIONS ... *)

  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;SphereGO.obl&quot;);
    TProto := loader.get (&quot;SphereGO_TProto&quot;);

    (*** Register the proxy maker ***)
    SphereGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, NewWithPrec, Center, Radius, SetCenter, SetRadius};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH p = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           r = ObRealProp.GetOverloadedVal  (args, 2, self, opCode, loc),
           sphere = NEW (SphereGO.T).init () DO
        sphere.setProp (SphereGO.Center.bind (p));
        sphere.setProp (SphereGO.Radius.bind (r));
        RETURN sphere.proxy.obj;
      END;
    | Code.NewWithPrec =&gt;
      WITH p    = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           r    = ObRealProp.GetOverloadedVal  (args, 2, self, opCode, loc),
           prec = ObInt.GetArg                 (args, 3, self, opCode, loc),
           sphere = NEW (SphereGO.T).init (prec) DO
        sphere.setProp (SphereGO.Center.bind (p));
        sphere.setProp (SphereGO.Radius.bind (r));
        RETURN sphere.proxy.obj;
      END;
    | Code.Center =&gt;
      RETURN ObProp.NameToObliq (SphereGO.Center);
    | Code.Radius =&gt;
      RETURN ObProp.NameToObliq (SphereGO.Radius);
    | Code.SetCenter =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SphereGO.Center.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetRadius =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SphereGO.Radius.bind (r));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObSphereGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
