<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObSpotLightGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObSpotLightGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat Mar  5 19:39:31 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObSpotLightGO.i3">ObSpotLightGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/LightGO.i3">LightGO</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObColorProp.i3">ObColorProp</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObLightGO.i3">ObLightGO</A>,
       <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRealProp.i3">ObRealProp</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>,
       <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../anim3D/src/SpotLightGO.i3">SpotLightGO</A>, <A HREF="../../anim3D/src/SpotLightGOProxy.i3">SpotLightGOProxy</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;SpotLightGO&quot;;
</PRE>***************************************************************************
 Wrapper for SpotLightGO.T                                                 
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObLightGO.T BRANDED &quot;ObSpotLightGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (light : SpotLightGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a SpotLightGO.T&gt;&quot;, po := light) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      light.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name : TEXT; arity : INTEGER; code : Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,              7, Code.New),
            NewOpCode (&quot;Origin&quot;,          -1, Code.Origin),
            NewOpCode (&quot;SetOrigin&quot;,        2, Code.SetOrigin),
            NewOpCode (&quot;Direction&quot;,       -1, Code.Direction),
            NewOpCode (&quot;SetDirection&quot;,     2, Code.SetDirection),
            NewOpCode (&quot;Concentration&quot;,   -1, Code.Concentration),
            NewOpCode (&quot;SetConcentration&quot;, 2, Code.SetConcentration),
            NewOpCode (&quot;SpreadAngle&quot;,     -1, Code.SpreadAngle),
            NewOpCode (&quot;SetSpreadAngle&quot;,   2, Code.SetSpreadAngle),
            NewOpCode (&quot;Attenuation0&quot;,    -1, Code.Attenuation0),
            NewOpCode (&quot;SetAttenuation0&quot;,  2, Code.SetAttenuation0),
            NewOpCode (&quot;Attenuation1&quot;,    -1, Code.Attenuation1),
            NewOpCode (&quot;SetAttenuation1&quot;,  2, Code.SetAttenuation1)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;SpotLightGO.obl&quot;);
    TProto := loader.get (&quot;SpotLightGO_TProto&quot;);

    (*** Register the proxy maker ***)
    SpotLightGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New,
          Origin,        SetOrigin,
          Direction,     SetDirection,
          Concentration, SetConcentration,
          SpreadAngle,   SetSpreadAngle,
          Attenuation0,  SetAttenuation0,
          Attenuation1,  SetAttenuation1};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH color  = ObColorProp.GetOverloadedVal(args, 1, self, opCode, loc),
           origin = ObPointProp.GetOverloadedVal(args, 2, self, opCode, loc),
           dir    = ObPointProp.GetOverloadedVal(args, 3, self, opCode, loc),
           conc   = ObRealProp.GetOverloadedVal (args, 4, self, opCode, loc),
           spread = ObRealProp.GetOverloadedVal (args, 5, self, opCode, loc),
           att0   = ObRealProp.GetOverloadedVal (args, 6, self, opCode, loc),
           att1   = ObRealProp.GetOverloadedVal (args, 7, self, opCode, loc),
           light  = NEW (SpotLightGO.T).init () DO
        light.setProp (LightGO.Colour.bind (color));
        light.setProp (SpotLightGO.Origin.bind (origin));
        light.setProp (SpotLightGO.Direction.bind (dir));
        light.setProp (SpotLightGO.Concentration.bind (conc));
        light.setProp (SpotLightGO.SpreadAngle.bind (spread));
        light.setProp (SpotLightGO.Attenuation0.bind (att0));
        light.setProp (SpotLightGO.Attenuation1.bind (att1));
        RETURN light.proxy.obj;
      END;
    | Code.Origin =&gt;
      RETURN ObProp.NameToObliq (SpotLightGO.Origin);
    | Code.SetOrigin =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SpotLightGO.Origin.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.Direction =&gt;
      RETURN ObProp.NameToObliq (SpotLightGO.Direction);
    | Code.SetDirection =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SpotLightGO.Direction.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.Concentration =&gt;
      RETURN ObProp.NameToObliq (SpotLightGO.Concentration);
    | Code.SetConcentration =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SpotLightGO.Concentration.bind (r));
        RETURN ObValue.valOk;
      END;
    | Code.SpreadAngle =&gt;
      RETURN ObProp.NameToObliq (SpotLightGO.SpreadAngle);
    | Code.SetSpreadAngle =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SpotLightGO.SpreadAngle.bind (r));
        RETURN ObValue.valOk;
      END;
    | Code.Attenuation0 =&gt;
      RETURN ObProp.NameToObliq (SpotLightGO.Attenuation0);
    | Code.SetAttenuation0 =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SpotLightGO.Attenuation0.bind (r));
        RETURN ObValue.valOk;
      END;
    | Code.Attenuation1 =&gt;
      RETURN ObProp.NameToObliq (SpotLightGO.Attenuation1);
    | Code.SetAttenuation1 =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SpotLightGO.Attenuation1.bind (r));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObSpotLightGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
