<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObSurfaceGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObSurfaceGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObSurfaceGO.i3">ObSurfaceGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/GO.i3">GO</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObBooleanProp.i3">ObBooleanProp</A>, <A HREF="ObColorProp.i3">ObColorProp</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>,
       <A HREF="ObLineTypeProp.i3">ObLineTypeProp</A>, <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRasterModeProp.i3">ObRasterModeProp</A>, <A HREF="ObRealProp.i3">ObRealProp</A>,
       <A HREF="ObShadingProp.i3">ObShadingProp</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../anim3D/src/SurfaceGO.i3">SurfaceGO</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;SurfaceGO&quot;;
</PRE>***************************************************************************
 Wrapper for SurfaceGO.T                                                   
***************************************************************************

<P>
<P><PRE>REVEAL
  <A NAME="T">T</A> = ObGO.T BRANDED &quot;ObSurfaceGO.T&quot; OBJECT END;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;Color&quot;,
                       -1, Code.Color),
            NewOpCode (&quot;GetColor&quot;,
                        1, Code.GetColor),
            NewOpCode (&quot;SetColor&quot;,
                        2, Code.SetColor),
            NewOpCode (&quot;RasterMode&quot;,
                       -1, Code.RasterMode),
            NewOpCode (&quot;SetRasterMode&quot;,
                        2, Code.SetRasterMode),
            NewOpCode (&quot;AmbientReflectionCoeff&quot;,
                       -1, Code.AmbientReflectionCoeff),
            NewOpCode (&quot;SetAmbientReflectionCoeff&quot;,
                        2, Code.SetAmbientReflectionCoeff),
            NewOpCode (&quot;DiffuseReflectionCoeff&quot;,
                       -1, Code.DiffuseReflectionCoeff),
            NewOpCode (&quot;SetDiffuseReflectionCoeff&quot;,
                        2, Code.SetDiffuseReflectionCoeff),
            NewOpCode (&quot;SpecularReflectionCoeff&quot;,
                       -1, Code.SpecularReflectionCoeff),
            NewOpCode (&quot;SetSpecularReflectionCoeff&quot;,
                        2, Code.SetSpecularReflectionCoeff),
            NewOpCode (&quot;SpecularReflectionConc&quot;,
                       -1, Code.SpecularReflectionConc),
            NewOpCode (&quot;SetSpecularReflectionConc&quot;,
                        2, Code.SetSpecularReflectionConc),
            NewOpCode (&quot;TransmissionCoeff&quot;,
                       -1, Code.TransmissionCoeff),
            NewOpCode (&quot;SetTransmissionCoeff&quot;,
                        2, Code.SetTransmissionCoeff),
            NewOpCode (&quot;SpecularReflectionColor&quot;,
                       -1, Code.SpecularReflectionColor),
            NewOpCode (&quot;SetSpecularReflectionColor&quot;,
                        2, Code.SetSpecularReflectionColor),
            NewOpCode (&quot;Lighting&quot;,
                       -1, Code.Lighting),
            NewOpCode (&quot;SetLighting&quot;,
                        2, Code.SetLighting),
            NewOpCode (&quot;Shading&quot;,
                       -1, Code.Shading),
            NewOpCode (&quot;SetShading&quot;,
                        2, Code.SetShading),
            NewOpCode (&quot;EdgeVisibility&quot;,
                       -1, Code.EdgeVisibility),
            NewOpCode (&quot;SetEdgeVisibility&quot;,
                        2, Code.SetEdgeVisibility),
            NewOpCode (&quot;EdgeColor&quot;,
                       -1, Code.EdgeColor),
            NewOpCode (&quot;SetEdgeColor&quot;,
                        2, Code.SetEdgeColor),
            NewOpCode (&quot;EdgeType&quot;,
                       -1, Code.EdgeType),
            NewOpCode (&quot;SetEdgeType&quot;,
                        2, Code.SetEdgeType),
            NewOpCode (&quot;EdgeWidth&quot;,
                       -1, Code.EdgeWidth),
            NewOpCode (&quot;SetEdgeWidth&quot;,
                        2, Code.SetEdgeWidth)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    (* DONT KNOW YET WHETHER TO INHIBIT TRANSMISSIONS ... *)

  END SetupPackage;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    loader.load (&quot;SurfaceGO.obl&quot;);
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {Color,                    GetColor, SetColor,
          RasterMode,               SetRasterMode,
          AmbientReflectionCoeff,   SetAmbientReflectionCoeff,
          DiffuseReflectionCoeff,   SetDiffuseReflectionCoeff,
          SpecularReflectionCoeff,  SetSpecularReflectionCoeff,
          SpecularReflectionConc,   SetSpecularReflectionConc,
          TransmissionCoeff,        SetTransmissionCoeff,
          SpecularReflectionColor,  SetSpecularReflectionColor,
          Lighting,                 SetLighting,
          Shading,                  SetShading,
          EdgeVisibility,           SetEdgeVisibility,
          EdgeColor,                SetEdgeColor,
          EdgeType,                 SetEdgeType,
          EdgeWidth,                SetEdgeWidth};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.Color =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.Colour);
    | Code.GetColor =&gt;
      WITH go = ObGO.GetArg (args, 1, self, opCode, loc) DO
        TRY
          RETURN go.getProp (SurfaceGO.Colour).proxy.obj;
        EXCEPT
        | GO.PropUndefined =&gt;
          ObValue.RaiseException (ObGO.PropUndefined, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.SetColor =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           pv = ObColorProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.Colour.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.RasterMode =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.RasterMode);
    | Code.SetRasterMode =&gt;
      WITH go = ObGO.GetArg (args, 1, self, opCode, loc),
           pv = ObRasterModeProp.GetOverloadedVal
                            (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.RasterMode.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.AmbientReflectionCoeff =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.AmbientReflectionCoeff);
    | Code.SetAmbientReflectionCoeff =&gt;
      WITH go = ObGO.GetArg   (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.AmbientReflectionCoeff.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.DiffuseReflectionCoeff =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.DiffuseReflectionCoeff);
    | Code.SetDiffuseReflectionCoeff =&gt;
      WITH go = ObGO.GetArg   (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.DiffuseReflectionCoeff.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.SpecularReflectionCoeff =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.SpecularReflectionCoeff);
    | Code.SetSpecularReflectionCoeff =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.SpecularReflectionCoeff.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.SpecularReflectionConc =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.SpecularReflectionConc);
    | Code.SetSpecularReflectionConc =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.SpecularReflectionConc.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.TransmissionCoeff =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.TransmissionCoeff);
    | Code.SetTransmissionCoeff =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.TransmissionCoeff.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.SpecularReflectionColor =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.SpecularReflectionColour);
    | Code.SetSpecularReflectionColor =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           pv = ObColorProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.SpecularReflectionColour.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.Lighting =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.Lighting);
    | Code.SetLighting =&gt;
      WITH go = ObGO.GetArg                    (args, 1, self, opCode, loc),
           pv = ObBooleanProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.Lighting.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.Shading =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.Shading);
    | Code.SetShading =&gt;
      WITH go = ObGO.GetArg                    (args, 1, self, opCode, loc),
           pv = ObShadingProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.Shading.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.EdgeVisibility =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.EdgeVisibility);
    | Code.SetEdgeVisibility =&gt;
      WITH go = ObGO.GetArg                   (args, 1, self, opCode, loc),
           pv = ObBooleanProp.GetOverloadedVal(args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.EdgeVisibility.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.EdgeColor =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.EdgeColour);
    | Code.SetEdgeColor =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           pv = ObColorProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.EdgeColour.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.EdgeType =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.EdgeType);
    | Code.SetEdgeType =&gt;
      WITH go = ObGO.GetArg                    (args, 1, self, opCode, loc),
           pv = ObLineTypeProp.GetOverloadedVal(args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.EdgeType.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.EdgeWidth =&gt;
      RETURN ObProp.NameToObliq (SurfaceGO.EdgeWidth);
    | Code.SetEdgeWidth =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (SurfaceGO.EdgeWidth.bind (pv));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObSurfaceGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
