<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObTorusGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObTorusGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObTorusGO.i3">ObTorusGO</A></implements></module>;

IMPORT <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="ObInt.i3">ObInt</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRealProp.i3">ObRealProp</A>, <A HREF="ObSurfaceGO.i3">ObSurfaceGO</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>,
       <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../anim3D/src/TorusGO.i3">TorusGO</A>, <A HREF="../../anim3D/src/TorusGOProxy.i3">TorusGOProxy</A>;

CONST
  pkgname = &quot;TorusGO&quot;;
</PRE>***************************************************************************
 Wrapper for TorusGO.T                                                     
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObSurfaceGO.T BRANDED &quot;ObTorusGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (torus : TorusGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a TorusGO.T&gt;&quot;, po := torus) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      torus.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,         4, Code.New),
            NewOpCode (&quot;NewWithPrec&quot;, 5, Code.NewWithPrec),
            NewOpCode (&quot;Center&quot;,     -1, Code.Center),
            NewOpCode (&quot;Normal&quot;,     -1, Code.Normal),
            NewOpCode (&quot;Radius1&quot;,    -1, Code.Radius1),
            NewOpCode (&quot;Radius2&quot;,    -1, Code.Radius2),
            NewOpCode (&quot;SetCenter&quot;,   2, Code.SetCenter),
            NewOpCode (&quot;SetNormal&quot;,   2, Code.SetNormal),
            NewOpCode (&quot;SetRadius1&quot;,  2, Code.SetRadius1),
            NewOpCode (&quot;SetRadius2&quot;,  2, Code.SetRadius2)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    (* DONT KNOW YET WHETHER TO INHIBIT TRANSMISSIONS ... *)

  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;TorusGO.obl&quot;);
    TProto := loader.get (&quot;TorusGO_TProto&quot;);

    (*** Register the proxy maker ***)
    TorusGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, NewWithPrec, Center, Normal, Radius1, Radius2,
          SetCenter, SetNormal, SetRadius1, SetRadius2};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH cent  = ObPointProp.GetOverloadedVal(args, 1, self, opCode, loc),
           norm  = ObPointProp.GetOverloadedVal(args, 2, self, opCode, loc),
           rad1  = ObRealProp.GetOverloadedVal (args, 3, self, opCode, loc),
           rad2  = ObRealProp.GetOverloadedVal (args, 4, self, opCode, loc),
           torus = NEW (TorusGO.T).init () DO
        torus.setProp (TorusGO.Center.bind (cent));
        torus.setProp (TorusGO.Normal.bind (norm));
        torus.setProp (TorusGO.Radius1.bind (rad1));
        torus.setProp (TorusGO.Radius2.bind (rad2));
        RETURN torus.proxy.obj;
      END;
    | Code.NewWithPrec =&gt;
      WITH cent  = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           norm  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           rad1  = ObRealProp.GetOverloadedVal  (args, 3, self, opCode, loc),
           rad2  = ObRealProp.GetOverloadedVal  (args, 4, self, opCode, loc),
           prec  = ObInt.GetArg                 (args, 5, self, opCode, loc),
           torus = NEW (TorusGO.T).init (prec) DO
        torus.setProp (TorusGO.Center.bind (cent));
        torus.setProp (TorusGO.Normal.bind (norm));
        torus.setProp (TorusGO.Radius1.bind (rad1));
        torus.setProp (TorusGO.Radius2.bind (rad2));
        RETURN torus.proxy.obj;
      END;
    | Code.Center =&gt;
      RETURN ObProp.NameToObliq (TorusGO.Center);
    | Code.Normal =&gt;
      RETURN ObProp.NameToObliq (TorusGO.Normal);
    | Code.Radius1 =&gt;
      RETURN ObProp.NameToObliq (TorusGO.Radius1);
    | Code.Radius2 =&gt;
      RETURN ObProp.NameToObliq (TorusGO.Radius2);
    | Code.SetCenter =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (TorusGO.Center.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetNormal =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (TorusGO.Normal.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetRadius1 =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (TorusGO.Radius1.bind (r));
        RETURN ObValue.valOk;
      END;
    | Code.SetRadius2 =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (TorusGO.Radius2.bind (r));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObTorusGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
