<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObTransformProp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObTransformProp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat May 28 11:15:36 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObTransformProp.i3">ObTransformProp</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/Matrix4.i3">Matrix4</A>, <A HREF="ObAnimHandle.i3">ObAnimHandle</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObLongReal.i3">ObLongReal</A>, <A HREF="ObMatrix4.i3">ObMatrix4</A>,
       <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObReal.i3">ObReal</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/Prop.i3">Prop</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>,
       <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../anim3D/src/TransformProp.i3">TransformProp</A>, <A HREF="../../anim3D/src/TransformPropProxy.i3">TransformPropProxy</A>;
</PRE>***************************************************************************
 Wrapper for TransformProp.Name                                            
***************************************************************************

<P><PRE>TYPE
  Name = ObProp.Name BRANDED &quot;ObTransformProp.Name&quot; OBJECT END;

PROCEDURE <A NAME="AddNameObj"><procedure>AddNameObj</procedure></A> (pn : TransformProp.Name) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {NameProto}),
         raw = NEW (Name, what := &quot;&lt;a TransformProp.Name&gt;&quot;, po := pn) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pn.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddNameObj;

PROCEDURE <A NAME="GetName"><procedure>GetName</procedure></A> (args    : ObValue.ArgArray;
                   idx     : INTEGER;
                   package : ObLib.T;
                   opCode  : ObLib.OpCode;
                   loc     : SynLocation.T) : TransformProp.Name
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Name (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetName;
</PRE>***************************************************************************
 Wrapper for TransformProp.Val                                             
***************************************************************************

<P>
<P><PRE>TYPE
  Val = ObProp.Val BRANDED &quot;ObTransformProp.Val&quot; OBJECT END;

PROCEDURE <A NAME="AddValObj"><procedure>AddValObj</procedure></A> (pv : TransformProp.Val) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {ValProto}),
         raw = NEW (Val, what := &quot;&lt;a TransformProp.Val&gt;&quot;, po := pv) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pv.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddValObj;

PROCEDURE <A NAME="GetVal"><procedure>GetVal</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : TransformProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Val (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetVal;

PROCEDURE <A NAME="GetOverloadedVal"><procedure>GetOverloadedVal</procedure></A> (args    : ObValue.ArgArray;
                            idx     : INTEGER;
                            package : ObLib.T;
                            opCode  : ObLib.OpCode;
                            loc     : SynLocation.T) : TransformProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    TYPECASE args[idx] OF
    | ObMatrix4.T (node) =&gt;
      RETURN TransformProp.NewConst (ObMatrix4.ObliqToM3 (node));
    | ObValue.ValObj =&gt;
      WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
        TYPECASE raw OF
        | Val (node) =&gt;
          RETURN node.po;
        ELSE
          ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
          RETURN NIL;      (* ... only to suppress compiler warning *)
        END;
      END;
    ELSE
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN NIL;   (* ... only to suppress compiler warning *)
    END;
  END GetOverloadedVal;
</PRE>***************************************************************************
 Wrapper for TransformProp.Beh                                             
***************************************************************************

<P><PRE>TYPE
  Beh = ObProp.Beh BRANDED &quot;ObTransformProp.Beh&quot; OBJECT END;

PROCEDURE <A NAME="GetBeh"><procedure>GetBeh</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : TransformProp.Beh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Beh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetBeh;
</PRE>***************************************************************************
 Wrapper for TransformProp.ConstBeh                                        
***************************************************************************

<P>
<P><PRE>TYPE
  ConstBeh = Beh BRANDED &quot;ObTransformProp.ConstBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddConstBehObj"><procedure>AddConstBehObj</procedure></A> (beh : TransformProp.ConstBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {ConstBehProto}),
         raw = NEW (ConstBeh, what := &quot;&lt;a TransformProp.ConstBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddConstBehObj;

PROCEDURE <A NAME="GetConstBeh"><procedure>GetConstBeh</procedure></A> (args    : ObValue.ArgArray;
                       idx     : INTEGER;
                       package : ObLib.T;
                       opCode  : ObLib.OpCode;
                       loc     : SynLocation.T) : TransformProp.ConstBeh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | ConstBeh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetConstBeh;
</PRE>***************************************************************************
 Wrapper for TransformProp.SyncBeh                                         
***************************************************************************

<P>
<P><PRE>TYPE
  SyncBeh = Beh BRANDED &quot;ObTransformProp.SyncBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddSyncBehObj"><procedure>AddSyncBehObj</procedure></A> (beh : TransformProp.SyncBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {SyncBehProto}),
         raw = NEW (SyncBeh, what := &quot;&lt;a TransformProp.SyncBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddSyncBehObj;

PROCEDURE <A NAME="GetSyncBeh"><procedure>GetSyncBeh</procedure></A> (args    : ObValue.ArgArray;
                       idx     : INTEGER;
                       package : ObLib.T;
                       opCode  : ObLib.OpCode;
                       loc     : SynLocation.T) : TransformProp.SyncBeh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | SyncBeh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetSyncBeh;
</PRE>***************************************************************************
 Wrapper for TransformProp.AsyncBeh                                        
***************************************************************************

<P>
<P><PRE>TYPE
  AsyncBeh = Beh BRANDED &quot;ObTransformProp.AsyncBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddAsyncBehObj"><procedure>AddAsyncBehObj</procedure></A> (beh : TransformProp.AsyncBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {AsyncBehProto}),
         raw = NEW (AsyncBeh, what := &quot;&lt;a TransformProp.AsyncBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (AsyncBehProxy, obj := obj);
    END;
  END AddAsyncBehObj;

TYPE
  AsyncBehProxy = TransformPropProxy.AsyncBehProxy BRANDED OBJECT
  OVERRIDES
    compute := AsyncBehCompute;
  END;

PROCEDURE <A NAME="AsyncBehCompute"><procedure>AsyncBehCompute</procedure></A> (proxy : AsyncBehProxy; time : LONGREAL) : Matrix4.T
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {Obliq.NewReal (time)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;compute&quot;, args) DO
        RETURN ObMatrix4.ObliqToM3 (res);
      END;
    EXCEPT
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END AsyncBehCompute;
</PRE>***************************************************************************
 Wrapper for TransformProp.DepBeh                                          
***************************************************************************

<P>
<P><PRE>TYPE
  DepBeh = Beh BRANDED &quot;ObTransformProp.DepBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddDepBehObj"><procedure>AddDepBehObj</procedure></A> (beh : TransformProp.DepBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {DepBehProto}),
         raw = NEW (DepBeh, what := &quot;&lt;a TransformProp.DepBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (DepBehProxy, obj := obj);
    END;
  END AddDepBehObj;

TYPE
  DepBehProxy = TransformPropProxy.DepBehProxy BRANDED OBJECT
  OVERRIDES
    compute := DepBehCompute;
  END;

PROCEDURE <A NAME="DepBehCompute"><procedure>DepBehCompute</procedure></A> (proxy : DepBehProxy; time : LONGREAL) : Matrix4.T
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {Obliq.NewReal (time)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;compute&quot;, args) DO
        RETURN ObMatrix4.ObliqToM3 (res);
      END;
    EXCEPT
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END DepBehCompute;
</PRE>***************************************************************************
 Wrapper for TransformProp.Request                                         
***************************************************************************

<P>
<P><PRE>TYPE
  Request = ObProp.Request BRANDED &quot;ObTransformProp.Request&quot; OBJECT END;

PROCEDURE <A NAME="AddRequestObj"><procedure>AddRequestObj</procedure></A> (req : TransformProp.Request) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {RequestProto}),
         raw = NEW (Request, what := &quot;&lt;a TransformProp.Request&gt;&quot;, po := req) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      req.proxy := NEW (RequestProxy, obj := obj);
    END;
  END AddRequestObj;

PROCEDURE <A NAME="GetRequest"><procedure>GetRequest</procedure></A> (args    : ObValue.ArgArray;
                      idx     : INTEGER;
                      package : ObLib.T;
                      opCode  : ObLib.OpCode;
                      loc     : SynLocation.T) : TransformProp.Request
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Request (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetRequest;

TYPE
  RequestProxy = TransformPropProxy.RequestProxy BRANDED OBJECT
  OVERRIDES
    value := RequestValue;
  END;

PROCEDURE <A NAME="RequestValue"><procedure>RequestValue</procedure></A> (proxy             : RequestProxy;
                        READONLY startval : Matrix4.T;
                        reltime           : REAL) : Matrix4.T
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {ObMatrix4.M3ToObliq (startval),
                              ObReal.M3ToObliq (reltime)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;value&quot;, args) DO
        RETURN ObMatrix4.ObliqToM3 (res);
      END;
    EXCEPT
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END RequestValue;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes := NEW (REF OpCodes, NUMBER (Code));
  BEGIN
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;NameBind&quot;,            2, Code.NameBind),
            NewOpCode (&quot;ValGetBeh&quot;,           1, Code.ValGetBeh),
            NewOpCode (&quot;ValSetBeh&quot;,           2, Code.ValSetBeh),
            NewOpCode (&quot;ValGet&quot;,              1, Code.ValGet),
            NewOpCode (&quot;ValValue&quot;,            2, Code.ValValue),
            NewOpCode (&quot;NewConst&quot;,            1, Code.NewConst),
            NewOpCode (&quot;NewSync&quot;,             2, Code.NewSync),
            NewOpCode (&quot;NewAsync&quot;,            1, Code.NewAsync),
            NewOpCode (&quot;NewDep&quot;,              1, Code.NewDep),
            NewOpCode (&quot;ConstBehSet&quot;,         2, Code.ConstBehSet),
            NewOpCode (&quot;ConstBehCompose&quot;,     2, Code.ConstBehCompose),
            NewOpCode (&quot;ConstBehReset&quot;,       1, Code.ConstBehReset),
            NewOpCode (&quot;ConstBehTranslate&quot;,   4, Code.ConstBehTranslate),
            NewOpCode (&quot;ConstBehScale&quot;,       4, Code.ConstBehScale),
            NewOpCode (&quot;ConstBehRotateX&quot;,     2, Code.ConstBehRotateX),
            NewOpCode (&quot;ConstBehRotateY&quot;,     2, Code.ConstBehRotateY),
            NewOpCode (&quot;ConstBehRotateZ&quot;,     2, Code.ConstBehRotateZ),
            NewOpCode (&quot;NewConstBeh&quot;,         1, Code.NewConstBeh),
            NewOpCode (&quot;SyncBehAddRequest&quot;,   2, Code.SyncBehAddRequest),
            NewOpCode (&quot;SyncBehReset&quot;,        2, Code.SyncBehReset),
            NewOpCode (&quot;SyncBehChangeTo&quot;,     4, Code.SyncBehChangeTo),
            NewOpCode (&quot;SyncBehTranslate&quot;,    6, Code.SyncBehTranslate),
            NewOpCode (&quot;SyncBehScale&quot;,        6, Code.SyncBehScale),
            NewOpCode (&quot;SyncBehRotateX&quot;,      4, Code.SyncBehRotateX),
            NewOpCode (&quot;SyncBehRotateY&quot;,      4, Code.SyncBehRotateY),
            NewOpCode (&quot;SyncBehRotateZ&quot;,      4, Code.SyncBehRotateZ),
            NewOpCode (&quot;NewSyncBeh&quot;,          2, Code.NewSyncBeh),
            NewOpCode (&quot;NewAsyncBeh&quot;,         1, Code.NewAsyncBeh),
            NewOpCode (&quot;NewDepBeh&quot;,           1, Code.NewDepBeh),
            NewOpCode (&quot;NewRequest&quot;,          3, Code.NewRequest)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  NameProto     : ObValue.Val;
  ValProto      : ObValue.Val;
  ConstBehProto : ObValue.Val;
  SyncBehProto  : ObValue.Val;
  AsyncBehProto : ObValue.Val;
  DepBehProto   : ObValue.Val;
  RequestProto  : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** retrieve the prototypes ***)
    loader.load (&quot;TransformProp.obl&quot;);
    NameProto     := loader.get (&quot;TransformProp_NameProto&quot;);
    ValProto      := loader.get (&quot;TransformProp_ValProto&quot;);
    ConstBehProto := loader.get (&quot;TransformProp_ConstBehProto&quot;);
    SyncBehProto  := loader.get (&quot;TransformProp_SyncBehProto&quot;);
    AsyncBehProto := loader.get (&quot;TransformProp_AsyncBehProto&quot;);
    DepBehProto   := loader.get (&quot;TransformProp_DepBehProto&quot;);
    RequestProto  := loader.get (&quot;TransformProp_RequestProto&quot;);

    (*** Register the proxy makers ***)
    TransformPropProxy.NamePM     := AddNameObj;
    TransformPropProxy.ValPM      := AddValObj;
    TransformPropProxy.ConstBehPM := AddConstBehObj;
    TransformPropProxy.SyncBehPM  := AddSyncBehObj;
    TransformPropProxy.AsyncBehPM := AddAsyncBehObj;
    TransformPropProxy.DepBehPM   := AddDepBehObj;
    TransformPropProxy.RequestPM  := AddRequestObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {NameBind,
          ValGetBeh, ValSetBeh, ValGet, ValValue,
             NewConst, NewSync, NewAsync, NewDep,
          ConstBehSet, ConstBehCompose, ConstBehReset, ConstBehTranslate,
             ConstBehScale, ConstBehRotateX, ConstBehRotateY, ConstBehRotateZ,
             NewConstBeh,
          SyncBehAddRequest, SyncBehReset, SyncBehChangeTo, SyncBehTranslate,
             SyncBehScale, SyncBehRotateX, SyncBehRotateY, SyncBehRotateZ,
             NewSyncBeh,
          NewAsyncBeh,
          NewDepBeh,
          NewRequest};

  OpCode = ObLib.OpCode BRANDED OBJECT
    code: Code;
  END;

  Package = ObLib.T BRANDED OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

CONST
  pkgname = &quot;TransformProp&quot;;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.NameBind =&gt;
      WITH pn   = GetName (args, 1, self, opCode, loc),
           pv   = GetVal  (args, 2, self, opCode, loc),
           prop = pn.bind (pv) DO
        RETURN prop.proxy.obj;
      END;
    | Code.ValGetBeh =&gt;
      WITH pv = GetVal (args, 1, self, opCode, loc) DO
        RETURN pv.beh.proxy.obj;
      END;
    | Code.ValSetBeh =&gt;
      WITH pv  = GetVal (args, 1, self, opCode, loc),
           beh = GetBeh (args, 2, self, opCode, loc) DO
        pv.beh := beh;
        RETURN ObValue.valOk;
      END;
    | Code.ValGet =&gt;
      WITH pv = GetVal (args, 1, self, opCode, loc) DO
        TRY
          RETURN ObMatrix4.M3ToObliq (pv.get ());
        EXCEPT
        | Prop.BadMethod =&gt;
          ObValue.RaiseException (ObProp.BadMethod, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.ValValue =&gt;
      WITH pv   = GetVal (args, 1, self, opCode, loc),
           time = ObLongReal.GetArg (args, 2, self, opCode, loc) DO
        TRY
          RETURN ObMatrix4.M3ToObliq (pv.value (time));
        EXCEPT
        | Prop.BadMethod =&gt;
          ObValue.RaiseException (ObProp.BadMethod, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.NewConst =&gt;
      (*** AddValObj creates the actual Obliq object ***)
      WITH r   = ObMatrix4.GetArg (args, 1, self, opCode, loc),
           val = TransformProp.NewConst (r) DO
        RETURN val.proxy.obj;
      END;
    | Code.NewSync =&gt;
      WITH ah  = ObAnimHandle.GetT (args, 1, self, opCode, loc),
           r   = ObMatrix4.GetArg (args, 2, self, opCode, loc),
           val = TransformProp.NewSync (ah, r) DO
        RETURN val.proxy.obj;
      END;
    | Code.NewAsync =&gt;
      WITH beh = NEW (TransformProp.AsyncBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        WITH val  = TransformProp.NewAsync (beh) DO
          RETURN val.proxy.obj;
        END;
      END;
    | Code.NewDep =&gt;
      WITH beh = NEW (TransformProp.DepBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        WITH val = TransformProp.NewDep (beh) DO
          RETURN val.proxy.obj;
        END;
      END;
    | Code.ConstBehSet =&gt;
      WITH beh = GetConstBeh (args, 1, self, opCode, loc),
           r   = ObMatrix4.GetArg (args, 2, self, opCode, loc) DO
        beh.set (r);
        RETURN ObValue.valOk;
      END;
    | Code.ConstBehCompose =&gt;
      WITH beh = GetConstBeh (args, 1, self, opCode, loc),
           r   = ObMatrix4.GetArg (args, 2, self, opCode, loc) DO
        beh.compose (r);
        RETURN ObValue.valOk;
      END;
    | Code.ConstBehReset =&gt;
      WITH beh = GetConstBeh (args, 1, self, opCode, loc) DO
        beh.reset ();
        RETURN ObValue.valOk;
      END;
    | Code.ConstBehTranslate =&gt;
      WITH beh = GetConstBeh   (args, 1, self, opCode, loc),
           x   = ObReal.GetArg (args, 2, self, opCode, loc),
           y   = ObReal.GetArg (args, 3, self, opCode, loc),
           z   = ObReal.GetArg (args, 4, self, opCode, loc) DO
        beh.translate (x, y, z);
        RETURN ObValue.valOk;
      END;
    | Code.ConstBehScale =&gt;
      WITH beh = GetConstBeh   (args, 1, self, opCode, loc),
           x   = ObReal.GetArg (args, 2, self, opCode, loc),
           y   = ObReal.GetArg (args, 3, self, opCode, loc),
           z   = ObReal.GetArg (args, 4, self, opCode, loc) DO
        beh.scale (x, y, z);
        RETURN ObValue.valOk;
      END;
    | Code.ConstBehRotateX =&gt;
      WITH beh = GetConstBeh   (args, 1, self, opCode, loc),
           a   = ObReal.GetArg (args, 2, self, opCode, loc) DO
        beh.rotateX (a);
        RETURN ObValue.valOk;
      END;
    | Code.ConstBehRotateY =&gt;
      WITH beh = GetConstBeh   (args, 1, self, opCode, loc),
           a   = ObReal.GetArg (args, 2, self, opCode, loc) DO
        beh.rotateY (a);
        RETURN ObValue.valOk;
      END;
    | Code.ConstBehRotateZ =&gt;
      WITH beh = GetConstBeh   (args, 1, self, opCode, loc),
           a   = ObReal.GetArg (args, 2, self, opCode, loc) DO
        beh.rotateZ (a);
        RETURN ObValue.valOk;
      END;
    | Code.NewConstBeh =&gt;
      WITH m   = ObMatrix4.GetArg (args, 1, self, opCode, loc),
           beh = NEW (TransformProp.ConstBeh).init (m) DO
        RETURN beh.proxy.obj;
      END;
    | Code.SyncBehAddRequest =&gt;
      WITH beh = GetSyncBeh (args, 1, self, opCode, loc),
           req = GetRequest (args, 2, self, opCode, loc) DO
        TRY
          beh.addRequest (req);
        EXCEPT
        | Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehReset =&gt;
      WITH beh   = GetSyncBeh    (args, 1, self, opCode, loc),
           start = ObReal.GetArg (args, 2, self, opCode, loc) DO
        TRY
          beh.reset (start);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehChangeTo =&gt;
      WITH beh   = GetSyncBeh       (args, 1, self, opCode, loc),
           m     = ObMatrix4.GetArg (args, 2, self, opCode, loc),
           start = ObReal.GetArg    (args, 3, self, opCode, loc),
           dur   = ObReal.GetArg    (args, 4, self, opCode, loc) DO
        TRY
          beh.changeTo (m, start, dur);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehTranslate =&gt;
      WITH beh   = GetSyncBeh    (args, 1, self, opCode, loc),
           x     = ObReal.GetArg (args, 2, self, opCode, loc),
           y     = ObReal.GetArg (args, 3, self, opCode, loc),
           z     = ObReal.GetArg (args, 4, self, opCode, loc),
           start = ObReal.GetArg (args, 5, self, opCode, loc),
           dur   = ObReal.GetArg (args, 6, self, opCode, loc) DO
        TRY
          beh.translate (x, y, z, start, dur);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehScale =&gt;
      WITH beh   = GetSyncBeh    (args, 1, self, opCode, loc),
           x     = ObReal.GetArg (args, 2, self, opCode, loc),
           y     = ObReal.GetArg (args, 3, self, opCode, loc),
           z     = ObReal.GetArg (args, 4, self, opCode, loc),
           start = ObReal.GetArg (args, 5, self, opCode, loc),
           dur   = ObReal.GetArg (args, 6, self, opCode, loc) DO
        TRY
          beh.scale (x, y, z, start, dur);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehRotateX =&gt;
      WITH beh   = GetSyncBeh    (args, 1, self, opCode, loc),
           a     = ObReal.GetArg (args, 2, self, opCode, loc),
           start = ObReal.GetArg (args, 3, self, opCode, loc),
           dur   = ObReal.GetArg (args, 4, self, opCode, loc) DO
        TRY
          beh.rotateX (a, start, dur);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehRotateY =&gt;
      WITH beh   = GetSyncBeh    (args, 1, self, opCode, loc),
           a     = ObReal.GetArg (args, 2, self, opCode, loc),
           start = ObReal.GetArg (args, 3, self, opCode, loc),
           dur   = ObReal.GetArg (args, 4, self, opCode, loc) DO
        TRY
          beh.rotateY (a, start, dur);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehRotateZ =&gt;
      WITH beh   = GetSyncBeh    (args, 1, self, opCode, loc),
           a     = ObReal.GetArg (args, 2, self, opCode, loc),
           start = ObReal.GetArg (args, 3, self, opCode, loc),
           dur   = ObReal.GetArg (args, 4, self, opCode, loc) DO
        TRY
          beh.rotateZ (a, start, dur);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.NewSyncBeh =&gt;
      WITH ah  = ObAnimHandle.GetT (args, 1, self, opCode, loc),
           m   = ObMatrix4.GetArg (args, 2, self, opCode, loc),
           beh = NEW (TransformProp.SyncBeh).init (ah, m) DO
        RETURN beh.proxy.obj;
      END;
    | Code.NewAsyncBeh =&gt;
      WITH beh = NEW (TransformProp.AsyncBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        RETURN obj;
      END;
    | Code.NewDepBeh =&gt;
      WITH beh   = NEW (TransformProp.DepBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        RETURN obj;
      END;
    | Code.NewRequest =&gt;
      WITH start = ObReal.GetArg (args, 1, self, opCode, loc),
           dur   = ObReal.GetArg (args, 2, self, opCode, loc),
           req   = NEW (TransformProp.Request).init (start, dur),
           obj   = NARROW (req.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;value&quot;, args[3]);
        RETURN obj;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObTransformProp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
