<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObVectorLightGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObVectorLightGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat Mar  5 19:17:45 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObVectorLightGO.i3">ObVectorLightGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/LightGO.i3">LightGO</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObColorProp.i3">ObColorProp</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObLightGO.i3">ObLightGO</A>,
       <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>,
       <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../anim3D/src/VectorLightGO.i3">VectorLightGO</A>, <A HREF="../../anim3D/src/VectorLightGOProxy.i3">VectorLightGOProxy</A>;

CONST
  pkgname = &quot;VectorLightGO&quot;;
</PRE>***************************************************************************
 Wrapper for VectorLightGO.T                                               
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObLightGO.T BRANDED &quot;ObVectorLightGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (light : VectorLightGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a VectorLightGO.T&gt;&quot;, po := light) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      light.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name : TEXT; arity : INTEGER; code : Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,          2, Code.New),
            NewOpCode (&quot;Direction&quot;,   -1, Code.Direction),
            NewOpCode (&quot;SetDirection&quot;, 2, Code.SetDirection)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;VectorLightGO.obl&quot;);
    TProto := loader.get (&quot;VectorLightGO_TProto&quot;);

    (*** Register the proxy maker ***)
    VectorLightGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, Direction, SetDirection};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH color = ObColorProp.GetOverloadedVal (args, 1, self, opCode, loc),
           dir   = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           light = NEW (VectorLightGO.T).init () DO
        light.setProp (LightGO.Colour.bind (color));
        light.setProp (VectorLightGO.Direction.bind (dir));
        RETURN light.proxy.obj;
      END;
    | Code.Direction =&gt;
      RETURN ObProp.NameToObliq (VectorLightGO.Direction);
    | Code.SetDirection =&gt;
      WITH go  = ObGO.GetArg                  (args, 1, self, opCode, loc),
           dir = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (VectorLightGO.Direction.bind (dir));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObVectorLightGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
