<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObView3D.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObView3D.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Mon Jan 24 09:35:05 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObView3D.i3">ObView3D</A></implements></module>;

IMPORT <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObColor.i3">ObColor</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqlibui/src/ObLibUI.i3">ObLibUI</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObReal.i3">ObReal</A>,
       <A HREF="ObText.i3">ObText</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../zeus3D/src/View3D.i3">View3D</A>, <A HREF="../../zeus3D/src/View3DProxy.i3">View3DProxy</A>;

CONST
  pkgname = &quot;View3D&quot;;
</PRE>***************************************************************************
 Wrapper for View3D.T                                                      
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObValue.ValAnything BRANDED OBJECT
    view : View3D.T;
  OVERRIDES
    Is := DoIs;
  END;

PROCEDURE <A NAME="DoIs"><procedure>DoIs</procedure></A> (self: T; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF
      T (oth) =&gt; RETURN self.view = oth.view;
    ELSE
      RETURN FALSE
    END;
  END DoIs;

PROCEDURE <A NAME="PairUp"><procedure>PairUp</procedure></A> (view : View3D.T; obj : Obliq.Val) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH raw   = NEW (T, what := &quot;&lt;a View3D.T&gt;&quot;, view := view),
         scene = NARROW (view.scene.proxy.obj, Obliq.Val),
         form  = NEW (Form, what := &quot;&lt;a View3D.Form&gt;&quot;,
                      picklable := FALSE, form := view.form),
         ah    = view.ah.proxy.obj DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;,   raw);
      Obliq.ObjectUpdate (obj, &quot;scene&quot;, scene);
      Obliq.ObjectUpdate (obj, &quot;form&quot;,  form);
      Obliq.ObjectUpdate (obj, &quot;ah&quot;,    ah);
      view.proxy := obj;
    END;
  END PairUp;

PROCEDURE <A NAME="M3ToObliq"><procedure>M3ToObliq</procedure></A> (view : View3D.T) : Obliq.Val =
  BEGIN
    RETURN view.proxy;
  END M3ToObliq;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : View3D.T
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | T (node) =&gt;
        RETURN node.view;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;   (* only to suppress compiler warnings *)
      END;
    END;
  END GetArg;
</PRE>***************************************************************************
 Wrapper for View3D.Form                                                   
***************************************************************************

<P>
<P><PRE>TYPE
  Form = ObLibUI.ValForm OBJECT END;

PROCEDURE <A NAME="GetFormArg"><procedure>GetFormArg</procedure></A> (args    : ObValue.ArgArray;
                      idx     : INTEGER;
                      package : ObLib.T;
                      opCode  : ObLib.OpCode;
                      loc     : SynLocation.T) : View3D.Form
    RAISES {ObValue.Error} =
  BEGIN
    TYPECASE args[idx] OF
    | Form (node) =&gt;
      RETURN node.form;
    ELSE
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN NIL;   (* only to suppress compiler warnings *)
    END;
  END GetFormArg;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;Error&quot;,            -1, Code.Error),
            NewOpCode (&quot;New&quot;,               1, Code.New),
            NewOpCode (&quot;ChangeTitle&quot;,       2, Code.ChangeTitle),
            NewOpCode (&quot;FindName&quot;,          2, Code.FindName),
            NewOpCode (&quot;InstallSubForm&quot;,    2, Code.InstallSubForm),
            NewOpCode (&quot;SetWcs&quot;,            7, Code.SetWcs),
            NewOpCode (&quot;Pause&quot;,             2, Code.Pause),
            NewOpCode (&quot;DefineColor&quot;,       3, Code.DefineColor),
            NewOpCode (&quot;GetColor&quot;,          2, Code.GetColor),
            NewOpCode (&quot;Rotate&quot;,            4, Code.Rotate),
            NewOpCode (&quot;AddRotationButton&quot;, 5, Code.AddRotationButton),
            NewOpCode (&quot;ViewOfForm&quot;,        1, Code.ViewOfForm)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));

    Error   := NEW (ObValue.ValException, name := pkgname &amp; &quot;_Error&quot;);

    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;View3D.obl&quot;);
    TProto := loader.get (&quot;View3D_TProto&quot;);
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {Error, New, ChangeTitle, FindName, InstallSubForm, SetWcs, Pause,
          DefineColor, GetColor, Rotate, AddRotationButton, ViewOfForm};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

VAR
  Error : ObValue.ValException;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.Error =&gt;
      RETURN Error;
    | Code.New =&gt;
</PRE><BLOCKQUOTE><EM><P>
        WITH text  = ObText.GetArg (args, 1, self, opCode, loc),
             view  = NEW (View3D.T).init (text),
             orig  = NARROW (view.proxy, ObValue.Val),
             new   = Obliq.ObjectClone (Obliq.Vals {orig, args[2]}) DO
          view.proxy := new;
          RETURN new;
        END;
</EM></BLOCKQUOTE><PRE>
      RETURN Obliq.ObjectClone (Obliq.Vals {TProto, args[1]});
    | Code.SetWcs =&gt;
      WITH view =        GetArg (args, 1, self, opCode, loc),
           xmin = ObReal.GetArg (args, 2, self, opCode, loc),
           xmax = ObReal.GetArg (args, 3, self, opCode, loc),
           ymin = ObReal.GetArg (args, 4, self, opCode, loc),
           ymax = ObReal.GetArg (args, 5, self, opCode, loc),
           zmin = ObReal.GetArg (args, 6, self, opCode, loc),
           zmax = ObReal.GetArg (args, 7, self, opCode, loc) DO
        view.setWcs (xmin, xmax, ymin, ymax, zmin, zmax);
        RETURN ObValue.valOk;
      END;
    | Code.Pause =&gt;
      WITH view =        GetArg (args, 1, self, opCode, loc),
           dur  = ObReal.GetArg (args, 2, self, opCode, loc) DO
        view.pause (dur);
        RETURN ObValue.valOk;
      END;
    | Code.ChangeTitle =&gt;
      WITH view  =        GetArg (args, 1, self, opCode, loc),
           title = ObText.GetArg (args, 2, self, opCode, loc) DO
        view.changeTitle (title);
        RETURN ObValue.valOk;
      END;
    | Code.FindName =&gt;
      WITH view  =       GetArg (args, 1, self, opCode, loc),
           name = ObText.GetArg (args, 2, self, opCode, loc) DO
        RETURN view.findName (name).proxy.obj;
      END;
    | Code.InstallSubForm =&gt;
      WITH view =        GetArg (args, 1, self, opCode, loc),
           file = ObText.GetArg (args, 2, self, opCode, loc) DO
        view.installSubForm (file);
        RETURN ObValue.valOk;
      END;
    | Code.AddRotationButton =&gt;
      WITH view =         GetArg (args, 1, self, opCode, loc),
           title = ObText.GetArg (args, 2, self, opCode, loc),
           x     = ObReal.GetArg (args, 3, self, opCode, loc),
           y     = ObReal.GetArg (args, 4, self, opCode, loc),
           z     = ObReal.GetArg (args, 5, self, opCode, loc) DO
        view.addRotationButton (title, x, y, z);
        RETURN ObValue.valOk;
      END;
    | Code.Rotate =&gt;
      WITH view =         GetArg (args, 1, self, opCode, loc),
           x     = ObReal.GetArg (args, 2, self, opCode, loc),
           y     = ObReal.GetArg (args, 3, self, opCode, loc),
           z     = ObReal.GetArg (args, 4, self, opCode, loc) DO
        view.rotate (x, y, z);
        RETURN ObValue.valOk;
      END;
    | Code.DefineColor =&gt;
      WITH view  =        GetArg  (args, 1, self, opCode, loc),
           menu  = ObText.GetArg  (args, 2, self, opCode, loc),
           init  = ObColor.GetArg (args, 3, self, opCode, loc),
           colpv = view.defineColor (menu, init) DO
        RETURN colpv.proxy.obj;
      END;
    | Code.GetColor =&gt;
      TRY
        WITH view =        GetArg  (args, 1, self, opCode, loc),
             menu = ObText.GetArg  (args, 2, self, opCode, loc),
             pv   = view.getColor (menu) DO
          RETURN pv.proxy.obj;
        END;
      EXCEPT
      | View3D.Error =&gt; ObValue.RaiseException (Error, opCode.name, loc);
        RETURN ObValue.valOk;    (* ... only to suppress compiler warning *)
      END;
    | Code.ViewOfForm =&gt;
      WITH form = GetFormArg (args, 1, self, opCode, loc) DO
        RETURN NARROW (form.view.proxy, ObValue.Val);
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObView3D.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
