<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObX_PEX_Base.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObX_PEX_Base.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Mon Mar  7 13:05:12 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObX_PEX_Base.i3">ObX_PEX_Base</A></implements></module>;

IMPORT <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGraphicsBase.i3">ObGraphicsBase</A>, <A HREF="ObInt.i3">ObInt</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObText.i3">ObText</A>,
       <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../anim3D/src/X_PEX_Base.i3">X_PEX_Base</A>, <A HREF="../../anim3D/src/X_PEX_BaseProxy.i3">X_PEX_BaseProxy</A>;

CONST
  pkgname = &quot;X`PEX`Base&quot;;
</PRE>***************************************************************************
 Wrapper for RootGO.T                                                      
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObGraphicsBase.T BRANDED &quot;ObX_PEX_Base.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (base : X_PEX_Base.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;an X_PEX_Base.T&gt;&quot;, po := base) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      base.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : X_PEX_Base.T
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | T (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetArg;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name : TEXT; arity : INTEGER; code : Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;Failure&quot;,    -1, Code.Failure),
            NewOpCode (&quot;New&quot;,         5, Code.New),
            NewOpCode (&quot;NewStd&quot;,      0, Code.NewStd),
            NewOpCode (&quot;ChangeTitle&quot;, 2, Code.ChangeTitle),
            NewOpCode (&quot;AwaitDelete&quot;, 1, Code.AwaitDelete),
            NewOpCode (&quot;Destroy&quot;,     1, Code.Destroy)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));

    Failure := NEW (ObValue.ValException, name := pkgname &amp; &quot;_Failure&quot;);
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** retrieve the prototype ***)
    loader.load (&quot;X_PEX_Base.obl&quot;);
    TProto := loader.get (&quot;X`PEX`Base_TProto&quot;);

    (*** Register the proxy maker ***)
    X_PEX_BaseProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {Failure, New, NewStd, ChangeTitle, AwaitDelete, Destroy};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

VAR
  Failure : ObValue.ValException;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.Failure =&gt;
      RETURN Failure;
    | Code.New =&gt;
      TRY
        WITH  title = ObText.GetArg (args, 1, self, opCode, loc),
              win_x = ObInt.GetArg  (args, 2, self, opCode, loc),
              win_y = ObInt.GetArg  (args, 3, self, opCode, loc),
              win_w = ObInt.GetArg  (args, 4, self, opCode, loc),
              win_h = ObInt.GetArg  (args, 5, self, opCode, loc),
              base  = NEW (X_PEX_Base.T).init (title, win_x, win_y,
                                               win_w, win_h) DO
          RETURN base.proxy.obj;
        END;
      EXCEPT
      | X_PEX_Base.Failure =&gt;
        ObValue.RaiseException (Failure, opCode.name, loc);
        RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
      END;
    | Code.NewStd =&gt;
      TRY
        WITH base = NEW (X_PEX_Base.T).init (&quot;Anim3D Viewer&quot;) DO
          RETURN base.proxy.obj;
        END;
      EXCEPT
      | X_PEX_Base.Failure =&gt;
        ObValue.RaiseException (Failure, opCode.name, loc);
        RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
      END;
    | Code.ChangeTitle =&gt;
      WITH base  = GetArg        (args, 1, self, opCode, loc),
           title = ObText.GetArg (args, 2, self, opCode, loc) DO
        base.changeTitle (title);
        RETURN ObValue.valOk;
      END;
    | Code.AwaitDelete =&gt;
      WITH base  = GetArg (args, 1, self, opCode, loc) DO
        base.awaitDelete ();
        RETURN ObValue.valOk;
      END;
    | Code.Destroy =&gt;
      WITH base  = GetArg (args, 1, self, opCode, loc) DO
        base.destroy ();
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname, &quot;X_PEX_Base&quot;);
  END Help;

BEGIN
END ObX_PEX_Base.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
