<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlibanim/src/ObLibAnim.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlibanim/src/ObLibAnim.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObLibAnim.i3">ObLibAnim</A></implements></module>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/ObEval.i3">ObEval</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../geometry/src/Point.i3">Point</A>,
<A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../mg/src/R2.i3">R2</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../mgkit/src/GraphVBT.i3">GraphVBT</A>, <A HREF="../../mgkit/src/GraphVBTExtras.i3">GraphVBTExtras</A>,
<A HREF="../../mg/src/Animate.i3">Animate</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../obliqlibui/src/ObLibUI.i3">ObLibUI</A>, <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../mgkit/src/PaintOpAnim.i3">PaintOpAnim</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../mgkit/src/RectsVBT.i3">RectsVBT</A>;

  VAR setupDone := FALSE;

  PROCEDURE <A NAME="PackageSetup"><procedure>PackageSetup</procedure></A>() =
  BEGIN
    IF NOT setupDone THEN
      setupDone := TRUE;
      Setup();
    END;
  END PackageSetup;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
    SetupRects();
    SetupGraph();
    SetupZeus();
  END Setup;
</PRE> ============ <CODE>rects</CODE> package ============ 

<P><PRE>TYPE

  RectsCode =
    {Error, New, SetN, Exists, Delete, Draw, Erase, SetColor,
    SetPosition, GetPosition, SetWorld, SetMargin, SetMins, SetBg,
    Show, Hide};

  RectsOpCode =
    ObLib.OpCode OBJECT
        code: RectsCode;
      END;

  PackageRects =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalRects;
      END;

  PROCEDURE <A NAME="IsRects"><procedure>IsRects</procedure></A>(self: ValRects; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValRects(oth)=&gt; RETURN self.rects = oth.rects;
    ELSE RETURN FALSE END;
  END IsRects;

  VAR rectsException: ObValue.ValException;

  PROCEDURE <A NAME="NewRectsOC"><procedure>NewRectsOC</procedure></A>(name: TEXT; arity: INTEGER; code: RectsCode)
    : RectsOpCode =
  BEGIN
    RETURN NEW(RectsOpCode, name:=name, arity:=arity, code:=code);
  END NewRectsOC;

  PROCEDURE <A NAME="SetupRects"><procedure>SetupRects</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(RectsCode));
    opCodes^ :=
      OpCodes{
      NewRectsOC(&quot;failure&quot;, -1, RectsCode.Error),
      NewRectsOC(&quot;new&quot;, 0, RectsCode.New),
      NewRectsOC(&quot;setWorld&quot;, 5, RectsCode.SetWorld),
      NewRectsOC(&quot;setMargin&quot;, 5, RectsCode.SetMargin),
      NewRectsOC(&quot;setMins&quot;, 3, RectsCode.SetMins),
      NewRectsOC(&quot;setBg&quot;, 2, RectsCode.SetBg),
      NewRectsOC(&quot;setN&quot;, 3, RectsCode.SetN),
      NewRectsOC(&quot;draw&quot;, 2, RectsCode.Draw),
      NewRectsOC(&quot;erase&quot;, 2, RectsCode.Erase),
      NewRectsOC(&quot;exists&quot;, 2, RectsCode.Exists),
      NewRectsOC(&quot;delete&quot;, 3, RectsCode.Delete),
      NewRectsOC(&quot;setColor&quot;, 4, RectsCode.SetColor),
      NewRectsOC(&quot;setPosition&quot;, 7, RectsCode.SetPosition),
      NewRectsOC(&quot;getPosition&quot;, 2, RectsCode.GetPosition),
      NewRectsOC(&quot;show&quot;, 1, RectsCode.Show),
      NewRectsOC(&quot;hide&quot;, 1, RectsCode.Hide)};
    ObLib.Register(
      NEW(PackageRects, name := &quot;rects&quot;, opCodes:=opCodes));
    rectsException := NEW(ObValue.ValException, name:=&quot;rects_failure&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValRects),
      &quot;rects cannot be transmitted/duplicated&quot;);
  END SetupRects;

  PROCEDURE <A NAME="EvalRects"><procedure>EvalRects</procedure></A>(self: PackageRects; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR rs1: ValRects; int1: INTEGER; bool1: BOOLEAN; clr1: Color.T;
      r1: Rect.T; p1,p2: RectsVBT.RealPoint;
      real1, real2, real3, real4: LONGREAL; ar1: REF ARRAY OF ObValue.Val;
    BEGIN
      TRY
      CASE NARROW(opCode, RectsOpCode).code OF
      | RectsCode.Error =&gt;
          RETURN rectsException;
      | RectsCode.SetWorld =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValReal(node) =&gt; real3:=node.real;
          ELSE ObValue.BadArgType(4, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValReal(node) =&gt; real4:=node.real;
          ELSE ObValue.BadArgType(5, &quot;real&quot;, self.name, opCode.name, loc); END;
          RectsVBT.SetWC(rs1.rects,
            FLOAT(real1, REAL), FLOAT(real4, REAL),
            FLOAT(real2, REAL), FLOAT(real3, REAL));
          RETURN ObValue.valOk;
      | RectsCode.SetMargin =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValReal(node) =&gt; real3:=node.real;
          ELSE ObValue.BadArgType(4, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValReal(node) =&gt; real4:=node.real;
          ELSE ObValue.BadArgType(5, &quot;real&quot;, self.name, opCode.name, loc); END;
          RectsVBT.SetMargin(rs1.rects,
            FLOAT(real1, REAL), FLOAT(real4, REAL),
            FLOAT(real2, REAL), FLOAT(real3, REAL));
          RETURN ObValue.valOk;
      | RectsCode.SetMins =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          RectsVBT.SetMins(rs1.rects, FLOAT(real1, REAL), FLOAT(real2, REAL));
          RETURN ObValue.valOk;
      | RectsCode.SetBg =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObLibUI.ValColor(node) =&gt; clr1:=node.color;
          ELSE ObValue.BadArgType(2, &quot;color&quot;, self.name, opCode.name, loc); END;
          RectsVBT.SetBg(rs1.rects, PaintOp.FromRGB(clr1.r, clr1.g, clr1.b,
              mode:=PaintOp.Mode.Accurate));
          RETURN ObValue.valOk;
      | RectsCode.New =&gt;
          RETURN NEW(ValRects, what:=&quot;&lt;a RectsVBT.T&gt;&quot;, picklable:=FALSE,
                 rects:=NEW(RectsVBT.T).init(), n:=-1, shown:=FALSE);
      | RectsCode.SetN =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(3, &quot;bool&quot;, self.name, opCode.name, loc); END;
          IF int1&lt;0 THEN
            ObValue.BadArgVal(2, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          RectsVBT.SetN(rs1.rects, int1, bool1);
          rs1.n := int1;
          RETURN ObValue.valOk;
      | RectsCode.Exists =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF (int1&lt;0) OR (int1&gt;rs1.n) THEN
            ObValue.BadArgVal(2, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          RETURN NEW(ObValue.ValBool, bool:=RectsVBT.Exists(rs1.rects, int1));
      | RectsCode.Delete =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(3, &quot;bool&quot;, self.name, opCode.name, loc); END;
          IF int1&lt;0 THEN
            ObValue.BadArgVal(2, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          RectsVBT.Delete(rs1.rects, int1, bool1);
          RETURN ObValue.valOk;
      | RectsCode.SetColor =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObLibUI.ValColor(node) =&gt; clr1:=node.color;
          ELSE ObValue.BadArgType(3, &quot;color&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(4, &quot;bool&quot;, self.name, opCode.name, loc); END;
          IF (int1&lt;0) OR (int1&gt;rs1.n) THEN
            ObValue.BadArgVal(2, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          RectsVBT.Color(rs1.rects, int1,
            PaintOp.FromRGB(clr1.r, clr1.g, clr1.b,
              mode:=PaintOp.Mode.Accurate),
            bool1);
          RETURN ObValue.valOk;
      | RectsCode.GetPosition =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF (int1&lt;0) OR (int1&gt;rs1.n) THEN
            ObValue.BadArgVal(2, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          r1 := RectsVBT.Locate(rs1.rects, int1);
          p1 := RectsVBT.VBT2WC(rs1.rects,
                  Point.T{h:=r1.west, v:=r1.north});
          p2 := RectsVBT.VBT2WC(rs1.rects,
                  Point.T{h:=r1.east, v:=r1.south});
          ar1 := NEW(REF ARRAY OF ObValue.Val, 4);
          ar1^[0] := NEW(ObValue.ValReal, real:=FLOAT(p1.h,LONGREAL), temp:=FALSE);
          ar1^[1] := NEW(ObValue.ValReal, real:=FLOAT(p2.h,LONGREAL), temp:=FALSE);
          ar1^[2] := NEW(ObValue.ValReal, real:=FLOAT(p1.v,LONGREAL), temp:=FALSE);
          ar1^[3] := NEW(ObValue.ValReal, real:=FLOAT(p2.v,LONGREAL), temp:=FALSE);
          RETURN ObValue.NewArray(ar1^);
      | RectsCode.SetPosition =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(4, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValReal(node) =&gt; real3:=node.real;
          ELSE ObValue.BadArgType(5, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[6] OF | ObValue.ValReal(node) =&gt; real4:=node.real;
          ELSE ObValue.BadArgType(6, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[7] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(4, &quot;bool&quot;, self.name, opCode.name, loc); END;
          IF (int1&lt;0) OR (int1&gt;rs1.n) THEN
            ObValue.BadArgVal(2, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          RectsVBT.Position(rs1.rects, int1,
            FLOAT(real1, REAL), FLOAT(real4, REAL),
            FLOAT(real2, REAL), FLOAT(real3, REAL),
            bool1);
          RETURN ObValue.valOk;
      | RectsCode.Draw =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF (int1&lt;0) OR (int1&gt;rs1.n) THEN
            ObValue.BadArgVal(2, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          RectsVBT.Draw(rs1.rects, int1);
          RETURN ObValue.valOk;
      | RectsCode.Erase =&gt;
          TYPECASE args[1] OF | ValRects(node) =&gt; rs1:=node;
          ELSE ObValue.BadArgType(1,&quot;rects&quot;,self.name,opCode.name,loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF (int1&lt;0) OR (int1&gt;rs1.n) THEN
            ObValue.BadArgVal(2, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          RectsVBT.Erase(rs1.rects, int1);
          RETURN ObValue.valOk;

      | RectsCode.Show =&gt;
          TYPECASE args[1] OF
          | ValRects(node) =&gt;
            IF node.shown THEN
              ObValue.BadArgVal(1, &quot;not already shown&quot;,
                self.name, opCode.name, loc);
            END;
            node.shown := TRUE;
            Trestle.Install(node.rects);
            node.rects.redisplay();
          ELSE ObValue.BadArgType(1, &quot;rects&quot;, self.name, opCode.name, loc);
          END;
          RETURN ObValue.valOk;
      | RectsCode.Hide =&gt;
          TYPECASE args[1] OF
          | ValRects(node) =&gt;
            IF node.shown THEN
              node.shown := FALSE;
              Trestle.Delete(node.rects);
            END;
          ELSE ObValue.BadArgType(1, &quot;rects&quot;, self.name, opCode.name, loc);
          END;
          RETURN ObValue.valOk;
      END;
      EXCEPT
      | TrestleComm.Failure =&gt;
        ObValue.RaiseException(rectsException, opCode.name, loc);
      | NetObj.Error(atoms) =&gt;
              ObValue.RaiseNetException(
                               self.name&amp;&quot;_&quot;&amp;opCode.name, atoms, loc);
      | Thread.Alerted =&gt;
          ObValue.RaiseException(ObValue.threadAlerted,
                               self.name&amp;&quot;_&quot;&amp;opCode.name,loc);
      END;
    END EvalRects;
</PRE> ============ <CODE>graph</CODE> package ============ 

<P><PRE>TYPE

  GraphCode =
    {Error,
     New, Redisplay, Animate, Clear, SetWorld, SetMargin, SetAspect,
       SetPreferredSize, SetPixelSizeDivisor,
       VerticesAt, VertexHiLisAt, EdgesAt, PolygonsAt,
       SetClickAction, SetClickReleaseAction, SetDoubleClickAction,
       SetObjectLayer,
     NewVertex, MoveVertex, MoveVertexOnPath, RemoveVertex, VertexToFront,
       VertexToBack, VertexSetSize, VertexSetShape, VertexSetColor,
       VertexSetFont, VertexSetLabel, VertexSetLabelColor, VertexSetBorder,
       VertexSetBorderColor, VertexGetPosition,
     NewVertexHiLi, MoveVertexHiLi, RemoveVertexHiLi, VertexHiLiToFront,
       VertexHiLiToBack, VertexHiLiSetBorder, VertexHiLiSetColor,
       VertexHiLiGetVertex,
     NewEdge, MoveEdge, MoveEdgeBezier, RemoveEdge, EdgeToFront, EdgeToBack,
       EdgeSetWidth, EdgeSetColor, EdgeSetArrow,
       EdgeGetVertices, EdgeGetControls,
     NewPolygon, MovePolygon, RemovePolygon, PolygonToFront, PolygonToBack,
       PolygonSetColor,
     NewFont, DefaultFont,
     NewSpectrum, SetSpectrumColor, SetSpectrumRange,
     Show, Hide};

  GraphOpCode =
    ObLib.OpCode OBJECT
        code: GraphCode;
      END;

  PackageGraph =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalGraph;
      END;

  PROCEDURE <A NAME="IsGraph"><procedure>IsGraph</procedure></A>(self: ValGraph; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValGraph(oth)=&gt; RETURN self.graph = oth.graph;
    ELSE RETURN FALSE END;
  END IsGraph;

  PROCEDURE <A NAME="IsVertex"><procedure>IsVertex</procedure></A>(self: ValVertex; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValVertex(oth)=&gt; RETURN self.vertex = oth.vertex;
    ELSE RETURN FALSE END;
  END IsVertex;

  PROCEDURE <A NAME="IsVertexHiLi"><procedure>IsVertexHiLi</procedure></A>(self: ValVertexHiLi; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValVertexHiLi(oth)=&gt;
      RETURN self.vertexHiLi = oth.vertexHiLi;
    ELSE RETURN FALSE END;
  END IsVertexHiLi;

  PROCEDURE <A NAME="IsEdge"><procedure>IsEdge</procedure></A>(self: ValEdge; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValEdge(oth)=&gt; RETURN self.edge = oth.edge;
    ELSE RETURN FALSE END;
  END IsEdge;

  PROCEDURE <A NAME="IsPolygon"><procedure>IsPolygon</procedure></A>(self: ValPolygon; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValPolygon(oth)=&gt; RETURN self.polygon = oth.polygon;
    ELSE RETURN FALSE END;
  END IsPolygon;

  PROCEDURE <A NAME="IsFont"><procedure>IsFont</procedure></A>(self: ValFont; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValFont(oth)=&gt; RETURN self.font = oth.font;
    ELSE RETURN FALSE END;
  END IsFont;

  PROCEDURE <A NAME="IsSpectrum"><procedure>IsSpectrum</procedure></A>(self: ValSpectrum; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValSpectrum(oth)=&gt; RETURN self.spectrum = oth.spectrum;
    ELSE RETURN FALSE END;
  END IsSpectrum;

  VAR graphException: ObValue.ValException;

  PROCEDURE <A NAME="NewGraphOC"><procedure>NewGraphOC</procedure></A>(name: TEXT; arity: INTEGER; code: GraphCode)
    : GraphOpCode =
  BEGIN
    RETURN NEW(GraphOpCode, name:=name, arity:=arity, code:=code);
  END NewGraphOC;

  PROCEDURE <A NAME="SetupGraph"><procedure>SetupGraph</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(GraphCode));
    opCodes^ :=
      OpCodes{
      NewGraphOC(&quot;failure&quot;, -1, GraphCode.Error),
      NewGraphOC(&quot;new&quot;, 0, GraphCode.New),
      NewGraphOC(&quot;redisplay&quot;, 1, GraphCode.Redisplay),
      NewGraphOC(&quot;animate&quot;, 3, GraphCode.Animate),
      NewGraphOC(&quot;clear&quot;, 1, GraphCode.Clear),
      NewGraphOC(&quot;setWorld&quot;, 5, GraphCode.SetWorld),
      NewGraphOC(&quot;setMargin&quot;, 2, GraphCode.SetMargin),
      NewGraphOC(&quot;setAspect&quot;, 2, GraphCode.SetAspect),
      NewGraphOC(&quot;setPreferredSize&quot;, 3, GraphCode.SetPreferredSize),
      NewGraphOC(&quot;setPixelSizeDivisor&quot;, 3, GraphCode.SetPixelSizeDivisor),
      NewGraphOC(&quot;verticesAt&quot;, 5, GraphCode.VerticesAt),
      NewGraphOC(&quot;vertexHiLisAt&quot;, 5, GraphCode.VertexHiLisAt),
      NewGraphOC(&quot;edgesAt&quot;, 5, GraphCode.EdgesAt),
      NewGraphOC(&quot;polygonsAt&quot;, 5, GraphCode.PolygonsAt),
      NewGraphOC(&quot;setClickAction&quot;, 2, GraphCode.SetClickAction),
      NewGraphOC(&quot;setClickReleaseAction&quot;, 2, GraphCode.SetClickReleaseAction),
      NewGraphOC(&quot;setDoubleClickAction&quot;, 2, GraphCode.SetDoubleClickAction),
      NewGraphOC(&quot;setObjectLayer&quot;, 2, GraphCode.SetObjectLayer),

      NewGraphOC(&quot;newVertex&quot;, 1, GraphCode.NewVertex),
      NewGraphOC(&quot;moveVertex&quot;, 4, GraphCode.MoveVertex),
      NewGraphOC(&quot;moveVertexOnPath&quot;, 2, GraphCode.MoveVertexOnPath),
      NewGraphOC(&quot;removeVertex&quot;, 1, GraphCode.RemoveVertex),
      NewGraphOC(&quot;vertexToFront&quot;, 1, GraphCode.VertexToFront),
      NewGraphOC(&quot;vertexToBack&quot;, 1, GraphCode.VertexToBack),
      NewGraphOC(&quot;setVertexSize&quot;, 3, GraphCode.VertexSetSize),
      NewGraphOC(&quot;setVertexShape&quot;, 2, GraphCode.VertexSetShape),
      NewGraphOC(&quot;setVertexColor&quot;, 2, GraphCode.VertexSetColor),
      NewGraphOC(&quot;setVertexFont&quot;, 2, GraphCode.VertexSetFont),
      NewGraphOC(&quot;setVertexLabel&quot;, 2, GraphCode.VertexSetLabel),
      NewGraphOC(&quot;setVertexLabelColor&quot;, 2, GraphCode.VertexSetLabelColor),
      NewGraphOC(&quot;setVertexBorder&quot;, 2, GraphCode.VertexSetBorder),
      NewGraphOC(&quot;setVertexBorderColor&quot;, 2, GraphCode.VertexSetBorderColor),
      NewGraphOC(&quot;getVertexPosition&quot;, 1, GraphCode.VertexGetPosition),

      NewGraphOC(&quot;newVertexHiLi&quot;, 1, GraphCode.NewVertexHiLi),
      NewGraphOC(&quot;moveVertexHiLi&quot;, 3, GraphCode.MoveVertexHiLi),
      NewGraphOC(&quot;removeVertexHiLi&quot;, 1, GraphCode.RemoveVertexHiLi),
      NewGraphOC(&quot;vertexHiLiToFront&quot;, 1, GraphCode.VertexHiLiToFront),
      NewGraphOC(&quot;vertexHiLiToBack&quot;, 1, GraphCode.VertexHiLiToBack),
      NewGraphOC(&quot;setVertexHiLiColor&quot;, 2, GraphCode.VertexHiLiSetColor),
      NewGraphOC(&quot;setVertexHiLiBorder&quot;, 3, GraphCode.VertexHiLiSetBorder),
      NewGraphOC(&quot;getVertexHiLiVertex&quot;, 1, GraphCode.VertexHiLiGetVertex),

      NewGraphOC(&quot;newEdge&quot;, 2, GraphCode.NewEdge),
      NewGraphOC(&quot;moveEdge&quot;, 4, GraphCode.MoveEdge),
      NewGraphOC(&quot;moveEdgeBezier&quot;, 6, GraphCode.MoveEdgeBezier),
      NewGraphOC(&quot;removeEdge&quot;, 1, GraphCode.RemoveEdge),
      NewGraphOC(&quot;edgeToFront&quot;, 1, GraphCode.EdgeToFront),
      NewGraphOC(&quot;edgeToBack&quot;, 1, GraphCode.EdgeToBack),
      NewGraphOC(&quot;setEdgeWidth&quot;, 2, GraphCode.EdgeSetWidth),
      NewGraphOC(&quot;setEdgeColor&quot;, 2, GraphCode.EdgeSetColor),
      NewGraphOC(&quot;setEdgeArrows&quot;, 3, GraphCode.EdgeSetArrow),
      NewGraphOC(&quot;getEdgeVertices&quot;, 1, GraphCode.EdgeGetVertices),
      NewGraphOC(&quot;getEdgeControls&quot;, 1, GraphCode.EdgeGetControls),

      NewGraphOC(&quot;newPolygon&quot;, 1, GraphCode.NewPolygon),
      NewGraphOC(&quot;movePolygon&quot;, 3, GraphCode.MovePolygon),
      NewGraphOC(&quot;removePolygon&quot;, 1, GraphCode.RemovePolygon),
      NewGraphOC(&quot;polygonToFront&quot;, 1, GraphCode.PolygonToFront),
      NewGraphOC(&quot;polygonToBack&quot;, 1, GraphCode.PolygonToBack),
      NewGraphOC(&quot;setPolygonColor&quot;, 2, GraphCode.PolygonSetColor),

      NewGraphOC(&quot;newFont&quot;, 6,  GraphCode.NewFont),
      NewGraphOC(&quot;defaultFont&quot;, -1, GraphCode.DefaultFont),

      NewGraphOC(&quot;newSpectrum&quot;, 1, GraphCode.NewSpectrum),
      NewGraphOC(&quot;setSpectrumColor&quot;, 2, GraphCode.SetSpectrumColor),
      NewGraphOC(&quot;setSpectrumRange&quot;, 2, GraphCode.SetSpectrumRange),

      NewGraphOC(&quot;show&quot;, 1, GraphCode.Show),
      NewGraphOC(&quot;hide&quot;, 1, GraphCode.Hide)
      };
    ObLib.Register(
      NEW(PackageGraph, name := &quot;graph&quot;, opCodes:=opCodes));
    graphException := NEW(ObValue.ValException, name:=&quot;graph_failure&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValGraph),
      &quot;graphs cannot be transmitted/duplicated&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValVertex),
      &quot;vetices cannot be transmitted/duplicated&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValVertexHiLi),
      &quot;vertex hilights cannot be transmitted/duplicated&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValEdge),
      &quot;edges cannot be transmitted/duplicated&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValPolygon),
      &quot;polygons cannot be transmitted/duplicated&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValFont),
      &quot;fonts cannot be transmitted/duplicated&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValSpectrum),
      &quot;spectrums cannot be transmitted/duplicated&quot;);
  END SetupGraph;

  PROCEDURE <A NAME="EvalGraph"><procedure>EvalGraph</procedure></A>(self: PackageGraph; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR gr1: Graph; gr0: ValGraph;
      v1,v2,v3,v4: GraphVBT.Vertex; e1: GraphVBT.Edge;
      p1: GraphVBT.Polygon; real1, real2, real3, real4: LONGREAL;
      list: RefList.T; size: INTEGER;
      bool1, bool2: BOOLEAN; text1, text2, text3, text4: TEXT;
      vh1: GraphVBT.VertexHighlight; font1: GraphVBT.WorldFont;
      fun1: ObValue.Val; int1,int2: INTEGER; sp1: ValSpectrum;
      moveClosure: MoveClosure; cl1: ObLibUI.ValColor;
      array1, ar1: REF ARRAY OF ObValue.Val; rl1: RefList.T;
    BEGIN
      TRY
      CASE NARROW(opCode, GraphOpCode).code OF
      | GraphCode.Error =&gt;
          RETURN graphException;
      | GraphCode.New =&gt;
          gr1 :=NEW(Graph, clickAction:=NIL,
              clickReleaseAction:=NIL, doubleClickAction:=NIL).init();
          gr0 := NEW(ValGraph, what:=&quot;&lt;a GraphVBT.T&gt;&quot;, picklable:=FALSE,
                     shown:=FALSE);
          gr1.valGraph := gr0;
          gr0.graph := gr1;
          RETURN gr0;
      | GraphCode.Redisplay =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          gr1.redisplay();
          RETURN ObValue.valOk;
      | GraphCode.Animate =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          Animate.SetDuration(1.0);
          Animate.ResetATime();
          gr1.animate(FLOAT(real1), FLOAT(real2));
          RETURN ObValue.valOk;
      | GraphCode.Clear =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          gr1.clear();
          RETURN ObValue.valOk;
      | GraphCode.SetWorld =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValReal(node) =&gt; real3:=node.real;
          ELSE ObValue.BadArgType(4, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValReal(node) =&gt; real4:=node.real;
          ELSE ObValue.BadArgType(5, &quot;real&quot;, self.name, opCode.name, loc); END;
          gr1.setWorld(GraphVBT.WorldRectangle{
            w:=FLOAT(real1), e:=FLOAT(real2),
            n:=FLOAT(real3), s:=FLOAT(real4)});
          RETURN ObValue.valOk;
      | GraphCode.SetMargin =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          gr1.setMargin(FLOAT(real1));
          RETURN ObValue.valOk;
      | GraphCode.SetAspect =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          gr1.setAspect(FLOAT(real1));
          RETURN ObValue.valOk;
      | GraphCode.SetPreferredSize =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          gr1.setPreferredSize(R2.T{FLOAT(real1), FLOAT(real2)});
          RETURN ObValue.valOk;
      | GraphCode.SetPixelSizeDivisor =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValInt(node) =&gt; int2:=node.int;
          ELSE ObValue.BadArgType(3, &quot;int&quot;, self.name, opCode.name, loc); END;
          gr1.setPixelSizeDivisor(
            ARRAY[0..1]OF CARDINAL{MAX(1,int1), MAX(1, int2)});
          RETURN ObValue.valOk;
      | GraphCode.VerticesAt =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValReal(node) =&gt; real3:=node.real;
          ELSE ObValue.BadArgType(4, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValReal(node) =&gt; real4:=node.real;
          ELSE ObValue.BadArgType(5, &quot;real&quot;, self.name, opCode.name, loc); END;
          rl1 := gr1.verticesAt(
            WorldRectToScreenRect(gr1.world, VBT.Domain(gr1),
                                  real1, real2, real3, real4));
          int1 := RefList.Length(rl1);
          ar1 := NEW(REF ARRAY OF ObValue.Val, int1);
          FOR i:=0 TO int1-1 DO
            ar1^[i] := NEW(ValVertex, what:=&quot;&lt;a GraphVBT.Vertex&gt;&quot;,
                           picklable:=FALSE, vertex:=rl1.head);
            rl1 := rl1.tail;
          END;
          RETURN ObValue.NewArray(ar1^);
      | GraphCode.VertexHiLisAt =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValReal(node) =&gt; real3:=node.real;
          ELSE ObValue.BadArgType(4, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValReal(node) =&gt; real4:=node.real;
          ELSE ObValue.BadArgType(5, &quot;real&quot;, self.name, opCode.name, loc); END;
          rl1 := gr1.vertexHighlightsAt(
            WorldRectToScreenRect(gr1.world, VBT.Domain(gr1),
                                  real1, real2, real3, real4));
          int1 := RefList.Length(rl1);
          ar1 := NEW(REF ARRAY OF ObValue.Val, int1);
          FOR i:=0 TO int1-1 DO
            ar1^[i] := NEW(ValVertexHiLi,
                           what:=&quot;&lt;a GraphVBT.VertexHighlight&gt;&quot;,
                           picklable:=FALSE, vertexHiLi:=rl1.head);
            rl1 := rl1.tail;
          END;
          RETURN ObValue.NewArray(ar1^);
      | GraphCode.EdgesAt =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValReal(node) =&gt; real3:=node.real;
          ELSE ObValue.BadArgType(4, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValReal(node) =&gt; real4:=node.real;
          ELSE ObValue.BadArgType(5, &quot;real&quot;, self.name, opCode.name, loc); END;
          rl1 := gr1.edgesAt(
            WorldRectToScreenRect(gr1.world, VBT.Domain(gr1),
                                  real1, real2, real3, real4));
          int1 := RefList.Length(rl1);
          ar1 := NEW(REF ARRAY OF ObValue.Val, int1);
          FOR i:=0 TO int1-1 DO
            ar1^[i] := NEW(ValEdge, what:=&quot;&lt;a GraphVBT.Edge&gt;&quot;,
                           picklable:=FALSE, edge:=rl1.head);
            rl1 := rl1.tail;
          END;
          RETURN ObValue.NewArray(ar1^);
      | GraphCode.PolygonsAt =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValReal(node) =&gt; real3:=node.real;
          ELSE ObValue.BadArgType(4, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValReal(node) =&gt; real4:=node.real;
          ELSE ObValue.BadArgType(5, &quot;real&quot;, self.name, opCode.name, loc); END;
          rl1 := gr1.polygonsAt(
            WorldRectToScreenRect(gr1.world, VBT.Domain(gr1),
                                  real1, real2, real3, real4));
          int1 := RefList.Length(rl1);
          ar1 := NEW(REF ARRAY OF ObValue.Val, int1);
          FOR i:=0 TO int1-1 DO
            ar1^[i] := NEW(ValPolygon, what:=&quot;&lt;a GraphVBT.Polygon&gt;&quot;,
                           picklable:=FALSE, polygon:=rl1.head);
            rl1 := rl1.tail;
          END;
          RETURN ObValue.NewArray(ar1^);
      | GraphCode.SetClickAction =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValFun(node) =&gt; fun1:=node;
          ELSE ObValue.BadArgType(2, &quot;procedure&quot;, self.name, opCode.name, loc); END;
          gr1.clickAction := fun1;
          RETURN ObValue.valOk;
      | GraphCode.SetClickReleaseAction =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValFun(node) =&gt; fun1:=node;
          ELSE ObValue.BadArgType(2, &quot;procedure&quot;, self.name, opCode.name, loc); END;
          gr1.clickReleaseAction := fun1;
          RETURN ObValue.valOk;
      | GraphCode.SetDoubleClickAction =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValFun(node) =&gt; fun1:=node;
          ELSE ObValue.BadArgType(2, &quot;procedure&quot;, self.name, opCode.name, loc); END;
          gr1.doubleClickAction := fun1;
          RETURN ObValue.valOk;
      | GraphCode.SetObjectLayer =&gt;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[1] OF
          | ValVertex(node) =&gt;
              node.vertex.toFront(VAL(int1, GraphVBT.ZOrder));
          | ValVertexHiLi(node) =&gt;
              node.vertexHiLi.toFront(VAL(int1, GraphVBT.ZOrder));
          | ValEdge(node) =&gt;
              node.edge.toFront(VAL(int1, GraphVBT.ZOrder));
          | ValPolygon(node) =&gt;
              node.polygon.toFront(VAL(int1, GraphVBT.ZOrder));
          ELSE ObValue.BadArgType(1, &quot;graph object&quot;,
              self.name, opCode.name, loc);
          END;
          RETURN ObValue.valOk;

      | GraphCode.NewVertex =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc); END;
          v1 :=NEW(GraphVBT.Vertex, graph:=gr1).init();
          RETURN NEW(ValVertex, what:=&quot;&lt;a GraphVBT.Vertex&gt;&quot;,
              picklable:=FALSE, vertex:=v1);
      | GraphCode.MoveVertex =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(4, &quot;bool&quot;, self.name, opCode.name, loc); END;
          v1.move(R2.T{FLOAT(real1), FLOAT(real2)} , bool1, 0.0, 1.0, NIL);
          RETURN ObValue.valOk;
      | GraphCode.MoveVertexOnPath =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValFun(node) =&gt; fun1:=node;
          ELSE ObValue.BadArgType(2, &quot;procedure&quot;, self.name, opCode.name, loc); END;
          moveClosure := NEW(MoveClosure, fun:=fun1, location:=loc);
          (* -- Sets the final vertex position by calling the obliq
             procedure at time 1.0. *)
          v1.move(moveClosure.pos(1.0), TRUE, 0.0, 1.0, moveClosure);
          RETURN ObValue.valOk;
      | GraphCode.RemoveVertex =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          v1.remove();
          RETURN ObValue.valOk;
      | GraphCode.VertexToFront =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          v1.toFront();
          RETURN ObValue.valOk;
      | GraphCode.VertexToBack =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          v1.toBack();
          RETURN ObValue.valOk;
      | GraphCode.VertexSetSize =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          v1.setSize(R2.T{FLOAT(real1), FLOAT(real2)});
          RETURN ObValue.valOk;
      | GraphCode.VertexSetShape =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          IF Text.Equal(text1, &quot;rectangle&quot;) THEN
             v1.setShape(GraphVBT.VertexShape.Rectangle);
          ELSIF Text.Equal(text1, &quot;ellipse&quot;) THEN
             v1.setShape(GraphVBT.VertexShape.Ellipse);
          ELSE
            ObValue.BadArgVal(2, &quot;\&quot;rectangle\&quot; or \&quot;ellipse\&quot;&quot;,
                self.name, opCode.name, loc);
          END;
          RETURN ObValue.valOk;
      | GraphCode.VertexSetColor =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          v1.setColor(ExtractColor(args[2], 2, self.name, opCode.name, loc));
          RETURN ObValue.valOk;
      | GraphCode.VertexSetFont =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ValFont(node) =&gt; font1:=node.font;
          ELSE ObValue.BadArgType(2, &quot;font&quot;, self.name, opCode.name, loc); END;
          v1.setFont(font1);
          RETURN ObValue.valOk;
      | GraphCode.VertexSetLabel =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          v1.setLabel(text1);
          RETURN ObValue.valOk;
      | GraphCode.VertexSetLabelColor =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          v1.setFontColor(ExtractColor(args[2], 2, self.name, opCode.name, loc));
          RETURN ObValue.valOk;
      | GraphCode.VertexSetBorder =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          v1.setBorder(FLOAT(real1));
          RETURN ObValue.valOk;
      | GraphCode.VertexSetBorderColor =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          (* -- v1.setBorderColor(ExtractColor(args[2], 2, self.name, opCode.name, loc)); *)
          v1.setFontColor(ExtractColor(args[2], 2, self.name, opCode.name, loc));
          RETURN ObValue.valOk;
      | GraphCode.VertexGetPosition =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc)END;
          ar1 := NEW(REF ARRAY OF ObValue.Val, 2);
          ar1^[0] := NEW(ObValue.ValReal, real:=FLOAT(v1.pos[0],LONGREAL), temp:=FALSE);
          ar1^[1] := NEW(ObValue.ValReal, real:=FLOAT(v1.pos[1],LONGREAL), temp:=FALSE);
          RETURN ObValue.NewArray(ar1^);

      | GraphCode.NewVertexHiLi =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          vh1 :=NEW(GraphVBT.VertexHighlight, vertex:=v1).init();
          RETURN NEW(ValVertexHiLi, what:=&quot;&lt;a GraphVBT.VertexHighlight&gt;&quot;,
                     picklable:=FALSE, vertexHiLi:=vh1);
      | GraphCode.MoveVertexHiLi =&gt;
          TYPECASE args[1] OF | ValVertexHiLi(node) =&gt; vh1:=node.vertexHiLi;
          ELSE ObValue.BadArgType(1, &quot;vertexHiLi&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(2, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(3, &quot;bool&quot;, self.name, opCode.name, loc); END;
          vh1.move(v1, bool1);
          RETURN ObValue.valOk;
      | GraphCode.RemoveVertexHiLi =&gt;
          TYPECASE args[1] OF | ValVertexHiLi(node) =&gt; vh1:=node.vertexHiLi;
          ELSE ObValue.BadArgType(1, &quot;vertexHiLi&quot;, self.name, opCode.name, loc); END;
          vh1.remove();
          RETURN ObValue.valOk;
      | GraphCode.VertexHiLiToFront =&gt;
          TYPECASE args[1] OF | ValVertexHiLi(node) =&gt; vh1:=node.vertexHiLi;
          ELSE ObValue.BadArgType(1, &quot;vertexHiLi&quot;, self.name, opCode.name, loc); END;
          vh1.toFront();
          RETURN ObValue.valOk;
      | GraphCode.VertexHiLiToBack =&gt;
          TYPECASE args[1] OF | ValVertexHiLi(node) =&gt; vh1:=node.vertexHiLi;
          ELSE ObValue.BadArgType(1, &quot;vertexHiLi&quot;, self.name, opCode.name, loc); END;
          vh1.toBack();
          RETURN ObValue.valOk;
      | GraphCode.VertexHiLiSetColor =&gt;
          TYPECASE args[1] OF | ValVertexHiLi(node) =&gt; vh1:=node.vertexHiLi;
          ELSE ObValue.BadArgType(1, &quot;vertexHiLi&quot;, self.name, opCode.name, loc); END;
          vh1.setColor(ExtractColor(args[2], 2, self.name, opCode.name, loc));
          RETURN ObValue.valOk;
      | GraphCode.VertexHiLiSetBorder =&gt;
          TYPECASE args[1] OF | ValVertexHiLi(node) =&gt; vh1:=node.vertexHiLi;
          ELSE ObValue.BadArgType(1, &quot;vertexHiLi&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          vh1.setBorder(R2.T{FLOAT(real1), FLOAT(real2)});
          RETURN ObValue.valOk;
      | GraphCode.VertexHiLiGetVertex =&gt;
          TYPECASE args[1] OF | ValVertexHiLi(node) =&gt; vh1:=node.vertexHiLi;
          ELSE ObValue.BadArgType(1, &quot;vertexHiLi&quot;, self.name, opCode.name, loc); END;
          RETURN NEW(ValVertex, what:=&quot;&lt;a GraphVBT.Vertex&gt;&quot;,
                     picklable:=FALSE, vertex:=vh1.vertex);

      | GraphCode.NewEdge =&gt;
          TYPECASE args[1] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(1, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ValVertex(node) =&gt; v2:=node.vertex;
          ELSE ObValue.BadArgType(2, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          e1 :=NEW(GraphVBT.Edge, vertex0:=v1, vertex1:=v2).init();
          RETURN NEW(ValEdge, what:=&quot;&lt;a GraphVBT.Edge&gt;&quot;,
              picklable:=FALSE, edge:=e1);
      | GraphCode.MoveEdge =&gt;
          TYPECASE args[1] OF | ValEdge(node) =&gt; e1:=node.edge;
          ELSE ObValue.BadArgType(1, &quot;edge&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(2, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ValVertex(node) =&gt; v2:=node.vertex;
          ELSE ObValue.BadArgType(3, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(4, &quot;bool&quot;, self.name, opCode.name, loc); END;
          e1.move(v1, v2, NIL, NIL, bool1);
          RETURN ObValue.valOk;
      | GraphCode.MoveEdgeBezier =&gt;
          TYPECASE args[1] OF | ValEdge(node) =&gt; e1:=node.edge;
          ELSE ObValue.BadArgType(1, &quot;edge&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ValVertex(node) =&gt; v1:=node.vertex;
          ELSE ObValue.BadArgType(2, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ValVertex(node) =&gt; v2:=node.vertex;
          ELSE ObValue.BadArgType(3, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ValVertex(node) =&gt; v3:=node.vertex;
          ELSE ObValue.BadArgType(4, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ValVertex(node) =&gt; v4:=node.vertex;
          ELSE ObValue.BadArgType(5, &quot;vertex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[6] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(6, &quot;bool&quot;, self.name, opCode.name, loc); END;
          e1.move(v1, v2, v3, v4, bool1);
          RETURN ObValue.valOk;
      | GraphCode.RemoveEdge =&gt;
          TYPECASE args[1] OF | ValEdge(node) =&gt; e1:=node.edge;
          ELSE ObValue.BadArgType(1, &quot;edge&quot;, self.name, opCode.name, loc); END;
          e1.remove();
          RETURN ObValue.valOk;
      | GraphCode.EdgeToFront =&gt;
          TYPECASE args[1] OF | ValEdge(node) =&gt; e1:=node.edge;
          ELSE ObValue.BadArgType(1, &quot;edge&quot;, self.name, opCode.name, loc); END;
          e1.toFront();
          RETURN ObValue.valOk;
      | GraphCode.EdgeToBack =&gt;
          TYPECASE args[1] OF | ValEdge(node) =&gt; e1:=node.edge;
          ELSE ObValue.BadArgType(1, &quot;edge&quot;, self.name, opCode.name, loc); END;
          e1.toBack();
          RETURN ObValue.valOk;
      | GraphCode.EdgeSetWidth =&gt;
          TYPECASE args[1] OF | ValEdge(node) =&gt; e1:=node.edge;
          ELSE ObValue.BadArgType(1, &quot;edge&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          e1.setWidth(FLOAT(real1));
          RETURN ObValue.valOk;
      | GraphCode.EdgeSetColor =&gt;
          TYPECASE args[1] OF | ValEdge(node) =&gt; e1:=node.edge;
          ELSE ObValue.BadArgType(1, &quot;edge&quot;, self.name, opCode.name, loc); END;
          e1.setColor(ExtractColor(args[2], 2, self.name, opCode.name, loc));
          RETURN ObValue.valOk;
      | GraphCode.EdgeSetArrow =&gt;
          TYPECASE args[1] OF | ValEdge(node) =&gt; e1:=node.edge;
          ELSE ObValue.BadArgType(1, &quot;edge&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(2, &quot;bool&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValBool(node) =&gt; bool2:=node.bool;
          ELSE ObValue.BadArgType(3, &quot;bool&quot;, self.name, opCode.name, loc); END;
          e1.setArrow(ARRAY[0..1]OF BOOLEAN{bool1, bool2});
          RETURN ObValue.valOk;
      | GraphCode.EdgeGetVertices =&gt;
          TYPECASE args[1] OF | ValEdge(node) =&gt; e1:=node.edge;
          ELSE ObValue.BadArgType(1, &quot;edge&quot;, self.name, opCode.name, loc); END;
          ar1 := NEW(REF ARRAY OF ObValue.Val, 2);
          ar1^[0] :=
              NEW(ValVertex, what:=&quot;&lt;a GraphVBT.Vertex&gt;&quot;,
                  picklable:=FALSE, vertex:=e1.vertex0);
          ar1^[1] :=
              NEW(ValVertex, what:=&quot;&lt;a GraphVBT.Vertex&gt;&quot;,
                  picklable:=FALSE, vertex:=e1.vertex1);
          RETURN ObValue.NewArray(ar1^);
      | GraphCode.EdgeGetControls =&gt;
          TYPECASE args[1] OF | ValEdge(node) =&gt; e1:=node.edge;
          ELSE ObValue.BadArgType(1, &quot;edge&quot;, self.name, opCode.name, loc); END;
          IF (e1.control0=NIL) OR (e1.control1=NIL) THEN
            ar1 := NEW(REF ARRAY OF ObValue.Val, 0);
            RETURN ObValue.NewArray(ar1^);
          ELSE
            ar1 := NEW(REF ARRAY OF ObValue.Val, 2);
            ar1^[0] :=
              NEW(ValVertex, what:=&quot;&lt;a GraphVBT.Vertex&gt;&quot;,
                  picklable:=FALSE, vertex:=e1.control0);
            ar1^[1] :=
              NEW(ValVertex, what:=&quot;&lt;a GraphVBT.Vertex&gt;&quot;,
                  picklable:=FALSE, vertex:=e1.control1);
            RETURN ObValue.NewArray(ar1^);
          END;

      | GraphCode.NewPolygon =&gt;
          TYPECASE args[1] OF
          | ObValue.ValArray(node) =&gt; array1:=node.remote.Obtain();
          ELSE ObValue.BadArgType(1, &quot;array&quot;, self.name, opCode.name, loc); END;
          size := NUMBER(array1^);
          list := NIL;
          FOR i := 0 TO size-1 DO
            TYPECASE array1^[(size-1)-i] OF
            | ValVertex(node) =&gt; list := RefList.Cons(node.vertex, list);
            ELSE ObValue.BadArgType(1,&quot;array(vertex)&quot;,self.name,opCode.name,loc);
            END;
          END;
          p1 :=NEW(GraphVBT.Polygon, vertices:=list).init();
          RETURN NEW(ValPolygon, what:=&quot;&lt;a GraphVBT.Polygon&gt;&quot;,
              picklable:=FALSE, polygon:=p1);
      | GraphCode.MovePolygon =&gt;
          TYPECASE args[1] OF | ValPolygon(node) =&gt; p1:=node.polygon;
          ELSE ObValue.BadArgType(1, &quot;polygon&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF
          | ObValue.ValArray(node) =&gt; array1:=node.remote.Obtain();
          ELSE ObValue.BadArgType(2, &quot;array&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(3, &quot;bool&quot;, self.name, opCode.name, loc); END;
          size := NUMBER(array1^);
          list := NIL;
          FOR i := 0 TO size-1 DO
            TYPECASE array1^[(size-1)-i] OF
            | ValVertex(node) =&gt; list := RefList.Cons(node.vertex, list);
            ELSE ObValue.BadArgType(1,&quot;array(vertex)&quot;,self.name,opCode.name,loc);
            END;
          END;
          p1.move(list, bool1);
          RETURN ObValue.valOk;
      | GraphCode.RemovePolygon =&gt;
          TYPECASE args[1] OF | ValPolygon(node) =&gt; p1:=node.polygon;
          ELSE ObValue.BadArgType(1, &quot;polygon&quot;, self.name, opCode.name, loc); END;
          p1.remove();
          RETURN ObValue.valOk;
      | GraphCode.PolygonToFront =&gt;
          TYPECASE args[1] OF | ValPolygon(node) =&gt; p1:=node.polygon;
          ELSE ObValue.BadArgType(1, &quot;polygon&quot;, self.name, opCode.name, loc); END;
          p1.toFront();
          RETURN ObValue.valOk;
      | GraphCode.PolygonToBack =&gt;
          TYPECASE args[1] OF | ValPolygon(node) =&gt; p1:=node.polygon;
          ELSE ObValue.BadArgType(1, &quot;polygon&quot;, self.name, opCode.name, loc); END;
          p1.toBack();
          RETURN ObValue.valOk;
      | GraphCode.PolygonSetColor =&gt;
          TYPECASE args[1] OF | ValPolygon(node) =&gt; p1:=node.polygon;
          ELSE ObValue.BadArgType(1, &quot;polygon&quot;, self.name, opCode.name, loc); END;
          p1.setColor(ExtractColor(args[2], 2, self.name, opCode.name, loc));
          RETURN ObValue.valOk;

      | GraphCode.NewFont =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(4, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValText(node) =&gt; text3:=node.text;
          ELSE ObValue.BadArgType(5, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[6] OF | ObValue.ValText(node) =&gt; text4:=node.text;
          ELSE ObValue.BadArgType(6, &quot;text&quot;, self.name, opCode.name, loc); END;
          font1 :=
              gr1.font(text1, FLOAT(real1), ExtractSlant(text2), text3, text4);
          RETURN NEW(ValFont, what:=&quot;&lt;a GraphVBT.WorldFont&gt;&quot;,
            picklable:=FALSE, font:=font1);
      | GraphCode.DefaultFont =&gt;
          RETURN NEW(ValFont, what:=&quot;&lt;a GraphVBT.WorldFont&gt;&quot;,
            picklable:=FALSE, font:=GraphVBT.DefaultFont);

      | GraphCode.NewSpectrum =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          RETURN
            NEW(ValSpectrum, what:=&quot;&lt;a GraphVBT.Spectrum&gt;&quot;,
                picklable:=FALSE, graph := gr1,
                spectrum:=NEW(PaintOpAnim.T).init(Color.Black));
      | GraphCode.SetSpectrumColor =&gt;
          TYPECASE args[1] OF | ValSpectrum(node) =&gt; sp1:=node;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObLibUI.ValColor(node) =&gt; cl1:=node;
          ELSE ObValue.BadArgType(2, &quot;color&quot;, self.name, opCode.name, loc) END;
          sp1.spectrum.set(sp1.graph, cl1.color);
          RETURN ObValue.valOk;
      | GraphCode.SetSpectrumRange =&gt;
          TYPECASE args[1] OF | ValSpectrum(node) =&gt; sp1:=node;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc) END;
          TYPECASE args[2] OF | ObValue.ValFun(node) =&gt; fun1:=node;
          ELSE ObValue.BadArgType(2, &quot;procedure&quot;, self.name, opCode.name, loc); END;
          sp1.spectrum.animate(sp1.graph,
            NEW(SpectrumClosure, fun:=fun1, location:=loc));
          RETURN ObValue.valOk;

      | GraphCode.Show =&gt;
          TYPECASE args[1] OF
          | ValGraph(node) =&gt;
            IF node.shown THEN
              ObValue.BadArgVal(1, &quot;not already shown&quot;,
                self.name, opCode.name, loc);
            END;
            node.shown := TRUE;
            Trestle.Install(node.graph);
            node.graph.redisplay();
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc);
          END;
          RETURN ObValue.valOk;
      | GraphCode.Hide =&gt;
          TYPECASE args[1] OF
          | ValGraph(node) =&gt;
            IF node.shown THEN
              node.shown := FALSE;
              Trestle.Delete(node.graph);
            END;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc);
          END;
          RETURN ObValue.valOk;
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
      EXCEPT
      | TrestleComm.Failure =&gt;
        ObValue.RaiseException(graphException, opCode.name, loc);
      | NetObj.Error(atoms) =&gt;
              ObValue.RaiseNetException(
                               self.name&amp;&quot;_&quot;&amp;opCode.name, atoms, loc);
      | Thread.Alerted =&gt;
          ObValue.RaiseException(ObValue.threadAlerted,
                               self.name&amp;&quot;_&quot;&amp;opCode.name,loc);
      END;
    END EvalGraph;

  TYPE SpectrumClosure =
    PaintOpAnim.Animation OBJECT
      fun: ObValue.ValFun;
      location: SynLocation.T;
    OVERRIDES
      rgb := SpectrumRangeClosure;
    END;

  PROCEDURE <A NAME="SpectrumRangeClosure"><procedure>SpectrumRangeClosure</procedure></A>(self: SpectrumClosure; t: REAL): Color.T RAISES {} =
  (* Can't produce any good error messages because it must raise {} *)
    VAR v: ObValue.Val; args: ARRAY [0..0] OF ObValue.Val;
    BEGIN
      TRY
        args[0] := NEW(ObValue.ValReal, real:=FLOAT(t, LONGREAL), temp:=FALSE);
        v := ObEval.Call(self.fun, args, self.location);
        TYPECASE v OF
        | ObLibUI.ValColor(node) =&gt; RETURN node.color;
        | ValSpectrum(node) =&gt; RETURN node.spectrum.get();
        ELSE ObValue.RaiseError(
          &quot;argument of graph_setSpectrumRange must return a color&quot;,
          self.location);
        END;
      EXCEPT
      | ObValue.Error(packet) =&gt;
          SynWr.Text(SynWr.out,
           &quot;*** A Modula3 callback to Obliq caused an Obliq error: ***\n&quot;);
          ObValue.ErrorMsg(SynWr.out,packet);
          SynWr.Flush(SynWr.out);
          RETURN Color.Black;
      | ObValue.Exception(packet) =&gt;
          SynWr.Text(SynWr.out,
           &quot;*** A Modula3 callback to Obliq caused an Obliq exception: ***\n&quot;);
          ObValue.ExceptionMsg(SynWr.out,packet);
          SynWr.Flush(SynWr.out);
          RETURN Color.Black;
      END;
    END SpectrumRangeClosure;

  TYPE MoveClosure =
    GraphVBT.AnimationPath OBJECT
      fun: ObValue.ValFun;
      location: SynLocation.T;
    OVERRIDES
      pos := MoveOnPathClosure;
    END;

  PROCEDURE <A NAME="MoveOnPathClosure"><procedure>MoveOnPathClosure</procedure></A>(self: MoveClosure; t: REAL): R2.T RAISES {} =
  (* Can't produce any good error messages because it must raise {} *)
    VAR v,vx,vy: ObValue.Val; rx,ry: REAL; args: ARRAY [0..0] OF ObValue.Val;
    BEGIN
      TRY
        args[0] := NEW(ObValue.ValReal, real:=FLOAT(t, LONGREAL), temp:=FALSE);
        v := ObEval.Call(self.fun, args, self.location);
        TYPECASE v OF
        | ObValue.ValArray(node) =&gt;
          TRY
            vx := node.remote.Get(0);
            vy := node.remote.Get(1);
          EXCEPT
          | ObValue.ServerError(msg) =&gt;
              ObValue.RaiseError(msg, self.location);
          | NetObj.Error(atoms) =&gt;
              ObValue.RaiseNetException(
                &quot;on remote array access&quot;, atoms, self.location);
          END;
        ELSE ObValue.RaiseError(
          &quot;argument of graph_moveOnPath must return an array(2,real)&quot;,
          self.location);
        END;
        TYPECASE vx OF | ObValue.ValReal(node) =&gt; rx:=FLOAT(node.real, REAL);
        ELSE ObValue.RaiseError(
          &quot;argument of graph_moveOnPath must return an array(2,real)&quot;,
          self.location);
        END;
        TYPECASE vy OF | ObValue.ValReal(node) =&gt; ry:=FLOAT(node.real, REAL);
        ELSE ObValue.RaiseError(
          &quot;argument of graph_moveOnPath must return an array(2,real)&quot;,
          self.location);
        END;
        RETURN R2.T{rx, ry};
      EXCEPT
      | ObValue.Error(packet) =&gt;
          SynWr.Text(SynWr.out,
            &quot;*** A Modula3 callback to Obliq caused an Obliq error: ***\n&quot;);
          ObValue.ErrorMsg(SynWr.out,packet);
          SynWr.Flush(SynWr.out);
          RETURN R2.T{0.0, 0.0};
      | ObValue.Exception(packet) =&gt;
          SynWr.Text(SynWr.out,
           &quot;*** A Modula3 callback to Obliq caused an Obliq exception: ***\n&quot;);
          ObValue.ExceptionMsg(SynWr.out,packet);
          SynWr.Flush(SynWr.out);
          RETURN R2.T{0.0, 0.0};
      END;
    END MoveOnPathClosure;

  PROCEDURE <A NAME="ExtractColor"><procedure>ExtractColor</procedure></A>(ob: ObValue.Val; argNo: INTEGER; name, opName: TEXT;
    loc: SynLocation.T): PaintOp.T RAISES {ObValue.Error} =
  BEGIN
    TYPECASE ob OF
    | ObLibUI.ValColor(node) =&gt;
        RETURN PaintOp.FromRGB(node.color.r, node.color.g, node.color.b,
          mode:=PaintOp.Mode.Accurate);
    | ValSpectrum(node) =&gt;
        RETURN node.spectrum.op();
    ELSE ObValue.BadArgType(argNo, &quot;color or spectrum&quot;, name, opName, loc);
    END;
  END ExtractColor;

  PROCEDURE <A NAME="ExtractSlant"><procedure>ExtractSlant</procedure></A>(slant: TEXT): GraphVBT.Slant =
  BEGIN
    IF Text.Equal(slant, &quot;Roman&quot;) THEN RETURN GraphVBT.Slant.Roman;
    ELSIF Text.Equal(slant, &quot;Italic&quot;) THEN RETURN GraphVBT.Slant.Italic;
    ELSIF Text.Equal(slant, &quot;Oblique&quot;) THEN RETURN GraphVBT.Slant.Oblique;
    ELSIF Text.Equal(slant, &quot;ReverseItalic&quot;) THEN RETURN GraphVBT.Slant.ReverseItalic;
    ELSIF Text.Equal(slant, &quot;ReverseOblique&quot;) THEN RETURN GraphVBT.Slant.ReverseOblique;
    ELSIF Text.Equal(slant, &quot;Other&quot;) THEN RETURN GraphVBT.Slant.Other;
    ELSIF Text.Equal(slant, &quot;Any&quot;) THEN RETURN GraphVBT.Slant.Any;
    ELSE RETURN GraphVBT.Slant.Roman;
    END;
  END ExtractSlant;

  PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A>(self: Graph; READONLY cd: VBT.MouseRec) =
  VAR r2:R2.T; args: ARRAY [0..2] OF ObValue.Val;
  BEGIN
    TRY
      IF (cd.clickType = VBT.ClickType.FirstDown) AND (cd.clickCount = 0)
      THEN
        IF self.clickAction = NIL THEN RETURN END;
        r2 := GraphVBTExtras.ScreenPtToWorldPos(self, cd.cp.pt);
        args[0] := self.valGraph;
        args[1] := NEW(ObValue.ValReal, real:=FLOAT(r2[0], LONGREAL), temp:=FALSE);
        args[2] := NEW(ObValue.ValReal, real:=FLOAT(r2[1], LONGREAL), temp:=FALSE);
        EVAL ObEval.Call(self.clickAction, args,
          self.clickAction.fun.location);
      ELSIF (cd.clickType = VBT.ClickType.LastUp) AND (cd.clickCount &lt;= 1)
      THEN
        IF self.clickReleaseAction = NIL THEN RETURN END;
        r2 := GraphVBTExtras.ScreenPtToWorldPos(self, cd.cp.pt);
        args[0] := self.valGraph;
        args[1] := NEW(ObValue.ValReal, real:=FLOAT(r2[0], LONGREAL), temp:=FALSE);
        args[2] := NEW(ObValue.ValReal, real:=FLOAT(r2[1], LONGREAL), temp:=FALSE);
        EVAL ObEval.Call(self.clickReleaseAction, args,
          self.clickReleaseAction.fun.location);
      ELSIF (cd.clickType = VBT.ClickType.FirstDown) AND (cd.clickCount = 2)
      THEN
        IF self.doubleClickAction = NIL THEN RETURN END;
        r2 := GraphVBTExtras.ScreenPtToWorldPos(self, cd.cp.pt);
        args[0] := self.valGraph;
        args[1] := NEW(ObValue.ValReal, real:=FLOAT(r2[0], LONGREAL), temp:=FALSE);
        args[2] := NEW(ObValue.ValReal, real:=FLOAT(r2[1], LONGREAL), temp:=FALSE);
        EVAL ObEval.Call(self.doubleClickAction, args,
          self.doubleClickAction.fun.location);
      END;
    EXCEPT
    | ObValue.Error(packet) =&gt;
        SynWr.Text(SynWr.out,
          &quot;*** a graph_ click action caused an Obliq error: ***\n&quot;);
        ObValue.ErrorMsg(SynWr.out,packet);
        SynWr.Flush(SynWr.out);
    | ObValue.Exception(packet) =&gt;
        SynWr.Text(SynWr.out,
         &quot;*** a graph_ click action caused an Obliq exception: ***\n&quot;);
        ObValue.ExceptionMsg(SynWr.out,packet);
        SynWr.Flush(SynWr.out);
    END;
  END Mouse;

  PROCEDURE <A NAME="WorldRectToScreenRect"><procedure>WorldRectToScreenRect</procedure></A>(
     world: GraphVBT.WorldRectangle; domain: Rect.T;
     w,e,n,s: LONGREAL): Rect.T =
  VAR domainWidth, domainHeight, worldWidth, worldHeight: REAL;
    r: Rect.T;
  BEGIN
    domainWidth := FLOAT(domain.east)-FLOAT(domain.west);
    domainHeight := FLOAT(domain.south)-FLOAT(domain.north);
    worldWidth := world.e-world.w;
    worldHeight := world.s-world.n;
    IF (worldWidth=0.0) OR (worldHeight=0.0) THEN RETURN Rect.Empty END;
    r :=
      Rect.T{
       west := domain.west + ROUND((FLOAT(w)-world.w)*domainWidth/worldWidth),
       east := domain.west + ROUND((FLOAT(e)-world.w)*domainWidth/worldWidth),
       north := domain.north + ROUND((FLOAT(n)-world.n)*domainHeight/worldHeight),
       south := domain.north + ROUND((FLOAT(s)-world.n)*domainHeight/worldHeight)
       };
     IF r.east=r.west THEN r.east:=r.east+1 END;
     IF r.north=r.south THEN r.south:=r.south+1 END;
     RETURN r;
  END WorldRectToScreenRect;
</PRE> ============ <CODE>zeus</CODE> package ============ 

<P><PRE>TYPE

  ZeusCode =
    {Error, Animate};

  ZeusOpCode =
    ObLib.OpCode OBJECT
        code: ZeusCode;
      END;

  PackageZeus =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalZeus;
      END;

  VAR zeusException: ObValue.ValException;

  PROCEDURE <A NAME="SetupZeus"><procedure>SetupZeus</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(ZeusCode));
    opCodes^ :=
      OpCodes{
      NEW(ZeusOpCode, name:=&quot;failure&quot;, arity:=-1, code:=ZeusCode.Error),
      NEW(ZeusOpCode, name:=&quot;animate&quot;,
          arity:=3, code:=ZeusCode.Animate)
      };
    ObLib.Register(
      NEW(PackageZeus, name:=&quot;zeus&quot;, opCodes:=opCodes));
    zeusException := NEW(ObValue.ValException, name:=&quot;zeus_failure&quot;);
  END SetupZeus;

  PROCEDURE <A NAME="EvalZeus"><procedure>EvalZeus</procedure></A>(self: PackageZeus; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR gr1: Graph; real1, real2: LONGREAL;
    BEGIN
      TRY
      CASE NARROW(opCode, ZeusOpCode).code OF
      | ZeusCode.Error =&gt;
          RETURN graphException;
      | ZeusCode.Animate =&gt;
          TYPECASE args[1] OF | ValGraph(node) =&gt; gr1:=node.graph;
          ELSE ObValue.BadArgType(1, &quot;graph&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
          gr1.animate(FLOAT(real1), FLOAT(real2));
          RETURN ObValue.valOk;
      END;
      EXCEPT
      | TrestleComm.Failure =&gt;
        ObValue.RaiseException(zeusException, opCode.name, loc);
      | NetObj.Error(atoms) =&gt;
              ObValue.RaiseNetException(
                               self.name&amp;&quot;_&quot;&amp;opCode.name, atoms, loc);
      | Thread.Alerted =&gt;
          ObValue.RaiseException(ObValue.threadAlerted,
                               self.name&amp;&quot;_&quot;&amp;opCode.name,loc);
      END;
    END EvalZeus;

BEGIN
END ObLibAnim.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
