<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlibm3/src/ObLibM3.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlibm3/src/ObLibM3.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObLibM3.i3">ObLibM3</A></implements></module>;
IMPORT <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../os/src/Common/Process.i3">Process</A>, <A HREF="#x1">FloatMode</A>,
  <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../os/src/Common/Pipe.i3">Pipe</A>, <A HREF="../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../rw/src/Common/FileWr.i3">FileWr</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../fmtlex/src/Lex.i3">Lex</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>,
  <A HREF="../../convert/src/Convert.i3">Convert</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../pickle/src/Pickle.i3">Pickle</A>;

  VAR setupDone := FALSE;

  PROCEDURE <A NAME="PackageSetup"><procedure>PackageSetup</procedure></A>() =
  BEGIN
    IF NOT setupDone THEN
      setupDone := TRUE;
      Setup();
    END;
  END PackageSetup;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
    SetupRd();
    SetupWr();
    SetupLex();
    SetupFmt();
    SetupPickle();
    SetupProc();
  END Setup;
</PRE> ============ <CODE>rd</CODE> package ============ 

<P><PRE>TYPE

  RdCode = {Failure, EofFailure, New, Stdin, Open, GetChar, Eof, UnGetChar,
            CharsReady, GetText, GetLine, Index, Length, Seek, Close,
            Intermittent, Seekable, Closed};

  RdOpCode =
    ObLib.OpCode OBJECT
        code: RdCode;
      END;

  PackageRd =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalRd;
      END;

  PROCEDURE <A NAME="IsRd"><procedure>IsRd</procedure></A>(self: ValRd; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValRd(oth)=&gt; RETURN self.rd = oth.rd;
    ELSE RETURN FALSE END;
  END IsRd;

  PROCEDURE <A NAME="CopyRd"><procedure>CopyRd</procedure></A>(self: ObValue.ValAnything; tbl: ObValue.Tbl;
    loc: SynLocation.T): ObValue.ValAnything RAISES {ObValue.Error} =
  BEGIN
    RETURN self;
  END CopyRd;

  VAR rdFailureException, rdEofFailureException: ObValue.ValException;

  PROCEDURE <A NAME="NewRdOC"><procedure>NewRdOC</procedure></A>(name: TEXT; arity: INTEGER; code: RdCode)
    : RdOpCode =
  BEGIN
    RETURN NEW(RdOpCode, name:=name, arity:=arity, code:=code);
  END NewRdOC;

  VAR true, false: ObValue.ValBool;

  PROCEDURE <A NAME="SetupRd"><procedure>SetupRd</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(RdCode));
    opCodes^ :=
      OpCodes{
      NewRdOC(&quot;failure&quot;, -1, RdCode.Failure),
      NewRdOC(&quot;eofFailure&quot;, -1, RdCode.EofFailure),
      NewRdOC(&quot;new&quot;, 1, RdCode.New),
      NewRdOC(&quot;stdin&quot;, -1, RdCode.Stdin),
      NewRdOC(&quot;open&quot;, 2, RdCode.Open),
      NewRdOC(&quot;getChar&quot;, 1, RdCode.GetChar),
      NewRdOC(&quot;eof&quot;, 1, RdCode.Eof),
      NewRdOC(&quot;unGetChar&quot;, 1, RdCode.UnGetChar),
      NewRdOC(&quot;charsReady&quot;, 1, RdCode.CharsReady),
      NewRdOC(&quot;getText&quot;, 2, RdCode.GetText),
      NewRdOC(&quot;getLine&quot;, 1, RdCode.GetLine),
      NewRdOC(&quot;index&quot;, 1, RdCode.Index),
      NewRdOC(&quot;length&quot;, 1, RdCode.Length),
      NewRdOC(&quot;seek&quot;, 2, RdCode.Seek),
      NewRdOC(&quot;close&quot;, 1, RdCode.Close),
      NewRdOC(&quot;intermittent&quot;, 1, RdCode.Intermittent),
      NewRdOC(&quot;seekable&quot;, 1, RdCode.Seekable),
      NewRdOC(&quot;closed&quot;, 1, RdCode.Closed)
      };
    ObLib.Register(
      NEW(PackageRd, name:=&quot;rd&quot;, opCodes:=opCodes));
    rdFailureException := NEW(ObValue.ValException, name:=&quot;rd_failure&quot;);
    rdEofFailureException := NEW(ObValue.ValException, name:=&quot;rd_eofFailure&quot;);
    true := NEW(ObValue.ValBool, bool:=TRUE);
    false := NEW(ObValue.ValBool, bool:=FALSE);
  END SetupRd;

  PROCEDURE <A NAME="EvalRd"><procedure>EvalRd</procedure></A>(self: PackageRd; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR rd1: Rd.T; text1: TEXT; int1: INTEGER; fileSys1: ObValue.ValFileSystem;
    BEGIN
      TRY
        CASE NARROW(opCode, RdOpCode).code OF
        | RdCode.Failure =&gt;
            RETURN rdFailureException;
        | RdCode.EofFailure =&gt;
            RETURN rdEofFailureException;
        | RdCode.New =&gt;
            TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
            ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
            rd1 := TextRd.New(text1);
            RETURN NEW(ValRd, what:=&quot;&lt;a reader&gt;&quot;, picklable:=FALSE, rd:=rd1);
       | RdCode.Stdin =&gt;
            RETURN NEW(ValRd, what:=&quot;&lt;stdin reader&gt;&quot;, picklable:=FALSE,
              rd:=Stdio.stdin);
       | RdCode.Open =&gt;
            TYPECASE args[1] OF | ObValue.ValFileSystem(node) =&gt; fileSys1:=node;
            ELSE ObValue.BadArgType(1, &quot;file system&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
            ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
            rd1 := fileSys1.remote.OpenRead(text1);
            RETURN NEW(ValRd, what:=&quot;&lt;'&quot; &amp; text1 &amp; &quot;' reader&gt;&quot;,
                       picklable:=FALSE, rd:=rd1);
        | RdCode.GetChar =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            IF Rd.Closed(rd1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            RETURN NEW(ObValue.ValChar, char:=Rd.GetChar(rd1));
        | RdCode.Eof =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            IF Rd.Closed(rd1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
	    IF Rd.EOF(rd1) THEN RETURN true ELSE RETURN false END;
        | RdCode.UnGetChar =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            IF Rd.Closed(rd1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            Rd.UnGetChar(rd1);
            RETURN ObValue.valOk;
        | RdCode.CharsReady =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            IF Rd.Closed(rd1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            RETURN NEW(ObValue.ValInt, int:=Rd.CharsReady(rd1), temp:=temp);
        | RdCode.GetText =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1 := node.int;
            ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
            IF Rd.Closed(rd1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            IF int1&lt;0 THEN
              ObValue.BadArgVal(2, &quot;non-negative&quot;, self.name, opCode.name, loc);
            END;
            RETURN ObValue.NewText(Rd.GetText(rd1, int1));
        | RdCode.GetLine =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            IF Rd.Closed(rd1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            RETURN ObValue.NewText(Rd.GetLine(rd1));
        | RdCode.Index =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            IF Rd.Closed(rd1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            RETURN NEW(ObValue.ValInt, int:=Rd.Index(rd1), temp:=temp);
        | RdCode.Length =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            IF Rd.Closed(rd1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            IF Rd.Intermittent(rd1) THEN
              ObValue.BadArgVal(1,&quot;non-intermittent&quot;,self.name,opCode.name,loc);
            END;
            RETURN NEW(ObValue.ValInt, int:=Rd.Length(rd1), temp:=temp);
        | RdCode.Seek =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1 := node.int;
            ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
            IF Rd.Closed(rd1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            IF NOT Rd.Seekable(rd1) THEN
              ObValue.BadArgVal(1, &quot;seekable&quot;, self.name, opCode.name, loc);
            END;
            IF int1&lt;0 THEN
              ObValue.BadArgVal(2, &quot;non-negative&quot;, self.name, opCode.name, loc);
            END;
            Rd.Seek(rd1, int1);
            RETURN ObValue.valOk;
        | RdCode.Close =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            Rd.Close(rd1);
            RETURN ObValue.valOk;
        | RdCode.Intermittent =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
	    IF Rd.Intermittent(rd1) THEN RETURN true ELSE RETURN false END;
        | RdCode.Seekable =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
	    IF Rd.Seekable(rd1) THEN RETURN true ELSE RETURN false END;
        | RdCode.Closed =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
	    IF Rd.Closed(rd1) THEN RETURN true ELSE RETURN false END;
        ELSE
          ObValue.BadOp(self.name, opCode.name, loc);
        END;
      EXCEPT
      | Rd.Failure, ObValue.ServerError =&gt;
          ObValue.RaiseException(rdFailureException,
                               self.name &amp; &quot;_&quot; &amp; opCode.name, loc);
      | Rd.EndOfFile =&gt;
          ObValue.RaiseException(rdEofFailureException,
                               self.name &amp; &quot;_&quot; &amp; opCode.name, loc);
      | Thread.Alerted =&gt;
          ObValue.RaiseException(ObValue.threadAlerted,
                               self.name&amp;&quot;_&quot;&amp;opCode.name, loc);
      | NetObj.Error(atoms) =&gt;
          ObValue.RaiseNetException(self.name&amp;&quot;_&quot;&amp;opCode.name, atoms, loc);
      END;
    END EvalRd;
</PRE> ============ <CODE>wr</CODE> package ============ 

<P><PRE>TYPE

  WrCode = {Failure, New, Stdout, Stderr, Open, OpenAppend, ToText, PutChar,
            PutText, Flush, Index, Length, Seek, Close, Buffered,
            Seekable, Closed};

  WrOpCode =
    ObLib.OpCode OBJECT
        code: WrCode;
      END;

  PackageWr =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalWr;
      END;

  PROCEDURE <A NAME="IsWr"><procedure>IsWr</procedure></A>(self: ValWr; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValWr(oth)=&gt; RETURN self.wr = oth.wr;
    ELSE RETURN FALSE END;
  END IsWr;

  PROCEDURE <A NAME="CopyWr"><procedure>CopyWr</procedure></A>(self: ObValue.ValAnything; tbl: ObValue.Tbl;
    loc: SynLocation.T): ObValue.ValAnything RAISES {ObValue.Error} =
  BEGIN
    RETURN self;
  END CopyWr;

  VAR wrFailureException: ObValue.ValException;

  PROCEDURE <A NAME="NewWrOC"><procedure>NewWrOC</procedure></A>(name: TEXT; arity: INTEGER; code: WrCode)
    : WrOpCode =
  BEGIN
    RETURN NEW(WrOpCode, name:=name, arity:=arity, code:=code);
  END NewWrOC;

  PROCEDURE <A NAME="SetupWr"><procedure>SetupWr</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(WrCode));
    opCodes^ :=
      OpCodes{
      NewWrOC(&quot;failure&quot;, -1, WrCode.Failure),
      NewWrOC(&quot;new&quot;, 0, WrCode.New),
      NewWrOC(&quot;stdout&quot;, -1, WrCode.Stdout),
      NewWrOC(&quot;stderr&quot;, -1, WrCode.Stderr),
      NewWrOC(&quot;open&quot;, 2, WrCode.Open),
      NewWrOC(&quot;openAppend&quot;, 2, WrCode.OpenAppend),
      NewWrOC(&quot;toText&quot;, 1, WrCode.ToText),
      NewWrOC(&quot;putChar&quot;, 2, WrCode.PutChar),
      NewWrOC(&quot;putText&quot;, 2, WrCode.PutText),
      NewWrOC(&quot;flush&quot;, 1, WrCode.Flush),
      NewWrOC(&quot;index&quot;, 1, WrCode.Index),
      NewWrOC(&quot;length&quot;, 1, WrCode.Length),
      NewWrOC(&quot;seek&quot;, 2, WrCode.Seek),
      NewWrOC(&quot;close&quot;, 1, WrCode.Close),
      NewWrOC(&quot;buffered&quot;, 1, WrCode.Buffered),
      NewWrOC(&quot;seekable&quot;, 1, WrCode.Seekable),
      NewWrOC(&quot;closed&quot;, 1, WrCode.Closed)
      };
    ObLib.Register(
      NEW(PackageWr, name:=&quot;wr&quot;, opCodes:=opCodes));
    wrFailureException := NEW(ObValue.ValException, name:=&quot;wr_failure&quot;);
  END SetupWr;

  PROCEDURE <A NAME="EvalWr"><procedure>EvalWr</procedure></A>(self: PackageWr; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR wr1: Wr.T; text1: TEXT; char1: CHAR; int1: INTEGER;
      fileSys1: ObValue.ValFileSystem;
    BEGIN
      TRY
        CASE NARROW(opCode, WrOpCode).code OF
        | WrCode.Failure =&gt;
            RETURN wrFailureException;
        | WrCode.New =&gt;
            wr1 := TextWr.New();
            RETURN NEW(ValWr, what:=&quot;&lt;a writer&gt;&quot;,
                picklable:=FALSE, wr:=wr1);
        | WrCode.Stdout =&gt;
            RETURN NEW(ValWr, what:=&quot;&lt;stdout writer&gt;&quot;,
              picklable:=FALSE, wr:=Stdio.stdout);
        | WrCode.Stderr =&gt;
            RETURN NEW(ValWr, what:=&quot;&lt;stderr writer&gt;&quot;,
              picklable:=FALSE, wr:=Stdio.stderr);
        | WrCode.Open =&gt;
            TYPECASE args[1] OF | ObValue.ValFileSystem(node) =&gt; fileSys1:=node;
            ELSE ObValue.BadArgType(1, &quot;file system&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
            ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
            wr1 := fileSys1.remote.OpenWrite(text1);
            RETURN NEW(ValWr, what:=&quot;&lt;'&quot; &amp; text1 &amp; &quot;' writer&gt;&quot;,
                       picklable:=FALSE, wr:=wr1);
        | WrCode.OpenAppend =&gt;
            TYPECASE args[1] OF | ObValue.ValFileSystem(node) =&gt; fileSys1:=node;
            ELSE ObValue.BadArgType(1, &quot;file system&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
            ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
            wr1 := fileSys1.remote.OpenAppend(text1);
            RETURN NEW(ValWr, what:=&quot;&lt;'&quot; &amp; text1 &amp; &quot;' writer&gt;&quot;,
                       picklable:=FALSE, wr:=wr1);
       | WrCode.ToText =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
            TYPECASE wr1 OF
            | TextWr.T(wr) =&gt;
                RETURN ObValue.NewText(TextWr.ToText(wr));
            ELSE
              ObValue.BadArgVal(1, &quot;locally produced by wr_new&quot;, self.name,
                              opCode.name, loc);
            END;
        | WrCode.PutChar =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValChar(node) =&gt; char1 := node.char;
            ELSE ObValue.BadArgType(2, &quot;char&quot;, self.name, opCode.name, loc); END;
            IF Wr.Closed(wr1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            Wr.PutChar(wr1, char1);
            RETURN ObValue.valOk;
        | WrCode.PutText =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
            ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
            IF Wr.Closed(wr1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            Wr.PutText(wr1, text1);
            RETURN ObValue.valOk;
        | WrCode.Flush =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
            IF Wr.Closed(wr1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            Wr.Flush(wr1);
            RETURN ObValue.valOk;
        | WrCode.Index =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
            IF Wr.Closed(wr1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            RETURN NEW(ObValue.ValInt, int:=Wr.Index(wr1), temp:=temp);
        | WrCode.Length =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
            IF Wr.Closed(wr1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            RETURN NEW(ObValue.ValInt, int:=Wr.Length(wr1), temp:=temp);
        | WrCode.Seek =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1 := node.int;
            ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
            IF Wr.Closed(wr1) THEN
              ObValue.BadArgVal(1, &quot;non-closed&quot;, self.name, opCode.name, loc);
            END;
            IF NOT Wr.Seekable(wr1) THEN
              ObValue.BadArgVal(1, &quot;seekable&quot;, self.name, opCode.name, loc);
            END;
            IF int1&lt;0 THEN
              ObValue.BadArgVal(2, &quot;non-negative&quot;, self.name, opCode.name, loc);
            END;
            Wr.Seek(wr1, int1);
            RETURN ObValue.valOk;
        | WrCode.Close =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
            Wr.Close(wr1);
            RETURN ObValue.valOk;
        | WrCode.Buffered =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
	    IF Wr.Buffered(wr1) THEN RETURN true ELSE RETURN false END;
        | WrCode.Seekable =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
	    IF Wr.Seekable(wr1) THEN RETURN true ELSE RETURN false END;
        | WrCode.Closed =&gt;
            TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
            ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
	    IF Wr.Closed(wr1) THEN RETURN true ELSE RETURN false END;
        ELSE
          ObValue.BadOp(self.name, opCode.name, loc);
        END;
      EXCEPT
      | Wr.Failure, ObValue.ServerError =&gt;
          ObValue.RaiseException(wrFailureException,
                               self.name &amp; &quot;_&quot; &amp; opCode.name, loc);
      | Thread.Alerted =&gt;
          ObValue.RaiseException(ObValue.threadAlerted,
                               self.name&amp;&quot;_&quot;&amp;opCode.name, loc);
      | NetObj.Error(atoms) =&gt;
          ObValue.RaiseNetException(self.name&amp;&quot;_&quot;&amp;opCode.name, atoms, loc);
      END;
    END EvalWr;
</PRE> ============ <CODE>lex</CODE> package ============ 

<P><PRE>TYPE

  LexCode = {Failure, Scan, Skip, Match, Bool, Int, Real};

  LexOpCode =
    ObLib.OpCode OBJECT
        code: LexCode;
      END;

  PackageLex =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalLex;
      END;

  VAR lexFailureException: ObValue.ValException;

  PROCEDURE <A NAME="NewLexOC"><procedure>NewLexOC</procedure></A>(name: TEXT; arity: INTEGER; code: LexCode)
    : LexOpCode =
  BEGIN
    RETURN NEW(LexOpCode, name:=name, arity:=arity, code:=code);
  END NewLexOC;

  PROCEDURE <A NAME="SetupLex"><procedure>SetupLex</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(LexCode));
    opCodes^ :=
      OpCodes{
      NewLexOC(&quot;failure&quot;, -1, LexCode.Failure),
      NewLexOC(&quot;scan&quot;, 2, LexCode.Scan),
      NewLexOC(&quot;skip&quot;, 2, LexCode.Skip),
      NewLexOC(&quot;match&quot;, 2, LexCode.Match),
      NewLexOC(&quot;bool&quot;, 1, LexCode.Bool),
      NewLexOC(&quot;int&quot;, 1, LexCode.Int),
      NewLexOC(&quot;real&quot;, 1, LexCode.Real)
      };
    ObLib.Register(
      NEW(PackageLex, name:=&quot;lex&quot;, opCodes:=opCodes));
    lexFailureException := NEW(ObValue.ValException, name:=&quot;lex_failure&quot;);
  END SetupLex;

  PROCEDURE <A NAME="EvalLex"><procedure>EvalLex</procedure></A>(self: PackageLex; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR text1: TEXT; rd1: Rd.T;
    BEGIN
      TRY
        CASE NARROW(opCode, LexOpCode).code OF
        | LexCode.Failure =&gt;
            RETURN lexFailureException;
        | LexCode.Scan =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
            ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc) END;
            RETURN ObValue.NewText(Lex.Scan(rd1, CharSet(text1)));
        | LexCode.Skip =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
            ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc) END;
            Lex.Skip(rd1, CharSet(text1));
            RETURN ObValue.valOk;
        | LexCode.Match =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
            ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc) END;
            Lex.Match(rd1, text1);
            RETURN ObValue.valOk;
        | LexCode.Bool =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
	    IF Lex.Bool(rd1) THEN RETURN true ELSE RETURN false END;
        | LexCode.Int =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            RETURN NEW(ObValue.ValInt, int:=Lex.Int(rd1, 10), temp:=temp);
        | LexCode.Real =&gt;
            TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
            ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
            RETURN NEW(ObValue.ValReal, real:=Lex.LongReal(rd1), temp:=temp);
        ELSE
          ObValue.BadOp(self.name, opCode.name, loc);
        END;
      EXCEPT
      | Lex.Error, Convert.Failed, FloatMode.Trap =&gt;
          ObValue.RaiseException(lexFailureException,
                               self.name &amp; &quot;_&quot; &amp; opCode.name, loc);
      | Rd.Failure =&gt;
          ObValue.RaiseException(rdFailureException,
                               self.name &amp; &quot;_&quot; &amp; opCode.name, loc);
      | Thread.Alerted =&gt;
          ObValue.RaiseException(ObValue.threadAlerted,
                               self.name&amp;&quot;_&quot;&amp;opCode.name, loc);
      END;
    END EvalLex;

PROCEDURE <A NAME="CharSet"><procedure>CharSet</procedure></A>(text: TEXT): SET OF CHAR =
  VAR s: SET OF CHAR;
  BEGIN
    s := SET OF CHAR{};
    FOR i:=0 TO Text.Length(text)-1 DO
      s := s + SET OF CHAR{Text.GetChar(text,i)};
    END;
    RETURN s;
 END CharSet;
</PRE> ============ <CODE>fmt</CODE> package ============ 

<P><PRE>TYPE

  FmtCode = {PadLft, PadRht, Bool, Int, Real};

  FmtOpCode =
    ObLib.OpCode OBJECT
        code: FmtCode;
      END;

  PackageFmt =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalFmt;
      END;

  PROCEDURE <A NAME="NewFmtOC"><procedure>NewFmtOC</procedure></A>(name: TEXT; arity: INTEGER; code: FmtCode)
    : FmtOpCode =
  BEGIN
    RETURN NEW(FmtOpCode, name:=name, arity:=arity, code:=code);
  END NewFmtOC;

  PROCEDURE <A NAME="SetupFmt"><procedure>SetupFmt</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(FmtCode));
    opCodes^ :=
      OpCodes{
      NewFmtOC(&quot;padLft&quot;, 2, FmtCode.PadLft),
      NewFmtOC(&quot;padRht&quot;, 2, FmtCode.PadRht),
      NewFmtOC(&quot;bool&quot;, 1, FmtCode.Bool),
      NewFmtOC(&quot;int&quot;, 1, FmtCode.Int),
      NewFmtOC(&quot;real&quot;, 1, FmtCode.Real)
      };
    ObLib.Register(
      NEW(PackageFmt, name:=&quot;fmt&quot;, opCodes:=opCodes));
  END SetupFmt;

  PROCEDURE <A NAME="EvalFmt"><procedure>EvalFmt</procedure></A>(self: PackageFmt; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR text1: TEXT; bool1: BOOLEAN; int1: INTEGER; real1: LONGREAL;
    BEGIN
        CASE NARROW(opCode, FmtOpCode).code OF
        | FmtCode.PadLft =&gt;
            TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1 := node.text;
            ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1 := node.int;
            ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
            RETURN ObValue.NewText(Fmt.Pad(text1, int1, ' ', Fmt.Align.Left));
        | FmtCode.PadRht =&gt;
            TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1 := node.text;
            ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
            TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1 := node.int;
            ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
            RETURN ObValue.NewText(Fmt.Pad(text1, int1, ' ', Fmt.Align.Right));
        | FmtCode.Bool =&gt;
            TYPECASE args[1] OF | ObValue.ValBool(node) =&gt; bool1 := node.bool;
            ELSE ObValue.BadArgType(1, &quot;bool&quot;, self.name, opCode.name, loc); END;
            IF bool1 THEN RETURN ObValue.NewText(&quot;true&quot;);
	    ELSE RETURN ObValue.NewText(&quot;false&quot;); END;
        | FmtCode.Int =&gt;
            TYPECASE args[1] OF | ObValue.ValInt(node) =&gt; int1 := node.int;
            ELSE ObValue.BadArgType(1, &quot;int&quot;, self.name, opCode.name, loc); END;
            RETURN ObValue.NewText(Fmt.Int(int1));
        | FmtCode.Real =&gt;
            TYPECASE args[1] OF | ObValue.ValReal(node) =&gt; real1 := node.real;
            ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
            RETURN ObValue.NewText(Fmt.LongReal(real1, literal:=TRUE));
        ELSE
          ObValue.BadOp(self.name, opCode.name, loc);
        END;
    END EvalFmt;
</PRE> ============ <CODE>pickle</CODE> package ============ 

<P><PRE>CONST CurrentPickleVersion = 1;
TYPE PickleVersion =
  BRANDED &quot;ObliqPickleVersion&quot; OBJECT version: INTEGER END;

TYPE

  PickleCode = {Failure, Write, Read};

  PickleOpCode =
    ObLib.OpCode OBJECT
        code: PickleCode;
      END;

  PackagePickle =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalPickle;
      END;

  VAR pickleFailureException: ObValue.ValException;

  PROCEDURE <A NAME="NewPickleOC"><procedure>NewPickleOC</procedure></A>(name: TEXT; arity: INTEGER; code: PickleCode)
    : PickleOpCode =
  BEGIN
    RETURN NEW(PickleOpCode, name:=name, arity:=arity, code:=code);
  END NewPickleOC;

  PROCEDURE <A NAME="SetupPickle"><procedure>SetupPickle</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(PickleCode));
    opCodes^ :=
      OpCodes{
      NewPickleOC(&quot;failure&quot;, -1, PickleCode.Failure),
      NewPickleOC(&quot;write&quot;, 2, PickleCode.Write),
      NewPickleOC(&quot;read&quot;, 1, PickleCode.Read)
      };
    ObLib.Register(
      NEW(PackagePickle, name:=&quot;pickle&quot;, opCodes:=opCodes));
    pickleFailureException := NEW(ObValue.ValException, name:=&quot;pickle_failure&quot;);
  END SetupPickle;

  PROCEDURE <A NAME="EvalPickle"><procedure>EvalPickle</procedure></A>(self: PackagePickle; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR wr1: Wr.T; rd1: Rd.T;
    BEGIN
      TRY
      CASE NARROW(opCode, PickleOpCode).code OF
      | PickleCode.Failure =&gt;
          RETURN pickleFailureException;
      | PickleCode.Write =&gt;
          TYPECASE args[1] OF | ValWr(node) =&gt; wr1 := node.wr;
          ELSE ObValue.BadArgType(1, &quot;wr&quot;, self.name, opCode.name, loc); END;
          Pickle.Write(wr1, NEW(PickleVersion, version:=CurrentPickleVersion));
          Pickle.Write(wr1,
            ObValue.CopyValToLocal(args[2], ObValue.NewTbl(), loc));
          RETURN ObValue.valOk;
      | PickleCode.Read =&gt;
          TYPECASE args[1] OF | ValRd(node) =&gt; rd1 := node.rd;
          ELSE ObValue.BadArgType(1, &quot;rd&quot;, self.name, opCode.name, loc); END;
          TYPECASE Pickle.Read(rd1) OF
          | PickleVersion(p) =&gt;
            IF p.version # CurrentPickleVersion THEN
              RAISE Pickle.Error(&quot;&quot;);
            END;
          ELSE RAISE Pickle.Error(&quot;&quot;);
          END;
          RETURN
            ObValue.CopyLocalToVal(Pickle.Read(rd1), ObValue.NewTbl(), loc);
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
      EXCEPT
      | Pickle.Error =&gt;
          ObValue.RaiseException(pickleFailureException, opCode.name, loc);
      | Wr.Failure =&gt;
          ObValue.RaiseException(wrFailureException, opCode.name, loc);
      | Rd.Failure =&gt;
          ObValue.RaiseException(rdFailureException, opCode.name, loc);
      | Rd.EndOfFile =&gt;
          ObValue.RaiseException(rdEofFailureException, opCode.name, loc);
      | Thread.Alerted =&gt;
          ObValue.RaiseException(ObValue.threadAlerted,
                               self.name&amp;&quot;_&quot;&amp;opCode.name, loc);
      | NetObj.Error(atoms) =&gt;
          ObValue.RaiseNetException(self.name&amp;&quot;_&quot;&amp;opCode.name, atoms, loc);
      END;
    END EvalPickle;
</PRE> ============ <CODE>process</CODE> package ============ 

<P><PRE>TYPE

  ProcCode = {New, In, Out, Err, Complete, Filter};

  ProcOpCode =
    ObLib.OpCode OBJECT
        code: ProcCode;
      END;

  PackageProc =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalProc;
      END;

  PROCEDURE <A NAME="IsProc"><procedure>IsProc</procedure></A>(self: ValProc; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValProc(oth)=&gt; RETURN self.proc = oth.proc;
    ELSE RETURN FALSE END;
  END IsProc;

  PROCEDURE <A NAME="CopyProc"><procedure>CopyProc</procedure></A>(self: ObValue.ValAnything; tbl: ObValue.Tbl;
    loc: SynLocation.T): ObValue.ValAnything RAISES {ObValue.Error} =
  BEGIN
    ObValue.RaiseError(&quot;Cannot copy processes&quot;, loc);
  END CopyProc;

  PROCEDURE <A NAME="NewProcOC"><procedure>NewProcOC</procedure></A>(name: TEXT; arity: INTEGER; code: ProcCode)
    : ProcOpCode =
  BEGIN
    RETURN NEW(ProcOpCode, name:=name, arity:=arity, code:=code);
  END NewProcOC;

  PROCEDURE <A NAME="SetupProc"><procedure>SetupProc</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(ProcCode));
    opCodes^ :=
      OpCodes{
      NewProcOC(&quot;new&quot;, 3, ProcCode.New),
      NewProcOC(&quot;in&quot;, 1, ProcCode.In),
      NewProcOC(&quot;out&quot;, 1, ProcCode.Out),
      NewProcOC(&quot;err&quot;, 1, ProcCode.Err),
      NewProcOC(&quot;complete&quot;, 1, ProcCode.Complete),
      NewProcOC(&quot;filter&quot;, 3, ProcCode.Filter)};
    ObLib.Register(
      NEW(PackageProc, name:=&quot;process&quot;, opCodes:=opCodes));
    ObValue.InhibitTransmission(TYPECODE(ValProc),
      &quot;processes cannot be transmitted/duplicated&quot;);
  END SetupProc;

  PROCEDURE <A NAME="EvalProc"><procedure>EvalProc</procedure></A>(self: PackageProc; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    TYPE Texts = REF ARRAY OF TEXT;
    VAR val: ObValue.Val; text1: TEXT; size, int: INTEGER;
      proc: Process.T; proc1: ValProc; texts: Texts;
      stdinR, stdinW, stdoutR, stdoutW, stderrR, stderrW: Pipe.T;
      stdinWr: FileWr.T; stdoutRd, stderrRd: FileRd.T;
      bool1: BOOLEAN; array1: REF ObValue.Vals;
      processor1: ObValue.ValProcessor;
    BEGIN
      TRY
      CASE NARROW(opCode, ProcOpCode).code OF
      | ProcCode.New =&gt;
          TYPECASE args[1] OF
          | ObValue.ValProcessor(node) =&gt; processor1:=node;
          ELSE ObValue.BadArgType(1, &quot;processor&quot;, self.name, opCode.name, loc); END;
          IF processor1 # ObValue.localProcessor THEN
            ObValue.BadArgVal(1, &quot;the local processor&quot;, self.name, opCode.name, loc);
          END;
          TYPECASE args[2] OF
          | ObValue.ValArray(node) =&gt; array1:=node.remote.Obtain();
          ELSE ObValue.BadArgType(2, &quot;array&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(3, &quot;bool&quot;, self.name, opCode.name, loc); END;
          size := NUMBER(array1^);
          IF size=0 THEN
            ObValue.BadArgVal(2, &quot;non-empty&quot;, self.name, opCode.name, loc);
          END;
          texts := NEW(Texts, size);
          FOR i := 0 TO size-1 DO
            TYPECASE array1^[i] OF
            | ObValue.ValText(node) =&gt; texts^[i] := node.text;
            ELSE
              ObValue.BadArgType(2, &quot;array(text)&quot;, self.name, opCode.name,loc);
            END;
          END;
          Pipe.Open((*out*)stdinR, (*out*)stdinW);
          Pipe.Open((*out*)stdoutR, (*out*)stdoutW);
          IF bool1 THEN
            stderrR := stdoutR; stderrW := stdoutW;
          ELSE
            Pipe.Open((*out*)stderrR, (*out*)stderrW);
          END;
          proc :=
            Process.Create(texts^[0],
              SUBARRAY(texts^, 1, NUMBER(texts^)-1),
              NIL, NIL,
              stdinR, stdoutW, stderrW);
          stdinR.close();
          stdoutW.close();
          IF NOT bool1 THEN stderrW.close(); END;
          stdinWr := NEW(FileWr.T).init(stdinW);
          stdoutRd := NEW(FileRd.T).init(stdoutR);
          IF bool1 THEN
            stderrRd := stdoutRd;
          ELSE
            stderrRd := NEW(FileRd.T).init(stderrR);
          END;
          RETURN NEW(ValProc, what:=&quot;&lt;a process&gt;&quot;,  picklable:=FALSE,
            proc:=proc,
            in :=
              NEW(ValWr, what:=&quot;&lt;a process stdin writer&gt;&quot;, picklable:=FALSE,
                wr:=stdinWr),
            out :=
              NEW(ValRd, what:=&quot;&lt;a process stdout reader&gt;&quot;, picklable:=FALSE,
                rd := stdoutRd),
            err :=
              NEW(ValRd, what:=&quot;&lt;a process stderr reader&gt;&quot;, picklable:=FALSE,
                rd := stderrRd));
      | ProcCode.In =&gt;
          TYPECASE args[1] OF | ValProc(node) =&gt; proc1 := node;
          ELSE ObValue.BadArgType(1, &quot;process&quot;, self.name, opCode.name, loc);
          END;
          RETURN proc1.in;
      | ProcCode.Out =&gt;
          TYPECASE args[1] OF | ValProc(node) =&gt; proc1 := node;
          ELSE ObValue.BadArgType(1, &quot;process&quot;, self.name, opCode.name, loc);
          END;
          RETURN proc1.out;
      | ProcCode.Err =&gt;
          TYPECASE args[1] OF | ValProc(node) =&gt; proc1 := node;
          ELSE ObValue.BadArgType(1, &quot;process&quot;, self.name, opCode.name, loc);
          END;
          RETURN proc1.err;
      | ProcCode.Complete =&gt;
          TYPECASE args[1] OF | ValProc(node) =&gt; proc1 := node;
          ELSE ObValue.BadArgType(1, &quot;process&quot;, self.name, opCode.name, loc);
          END;
          int := Process.Wait(proc1.proc);
          Wr.Close(proc1.in.wr);
          Rd.Close(proc1.out.rd);
          Rd.Close(proc1.err.rd);
          RETURN NEW(ObValue.ValInt, int := int, temp:=temp);
      | ProcCode.Filter =&gt;
          TYPECASE args[1] OF
          | ObValue.ValProcessor(node) =&gt; processor1:=node;
          ELSE ObValue.BadArgType(1, &quot;processor&quot;, self.name, opCode.name, loc); END;
          IF processor1 # ObValue.localProcessor THEN
            ObValue.BadArgVal(1, &quot;the local processor&quot;, self.name, opCode.name, loc);
          END;
          TYPECASE args[2] OF
          | ObValue.ValArray(node) =&gt; array1:=node.remote.Obtain();
          ELSE ObValue.BadArgType(2, &quot;array&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          size := NUMBER(array1^);
          IF size=0 THEN
            ObValue.BadArgVal(2, &quot;non-empty&quot;, self.name, opCode.name, loc);
          END;
          texts := NEW(Texts, size);
          FOR i := 0 TO size-1 DO
            TYPECASE array1^[i] OF
            | ObValue.ValText(node) =&gt; texts^[i] := node.text;
            ELSE ObValue.BadArgType(2, &quot;array(text)&quot;, self.name,
                   opCode.name, loc);
            END;
          END;
          Pipe.Open((*out*)stdinR, (*out*)stdinW);
          Pipe.Open((*out*)stdoutR, (*out*)stdoutW);
          proc :=
            Process.Create(texts^[0],
              SUBARRAY(texts^, 1, NUMBER(texts^)-1),
              NIL, NIL,
              stdinR, stdoutW, stdoutW);
          stdinR.close();
          stdoutW.close();
          stdinWr := NEW(FileWr.T).init(stdinW);
          stdoutRd := NEW(FileRd.T).init(stdoutR);
          Wr.PutText(stdinWr, text1);
          Wr.Close(stdinWr);
          val := ObValue.NewText(Rd.GetText(stdoutRd, LAST(CARDINAL)));
          Rd.Close(stdoutRd);
          EVAL Process.Wait(proc);
          RETURN val;
 (* -- LocalPipe
      | ProcCode.Pipe =&gt;
          TYPECASE args[1] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(1, &quot;bool&quot;, self.name, opCode.name, loc); END;
          rd1 := NEW(LocalPipe.Reaader);
          wr1 := NEW(LocalPipe.Writer);
          LocalPipe.Init(rd1, wr1, NOT bool1);
          RETURN ObValue.NewObject(
            NEW(ObValue.ObjFieldValue,
              label:=&quot;r&quot;,
              val:=NEW(ValRd, what:=&quot;&lt;a pipe reader&gt;&quot;, picklable:=FALSE,
                  rd:=rd1),
              rest:=NEW(ObValue.ObjFieldValue(
                label:=&quot;w&quot;,
                val:=NEW(ValWr, what:=&quot;&lt;a pipe writer&gt;&quot;, picklable:=FALSE,
                  wr:=wr1),
                rest:=NIL)));
            );
 *)
       ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
      EXCEPT
      | Rd.Failure, Wr.Failure, Thread.Alerted, OSError.E =&gt;
          ObValue.RaiseError(self.name&amp;&quot;_&quot;&amp;opCode.name, loc);
      | NetObj.Error(atoms) =&gt;
              ObValue.RaiseNetException(
                               self.name&amp;&quot;_&quot;&amp;opCode.name, atoms, loc);
      END;
    END EvalProc;

BEGIN
END ObLibM3.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
