<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlibui/src/ObLibUI.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlibui/src/ObLibUI.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObLibUI.i3">ObLibUI</A></implements></module>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>,
<A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../obliqrt/src/ObEval.i3">ObEval</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../formsvbt/src/FormsVBT.i3">FormsVBT</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>,
<A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../color/src/ColorName.i3">ColorName</A>, <A HREF="../../lego/src/MultiSplit.i3">MultiSplit</A>;

  VAR setupDone := FALSE;

  PROCEDURE <A NAME="PackageSetup"><procedure>PackageSetup</procedure></A>() =
  BEGIN
    IF NOT setupDone THEN
      setupDone := TRUE;
      Setup();
    END;
  END PackageSetup;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
    SetupColor();
    SetupForm();
  END Setup;
</PRE> ============ <CODE>color</CODE> package ============ 

<P><PRE>TYPE

  ColorCode = {Named, RGB, HSV, R, G, B, H, S, V, Brightness};

  ColorOpCode =
    ObLib.OpCode OBJECT
        code: ColorCode;
      END;

  PackageColor =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalColor;
      END;

  PROCEDURE <A NAME="IsColor"><procedure>IsColor</procedure></A>(self: ValColor; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValColor(oth)=&gt; RETURN self.color = oth.color;
    ELSE RETURN FALSE END;
  END IsColor;

  PROCEDURE <A NAME="CopyColor"><procedure>CopyColor</procedure></A>(self: ObValue.ValAnything; tbl: ObValue.Tbl;
    loc: SynLocation.T): ObValue.ValAnything RAISES {ObValue.Error} =
  BEGIN
    RETURN self;
  END CopyColor;

  PROCEDURE <A NAME="NewColorOC"><procedure>NewColorOC</procedure></A>(name: TEXT; arity: INTEGER; code: ColorCode)
    : ColorOpCode =
  BEGIN
    RETURN NEW(ColorOpCode, name:=name, arity:=arity, code:=code);
  END NewColorOC;

  PROCEDURE <A NAME="SetupColor"><procedure>SetupColor</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(ColorCode));
    opCodes^ :=
      OpCodes{
      NewColorOC(&quot;named&quot;, 1, ColorCode.Named),
      NewColorOC(&quot;rgb&quot;, 3, ColorCode.RGB),
      NewColorOC(&quot;hsv&quot;, 3, ColorCode.HSV),
      NewColorOC(&quot;r&quot;, 1, ColorCode.R),
      NewColorOC(&quot;g&quot;, 1, ColorCode.G),
      NewColorOC(&quot;b&quot;, 1, ColorCode.B),
      NewColorOC(&quot;h&quot;, 1, ColorCode.H),
      NewColorOC(&quot;s&quot;, 1, ColorCode.S),
      NewColorOC(&quot;v&quot;, 1, ColorCode.V),
      NewColorOC(&quot;brightness&quot;, 1, ColorCode.Brightness)
      };
    ObLib.Register(
      NEW(PackageColor, name:=&quot;color&quot;, opCodes:=opCodes));
  END SetupColor;

  PROCEDURE <A NAME="EvalColor"><procedure>EvalColor</procedure></A>(self: PackageColor; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR real1, real2, real3: LONGREAL; rgb1: Color.T; hsv1: Color.HSV;
      text1: TEXT;
    BEGIN
      CASE NARROW(opCode, ColorOpCode).code OF
      | ColorCode.Named =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TRY rgb1 := ColorName.ToRGB(text1);
          EXCEPT ColorName.NotFound =&gt; rgb1 := Color.Black;
          END;
          RETURN NEW(ValColor,  what:=&quot;&lt;a Color.T&gt;&quot;, picklable:=TRUE,
              color:=rgb1);
      | ColorCode.RGB =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real3:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
	  IF (real1&lt;0.0d0) OR (real1&gt;1.0d0)
          THEN ObValue.BadArgVal(1, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
	  IF (real2&lt;0.0d0) OR (real2&gt;1.0d0)
          THEN ObValue.BadArgVal(2, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
	  IF (real3&lt;0.0d0) OR (real3&gt;1.0d0)
          THEN ObValue.BadArgVal(3, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          rgb1 := Color.T{r:=FLOAT(real1), g:=FLOAT(real2), b:=FLOAT(real3)};
          RETURN NEW(ValColor, what:=&quot;&lt;a Color.T&gt;&quot;, picklable:=TRUE,
            color:=rgb1);
      | ColorCode.HSV =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValReal(node) =&gt; real2:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValReal(node) =&gt; real3:=node.real;
          ELSE ObValue.BadArgType(3, &quot;real&quot;, self.name, opCode.name, loc); END;
	  IF (real1&lt;0.0d0) OR (real1&gt;1.0d0)
          THEN ObValue.BadArgVal(1, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
	  IF (real2&lt;0.0d0) OR (real2&gt;1.0d0)
          THEN ObValue.BadArgVal(2, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
	  IF (real3&lt;0.0d0) OR (real3&gt;1.0d0)
          THEN ObValue.BadArgVal(3, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          rgb1 := Color.FromHSV(
              Color.HSV{h:=FLOAT(real1), s:=FLOAT(real2), v:=FLOAT(real3)});
          RETURN NEW(ValColor, what:=&quot;&lt;a Color.T&gt;&quot;, picklable:=TRUE,
            color:=rgb1);
      | ColorCode.R =&gt;
          TYPECASE args[1] OF | ValColor(node) =&gt; rgb1:=node.color;
          ELSE ObValue.BadArgType(1, &quot;color&quot;, self.name, opCode.name, loc);END;
          RETURN NEW(ObValue.ValReal, real:=FLOAT(rgb1.r, LONGREAL), temp:=temp);
      | ColorCode.G =&gt;
          TYPECASE args[1] OF | ValColor(node) =&gt; rgb1:=node.color;
          ELSE ObValue.BadArgType(1, &quot;color&quot;, self.name, opCode.name, loc);END;
          RETURN NEW(ObValue.ValReal, real:=FLOAT(rgb1.g, LONGREAL), temp:=temp);
      | ColorCode.B =&gt;
          TYPECASE args[1] OF | ValColor(node) =&gt; rgb1:=node.color;
          ELSE ObValue.BadArgType(1, &quot;color&quot;, self.name, opCode.name, loc);END;
          RETURN NEW(ObValue.ValReal, real:=FLOAT(rgb1.b, LONGREAL), temp:=temp);
      | ColorCode.H =&gt;
          TYPECASE args[1] OF | ValColor(node) =&gt; rgb1:=node.color;
          ELSE ObValue.BadArgType(1, &quot;color&quot;, self.name, opCode.name, loc);END;
          hsv1 := Color.ToHSV(rgb1);
          RETURN NEW(ObValue.ValReal, real:=FLOAT(hsv1.h, LONGREAL), temp:=temp);
      | ColorCode.S =&gt;
          TYPECASE args[1] OF | ValColor(node) =&gt; rgb1:=node.color;
          ELSE ObValue.BadArgType(1, &quot;color&quot;, self.name, opCode.name, loc);END;
          hsv1 := Color.ToHSV(rgb1);
          RETURN NEW(ObValue.ValReal, real:=FLOAT(hsv1.s, LONGREAL), temp:=temp);
      | ColorCode.V =&gt;
          TYPECASE args[1] OF | ValColor(node) =&gt; rgb1:=node.color;
          ELSE ObValue.BadArgType(1, &quot;color&quot;, self.name, opCode.name, loc);END;
          hsv1 := Color.ToHSV(rgb1);
          RETURN NEW(ObValue.ValReal, real:=FLOAT(hsv1.v, LONGREAL), temp:=temp);
      | ColorCode.Brightness =&gt;
          TYPECASE args[1] OF | ValColor(node) =&gt; rgb1:=node.color;
          ELSE ObValue.BadArgType(1, &quot;color&quot;, self.name, opCode.name, loc);END;
          RETURN NEW(ObValue.ValReal,
            real:=FLOAT(Color.Brightness(rgb1), LONGREAL), temp:=temp);
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
    END EvalColor;
</PRE> ============ <CODE>form</CODE> package ============ 

<P><PRE>TYPE

  FormCode = {Error, New, FromFile, Attach,
    GetBool, PutBool, GetInt, PutInt, GetText, PutText,
    GetBoolean, PutBoolean, GetChoice, PutChoice, TakeFocus,
    GetReactivity, PutReactivity, PopUp, PopDown,
    Insert, Move, Delete, DeleteRange,
    ChildIndex, Child, NumOfChildren,
    ShowAt, Show, Hide};

  FormOpCode =
    ObLib.OpCode OBJECT
        code: FormCode;
      END;

  PackageForm =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalForm;
      END;

  TYPE FormClosure =
    FormsVBT.Closure OBJECT
      fun: ObValue.ValFun;
      fv: ObValue.Val;
      location: SynLocation.T;
    OVERRIDES
      apply := ApplyFormClosure;
    END;

  PROCEDURE <A NAME="ApplyFormClosure"><procedure>ApplyFormClosure</procedure></A>(self: FormClosure;
      fv: FormsVBT.T; name: TEXT; time: VBT.TimeStamp) RAISES {} =
    VAR args: ARRAY [0..0] OF ObValue.Val;
    BEGIN
      TRY
        args[0] := self.fv;
        EVAL ObEval.Call(self.fun, args, self.location);
      EXCEPT
      | ObValue.Error(packet) =&gt;
          SynWr.Text(SynWr.out,
           &quot;*** A Modula3 callback to Obliq caused an Obliq error: ***\n&quot;);
          ObValue.ErrorMsg(SynWr.out, packet);
          SynWr.Flush(SynWr.out);
      | ObValue.Exception(packet) =&gt;
          SynWr.Text(SynWr.out,
           &quot;*** A Modula3 callback to Obliq caused an Obliq exception: ***\n&quot;);
          ObValue.ExceptionMsg(SynWr.out, packet);
          SynWr.Flush(SynWr.out);
      END;
    END ApplyFormClosure;

  PROCEDURE <A NAME="IsForm"><procedure>IsForm</procedure></A>(self: ValForm; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValForm(oth)=&gt; RETURN self.form = oth.form;
    ELSE RETURN FALSE END;
  END IsForm;

  PROCEDURE <A NAME="CopyForm"><procedure>CopyForm</procedure></A>(self: ObValue.ValAnything; tbl: ObValue.Tbl;
    loc: SynLocation.T): ObValue.ValAnything RAISES {ObValue.Error} =
  BEGIN
    ObValue.RaiseError(&quot;Cannot copy forms&quot;, loc);
  END CopyForm;

  VAR formException: ObValue.ValException;

  PROCEDURE <A NAME="NewFormOC"><procedure>NewFormOC</procedure></A>(name: TEXT; arity: INTEGER; code: FormCode)
    : FormOpCode =
  BEGIN
    RETURN NEW(FormOpCode, name:=name, arity:=arity, code:=code);
  END NewFormOC;

  PROCEDURE <A NAME="SetupForm"><procedure>SetupForm</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(FormCode));
    opCodes^ :=
      OpCodes{
      NewFormOC(&quot;failure&quot;, -1, FormCode.Error),
      NewFormOC(&quot;new&quot;, 1, FormCode.New),
      NewFormOC(&quot;fromFile&quot;, 1, FormCode.FromFile),
      NewFormOC(&quot;attach&quot;, 3, FormCode.Attach),
      NewFormOC(&quot;getBool&quot;, 3, FormCode.GetBool),
      NewFormOC(&quot;putBool&quot;, 4, FormCode.PutBool),
      NewFormOC(&quot;getInt&quot;, 3, FormCode.GetInt),
      NewFormOC(&quot;putInt&quot;, 4, FormCode.PutInt),
      NewFormOC(&quot;getText&quot;, 3, FormCode.GetText),
      NewFormOC(&quot;putText&quot;, 5, FormCode.PutText),
      NewFormOC(&quot;getBoolean&quot;, 2, FormCode.GetBoolean),
      NewFormOC(&quot;putBoolean&quot;, 3, FormCode.PutBoolean),
      NewFormOC(&quot;getChoice&quot;, 2, FormCode.GetChoice),
      NewFormOC(&quot;putChoice&quot;, 3, FormCode.PutChoice),
      NewFormOC(&quot;takeFocus&quot;, 3, FormCode.TakeFocus),
      NewFormOC(&quot;getReactivity&quot;, 2, FormCode.GetReactivity),
      NewFormOC(&quot;putReactivity&quot;, 3, FormCode.PutReactivity),
      NewFormOC(&quot;popUp&quot;, 2, FormCode.PopUp),
      NewFormOC(&quot;popDown&quot;, 2, FormCode.PopDown),
      NewFormOC(&quot;insert&quot;, 4, FormCode.Insert),
      NewFormOC(&quot;move&quot;, 5, FormCode.Move),
      NewFormOC(&quot;delete&quot;, 3, FormCode.Delete),
      NewFormOC(&quot;deleteRange&quot;, 4, FormCode.DeleteRange),
      NewFormOC(&quot;childIndex&quot;, 3, FormCode.ChildIndex),
      NewFormOC(&quot;child&quot;, 3, FormCode.Child),
      NewFormOC(&quot;numOfChildren&quot;, 2, FormCode.NumOfChildren),
      NewFormOC(&quot;showAt&quot;, 3, FormCode.ShowAt),
      NewFormOC(&quot;show&quot;, 1, FormCode.Show),
      NewFormOC(&quot;hide&quot;, 1, FormCode.Hide)
      };
    ObLib.Register(
      NEW(PackageForm, name:=&quot;form&quot;, opCodes:=opCodes));
    formException := NEW(ObValue.ValException, name:=&quot;form_failure&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValForm),
      &quot;forms cannot be transmitted/duplicated&quot;);
  END SetupForm;

  PROCEDURE <A NAME="EvalForm"><procedure>EvalForm</procedure></A>(self: PackageForm; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR text1, text2, text3: TEXT; fv1: FormsVBT.T; bool1: BOOLEAN;
      int1, int2, index: INTEGER; fun1: ObValue.Val;
      ch, toCh, p: VBT.T;
    BEGIN
      TRY
      CASE NARROW(opCode, FormOpCode).code OF
      | FormCode.Error =&gt;
          RETURN formException;
      | FormCode.New =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          fv1 :=NEW(FormsVBT.T).init(text1);
          RETURN NEW(ValForm, what:=&quot;&lt;a FormsVBT.T&gt;&quot;, picklable:=FALSE,
              form:=fv1);
      | FormCode.FromFile =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TRY
            fv1 :=NEW(FormsVBT.T).initFromFile(text1);
          EXCEPT
          | Rd.Failure =&gt;
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          RETURN NEW(ValForm, what:=&quot;&lt;a FormsVBT.T&gt;&quot;, picklable:=FALSE,
              form:=fv1);
      | FormCode.Attach =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1:=node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValFun(node) =&gt; fun1:=node;
          ELSE ObValue.BadArgType(3, &quot;procedure&quot;, self.name, opCode.name, loc);
          END;
          FormsVBT.Attach(fv1, text1,
              NEW(FormClosure, fun:=fun1, fv:=args[1], location:=loc));
          RETURN ObValue.valOk;
      | FormCode.GetBool =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1:=node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          bool1 := FormsVBT.GetBooleanProperty(fv1, text1, text2);
          RETURN NEW(ObValue.ValBool, bool:=bool1);
      | FormCode.PutBool =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(4, &quot;bool&quot;, self.name, opCode.name, loc); END;
          FormsVBT.PutBooleanProperty(fv1, text1, text2, bool1);
          RETURN ObValue.valOk;
      | FormCode.GetInt =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          IF Text.Empty(text2) THEN
            int1 := FormsVBT.GetInteger(fv1, text1);
          ELSE
            int1 := FormsVBT.GetIntegerProperty(fv1, text1, text2);
          END;
          RETURN NEW(ObValue.ValInt, int:=int1);
      | FormCode.PutInt =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(4, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF Text.Empty(text2) THEN
            FormsVBT.PutInteger(fv1, text1, int1);
          ELSE
            FormsVBT.PutIntegerProperty(fv1, text1, text2, int1);
          END;
          RETURN ObValue.valOk;
      | FormCode.GetText =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          IF Text.Empty(text2) THEN
            text3 := FormsVBT.GetText(fv1, text1);
          ELSE
            text3 := FormsVBT.GetTextProperty(fv1, text1, text2);
          END;
          RETURN ObValue.NewText(text3);
      | FormCode.PutText =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValText(node) =&gt; text3:=node.text;
          ELSE ObValue.BadArgType(4, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(5, &quot;bool&quot;, self.name, opCode.name, loc); END;
          IF Text.Empty(text2) THEN
            FormsVBT.PutText(fv1, text1, text3, bool1);
          ELSE
            FormsVBT.PutTextProperty(fv1, text1, text2, text3);
          END;
          RETURN ObValue.valOk;
      | FormCode.GetBoolean =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1:=node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          bool1 := FormsVBT.GetBoolean(fv1, text1);
          RETURN NEW(ObValue.ValBool, bool:=bool1);
      | FormCode.PutBoolean =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(3, &quot;bool&quot;, self.name, opCode.name, loc); END;
          FormsVBT.PutBoolean(fv1, text1, bool1);
          RETURN ObValue.valOk;
      | FormCode.GetChoice =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          text2 := FormsVBT.GetChoice(fv1, text1);
          RETURN ObValue.NewText(text2);
       | FormCode.PutChoice =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          IF Text.Empty(text2) THEN
            FormsVBT.PutChoice(fv1, text1, NIL);
          ELSE
            FormsVBT.PutChoice(fv1, text1, text2);
          END;
          RETURN ObValue.valOk;
      | FormCode.GetReactivity =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          IF FormsVBT.IsActive(fv1, text1) THEN
            RETURN ObValue.NewText(&quot;active&quot;);
          ELSIF FormsVBT.IsPassive(fv1, text1) THEN
            RETURN ObValue.NewText(&quot;passive&quot;);
          ELSIF FormsVBT.IsDormant(fv1, text1) THEN
            RETURN ObValue.NewText(&quot;dormant&quot;);
          ELSIF FormsVBT.IsVanished(fv1, text1) THEN
            RETURN ObValue.NewText(&quot;vanished&quot;);
          ELSE
            RETURN ObValue.NewText(&quot;&quot;);
          END;
       | FormCode.PutReactivity =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          IF Text.Equal(text2, &quot;active&quot;) THEN
            FormsVBT.MakeActive(fv1, text1);
          ELSIF Text.Equal(text2, &quot;passive&quot;) THEN
            FormsVBT.MakePassive(fv1, text1);
          ELSIF Text.Equal(text2, &quot;dormant&quot;) THEN
            FormsVBT.MakeDormant(fv1, text1);
          ELSIF Text.Equal(text2, &quot;vanished&quot;) THEN
            FormsVBT.MakeVanish(fv1, text1);
          ELSE ObValue.BadArgVal(3, &quot;a valid reactivity&quot;,
                               self.name, opCode.name, loc);
          END;
          RETURN ObValue.valOk;
      | FormCode.TakeFocus =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1:=node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(3, &quot;bool&quot;, self.name, opCode.name, loc); END;
          FormsVBT.TakeFocus(fv1, text1, FormsVBT.GetTheEventTime(fv1), bool1);
          RETURN ObValue.valOk;
      | FormCode.PopUp =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          FormsVBT.PopUp(fv1, text1);
          RETURN ObValue.valOk;
      | FormCode.PopDown =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          FormsVBT.PopDown(fv1, text1);
          RETURN ObValue.valOk;
      | FormCode.Insert =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(4, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF int1 &lt; 0 THEN
            ObValue.BadArgVal(4, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          EVAL FormsVBT.Insert(fv1, text1, text2, int1);
          RETURN ObValue.valOk;
      | FormCode.ChildIndex =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          p := FormsVBT.GetVBT(fv1, text1);
          ch := FormsVBT.GetVBT(fv1, text2);
          IF (p = NIL) OR (ch = NIL) THEN
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          TRY int1 := MultiSplit.Index(p, ch);
          EXCEPT MultiSplit.NotAChild =&gt;
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          RETURN NEW(ObValue.ValInt, int:=int1);
      | FormCode.Child =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(3, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF int1 &lt; 0 THEN
            ObValue.BadArgVal(3, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          p := FormsVBT.GetVBT(fv1, text1);
	  ch := MultiSplit.Nth(p, int1);
	  IF (p=NIL) OR (ch=NIL) THEN
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          TRY text2 := FormsVBT.GetName(ch);
          EXCEPT FormsVBT.Error =&gt;
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          RETURN ObValue.NewText(text2);
      | FormCode.NumOfChildren =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          p := FormsVBT.GetVBT(fv1, text1);
	  IF p=NIL THEN
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          TRY int1 := MultiSplit.NumChildren(p);
          EXCEPT MultiSplit.NotAChild =&gt;
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          RETURN NEW(ObValue.ValInt, int:=int1);
      | FormCode.Move =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValText(node) =&gt; text3:=node.text;
          ELSE ObValue.BadArgType(4, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[5] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(5, &quot;bool&quot;, self.name, opCode.name, loc); END;
          IF Text.Equal(text2, text3) THEN RETURN ObValue.valOk END;
          p := FormsVBT.GetVBT(fv1, text1);
          ch := FormsVBT.GetVBT(fv1, text2);
          IF Text.Empty(text3) THEN toCh := NIL
          ELSE toCh := FormsVBT.GetVBT(fv1, text3);
          END;
          IF (p = NIL) OR (ch = NIL) OR
            ((NOT Text.Empty(text3)) AND (toCh = NIL)) THEN
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          TRY
            IF bool1 THEN toCh := MultiSplit.Pred(p, toCh) END;
            MultiSplit.Move(p, toCh, ch);
          EXCEPT MultiSplit.NotAChild =&gt;
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          RETURN ObValue.valOk;
      | FormCode.Delete =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          p := FormsVBT.GetVBT(fv1, text1);
          ch := FormsVBT.GetVBT(fv1, text2);
          IF (p = NIL) OR (ch = NIL) THEN
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          TRY
            index := MultiSplit.Index(p, ch);
          EXCEPT MultiSplit.NotAChild =&gt;
            ObValue.RaiseException(formException, opCode.name, loc);
          END;
          FormsVBT.Delete(fv1, text1, index, 1);
          RETURN ObValue.valOk;
      | FormCode.DeleteRange =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(3, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF | ObValue.ValInt(node) =&gt; int2:=node.int;
          ELSE ObValue.BadArgType(4, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF int1 &lt; 0 THEN
            ObValue.BadArgVal(3, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          IF int2 &lt; 0 THEN
            ObValue.BadArgVal(4, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          FormsVBT.Delete(fv1, text1, int1, int2);
          RETURN ObValue.valOk;
      | FormCode.Show =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          Trestle.Install(fv1);
          RETURN ObValue.valOk;
      | FormCode.ShowAt =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          IF Text.Empty(text1) THEN Trestle.Install(fv1);
          ELSE
            Trestle.Install(v:=fv1, trsl:=Trestle.Connect(text1),
              windowTitle:=text2, iconTitle:=text2);
          END;
          RETURN ObValue.valOk;
      | FormCode.Hide =&gt;
          TYPECASE args[1] OF | ValForm(node) =&gt; fv1 := node.form;
          ELSE ObValue.BadArgType(1, &quot;form&quot;, self.name, opCode.name, loc); END;
          Trestle.Delete(fv1);
          RETURN ObValue.valOk;
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
      EXCEPT
      | FormsVBT.Error, FormsVBT.Unimplemented, TrestleComm.Failure =&gt;
        ObValue.RaiseException(formException, opCode.name, loc);
      | Thread.Alerted =&gt;
          ObValue.RaiseException(ObValue.threadAlerted,
                               self.name&amp;&quot;_&quot;&amp;opCode.name,loc);
      END;
    END EvalForm;

BEGIN
END ObLibUI.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
