<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqparse/src/ObFrame.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqparse/src/ObFrame.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
MODULE <module><implements><A HREF="ObFrame.i3">ObFrame</A></implements></module>;
IMPORT <A HREF="../../obliqrt/src/ObErr.i3">ObErr</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synex/src/SynScan.i3">SynScan</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../fmtlex/src/Lex.i3">Lex</A>, <A HREF="../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../obliqrt/src/ObEval.i3">ObEval</A>;
IMPORT <A HREF="../../params/src/Env.i3">Env</A> AS ProcessEnv;

PROCEDURE <A NAME="FmtSearchPath"><procedure>FmtSearchPath</procedure></A>(searchPath: SearchPath): TEXT  =
  BEGIN
    IF searchPath=NIL THEN RETURN &quot;&quot;;
    ELSIF searchPath.rest=NIL THEN RETURN searchPath.first;
    ELSE RETURN
      searchPath.first &amp;
        Text.FromChar(SearchPathSeparator) &amp;
        FmtSearchPath(searchPath.rest);
    END;
  END FmtSearchPath;

PROCEDURE <A NAME="LexSearchPath"><procedure>LexSearchPath</procedure></A>(rd: TextRd.T): SearchPath =
  VAR item, junk: TEXT; rest: SearchPath;
  BEGIN
    IF Rd.EOF(rd) &lt;* NOWARN *&gt; THEN RETURN NIL
    ELSE
      junk :=
        Lex.Scan(rd, &lt;* NOWARN *&gt;
          Lex.Blanks + SET OF CHAR{SearchPathSeparator}); &lt;* NOWARN *&gt;
      item :=
        Lex.Scan(rd, &lt;* NOWARN *&gt;
          Lex.NonBlanks - SET OF CHAR{SearchPathSeparator}); &lt;* NOWARN *&gt;
      IF Text.Empty(junk) AND Text.Empty(item) THEN RETURN NIL END;
      rest := LexSearchPath(rd);
      IF Text.Empty(item) THEN RETURN rest;
      ELSIF NOT Pathname.Valid(item) THEN RETURN rest;
      ELSE RETURN NEW(SearchPath, first:=item, rest:=rest);
      END;
    END;
  END LexSearchPath;

PROCEDURE <A NAME="PostFile"><procedure>PostFile</procedure></A>(sc: SynScan.T; filename: Pathname.T): BOOLEAN =
  VAR rd: Rd.T;
  BEGIN
    TRY
      rd:= FileRd.Open(filename);
      SynWr.Text(SynWr.out, &quot;Loading '&quot; &amp; filename &amp; &quot;'\n&quot;);
      SynScan.PushInput(sc, Pathname.Last(filename), rd, TRUE, TRUE);
      RETURN TRUE;
    EXCEPT OSError.E =&gt; RETURN FALSE
    END;
  END PostFile;

PROCEDURE <A NAME="LoadFile"><procedure>LoadFile</procedure></A>(sc: SynScan.T; filename: Pathname.T;
  complain: BOOLEAN:=TRUE) RAISES {ObErr.Fail} =
  VAR scan: SearchPath;
  BEGIN
    IF Pathname.Valid(filename) THEN
      IF Pathname.Absolute(filename) THEN
        IF PostFile(sc, filename) THEN RETURN END;
      ELSE
        scan := searchPath;
        WHILE scan # NIL DO
          IF PostFile(sc,
               Pathname.Join(scan.first, filename, NIL))
          THEN RETURN
          END;
          scan := scan.rest;
        END;
      END;
    END;
    IF complain THEN
      SynScan.ErrorMsg(sc, &quot;Could not open file '&quot; &amp; filename
        &amp; &quot;' along path '&quot; &amp; FmtSearchPath(searchPath) &amp; &quot;'&quot;);
    END;
  END LoadFile;

PROCEDURE <A NAME="ModuleFrame"><procedure>ModuleFrame</procedure></A>(sc: SynScan.T; name, for: TEXT;
  imports: NameList; env: Env) RAISES {ObErr.Fail} =
</PRE><BLOCKQUOTE><EM> Push scanner inputs so it will first load the imports first
   to last, then establish a frame for this module, and then
   finish reading this module. The last PushInput is executed first. </EM></BLOCKQUOTE><PRE>
  BEGIN
    SynScan.PushInput(sc, &quot;&lt;none&gt;&quot;,
      TextRd.New(&quot;establish &quot; &amp; name &amp; &quot; for &quot; &amp; for &amp; &quot;;\n&quot;),
      TRUE, TRUE);
    LoadImports(sc, imports, env);
  END ModuleFrame;

PROCEDURE <A NAME="ModuleEnd"><procedure>ModuleEnd</procedure></A>(sc: SynScan.T) RAISES {ObErr.Fail} =
  BEGIN
    SynScan.PushInput(sc, &quot;&lt;none&gt;&quot;, TextRd.New(&quot;qualify;\n&quot;), TRUE, TRUE);
  END ModuleEnd;

PROCEDURE <A NAME="LoadImports"><procedure>LoadImports</procedure></A>(sc: SynScan.T; imports: NameList; env: Env)
  RAISES {ObErr.Fail} =
</PRE><BLOCKQUOTE><EM> last to first, so the scanner will see them first to last </EM></BLOCKQUOTE><PRE>
  BEGIN
    IF imports#NIL THEN
      LoadImports(sc, imports.rest, env);
      ImportFrame(sc, imports.first, env);
    END;
  END LoadImports;

PROCEDURE <A NAME="ImportFrame"><procedure>ImportFrame</procedure></A>(sc: SynScan.T; name: TEXT; env: Env)
    RAISES {ObErr.Fail} =
  VAR scan: Env;
  BEGIN
    scan:=FindFrame(name, env);
    IF scan=NIL THEN LoadFile(sc, name &amp; &quot;.obl&quot;);
    ELSIF SynScan.TopLevel(sc) THEN
      SynWr.Text(SynWr.out, &quot;(Frame '&quot; &amp; name &amp;
        &quot;' already exists and has not been reloaded)\n&quot;);
    END;
  END ImportFrame;

PROCEDURE <A NAME="ModAndLib"><procedure>ModAndLib</procedure></A>(name, for: TEXT): TEXT =
  BEGIN
    IF Text.Equal(name, for) THEN RETURN &quot;'&quot; &amp; name &amp; &quot;'&quot;
    ELSE RETURN &quot;'&quot; &amp; name &amp; &quot;' for '&quot; &amp; for &amp; &quot;'&quot; END;
  END ModAndLib;

PROCEDURE <A NAME="EstablishFrame"><procedure>EstablishFrame</procedure></A>(name, for: TEXT; env: Env): Env
    RAISES {ObErr.Fail} =
  VAR moduleExists, frameExists: BOOLEAN;
  BEGIN
    SynWr.Text(SynWr.out, &quot;Establishing &quot; &amp; ModAndLib(name,for) &amp; &quot;\n&quot;);
    moduleExists := ObLib.Lookup(name, env.libEnv)#NIL;
    frameExists := FindFrame(name, env)#NIL;
    IF frameExists THEN
      RETURN SaveFrame(name, for, DeleteFrame(name, env));
    ELSIF moduleExists THEN
      ObErr.Fault(SynWr.out,
        &quot;Module name conflicts with existing library: '&quot; &amp; name &amp; &quot;_'&quot;);
    ELSE
      RETURN SaveFrame(name, for, env);
    END;
  END EstablishFrame;

PROCEDURE <A NAME="SaveFrame"><procedure>SaveFrame</procedure></A>(name, for: TEXT; env: Env): Env
    RAISES {ObErr.Fail} =
  VAR scan: Env;
  BEGIN
    scan:=FindFrame(name, env);
    IF scan#NIL THEN
      ObErr.Fault(SynWr.out, &quot;Frame already exists: '&quot; &amp; name &amp; &quot;'&quot;);
      RETURN env;
    END;
    IF NOT Text.Empty(name) THEN
      SynWr.Text(SynWr.out, &quot;(Created frame &quot; &amp; ModAndLib(name,for) &amp; &quot;)\n&quot;);
    END;
    RETURN
      NEW(Env,
        frameName := name,
        forName := for,
        libEnv := env.libEnv,
        scopeEnv := env.scopeEnv,
        checkEnv := env.checkEnv,
        valueEnv := env.valueEnv,
        nextFrame := env);
  END SaveFrame;

PROCEDURE <A NAME="DeleteFrame"><procedure>DeleteFrame</procedure></A>(name: TEXT; env: Env): Env RAISES {ObErr.Fail} =
  VAR scan: Env;
  BEGIN
    scan:=FindFrame(name, env);
    IF scan=NIL THEN
      RETURN env;
    ELSE
      LOOP
        SynWr.Text(SynWr.out,
          &quot;(Deleted frame &quot; &amp; ModAndLib(env.frameName,env.forName) &amp; &quot;)\n&quot;);
	IF env=scan THEN EXIT END;
	env:=env.nextFrame;
      END;
      RETURN scan.nextFrame;
    END;
  END DeleteFrame;

PROCEDURE <A NAME="FindFrame"><procedure>FindFrame</procedure></A>(name: TEXT; env: Env): Env =
  VAR scan: Env;
  BEGIN
    scan:=env;
    LOOP
      IF scan=NIL THEN EXIT END;
      IF Text.Equal(scan.frameName, name) THEN EXIT END;
      scan := scan.nextFrame;
    END;
    RETURN scan;
  END FindFrame;

TYPE
  FrameLib =
    ObLib.T OBJECT
      OVERRIDES
        Eval := FrameLibEval;
      END;

PROCEDURE <A NAME="QualifyFrame"><procedure>QualifyFrame</procedure></A>(env: Env): Env
    RAISES {ObErr.Fail} =
  VAR scanValueEnv: ObValue.Env;
    frameSize: INTEGER; opCodes: REF ObLib.OpCodes;
    library: ObLib.T; newLibEnv: ObLib.Env; newEnv: Env;
  BEGIN
    IF Text.Empty(env.frameName) THEN RETURN env END;
    scanValueEnv := env.valueEnv;
    frameSize := 0;
    LOOP
      IF scanValueEnv=env.nextFrame.valueEnv THEN EXIT END;
      INC(frameSize);
      scanValueEnv:=scanValueEnv.rest;
    END;
    opCodes := NEW(REF ObLib.OpCodes, frameSize);
    scanValueEnv := env.valueEnv;
    FOR i:=0 TO frameSize-1 DO
      opCodes[i] :=
          NEW(FrameOpCode, name:=scanValueEnv.name.text,
              arity := -2, fixity := ObLib.OpFixity.Qualified,
              val := NARROW(scanValueEnv, ObValue.LocalEnv).val);
      scanValueEnv:=scanValueEnv.rest;
    END;
    library := NEW(FrameLib, name:=env.forName, opCodes:=opCodes);
    newLibEnv := ObLib.Extend(library, env.libEnv);
    newEnv :=
      NEW(Env,
          frameName := env.frameName,
          forName := env.forName,
          libEnv := newLibEnv,
          scopeEnv := env.nextFrame.scopeEnv,
          checkEnv := env.nextFrame.checkEnv,
          valueEnv := env.nextFrame.valueEnv,
          nextFrame := env.nextFrame);
    SynWr.Text(SynWr.out,
      &quot;(Closed frame &quot; &amp; ModAndLib(env.frameName,env.forName) &amp; &quot;)\n&quot;);
    RETURN newEnv;
  END QualifyFrame;

PROCEDURE <A NAME="FrameLibEval"><procedure>FrameLibEval</procedure></A>(self: FrameLib; opCode: ObLib.OpCode;
  arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
  temp: BOOLEAN; loc: SynLocation.T)
  : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
  VAR frameOpCode: FrameOpCode;
  BEGIN
    frameOpCode := NARROW(opCode, FrameOpCode);
    IF arity = -1 THEN
      RETURN frameOpCode.val;
    ELSIF arity &gt; NUMBER(args) THEN
      ObValue.RaiseError(&quot;Too many arguments&quot;, loc);
    ELSE
      RETURN ObEval.Call(frameOpCode.val, SUBARRAY(args, 0, arity), loc);
    END;
  END FrameLibEval;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>()  =
  VAR envPath: TEXT;
  BEGIN
    envPath := ProcessEnv.Get(&quot;OBLIQPATH&quot;);
    IF envPath=NIL THEN
      searchPath :=
        NEW(SearchPath,
            first:=Pathname.Current,
            rest:= NIL);
    ELSE
      searchPath := LexSearchPath(TextRd.New(envPath));
    END;
  END Setup;

BEGIN
END ObFrame.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
