<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqparse/src/ObParseFrame.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqparse/src/ObParseFrame.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
MODULE <module><implements><A HREF="ObParseFrame.i3">ObParseFrame</A></implements></module>;
IMPORT <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../synex/src/SynParse.i3">SynParse</A>, <A HREF="../../metasyn/src/MetaParser.i3">MetaParser</A>, <A HREF="ObFrame.i3">ObFrame</A>;

  PROCEDURE <A NAME="SelectText"><procedure>SelectText</procedure></A>(p: SynParse.T; index: INTEGER): TEXT  =
    BEGIN
      RETURN NARROW(p.stack[index], MetaParser.TextTemp).text;
    END SelectText;

  PROCEDURE <A NAME="BuildPhraseQuit"><procedure>BuildPhraseQuit</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW(ObFrame.Quit, location:=SynLocation.NewLineLocation(info));
  END BuildPhraseQuit;

  PROCEDURE <A NAME="BuildPhraseLoadName"><procedure>BuildPhraseLoadName</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW(ObFrame.Load, location:=SynLocation.NewLineLocation(info),
        name:=SelectText(p, base+1) &amp; &quot;.obl&quot;);
  END BuildPhraseLoadName;

  PROCEDURE <A NAME="BuildPhraseLoadString"><procedure>BuildPhraseLoadString</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW(ObFrame.Load, location:=SynLocation.NewLineLocation(info),
        name:=SelectText(p, base+1));
  END BuildPhraseLoadString;

  PROCEDURE <A NAME="BuildPhraseImport"><procedure>BuildPhraseImport</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW(ObFrame.Import, location:=SynLocation.NewLineLocation(info),
        name:=SelectText(p, base+1));
  END BuildPhraseImport;

  PROCEDURE <A NAME="BuildPhraseModule"><procedure>BuildPhraseModule</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree =
  VAR name, for: TEXT;
  BEGIN
    name := SelectText(p, base+1);
    IF p.stack[base+3] = NIL
    THEN for := name;
    ELSE for := SelectText(p, base+3);
    END;
    RETURN
      NEW(ObFrame.Module, location:=SynLocation.NewLineLocation(info),
        name:=name, for:=for, imports:=p.stack[base+5]);
  END BuildPhraseModule;

  PROCEDURE <A NAME="BuildPhraseEndModule"><procedure>BuildPhraseEndModule</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW(ObFrame.EndModule,
        location:=SynLocation.NewLineLocation(info));
  END BuildPhraseEndModule;

  PROCEDURE <A NAME="BuildImportList"><procedure>BuildImportList</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW(ObFrame.NameList, location:=SynLocation.NewLineLocation(info),
        first:=SelectText(p, base+1),
	rest:=p.stack[base+2]);
  END BuildImportList;

  PROCEDURE <A NAME="BuildImportListSingle"><procedure>BuildImportListSingle</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree =
  BEGIN
    RETURN
      NEW(ObFrame.NameList, location:=SynLocation.NewLineLocation(info),
        first:=SelectText(p, base+1), rest:=NIL);
  END BuildImportListSingle;

  PROCEDURE <A NAME="BuildImportListNil"><procedure>BuildImportListNil</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree  =
  BEGIN
    RETURN NIL;
  END BuildImportListNil;

  PROCEDURE <A NAME="BuildPhraseEstablish"><procedure>BuildPhraseEstablish</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree  =
  VAR name, for: TEXT;
  BEGIN
    name := SelectText(p, base+1);
    IF p.stack[base+3] = NIL
    THEN for := name;
    ELSE for := SelectText(p, base+3);
    END;
    RETURN
      NEW(ObFrame.Establish, location:=SynLocation.NewLineLocation(info),
        name:=name, for:=for);
  END BuildPhraseEstablish;

  PROCEDURE <A NAME="BuildPhraseDelete"><procedure>BuildPhraseDelete</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree  =
  BEGIN
    RETURN
      NEW(ObFrame.Delete, location:=SynLocation.NewLineLocation(info),
        name:=SelectText(p, base+1));
  END BuildPhraseDelete;

  PROCEDURE <A NAME="BuildPhraseSave"><procedure>BuildPhraseSave</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree  =
  BEGIN
    RETURN
      NEW(ObFrame.Save, location:=SynLocation.NewLineLocation(info),
        name:=SelectText(p, base+1));
  END BuildPhraseSave;

  PROCEDURE <A NAME="BuildPhraseQualify"><procedure>BuildPhraseQualify</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree  =
  BEGIN
    RETURN
      NEW(ObFrame.Qualify,
        location:=SynLocation.NewLineLocation(info));
  END BuildPhraseQualify;

PROCEDURE <A NAME="RegisterActions"><procedure>RegisterActions</procedure></A>(actions: MetaParser.ActionTable)  =
  BEGIN
    MetaParser.Register(&quot;BuildPhraseQuit&quot;, BuildPhraseQuit, actions);
    MetaParser.Register(&quot;BuildPhraseLoadName&quot;, BuildPhraseLoadName, actions);
    MetaParser.Register(&quot;BuildPhraseLoadString&quot;, BuildPhraseLoadString, actions);
    MetaParser.Register(&quot;BuildPhraseImport&quot;, BuildPhraseImport, actions);
    MetaParser.Register(&quot;BuildPhraseEstablish&quot;, BuildPhraseEstablish, actions);
    MetaParser.Register(&quot;BuildPhraseDelete&quot;, BuildPhraseDelete, actions);
    MetaParser.Register(&quot;BuildPhraseSave&quot;, BuildPhraseSave, actions);
    MetaParser.Register(&quot;BuildPhraseQualify&quot;, BuildPhraseQualify, actions);
    MetaParser.Register(&quot;BuildPhraseModule&quot;, BuildPhraseModule, actions);
    MetaParser.Register(&quot;BuildPhraseEndModule&quot;, BuildPhraseEndModule, actions);
    MetaParser.Register(&quot;BuildImportList&quot;, BuildImportList, actions);
    MetaParser.Register(&quot;BuildImportListSingle&quot;, BuildImportListSingle, actions);
    MetaParser.Register(&quot;BuildImportListNil&quot;, BuildImportListNil, actions);
  END RegisterActions;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>()  =
  BEGIN
  END Setup;

BEGIN
END ObParseFrame.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
