<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqparse/src/ObParseTree.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqparse/src/ObParseTree.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObParseTree.i3">ObParseTree</A></implements></module>;
IMPORT <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../synex/src/SynScan.i3">SynScan</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../synex/src/SynParse.i3">SynParse</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqrt/src/ObTree.i3">ObTree</A>, <A HREF="../../metasyn/src/MetaParser.i3">MetaParser</A>;

  PROCEDURE <A NAME="SelectText"><procedure>SelectText</procedure></A>(p: SynParse.T; index: INTEGER): TEXT =
    BEGIN
      RETURN NARROW(p.stack[index], MetaParser.TextTemp).text;
    END SelectText;

  PROCEDURE <A NAME="SelectInt"><procedure>SelectInt</procedure></A>(p: SynParse.T; index: INTEGER): INTEGER =
    BEGIN
      RETURN NARROW(p.stack[index], MetaParser.IntegerTemp).int;
    END SelectInt;

  PROCEDURE <A NAME="SelectReal"><procedure>SelectReal</procedure></A>(p: SynParse.T; index: INTEGER): LONGREAL =
    BEGIN
      RETURN NARROW(p.stack[index], MetaParser.RealTemp).real;
    END SelectReal;

  PROCEDURE <A NAME="Select1"><procedure>Select1</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree =
    BEGIN
      RETURN p.stack[base+1];
    END Select1;

  PROCEDURE <A NAME="Select2"><procedure>Select2</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree =
    BEGIN
      RETURN p.stack[base+2];
    END Select2;

  PROCEDURE <A NAME="Select3"><procedure>Select3</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree =
    BEGIN
      RETURN p.stack[base+3];
    END Select3;

  PROCEDURE <A NAME="Select4"><procedure>Select4</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree =
    BEGIN
      RETURN p.stack[base+4];
    END Select4;

  PROCEDURE <A NAME="Select5"><procedure>Select5</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree =
    BEGIN
      RETURN p.stack[base+5];
    END Select5;

  PROCEDURE <A NAME="Select6"><procedure>Select6</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree =
    BEGIN
      RETURN p.stack[base+6];
    END Select6;

  PROCEDURE <A NAME="BuildIdeName"><procedure>BuildIdeName</procedure></A>(p: SynParse.T; index: INTEGER): ObTree.IdeName =
    BEGIN
      RETURN NEW(ObTree.IdeName, text:=SelectText(p, index), variant:=0);
    END BuildIdeName;

  PROCEDURE <A NAME="BuildPhraseEmpty"><procedure>BuildPhraseEmpty</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree =
    BEGIN
      RETURN NIL;
    END BuildPhraseEmpty;

  PROCEDURE <A NAME="BuildPhraseFlag"><procedure>BuildPhraseFlag</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
  VAR name, arg: TEXT;
  BEGIN
    IF p.stack[base+1]=NIL THEN name:=&quot;?&quot;; arg:=&quot;?&quot;;
    ELSE
      name := SelectText(p, base+1);
      IF p.stack[base+2]=NIL THEN arg:=&quot;?&quot;;
      ELSE
	arg:=SelectText(p, base+2);
      END;
    END;
    RETURN
      NEW(ObTree.PhraseCommand, location:=SynLocation.NewLineLocation(info),
        set:=ObTree.doCommandSet, name:=name, arg:=arg);
  END BuildPhraseFlag;

  PROCEDURE <A NAME="BuildPhraseHelp"><procedure>BuildPhraseHelp</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
  VAR name, arg: TEXT;
  BEGIN
    IF p.stack[base+1]=NIL THEN name:=&quot;?&quot;; arg:=&quot;?&quot;;
    ELSE
      name := SelectText(p, base+1);
      IF p.stack[base+2]=NIL THEN arg:=&quot;?&quot;;
      ELSE
	arg:=SelectText(p, base+2);
      END;
    END;
    RETURN
      NEW(ObTree.PhraseCommand, location:=SynLocation.NewLineLocation(info),
        set:=ObLib.helpCommandSet, name:=name, arg:=arg);
  END BuildPhraseHelp;

  PROCEDURE <A NAME="BuildPhraseTerm"><procedure>BuildPhraseTerm</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
	NEW(ObTree.PhraseTerm, location:=SynLocation.NewLineLocation(info),
	  term:=p.stack[base+1], printDepth:=-1);
    END BuildPhraseTerm;

  PROCEDURE <A NAME="BuildPhraseTermDeep"><procedure>BuildPhraseTermDeep</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
	NEW(ObTree.PhraseTerm, location:=SynLocation.NewLineLocation(info),
	  term:=p.stack[base+1], printDepth:=40);
    END BuildPhraseTermDeep;

  PROCEDURE <A NAME="BuildPhraseTermDepth"><procedure>BuildPhraseTermDepth</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
	NEW(ObTree.PhraseTerm, location:=SynLocation.NewLineLocation(info),
	  term:=p.stack[base+1],
	  printDepth:=SelectInt(p, base+2));
    END BuildPhraseTermDepth;

  PROCEDURE <A NAME="BuildTermBinding"><procedure>BuildTermBinding</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
	NEW(ObTree.TermBinding, location:=SynLocation.NewLineLocation(info),
	  binder:=BuildIdeName(p, base+1),
	  term:=p.stack[base+2],
	  rest:=p.stack[base+3]);
    END BuildTermBinding;

  PROCEDURE <A NAME="BuildTermBindingSingle"><procedure>BuildTermBindingSingle</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
	NEW(ObTree.TermBinding, location:=SynLocation.NewLineLocation(info),
	  binder:=BuildIdeName(p, base+1),
	  term:=p.stack[base+2],
	  rest:=NIL);
    END BuildTermBindingSingle;

  PROCEDURE <A NAME="BuildTermBindingNil"><procedure>BuildTermBindingNil</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NIL;
    END BuildTermBindingNil;

  PROCEDURE <A NAME="BuildTermIde"><procedure>BuildTermIde</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermIde, location:=SynLocation.NewLineLocation(info),
	name:=BuildIdeName(p, base+1), place:=NIL);
    END BuildTermIde;

  PROCEDURE <A NAME="BuildTermOk"><procedure>BuildTermOk</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermOk, location:=SynLocation.NewLineLocation(info));
    END BuildTermOk;

  PROCEDURE <A NAME="BuildTermBoolTrue"><procedure>BuildTermBoolTrue</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermBool, location:=SynLocation.NewLineLocation(info),
	bool:=TRUE);
    END BuildTermBoolTrue;

  PROCEDURE <A NAME="BuildTermBoolFalse"><procedure>BuildTermBoolFalse</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermBool, location:=SynLocation.NewLineLocation(info),
	bool:=FALSE);
    END BuildTermBoolFalse;

  PROCEDURE <A NAME="BuildTermChar"><procedure>BuildTermChar</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermChar, location:=SynLocation.NewLineLocation(info),
	char:=Text.GetChar(SelectText(p, base+1),0));
    END BuildTermChar;

  PROCEDURE <A NAME="BuildTermText"><procedure>BuildTermText</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermText, location:=SynLocation.NewLineLocation(info),
	text:=SelectText(p, base+1));
    END BuildTermText;

  PROCEDURE <A NAME="BuildTermInt"><procedure>BuildTermInt</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermInt, location:=SynLocation.NewLineLocation(info),
	int:=SelectInt(p, base+1));
    END BuildTermInt;

  PROCEDURE <A NAME="BuildTermReal"><procedure>BuildTermReal</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermReal, location:=SynLocation.NewLineLocation(info),
	real:=SelectReal(p, base+1));
    END BuildTermReal;

  PROCEDURE <A NAME="BuildTermArray"><procedure>BuildTermArray</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermArray, location:=SynLocation.NewLineLocation(info),
	elems:=p.stack[base+1]);
    END BuildTermArray;

  PROCEDURE <A NAME="BuildTermOption"><procedure>BuildTermOption</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermOption, location:=SynLocation.NewLineLocation(info),
	tag := BuildIdeName(p, base+1), term :=p.stack[base+2]);
    END BuildTermOption;

  PROCEDURE <A NAME="BuildTermAlias"><procedure>BuildTermAlias</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermAlias, location:=SynLocation.NewLineLocation(info),
	label := BuildIdeName(p, base+1), term :=p.stack[base+2]);
    END BuildTermAlias;

  PROCEDURE <A NAME="BuildTermOp"><procedure>BuildTermOp</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
    VAR pkg: ObTree.IdeName;
    BEGIN
      TYPECASE p.stack[base+1] OF
      | ObTree.TermIde(node) =&gt; pkg:=node.name;
      ELSE
        SynScan.SyntaxMsg(p.Scanner(), &quot;Identifier expected before '_'&quot;,&quot;&quot;);
        RAISE SynParse.Fail;
      END;
      RETURN NEW(ObTree.TermOp, location:=SynLocation.NewLineLocation(info),
        pkg:=pkg,
        op:=BuildIdeName(p, base+2),
	args:=p.stack[base+3],
	(* the rest is setup in Scope.Term *)
	argsNo:=0, package:=NIL, opCode:=NIL);
    END BuildTermOp;

  PROCEDURE <A NAME="BuildTermOpConst"><procedure>BuildTermOpConst</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
    VAR pkg: ObTree.IdeName;
    BEGIN
      TYPECASE p.stack[base+1] OF
      | ObTree.TermIde(node) =&gt; pkg:=node.name;
      ELSE
        SynScan.SyntaxMsg(p.Scanner(), &quot;Identifier expected before '_'&quot;,&quot;&quot;);
        RAISE SynParse.Fail;
      END;
      RETURN NEW(ObTree.TermOp, location:=SynLocation.NewLineLocation(info),
        pkg:=pkg,
        op:=BuildIdeName(p, base+2),
	args:=NIL, argsNo:=-1,
	(* the rest is setup in Scope.Term *)
	package:=NIL, opCode:=NIL);
    END BuildTermOpConst;

  PROCEDURE <A NAME="BuildIdeListNil"><procedure>BuildIdeListNil</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NIL;
    END BuildIdeListNil;

  PROCEDURE <A NAME="BuildIdeListSingle"><procedure>BuildIdeListSingle</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.IdeList, location:=SynLocation.NewLineLocation(info),
        first:=BuildIdeName(p, base+1), rest:=NIL);
    END BuildIdeListSingle;

  PROCEDURE <A NAME="BuildIdeListCons"><procedure>BuildIdeListCons</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.IdeList, location:=SynLocation.NewLineLocation(info),
        first:=BuildIdeName(p, base+1),
        rest:=p.stack[base+2]);
    END BuildIdeListCons;

  PROCEDURE <A NAME="BuildTermListNil"><procedure>BuildTermListNil</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NIL;
    END BuildTermListNil;

  PROCEDURE <A NAME="BuildTermListSingle"><procedure>BuildTermListSingle</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermList, location:=SynLocation.NewLineLocation(info),
        first:=p.stack[base+1], rest:=NIL);
    END BuildTermListSingle;

  PROCEDURE <A NAME="BuildTermListCons"><procedure>BuildTermListCons</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermList, location:=SynLocation.NewLineLocation(info),
        first:=p.stack[base+1],
        rest:=p.stack[base+2]);
    END BuildTermListCons;

 PROCEDURE <A NAME="BuildTermProc"><procedure>BuildTermProc</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermFun,location:=SynLocation.NewLineLocation(info),
	  binders:=p.stack[base+1],
	  bindersNo:=-1,
	  body:=p.stack[base+2],
	  globals:=NIL,
	  globalsNo:=-1);
    END BuildTermProc;

  PROCEDURE <A NAME="BuildTermAppl"><procedure>BuildTermAppl</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
    VAR fun: ObTree.Term; args: ObTree.TermList;
      loc: SynLocation.T; pkgName: TEXT;
    BEGIN
      fun := p.stack[base+1];
      args := p.stack[base+2];
      loc := SynLocation.NewLineLocation(info);
      TYPECASE fun OF
      | ObTree.TermIde(ide) =&gt;
          CASE ObLib.LookupFixity(ide.name.text, ObLib.libraries,
                                  (*out*)pkgName) OF
          | ObLib.OpFixity.Undefined, ObLib.OpFixity.Qualified =&gt;
              RETURN NEW(ObTree.TermAppl, location:=loc, fun:=fun, args:=args);
          | ObLib.OpFixity.Prefix, ObLib.OpFixity.Infix =&gt;
            RETURN
              NEW(ObTree.TermOp, location:=loc,
                pkg:=NEW(ObTree.IdeName, text:=pkgName, variant:=0),
                op:=ide.name, args:=args, package:=NIL, opCode:=NIL);
          END;
      ELSE RETURN NEW(ObTree.TermAppl, location:=loc, fun:=fun, args:=args);
      END;
    END BuildTermAppl;

  PROCEDURE <A NAME="BuildTermInfix"><procedure>BuildTermInfix</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
    VAR opName: ObTree.IdeName; pkgName: TEXT; args: ObTree.TermList;
      loc: SynLocation.T;
    BEGIN
      opName := BuildIdeName(p, base+2);
      loc := SynLocation.NewLineLocation(info);
      args :=
        NEW(ObTree.TermList, location:=loc,
           first:=p.stack[base+1],
           rest:=
             NEW(ObTree.TermList, location:=loc,
                 first:=p.stack[base+3],
                 rest:=NIL));
      CASE ObLib.LookupFixity(opName.text, ObLib.libraries, (*out*)pkgName) OF
      | ObLib.OpFixity.Infix, ObLib.OpFixity.Prefix(*will give an error leater*) =&gt;
        RETURN
          NEW(ObTree.TermOp, location:=loc,
            pkg:=NEW(ObTree.IdeName, text:=pkgName, variant:=0),
            op:=opName, args:=args,
	    package:=NIL, opCode:=NIL);
      | ObLib.OpFixity.Undefined, ObLib.OpFixity.Qualified =&gt;
        RETURN
          NEW(ObTree.TermAppl, location:=loc,
	    fun:=NEW(ObTree.TermIde, location:=loc, name:=opName, place:=NIL),
	    args:=args);
      END;
    END BuildTermInfix;

  PROCEDURE <A NAME="BuildTermSeq"><procedure>BuildTermSeq</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(ObTree.TermSeq, location:=SynLocation.NewLineLocation(info),
	before:=p.stack[base+1],
	after:=p.stack[base+2]);
    END BuildTermSeq;

 PROCEDURE <A NAME="BuildTermObj"><procedure>BuildTermObj</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail} =
    VAR protected: BOOLEAN; serialized: ObTree.Sync;
    BEGIN
      protected := NARROW(p.stack[base+1], BoolTemp).bool;
      IF NARROW(p.stack[base+2], BoolTemp).bool THEN
        serialized := ObTree.Sync.Monitored;
      ELSE serialized := ObTree.Sync.None;
      END;
      RETURN
        NEW(ObTree.TermObj, location:=SynLocation.NewLineLocation(info),
	  protected := protected,
          sync := serialized,
          fields:=p.stack[base+3]);
    END BuildTermObj;

  TYPE BoolTemp =
    SynParse.Tree BRANDED OBJECT bool: BOOLEAN END;

  PROCEDURE <A NAME="BuildOptionYes"><procedure>BuildOptionYes</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base:INTEGER; READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(BoolTemp, location:=NIL, bool:=TRUE);
    END BuildOptionYes;

  PROCEDURE <A NAME="BuildOptionNo"><procedure>BuildOptionNo</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base:INTEGER; READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NEW(BoolTemp, location:=NIL, bool:=FALSE);
    END BuildOptionNo;

 PROCEDURE <A NAME="BuildTermObjFieldNil"><procedure>BuildTermObjFieldNil</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NIL;
    END BuildTermObjFieldNil;

 PROCEDURE <A NAME="BuildTermObjFieldSingle"><procedure>BuildTermObjFieldSingle</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermObjFields,location:=SynLocation.NewLineLocation(info),
          label:=BuildIdeName(p, base+1),
          term:=p.stack[base+2],
	  rest:=NIL);
    END BuildTermObjFieldSingle;

 PROCEDURE <A NAME="BuildTermObjField"><procedure>BuildTermObjField</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermObjFields,location:=SynLocation.NewLineLocation(info),
          label:=BuildIdeName(p, base+1),
          term:=p.stack[base+2],
	  rest:=p.stack[base+3]);
    END BuildTermObjField;

 PROCEDURE <A NAME="BuildTermMeth"><procedure>BuildTermMeth</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermMeth,location:=SynLocation.NewLineLocation(info),
	  binders:=p.stack[base+1],
	  bindersNo := -1,
	  body:=p.stack[base+2],
	  globals := NIL,
	  globalsNo := -1);
    END BuildTermMeth;

 PROCEDURE <A NAME="BuildTermClone"><procedure>BuildTermClone</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermClone,location:=SynLocation.NewLineLocation(info),
	  objs:=p.stack[base+1]);
    END BuildTermClone;

 PROCEDURE <A NAME="BuildTermRedirect"><procedure>BuildTermRedirect</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermRedirect,location:=SynLocation.NewLineLocation(info),
	  obj:=p.stack[base+1], toObj:=p.stack[base+2]);
    END BuildTermRedirect;

 PROCEDURE <A NAME="BuildTermSelect"><procedure>BuildTermSelect</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermSelect,location:=SynLocation.NewLineLocation(info),
	  obj:=p.stack[base+1],
	  label:=BuildIdeName(p, base+2), labelIndexHint:=-1,
	  invoke:=FALSE, argsNo:=0, args:=NIL);
    END BuildTermSelect;

 PROCEDURE <A NAME="BuildTermInvoke"><procedure>BuildTermInvoke</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermSelect,location:=SynLocation.NewLineLocation(info),
	  obj:=p.stack[base+1],
	  label:=BuildIdeName(p, base+2), labelIndexHint:=-1,
	  invoke:=TRUE, argsNo:=0, args:=p.stack[base+3]);
    END BuildTermInvoke;

 PROCEDURE <A NAME="BuildTermUpdate"><procedure>BuildTermUpdate</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermUpdate,location:=SynLocation.NewLineLocation(info),
	  obj:=p.stack[base+1],
	  label:=BuildIdeName(p, base+2), labelIndexHint:=-1,
	  term:=p.stack[base+3]);
    END BuildTermUpdate;

 PROCEDURE <A NAME="BuildTermArrayGet"><procedure>BuildTermArrayGet</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    VAR loc: SynLocation.T;
    BEGIN
      loc := SynLocation.NewLineLocation(info);
      RETURN
        NEW(ObTree.TermOp,  location:=loc,
          pkg:=NEW(ObTree.IdeName, text:=&quot;array&quot;, variant:=0),
          op:=NEW(ObTree.IdeName, text:=&quot;get&quot;, variant:=0),
          args:=NEW(ObTree.TermList, location:=loc,
            first:=p.stack[base+1],
            rest:=NEW(ObTree.TermList, location:=loc,
              first:=p.stack[base+2],
              rest:=NIL)),
	(* the rest is setup in Scope.Term *)
	package:=NIL, opCode:=NIL);
    END BuildTermArrayGet;

 PROCEDURE <A NAME="BuildTermArraySub"><procedure>BuildTermArraySub</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    VAR loc: SynLocation.T;
    BEGIN
      loc := SynLocation.NewLineLocation(info);
      RETURN
        NEW(ObTree.TermOp,  location:=loc,
          pkg:=NEW(ObTree.IdeName, text:=&quot;array&quot;, variant:=0),
          op:=NEW(ObTree.IdeName, text:=&quot;sub&quot;, variant:=0),
          args:=NEW(ObTree.TermList, location:=loc,
            first:=p.stack[base+1],
            rest:=NEW(ObTree.TermList, location:=loc,
              first:=p.stack[base+2],
              rest:=NEW(ObTree.TermList, location:=loc,
                first:=p.stack[base+3],
                rest:=NIL))),
	(* the rest is setup in Scope.Term *)
	package:=NIL, opCode:=NIL);
    END BuildTermArraySub;

 PROCEDURE <A NAME="BuildTermArraySet"><procedure>BuildTermArraySet</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    VAR loc: SynLocation.T;
    BEGIN
      loc := SynLocation.NewLineLocation(info);
      RETURN
        NEW(ObTree.TermOp,  location:=loc,
          pkg:=NEW(ObTree.IdeName, text:=&quot;array&quot;, variant:=0),
          op:=NEW(ObTree.IdeName, text:=&quot;set&quot;, variant:=0),
          args:=NEW(ObTree.TermList, location:=loc,
            first:=p.stack[base+1],
            rest:=NEW(ObTree.TermList, location:=loc,
              first:=p.stack[base+2],
              rest:=NEW(ObTree.TermList, location:=loc,
                first:=p.stack[base+3],
                rest:=NIL))),
	(* the rest is setup in Scope.Term *)
	package:=NIL, opCode:=NIL);
    END BuildTermArraySet;

 PROCEDURE <A NAME="BuildTermArrayUpd"><procedure>BuildTermArrayUpd</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    VAR loc: SynLocation.T;
    BEGIN
      loc := SynLocation.NewLineLocation(info);
      RETURN
        NEW(ObTree.TermOp,  location:=loc,
          pkg:=NEW(ObTree.IdeName, text:=&quot;array&quot;, variant:=0),
          op:=NEW(ObTree.IdeName, text:=&quot;upd&quot;, variant:=0),
          args:=NEW(ObTree.TermList, location:=loc,
            first:=p.stack[base+1],
            rest:=NEW(ObTree.TermList, location:=loc,
              first:=p.stack[base+2],
              rest:=NEW(ObTree.TermList, location:=loc,
                first:=p.stack[base+3],
                rest:=NEW(ObTree.TermList, location:=loc,
                  first:=p.stack[base+4],
                rest:=NIL)))),
	(* the rest is setup in Scope.Term *)
	package:=NIL, opCode:=NIL);
    END BuildTermArrayUpd;

  PROCEDURE <A NAME="BuildTermMinus"><procedure>BuildTermMinus</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    VAR loc: SynLocation.T;
    BEGIN
      loc := SynLocation.NewLineLocation(info);
      RETURN
        NEW(ObTree.TermOp,  location:=loc,
          pkg:=NEW(ObTree.IdeName, text:=&quot;real&quot;, variant:=0),
          op:=NEW(ObTree.IdeName, text:=&quot;minus&quot;, variant:=0),
          args:=NEW(ObTree.TermList, location:=loc,
            first:=p.stack[base+1],
            rest:=NIL),
	(* the rest is setup in Scope.Term *)
	package:=NIL, opCode:=NIL);
    END BuildTermMinus;

 PROCEDURE <A NAME="BuildTermLet"><procedure>BuildTermLet</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermLet,location:=SynLocation.NewLineLocation(info),
	  var:=FALSE, rec:=FALSE,
	  binding:=p.stack[base+1]);
    END BuildTermLet;

 PROCEDURE <A NAME="BuildTermVar"><procedure>BuildTermVar</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermLet,location:=SynLocation.NewLineLocation(info),
	  var:=TRUE, rec:=FALSE,
	  binding:=p.stack[base+1]);
    END BuildTermVar;

 PROCEDURE <A NAME="BuildTermLetRec"><procedure>BuildTermLetRec</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermLet,location:=SynLocation.NewLineLocation(info),
	  var:=FALSE, rec:=TRUE,
	  binding:=p.stack[base+1]);
    END BuildTermLetRec;

 PROCEDURE <A NAME="BuildTermVarRec"><procedure>BuildTermVarRec</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermLet,location:=SynLocation.NewLineLocation(info),
	  var:=TRUE, rec:=TRUE,
	  binding:=p.stack[base+1]);
    END BuildTermVarRec;

 PROCEDURE <A NAME="BuildTermAssign"><procedure>BuildTermAssign</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree RAISES {SynParse.Fail}  =
    VAR name: ObTree.IdeName;
    BEGIN
      TYPECASE p.stack[base+1] OF
      | ObTree.TermIde(node) =&gt; name:=node.name;
      ELSE
        SynScan.SyntaxMsg(p.Scanner(), &quot;Identifier expected before ':='&quot;,&quot;&quot;);
        RAISE SynParse.Fail;
      END;
      RETURN
        NEW(ObTree.TermAssign,location:=SynLocation.NewLineLocation(info),
	  name:=name, place:=NIL, val:=p.stack[base+2]);
    END BuildTermAssign;

  PROCEDURE <A NAME="BuildTermIf"><procedure>BuildTermIf</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermIf,location:=SynLocation.NewLineLocation(info),
	  test:=p.stack[base+1],
	  ifTrue:=p.stack[base+2],
	  ifFalse:=p.stack[base+3]);
    END BuildTermIf;

  PROCEDURE <A NAME="BuildTermIfEnd"><procedure>BuildTermIfEnd</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NIL;
    END BuildTermIfEnd;

  PROCEDURE <A NAME="BuildTermAndif"><procedure>BuildTermAndif</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermIf,location:=SynLocation.NewLineLocation(info),
	  test:=p.stack[base+1],
	  ifTrue:=p.stack[base+2],
	  ifFalse:=
              NEW(ObTree.TermBool, location:=SynLocation.NewLineLocation(info),
                  bool:=FALSE));
    END BuildTermAndif;

  PROCEDURE <A NAME="BuildTermOrif"><procedure>BuildTermOrif</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermIf,location:=SynLocation.NewLineLocation(info),
	  test:=p.stack[base+1],
	  ifTrue:=
              NEW(ObTree.TermBool, location:=SynLocation.NewLineLocation(info),
                  bool:=TRUE),
	  ifFalse:=p.stack[base+2]);
    END BuildTermOrif;

  PROCEDURE <A NAME="BuildTermCase"><procedure>BuildTermCase</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermCase, location:=SynLocation.NewLineLocation(info),
	  option:=p.stack[base+1],
	  caseList:=p.stack[base+2]);
    END BuildTermCase;

 PROCEDURE <A NAME="BuildTermLoop"><procedure>BuildTermLoop</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermLoop,location:=SynLocation.NewLineLocation(info),
	  loop:=p.stack[base+1]);
    END BuildTermLoop;

 PROCEDURE <A NAME="BuildTermExit"><procedure>BuildTermExit</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermExit,location:=SynLocation.NewLineLocation(info));
    END BuildTermExit;

  PROCEDURE <A NAME="BuildTermFor"><procedure>BuildTermFor</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermFor, location:=SynLocation.NewLineLocation(info),
          binder := BuildIdeName(p, base+1), lb := p.stack[base+2],
          ub := p.stack[base+3], body := p.stack[base+4]);
    END BuildTermFor;

  PROCEDURE <A NAME="BuildTermForeachDo"><procedure>BuildTermForeachDo</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermForeach, location:=SynLocation.NewLineLocation(info),
          binder := BuildIdeName(p, base+1), range := p.stack[base+2],
          body := p.stack[base+3], map:=FALSE);
    END BuildTermForeachDo;

  PROCEDURE <A NAME="BuildTermForeachMap"><procedure>BuildTermForeachMap</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermForeach, location:=SynLocation.NewLineLocation(info),
          binder := BuildIdeName(p, base+1), range := p.stack[base+2],
          body := p.stack[base+3], map:=TRUE);
    END BuildTermForeachMap;

 PROCEDURE <A NAME="BuildTermException"><procedure>BuildTermException</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermException,location:=SynLocation.NewLineLocation(info),
            name:=p.stack[base+1]);
    END BuildTermException;

 PROCEDURE <A NAME="BuildTermRaise"><procedure>BuildTermRaise</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermRaise,location:=SynLocation.NewLineLocation(info),
          exception:=p.stack[base+1]);
    END BuildTermRaise;

 PROCEDURE <A NAME="BuildTermTry"><procedure>BuildTermTry</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermTry,location:=SynLocation.NewLineLocation(info),
          body:=p.stack[base+1],
          tryList:=p.stack[base+2]);
    END BuildTermTry;

 PROCEDURE <A NAME="BuildTermTryElse"><procedure>BuildTermTryElse</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermTry,location:=SynLocation.NewLineLocation(info),
          body:=p.stack[base+1],
          tryList:=
            NEW(ObTree.TermTryList,location:=SynLocation.NewLineLocation(info),
              exception:=NIL,
              recover:=p.stack[base+2],
              rest:=NIL));
    END BuildTermTryElse;

 PROCEDURE <A NAME="BuildTermTryFinally"><procedure>BuildTermTryFinally</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermTryFinally,location:=SynLocation.NewLineLocation(info),
          body:=p.stack[base+1],
          finally:=p.stack[base+2]);
    END BuildTermTryFinally;

 PROCEDURE <A NAME="BuildCaseListCons"><procedure>BuildCaseListCons</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    VAR bind: ObTree.IdeName;
    BEGIN
      IF p.stack[base+2] = NIL THEN bind := NIL;
      ELSE bind := BuildIdeName(p, base+2);
      END;
      RETURN
        NEW(ObTree.TermCaseList, location:=SynLocation.NewLineLocation(info),
          tag:=BuildIdeName(p, base+1),
          binder:=bind,
          body:=p.stack[base+3],
          rest:=p.stack[base+4]);
    END BuildCaseListCons;

 PROCEDURE <A NAME="BuildCaseListElse"><procedure>BuildCaseListElse</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermCaseList, location:=SynLocation.NewLineLocation(info),
          tag:=NIL, binder:=NIL, body:=p.stack[base+1], rest:=NIL);
    END BuildCaseListElse;

 PROCEDURE <A NAME="BuildCaseListNil"><procedure>BuildCaseListNil</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NIL;
    END BuildCaseListNil;

 PROCEDURE <A NAME="BuildTryListCons"><procedure>BuildTryListCons</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermTryList,location:=SynLocation.NewLineLocation(info),
          exception:=p.stack[base+1],
          recover:=p.stack[base+2],
          rest:=p.stack[base+3]);
    END BuildTryListCons;

 PROCEDURE <A NAME="BuildTryListConsElse"><procedure>BuildTryListConsElse</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermTryList,location:=SynLocation.NewLineLocation(info),
          exception:=p.stack[base+1],
          recover:=p.stack[base+2],
          rest:=
            NEW(ObTree.TermTryList,location:=SynLocation.NewLineLocation(info),
                exception:=NIL,
                recover:=p.stack[base+3],
                rest:=NIL));
    END BuildTryListConsElse;

 PROCEDURE <A NAME="BuildTryListSingle"><procedure>BuildTryListSingle</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermTryList,location:=SynLocation.NewLineLocation(info),
          exception:=p.stack[base+1],
          recover:=p.stack[base+2],
          rest:=NIL);
    END BuildTryListSingle;

 PROCEDURE <A NAME="BuildTryListElse"><procedure>BuildTryListElse</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermTryList,location:=SynLocation.NewLineLocation(info),
          exception:=NIL,
          recover:=p.stack[base+1],
          rest:=NIL);
    END BuildTryListElse;

 PROCEDURE <A NAME="BuildTryListNil"><procedure>BuildTryListNil</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN NIL;
    END BuildTryListNil;

  PROCEDURE <A NAME="BuildTermLock"><procedure>BuildTermLock</procedure></A>(self: SynParse.Action; p: SynParse.T; base: INTEGER;
      READONLY info: SynLocation.Info): SynParse.Tree  =
    VAR loc: SynLocation.T;
    BEGIN
      loc := SynLocation.NewLineLocation(info);
      RETURN
        NEW(ObTree.TermOp,  location:=loc,
          pkg:=NEW(ObTree.IdeName, text:=&quot;thread&quot;, variant:=0),
          op:=NEW(ObTree.IdeName, text:=&quot;lock&quot;, variant:=0),
          args:=NEW(ObTree.TermList, location:=loc,
            first:=p.stack[base+1],
            rest:=NEW(ObTree.TermList, location:=loc,
              first:=
                NEW(ObTree.TermFun,location:=loc,
	          binders:=NIL, bindersNo:=-1,
	          body:=p.stack[base+2],
	          globals:=NIL, globalsNo:=-1),
              rest:=NIL)),
	  (* the rest is setup in Scope.Term *)
	  package:=NIL, opCode:=NIL);
      END BuildTermLock;

  PROCEDURE <A NAME="BuildTermWatch"><procedure>BuildTermWatch</procedure></A>(self: SynParse.Action; p: SynParse.T;
      base: INTEGER; READONLY info: SynLocation.Info): SynParse.Tree  =
    BEGIN
      RETURN
        NEW(ObTree.TermWatch,location:=SynLocation.NewLineLocation(info),
          condition:=p.stack[base+1],
          guard:=p.stack[base+2]);
      END BuildTermWatch;

  PROCEDURE <A NAME="RegisterActions"><procedure>RegisterActions</procedure></A>(actions: MetaParser.ActionTable)
    RAISES {SynParse.Fail} =
  BEGIN
    MetaParser.Register(&quot;Select1&quot;, Select1, actions);
    MetaParser.Register(&quot;Select2&quot;, Select2, actions);
    MetaParser.Register(&quot;Select3&quot;, Select3, actions);
    MetaParser.Register(&quot;Select4&quot;, Select4, actions);
    MetaParser.Register(&quot;Select5&quot;, Select5, actions);
    MetaParser.Register(&quot;Select6&quot;, Select6, actions);
    MetaParser.Register(&quot;BuildPhraseEmpty&quot;, BuildPhraseEmpty, actions);
    MetaParser.Register(&quot;BuildPhraseFlag&quot;, BuildPhraseFlag, actions);
    MetaParser.Register(&quot;BuildPhraseHelp&quot;, BuildPhraseHelp, actions);
    MetaParser.Register(&quot;BuildPhraseTerm&quot;, BuildPhraseTerm, actions);
    MetaParser.Register(&quot;BuildPhraseTermDepth&quot;, BuildPhraseTermDepth, actions);
    MetaParser.Register(&quot;BuildPhraseTermDeep&quot;, BuildPhraseTermDeep, actions);
    MetaParser.Register(&quot;BuildTermBinding&quot;, BuildTermBinding, actions);
    MetaParser.Register(&quot;BuildTermBindingSingle&quot;, BuildTermBindingSingle, actions);
    MetaParser.Register(&quot;BuildTermBindingNil&quot;, BuildTermBindingNil, actions);
    MetaParser.Register(&quot;BuildTermIde&quot;, BuildTermIde, actions);
    MetaParser.Register(&quot;BuildTermOk&quot;, BuildTermOk, actions);
    MetaParser.Register(&quot;BuildTermBoolTrue&quot;, BuildTermBoolTrue, actions);
    MetaParser.Register(&quot;BuildTermBoolFalse&quot;, BuildTermBoolFalse, actions);
    MetaParser.Register(&quot;BuildTermChar&quot;, BuildTermChar, actions);
    MetaParser.Register(&quot;BuildTermString&quot;, BuildTermText, actions);
    MetaParser.Register(&quot;BuildTermInt&quot;, BuildTermInt, actions);
    MetaParser.Register(&quot;BuildTermReal&quot;, BuildTermReal, actions);
    MetaParser.Register(&quot;BuildTermArray&quot;, BuildTermArray, actions);
    MetaParser.Register(&quot;BuildTermOption&quot;, BuildTermOption, actions);
    MetaParser.Register(&quot;BuildTermAlias&quot;, BuildTermAlias, actions);
    MetaParser.Register(&quot;BuildTermOp&quot;, BuildTermOp, actions);
    MetaParser.Register(&quot;BuildTermOpConst&quot;, BuildTermOpConst, actions);
    MetaParser.Register(&quot;BuildTermAppl&quot;, BuildTermAppl, actions);
    MetaParser.Register(&quot;BuildTermInfix&quot;, BuildTermInfix, actions);
    MetaParser.Register(&quot;BuildTermSeq&quot;, BuildTermSeq, actions);
    MetaParser.Register(&quot;BuildTermLet&quot;, BuildTermLet, actions);
    MetaParser.Register(&quot;BuildTermVar&quot;, BuildTermVar, actions);
    MetaParser.Register(&quot;BuildTermLetRec&quot;, BuildTermLetRec, actions);
    MetaParser.Register(&quot;BuildTermVarRec&quot;, BuildTermVarRec, actions);
    MetaParser.Register(&quot;BuildTermAssign&quot;, BuildTermAssign, actions);
    MetaParser.Register(&quot;BuildTermIf&quot;, BuildTermIf, actions);
    MetaParser.Register(&quot;BuildTermIfEnd&quot;, BuildTermIfEnd, actions);
    MetaParser.Register(&quot;BuildTermAndif&quot;, BuildTermAndif, actions);
    MetaParser.Register(&quot;BuildTermOrif&quot;, BuildTermOrif, actions);
    MetaParser.Register(&quot;BuildTermCase&quot;, BuildTermCase, actions);
    MetaParser.Register(&quot;BuildTermUpdate&quot;, BuildTermUpdate, actions);
    MetaParser.Register(&quot;BuildTermSelect&quot;, BuildTermSelect, actions);
    MetaParser.Register(&quot;BuildTermInvoke&quot;, BuildTermInvoke, actions);
    MetaParser.Register(&quot;BuildTermArrayGet&quot;, BuildTermArrayGet, actions);
    MetaParser.Register(&quot;BuildTermArraySet&quot;, BuildTermArraySet, actions);
    MetaParser.Register(&quot;BuildTermArraySub&quot;, BuildTermArraySub, actions);
    MetaParser.Register(&quot;BuildTermArrayUpd&quot;, BuildTermArrayUpd, actions);
    MetaParser.Register(&quot;BuildTermMinus&quot;, BuildTermMinus, actions);
    MetaParser.Register(&quot;BuildTermObj&quot;, BuildTermObj, actions);
    MetaParser.Register(&quot;BuildOptionYes&quot;, BuildOptionYes, actions);
    MetaParser.Register(&quot;BuildOptionNo&quot;, BuildOptionNo, actions);
    MetaParser.Register(&quot;BuildTermObjField&quot;, BuildTermObjField, actions);
    MetaParser.Register(&quot;BuildTermObjFieldSingle&quot;, BuildTermObjFieldSingle, actions);
    MetaParser.Register(&quot;BuildTermObjFieldNil&quot;, BuildTermObjFieldNil, actions);
    MetaParser.Register(&quot;BuildTermClone&quot;, BuildTermClone, actions);
    MetaParser.Register(&quot;BuildTermRedirect&quot;, BuildTermRedirect, actions);
    MetaParser.Register(&quot;BuildTermProc&quot;, BuildTermProc, actions);
    MetaParser.Register(&quot;BuildTermMeth&quot;, BuildTermMeth, actions);
    MetaParser.Register(&quot;BuildTermLoop&quot;, BuildTermLoop, actions);
    MetaParser.Register(&quot;BuildTermExit&quot;, BuildTermExit, actions);
    MetaParser.Register(&quot;BuildTermFor&quot;, BuildTermFor, actions);
    MetaParser.Register(&quot;BuildTermForeachDo&quot;, BuildTermForeachDo, actions);
    MetaParser.Register(&quot;BuildTermForeachMap&quot;, BuildTermForeachMap, actions);
    MetaParser.Register(&quot;BuildTermException&quot;, BuildTermException, actions);
    MetaParser.Register(&quot;BuildTermRaise&quot;, BuildTermRaise, actions);
    MetaParser.Register(&quot;BuildTermTry&quot;, BuildTermTry, actions);
    MetaParser.Register(&quot;BuildTermTryElse&quot;, BuildTermTryElse, actions);
    MetaParser.Register(&quot;BuildTermTryFinally&quot;, BuildTermTryFinally, actions);
    MetaParser.Register(&quot;BuildTermLock&quot;, BuildTermLock, actions);
    MetaParser.Register(&quot;BuildTermWatch&quot;, BuildTermWatch, actions);
    MetaParser.Register(&quot;BuildCaseListCons&quot;, BuildCaseListCons, actions);
    MetaParser.Register(&quot;BuildCaseListElse&quot;, BuildCaseListElse, actions);
    MetaParser.Register(&quot;BuildCaseListNil&quot;, BuildCaseListNil, actions);
    MetaParser.Register(&quot;BuildTryListCons&quot;, BuildTryListCons, actions);
    MetaParser.Register(&quot;BuildTryListConsElse&quot;, BuildTryListConsElse, actions);
    MetaParser.Register(&quot;BuildTryListSingle&quot;, BuildTryListSingle, actions);
    MetaParser.Register(&quot;BuildTryListElse&quot;, BuildTryListElse, actions);
    MetaParser.Register(&quot;BuildTryListNil&quot;, BuildTryListNil, actions);
    MetaParser.Register(&quot;BuildIdeListNil&quot;, BuildIdeListNil, actions);
    MetaParser.Register(&quot;BuildIdeListSingle&quot;, BuildIdeListSingle, actions);
    MetaParser.Register(&quot;BuildIdeListCons&quot;, BuildIdeListCons, actions);
    MetaParser.Register(&quot;BuildTermListNil&quot;, BuildTermListNil, actions);
    MetaParser.Register(&quot;BuildTermListSingle&quot;, BuildTermListSingle, actions);
    MetaParser.Register(&quot;BuildTermListCons&quot;, BuildTermListCons, actions);
  END RegisterActions;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>()  =
  BEGIN
  END Setup;

BEGIN
END ObParseTree.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
