<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqparse/src/ObliqParser.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqparse/src/ObliqParser.m3</H2></A><HR>
<inModule>
<PRE>
<A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObliqParser.i3">ObliqParser</A></implements></module>;
IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../bundleintf/src/Bundle.i3">Bundle</A>, <A HREF="../derived/ObliqBdl.i3">ObliqBdl</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synex/src/SynScan.i3">SynScan</A>, <A HREF="../../synex/src/SynParse.i3">SynParse</A>, <A HREF="../../metasyn/src/MetaParser.i3">MetaParser</A>, <A HREF="ObParseFrame.i3">ObParseFrame</A>, <A HREF="../../obliqrt/src/ObTree.i3">ObTree</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="ObParseTree.i3">ObParseTree</A>, <A HREF="ObFrame.i3">ObFrame</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../obliqrt/src/ObErr.i3">ObErr</A>, <A HREF="../../os/src/Common/Process.i3">Process</A>;
FROM <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A> IMPORT Error, Exception;

  VAR metaParserMutex: Thread.Mutex;
      obliqClauseList: MetaParser.ClauseList;

  VAR setupDone := FALSE;

  PROCEDURE <A NAME="PackageSetup"><procedure>PackageSetup</procedure></A>() =
  BEGIN
    SynParse.PackageSetup();
    MetaParser.PackageSetup(); &lt;* NOWARN *&gt;
    Obliq.PackageSetup();

    IF NOT setupDone THEN
      setupDone := TRUE;
      ObFrame.Setup();
      ObParseTree.Setup();
      ObParseFrame.Setup();
      metaParserMutex := NEW(Thread.Mutex);
      obliqClauseList := NIL;
    END;
  END PackageSetup;

  PROCEDURE <A NAME="New"><procedure>New</procedure></A>(swr: SynWr.T): SynParse.T =
  VAR parser: SynParse.T; actions: MetaParser.ActionTable;
  BEGIN
    LOCK metaParserMutex DO
      IF obliqClauseList = NIL THEN
        actions := MetaParser.NewActionTable();
        ObParseFrame.RegisterActions(actions);
        ObParseTree.RegisterActions(actions); &lt;* NOWARN *&gt;
        obliqClauseList := MetaParser.NewClauseList(actions, &quot;obliq.gr&quot;,
          TextRd.New(Bundle.Get(ObliqBdl.Get(), &quot;ObliqGram&quot;)));
      END;
      parser := SynParse.New(swr, SynParse.NewEnv());
      MetaParser.AddClauseList(obliqClauseList, parser);
    END;
    SynScan.SetPrompt(parser.Scanner(), &quot;- &quot;, &quot;  &quot;);
    RETURN parser;
  END New;

  PROCEDURE <A NAME="ReadFrom"><procedure>ReadFrom</procedure></A>(p: T; rdName: TEXT; rd: Rd.T; closeRd: BOOLEAN;
    generateEOF: BOOLEAN := TRUE) =
  BEGIN
    SynScan.PushInput(p.Scanner(), rdName, rd, closeRd, generateEOF);
  END ReadFrom;

  PROCEDURE <A NAME="ParseTerm"><procedure>ParseTerm</procedure></A>(p: SynParse.T): Obliq.Term RAISES {Error, Eof} =
  BEGIN
      TRY
        TYPECASE p.ReadNonTerminal(&quot;phrase&quot;) OF
        | ObTree.PhraseTerm(node) =&gt;
          RETURN node.term;
        ELSE
          SynParse.Fault(p,
            &quot;ObliqParser.ParseTerm: parsed a phrase that is not a term&quot;);
        END;
      EXCEPT
      | SynScan.NoReader =&gt;
          RAISE Eof;
      | SynParse.Fail, SynScan.Fail =&gt;
          Obliq.RaiseError(&quot;Static Error&quot;);
      END;
  END ParseTerm;

  PROCEDURE <A NAME="ParsePhrase"><procedure>ParsePhrase</procedure></A>(p: SynParse.T): Obliq.Phrase RAISES {Error, Eof} =
  BEGIN
      TRY
        RETURN p.ReadNonTerminal(&quot;phrase&quot;);
      EXCEPT
      | SynScan.NoReader =&gt;
          RAISE Eof;
      | SynParse.Fail, SynScan.Fail =&gt;
          Obliq.RaiseError(&quot;Static Error&quot;);
      END;
  END ParsePhrase;

  PROCEDURE <A NAME="EvalPhrase"><procedure>EvalPhrase</procedure></A>(p: SynParse.T; phrase: Phrase; VAR (*in-out*) env: Env;
    loc: Location:=NIL): Obliq.Val(*or NIL*) RAISES {Error, Exception} =
  VAR val: ObValue.Val;
  BEGIN
    IF loc=NIL THEN loc:=SourceLocation(&quot;Obliq.EvalPhrase&quot;) END;
    val := NIL;
    TRY
      TYPECASE phrase OF
      | NULL =&gt;
      | ObFrame.Quit =&gt; Process.Exit();
      | ObFrame.Load(node) =&gt;
	    ObFrame.LoadFile(p.Scanner(), node.name);
      | ObFrame.Import(node) =&gt;
	    ObFrame.ImportFrame(p.Scanner(), node.name, env);
      | ObFrame.Module(node) =&gt;
	    ObFrame.ModuleFrame(p.Scanner(), node.name, node.for,
	      node.imports, env);
      | ObFrame.EndModule =&gt;
	    ObFrame.ModuleEnd(p.Scanner());
      | ObFrame.Establish(node) =&gt;
	    env := ObFrame.EstablishFrame(node.name, node.for, env);
      | ObFrame.Save(node) =&gt;
	    env := ObFrame.SaveFrame(node.name, node.name, env);
      | ObFrame.Delete(node) =&gt;
	    env := ObFrame.DeleteFrame(node.name, env);
      | ObFrame.Qualify =&gt;
	    env := ObFrame.QualifyFrame(env);
      | ObTree.PhraseCommand,
        ObTree.PhraseTerm =&gt;
          val := Obliq.EvalPhrase(phrase, (*in-out*) env, loc);
      END;
      RETURN val;
    EXCEPT
    | ObErr.Fail =&gt;
        Obliq.RaiseError(&quot;Static Error&quot;, loc);
    END;
  END EvalPhrase;

  PROCEDURE <A NAME="SourceLocation"><procedure>SourceLocation</procedure></A>(where: TEXT): SynLocation.T =
  BEGIN
    RETURN
      SynLocation.NewLineLocation(
        SynLocation.Info{fileName:=where, line:=0, lineChar:=0, char:=0});
  END SourceLocation;

BEGIN
END ObliqParser.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
