<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqprint/src/ObPrintTree.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqprint/src/ObPrintTree.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObPrintTree.i3">ObPrintTree</A></implements></module>;
IMPORT <A HREF="../../text/src/TextConv.i3">TextConv</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../obliqrt/src/ObTree.i3">ObTree</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>;

  VAR
    printAlphaDecor: BOOLEAN;
    printVarIndex: BOOLEAN;
    printVariant: BOOLEAN;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>()  =
  BEGIN

    printVarIndex := FALSE;
    ObCommand.Register(ObTree.doCommandSet,
      NEW(ObCommand.T, name:=&quot;ShowVarIndex&quot;, sortingName:=&quot;ShowVarIndex&quot;,
	Exec:=PrintVarIndex));

    printAlphaDecor := FALSE;
    ObCommand.Register(ObTree.doCommandSet,
      NEW(ObCommand.T, name:=&quot;ShowVarAlphaDecor&quot;, sortingName:=&quot;ShowAlphaDecor&quot;,
	Exec:=PrintAlphaDecor));

    printVariant := FALSE;
    ObCommand.Register(ObTree.doCommandSet,
      NEW(ObCommand.T, name:=&quot;ShowVarVariant&quot;, sortingName:=&quot;ShowVarVariant&quot;,
	Exec:=PrintVariant));

  END Setup;

  PROCEDURE <A NAME="FetchDecoration"><procedure>FetchDecoration</procedure></A>(name: ObTree.IdeName; env: ObTree.Env): INTEGER  =
  BEGIN
    LOOP
      IF env=NIL THEN RETURN -1 END;
      IF ObTree.SameIdeName(env.name, name) THEN RETURN env.decoration END;
      env := env.rest;
    END;
  END FetchDecoration;

  PROCEDURE <A NAME="PrintDecoration"><procedure>PrintDecoration</procedure></A>(swr: SynWr.T; decoration: INTEGER)  =
  BEGIN
    SynWr.Text(swr, FmtDecoration(decoration));
  END PrintDecoration;

  PROCEDURE <A NAME="PrintIdeName"><procedure>PrintIdeName</procedure></A>(swr: SynWr.T; name: ObTree.IdeName; env: ObTree.Env)  =
  BEGIN
    SynWr.Beg(swr);
    SynWr.Text(swr, name.text);
    IF printAlphaDecor THEN
      PrintDecoration(swr, FetchDecoration(name, env));
    END;
    IF printVariant THEN
      IF name.variant#0 THEN
	SynWr.Text(swr, &quot;%&quot; &amp; Fmt.Int(name.variant));
      END;
    END;
    SynWr.End(swr);
  END PrintIdeName;

  PROCEDURE <A NAME="PrintIdePlace"><procedure>PrintIdePlace</procedure></A>(swr: SynWr.T; place: ObTree.IdePlace)  =
  BEGIN
    SynWr.Beg(swr);
    TYPECASE place OF
    | ObTree.IdePlaceLocal(node) =&gt;
        SynWr.Text(swr, &quot;L&quot; &amp; Fmt.Int(node.index));
    | ObTree.IdePlaceGlobal(node) =&gt;
        SynWr.Text(swr, &quot;G&quot; &amp; Fmt.Int(node.index));
    END;
    SynWr.End(swr);
  END PrintIdePlace;

  PROCEDURE <A NAME="PrintIde"><procedure>PrintIde</procedure></A>(swr: SynWr.T; name: ObTree.IdeName; place: ObTree.IdePlace;
    env: ObTree.Env)  =
  BEGIN
    SynWr.Beg(swr);
    PrintIdeName(swr, name, env);
    IF printVarIndex THEN
      SynWr.Char(swr, '_');
      PrintIdePlace(swr, place);
    END;
    SynWr.End(swr);
  END PrintIde;

  PROCEDURE <A NAME="PrintIdeList"><procedure>PrintIdeList</procedure></A>(swr: SynWr.T; list: ObTree.IdeList; env: ObTree.Env): ObTree.Env =
  VAR sep: TEXT;
  BEGIN
    sep := &quot;&quot;;
    LOOP
      TYPECASE list OF
      | NULL =&gt; EXIT;
      | ObTree.IdeList(node) =&gt;
          env := ObTree.NewEnv(node.first, env);
	  SynWr.Text(swr, sep); sep := &quot;,&quot;;
          SynWr.FlatBreak(swr);
	  SynWr.Beg(swr, 2);
	    PrintIdeName(swr, node.first, env);
	  SynWr.End(swr);
          list := node.rest;
      END;
    END;
    RETURN env;
  END PrintIdeList;

  PROCEDURE <A NAME="FmtDecoration"><procedure>FmtDecoration</procedure></A>(decoration: INTEGER): TEXT  =
  VAR res: TEXT;
  BEGIN
    IF decoration&lt;=0 THEN RETURN &quot;&quot; END;
    res := &quot;&quot;;
    LOOP
      CASE decoration MOD 4 OF
      | 1 =&gt; res := &quot;\'&quot; &amp; res;
      | 2 =&gt; res := &quot;\&quot;&quot; &amp; res;
      | 3 =&gt; res := &quot;^&quot; &amp; res;
      | 0 =&gt; res := &quot;~&quot; &amp; res;
      END;
      decoration := (decoration-1) DIV 4;
      IF decoration = 0 THEN EXIT END;
    END;
    RETURN res;
  END FmtDecoration;

  PROCEDURE <A NAME="FmtIdeName"><procedure>FmtIdeName</procedure></A>(name: ObTree.IdeName; env: ObTree.Env): TEXT  =
  VAR text: TEXT;
  BEGIN
    text := name.text;
    IF printAlphaDecor THEN
      text:=text &amp; FmtDecoration(ObTree.FreshDecoration(name, env));
    END;
    IF printVariant THEN
      IF name.variant&gt;0 THEN
	text:=text &amp; &quot;%&quot;;
	text := text &amp; Fmt.Int(name.variant);
      END;
    END;
    RETURN text;
  END FmtIdeName;

  PROCEDURE <A NAME="FmtIdePlace"><procedure>FmtIdePlace</procedure></A>(place: ObTree.IdePlace): TEXT  =
  BEGIN
    TYPECASE place OF
    | ObTree.IdePlaceLocal(node) =&gt;
        RETURN &quot;L&quot; &amp; Fmt.Int(node.index);
    | ObTree.IdePlaceGlobal(node) =&gt;
         RETURN &quot;L&quot; &amp; Fmt.Int(node.index);
    END;
  END FmtIdePlace;

  PROCEDURE <A NAME="FmtIde"><procedure>FmtIde</procedure></A>(name: ObTree.IdeName; place: ObTree.IdePlace; env: ObTree.Env): TEXT  =
  VAR text: TEXT;
  BEGIN
    text := FmtIdeName(name, env);
    IF printVarIndex THEN
      text := text &amp; &quot;_&quot; &amp; FmtIdePlace(place);
    END;
    RETURN text;
  END FmtIde;

  PROCEDURE <A NAME="PrintTermBinding"><procedure>PrintTermBinding</procedure></A>(swr: SynWr.T; rec: BOOLEAN; binding: ObTree.TermBinding;
    libEnv: ObLib.Env; env: ObTree.Env; depth: INTEGER)  =
  (* -- The env stuff is correct for sequential bindings, not for recursive
     ones *)
  VAR newEnv: ObTree.Env; sep: TEXT;
  BEGIN
    sep := &quot;&quot;;
    newEnv := env;
    LOOP
      TYPECASE binding OF
      | NULL =&gt; EXIT;
      | ObTree.TermBinding(node) =&gt;
	  SynWr.Text(swr, sep); sep := &quot;, &quot;;
          SynWr.Break(swr);
	  SynWr.Beg(swr, 2);
	    SynWr.Beg(swr, 4);
	      newEnv := ObTree.NewEnv(node.binder, newEnv);
	      PrintIdeName(swr, node.binder, newEnv);
	      SynWr.Text(swr, &quot; = &quot;);
	    SynWr.End(swr);
	  SynWr.Break(swr);
	    PrintTerm(swr, node.term, libEnv, env, depth-1);
	  SynWr.End(swr);
          binding := node.rest;
      END;
    END;
  END PrintTermBinding;

  PROCEDURE <A NAME="PrintProtected"><procedure>PrintProtected</procedure></A>(swr: SynWr.T; protected: BOOLEAN) =
  BEGIN
    IF protected THEN
      SynWr.Break(swr);
      SynWr.Beg(swr, 2);
      SynWr.Text(swr, &quot;protected, &quot;);
      SynWr.End(swr);
    END;
  END PrintProtected;

  PROCEDURE <A NAME="PrintSerialized"><procedure>PrintSerialized</procedure></A>(swr: SynWr.T; sync: ObTree.Sync) =
  BEGIN
    CASE sync OF
    | ObTree.Sync.Monitored =&gt;
      SynWr.Break(swr);
      SynWr.Beg(swr, 2);
      SynWr.Text(swr, &quot;serialized, &quot;);
      SynWr.End(swr);
    ELSE
    END;
  END PrintSerialized;

  PROCEDURE <A NAME="PrintObjFields"><procedure>PrintObjFields</procedure></A>(swr: SynWr.T; fields: ObTree.TermObjFields; libEnv: ObLib.Env; env: ObTree.Env;
    depth: INTEGER)  =
  VAR sep: TEXT;
  BEGIN
    sep := &quot;&quot;;
    LOOP
      TYPECASE fields OF
      | NULL =&gt; EXIT;
      | ObTree.TermObjFields(node) =&gt;
	  SynWr.Text(swr, sep); sep := &quot;, &quot;;
          SynWr.Break(swr);
	  SynWr.Beg(swr, 2);
	    SynWr.Beg(swr, 4);
	      PrintIdeName(swr, node.label, env);
	      SynWr.Text(swr, &quot; =&gt; &quot;);
	    SynWr.End(swr);
	  SynWr.Break(swr);
	    PrintTerm(swr, node.term, libEnv, env, depth-1);
	  SynWr.End(swr);
	  fields := node.rest;
      END;
    END;
  END PrintObjFields;

  PROCEDURE <A NAME="PrintTermList"><procedure>PrintTermList</procedure></A>(swr: SynWr.T; list: ObTree.TermList; libEnv: ObLib.Env; env: ObTree.Env;
    depth: INTEGER)  =
  VAR sep: TEXT;
  BEGIN
    sep := &quot;&quot;;
    LOOP
      TYPECASE list OF
      | NULL =&gt; EXIT;
      | ObTree.TermList(node) =&gt;
	  SynWr.Text(swr, sep); sep := &quot;, &quot;;
          SynWr.Break(swr);
	  SynWr.Beg(swr, 2);
	    PrintTerm(swr, node.first, libEnv, env, depth-1);
	  SynWr.End(swr);
	  list := node.rest;
      END;
    END
  END PrintTermList;

  PROCEDURE <A NAME="PrintCaseList"><procedure>PrintCaseList</procedure></A>(swr: SynWr.T; list: ObTree.TermCaseList; libEnv: ObLib.Env; env: ObTree.Env;
    depth: INTEGER)  =
  VAR sep: TEXT;
  BEGIN
    sep := &quot;&quot;;
    LOOP
      TYPECASE list OF
      | NULL =&gt; EXIT;
      | ObTree.TermCaseList(node) =&gt;
	  SynWr.Text(swr, sep); sep := &quot;, &quot;;
          SynWr.Break(swr);
	  SynWr.Beg(swr, 2);
	    SynWr.Beg(swr, 4);
              IF node.tag=NIL THEN
                SynWr.Text(swr, &quot;else &quot;);
              ELSE
	        PrintIdeName(swr, node.tag, env);
                IF node.binder # NIL THEN
	          SynWr.Char(swr, '(');
	          PrintIdeName(swr, node.binder, env);
	          SynWr.Char(swr, ')');
                END;
	        SynWr.Text(swr, &quot; =&gt; &quot;);
              END;
	    SynWr.End(swr);
	  SynWr.Break(swr);
	    PrintTerm(swr, node.body, libEnv, env, depth-1);
	  SynWr.End(swr);
	  list := node.rest;
      END;
    END;
  END PrintCaseList;

  PROCEDURE <A NAME="PrintTryList"><procedure>PrintTryList</procedure></A>(swr: SynWr.T; list: ObTree.TermTryList; libEnv: ObLib.Env; env: ObTree.Env;
    depth: INTEGER)  =
  VAR sep: TEXT;
  BEGIN
    sep := &quot;&quot;;
    LOOP
      TYPECASE list OF
      | NULL =&gt; EXIT;
      | ObTree.TermTryList(node) =&gt;
	  SynWr.Text(swr, sep); sep := &quot;, &quot;;
          SynWr.Break(swr);
	  SynWr.Beg(swr, 2);
	    SynWr.Beg(swr, 4);
              IF node.exception=NIL THEN
                SynWr.Text(swr, &quot;else &quot;);
              ELSE
	        PrintTerm(swr, node.exception, libEnv, env, depth-1);
	        SynWr.Text(swr, &quot; =&gt; &quot;);
              END;
	    SynWr.End(swr);
	  SynWr.Break(swr);
	    PrintTerm(swr, node.recover, libEnv, env, depth-1);
	  SynWr.End(swr);
	  list := node.rest;
      END;
    END;
  END PrintTryList;

  PROCEDURE <A NAME="PrintOk"><procedure>PrintOk</procedure></A>(swr: SynWr.T)  =
  BEGIN
    SynWr.Text(swr, &quot;ok&quot;);
  END PrintOk;

  PROCEDURE <A NAME="PrintChar"><procedure>PrintChar</procedure></A>(swr: SynWr.T; char: CHAR)  =
  VAR charsOut: ARRAY[0..3] OF CHAR; avail: INTEGER;
  BEGIN
    avail := TextConv.EncodeChar(char, (*out*)charsOut);
    SynWr.Beg(swr);
    SynWr.Char(swr, '\'');
    FOR i:=0 TO avail-1 DO
      SynWr.Char(swr, charsOut[i]);
    END;
    SynWr.Char(swr, '\'');
    SynWr.End(swr);
  END PrintChar;

  PROCEDURE <A NAME="PrintText"><procedure>PrintText</procedure></A>(swr: SynWr.T; text: TEXT)  =
  BEGIN
    SynWr.Beg(swr);
    SynWr.Text(swr, TextConv.Encode(text, TRUE));
    SynWr.End(swr);
  END PrintText;

  PROCEDURE <A NAME="PrintBool"><procedure>PrintBool</procedure></A>(swr: SynWr.T; bool: BOOLEAN)  =
  BEGIN
    SynWr.Text(swr, ObTree.FmtBool(bool));
  END PrintBool;

  PROCEDURE <A NAME="PrintInt"><procedure>PrintInt</procedure></A>(swr: SynWr.T; int: INTEGER)  =
  BEGIN
    SynWr.Text(swr, ObTree.FmtInt(int));
  END PrintInt;

  PROCEDURE <A NAME="PrintReal"><procedure>PrintReal</procedure></A>(swr: SynWr.T; real: LONGREAL)  =
  BEGIN
    SynWr.Text(swr, ObTree.FmtReal(real));
  END PrintReal;

  PROCEDURE <A NAME="PrintSignature"><procedure>PrintSignature</procedure></A>(swr: SynWr.T; term: ObTree.Term; libEnv: ObLib.Env;
                      env: ObTree.Env)  =
  VAR newEnv: ObTree.Env;
  BEGIN
    TYPECASE term OF
    | NULL =&gt; SynWr.Text(swr, &quot;&lt;nil term&gt;&quot;);
    | ObTree.TermFun(node) =&gt;
	  SynWr.Beg(swr);
	    SynWr.Beg(swr, 2);
              SynWr.Text(swr, &quot;proc(&quot;);
	      newEnv := PrintIdeList(swr, node.binders, env);
              SynWr.Text(swr, &quot;)...end&quot;);
	    SynWr.End(swr);
          SynWr.End(swr);
    | ObTree.TermMeth(node) =&gt;
	  SynWr.Beg(swr);
	    SynWr.Beg(swr, 2);
              SynWr.Text(swr, &quot;meth(&quot;);
	      newEnv := PrintIdeList(swr, node.binders, env);
              SynWr.Text(swr, &quot;)...end&quot;);
	    SynWr.End(swr);
          SynWr.End(swr);
    ELSE
	SynWr.Text(swr, &quot;&lt;?&gt;&quot;);
    END;

  END PrintSignature;

  PROCEDURE <A NAME="PrintTerm"><procedure>PrintTerm</procedure></A>(swr: SynWr.T; term: ObTree.Term; libEnv: ObLib.Env;
                      env: ObTree.Env; depth: INTEGER)  =
  VAR newEnv: ObTree.Env; pkgName: TEXT;
  BEGIN
    TYPECASE term OF
    | NULL =&gt; SynWr.Text(swr, &quot;&lt;nil term&gt;&quot;);
    | ObTree.TermIde(node) =&gt;
	PrintIde(swr, node.name, node.place, env);
    | ObTree.TermOk =&gt;
        PrintOk(swr);
    | ObTree.TermBool(node) =&gt;
        PrintBool(swr, node.bool);
    | ObTree.TermChar(node) =&gt;
        PrintChar(swr, node.char);
    | ObTree.TermText(node) =&gt;
        PrintText(swr, node.text);
    | ObTree.TermInt(node) =&gt;
        PrintInt(swr, node.int);
    | ObTree.TermReal(node) =&gt;
        PrintReal(swr, node.real);
    | ObTree.TermArray(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        SynWr.Beg(swr, 1);
          SynWr.Char(swr, '[');
          PrintTermList(swr, node.elems, libEnv, env, depth);
          SynWr.Char(swr, ']');
	SynWr.End(swr);
    | ObTree.TermOption(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;option &quot;);
	  SynWr.Break(swr);
            SynWr.Beg(swr, 4);
	      PrintIdeName(swr, node.tag, env);
	      SynWr.Text(swr, &quot; =&gt; &quot;);
            SynWr.End(swr);
	  SynWr.Break(swr);
	    PrintTerm(swr, node.term, libEnv, env, depth-1);
	    SynWr.Char(swr, ' ');
	  SynWr.End(swr);
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermAlias(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;alias &quot;);
	  SynWr.Break(swr);
            SynWr.Beg(swr, 4);
	      PrintIdeName(swr, node.label, env);
	      SynWr.Text(swr, &quot; of &quot;);
            SynWr.End(swr);
	  SynWr.Break(swr);
	    PrintTerm(swr, node.term, libEnv, env, depth-1);
	    SynWr.Char(swr, ' ');
	  SynWr.End(swr);
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermOp(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        IF (node.argsNo=2) AND
           (ObLib.LookupFixity(node.op.text, libEnv, (*out*)pkgName)=
             ObLib.OpFixity.Infix)
        THEN
	   SynWr.Beg(swr, 2);
             SynWr.Char(swr, '(');
             PrintTerm(swr, node.args.first, libEnv, env, depth-1);
             SynWr.Char(swr, ' ');
           SynWr.Break(swr);
             SynWr.Text(swr, node.op.text);
             SynWr.Char(swr, ' ');
             PrintTerm(swr, node.args.rest.first, libEnv, env, depth-1);
             SynWr.Char(swr, ')');
           SynWr.End(swr);
        ELSIF (node.argsNo=1) AND
           (ObLib.LookupFixity(node.op.text, libEnv, (*out*)pkgName)=
             ObLib.OpFixity.Prefix)
        THEN
	  SynWr.Beg(swr, 2);
            SynWr.Text(swr, node.op.text);
            SynWr.Char(swr, '(');
	    PrintTermList(swr, node.args, libEnv, env, depth);
            SynWr.Char(swr, ')');
	  SynWr.End(swr);
        ELSIF node.argsNo&gt;=0 THEN
	  SynWr.Beg(swr, 2);
	   SynWr.Beg(swr, 4);
              SynWr.Text(swr, node.pkg.text);
              SynWr.Char(swr, '_');
	    SynWr.Break(swr);
              SynWr.Text(swr, node.op.text);
              SynWr.Char(swr, '(');
	    SynWr.End(swr);
	    PrintTermList(swr, node.args, libEnv, env, depth);
            SynWr.Char(swr, ')');
	  SynWr.End(swr);
        ELSE
	 SynWr.Beg(swr, 2);
            SynWr.Text(swr, node.pkg.text);
            SynWr.Char(swr, '_');
	  SynWr.Break(swr);
            SynWr.Text(swr, node.op.text);
	  SynWr.End(swr);
        END;
    | ObTree.TermFun(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        SynWr.Beg(swr);
	  SynWr.Beg(swr, 2);
	    SynWr.Beg(swr, 4);
              SynWr.Text(swr, &quot;proc(&quot;);
	      newEnv := PrintIdeList(swr, node.binders, env);
              SynWr.Text(swr, &quot;) &quot;);
	    SynWr.End(swr);
	  SynWr.Break(swr);
	    PrintTerm(swr, node.body, libEnv, newEnv, depth-1);
            SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermMeth(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        SynWr.Beg(swr);
	  SynWr.Beg(swr, 2);
	    SynWr.Beg(swr, 4);
              SynWr.Text(swr, &quot;meth(&quot;);
	      newEnv := PrintIdeList(swr, node.binders, env);
              SynWr.Text(swr, &quot;) &quot;);
	    SynWr.End(swr);
	  SynWr.Break(swr);
	    PrintTerm(swr, node.body, libEnv, newEnv, depth-1);
            SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermObj(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
    	SynWr.Beg(swr, 1);
    	SynWr.Char(swr, '{');
        PrintProtected(swr, node.protected);
        PrintSerialized(swr, node.sync);
	PrintObjFields(swr, node.fields, libEnv, env, depth);
    	SynWr.Char(swr, '}');
    	SynWr.End(swr);
    | ObTree.TermClone(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
	  SynWr.Text(swr, &quot;clone(&quot;);
	SynWr.Break(swr);
	  PrintTermList(swr, node.objs, libEnv, env, depth);
          SynWr.Char(swr, ')');
	SynWr.End(swr);
    | ObTree.TermRedirect(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
	  SynWr.Text(swr, &quot;redirect &quot;);
	SynWr.Break(swr);
	  PrintTerm(swr, node.obj, libEnv, env, depth);
	  SynWr.Char(swr, ' ');
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot; to &quot;);
	SynWr.Break(swr);
	  PrintTerm(swr, node.toObj, libEnv, env, depth);
	  SynWr.Char(swr, ' ');
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermSelect(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
	  PrintTerm(swr, node.obj, libEnv, env, depth-1);
	  SynWr.Char(swr, '.');
          (* PrintInt(swr, node.labelIndexHint); *)
	SynWr.Break(swr);
	  PrintIdeName(swr, node.label, env);
	  IF node.args#NIL THEN
	    SynWr.Char(swr, '(');
	    PrintTermList(swr, node.args, libEnv, env, depth);
	    SynWr.Char(swr, ')');
	  END;
	SynWr.End(swr);
    | ObTree.TermUpdate(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
	  PrintTerm(swr, node.obj, libEnv, env, depth-1);
	SynWr.Break(swr);
	  SynWr.Char(swr, '.');
          (* PrintInt(swr, node.labelIndexHint); *)
	  PrintIdeName(swr, node.label, env);
	  SynWr.Text(swr, &quot; := &quot;);
	SynWr.Break(swr);
	  PrintTerm(swr, node.term, libEnv, env, depth-1);
	SynWr.End(swr);
    | ObTree.TermAppl(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
	  PrintTerm(swr, node.fun, libEnv, env, depth-1);
	  SynWr.Char(swr, '(');
	  PrintTermList(swr, node.args, libEnv, env, depth);
	  SynWr.Char(swr, ')');
	SynWr.End(swr);
    | ObTree.TermSeq(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
	  PrintTerm(swr, node.before, libEnv, env, depth-1);
	  SynWr.Text(swr, &quot;; &quot;);
	SynWr.Break(swr);
	  PrintTerm(swr, node.after, libEnv, env, depth-1);
	SynWr.End(swr);
    | ObTree.TermLet(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
          IF node.var THEN SynWr.Text(swr, &quot;var &quot;) ELSE SynWr.Text(swr, &quot;let &quot;) END;
          PrintTermBinding(swr, node.rec, node.binding, libEnv, env, depth);
	SynWr.End(swr);
    | ObTree.TermAssign(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
	  PrintIde(swr, node.name, node.place, env);
	  SynWr.Text(swr, &quot; := &quot;);
	SynWr.Break(swr);
	  PrintTerm(swr, node.val, libEnv, env, depth-1);
	SynWr.End(swr);
    | ObTree.TermIf(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;if &quot;);
          SynWr.Break(swr);
	    PrintTerm(swr, node.test, libEnv, env, depth-1);
	    SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;then &quot;);
          SynWr.Break(swr);
	    PrintTerm(swr, node.ifTrue, libEnv, env, depth-1);
	    SynWr.Char(swr, ' ');
          SynWr.End(swr);
        IF node.ifFalse # NIL THEN
	SynWr.Break(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;else &quot;);
          SynWr.Break(swr);
	    PrintTerm(swr, node.ifFalse, libEnv, env, depth-1);
	    SynWr.Char(swr, ' ');
          SynWr.End(swr);
        END;
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermCase(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;case &quot;);
          SynWr.Break(swr);
	    PrintTerm(swr, node.option, libEnv, env, depth-1);
	    SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;of &quot;);
          SynWr.Break(swr);
            PrintCaseList(swr, node.caseList, libEnv, env, depth);
	    SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermLoop(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;loop &quot;);
          SynWr.Break(swr);
	    PrintTerm(swr, node.loop, libEnv, env, depth-1);
	    SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermExit =&gt;
	SynWr.Text(swr, &quot;exit&quot;);
    | ObTree.TermFor(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
            SynWr.Text(swr, &quot;for &quot;);
          SynWr.Break(swr);
            SynWr.Beg(swr, 4);
	      newEnv := ObTree.NewEnv(node.binder, env);
	      PrintIdeName(swr, node.binder, newEnv);
	      SynWr.Text(swr, &quot; = &quot;);
	    SynWr.Break(swr);
	      PrintTerm(swr, node.lb, libEnv, env, depth-1);
              SynWr.Char(swr, ' ');
            SynWr.End(swr);
	  SynWr.Break(swr);
            SynWr.Text(swr, &quot;to &quot;);
	    PrintTerm(swr, node.ub, libEnv, env, depth-1);
            SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
          SynWr.Beg(swr, 2);
            SynWr.Text(swr, &quot;do &quot;);
          SynWr.Break(swr);
	    PrintTerm(swr, node.body, libEnv, env, depth-1);
            SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
          SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermForeach(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
            SynWr.Text(swr, &quot;for &quot;);
          SynWr.Break(swr);
            SynWr.Beg(swr, 4);
	      newEnv := ObTree.NewEnv(node.binder, env);
	      PrintIdeName(swr, node.binder, newEnv);
	      SynWr.Text(swr, &quot; in &quot;);
	    SynWr.Break(swr);
	      PrintTerm(swr, node.range, libEnv, env, depth-1);
              SynWr.Char(swr, ' ');
            SynWr.End(swr);
          SynWr.End(swr);
	SynWr.Break(swr);
          SynWr.Beg(swr, 2);
            IF node.map THEN SynWr.Text(swr, &quot;map &quot;) ELSE SynWr.Text(swr, &quot;do &quot;) END;
          SynWr.Break(swr);
	    PrintTerm(swr, node.body, libEnv, env, depth-1);
            SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
          SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermException(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
	  SynWr.Text(swr, &quot;exception&quot;);
	  SynWr.Char(swr, '(');
	SynWr.Break(swr);
	  PrintTerm(swr, node.name, libEnv, env, depth-1);
	  SynWr.Char(swr, ')');
	SynWr.End(swr);
    | ObTree.TermRaise(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
	  SynWr.Text(swr, &quot;raise&quot;);
	  SynWr.Char(swr, '(');
	SynWr.Break(swr);
	  PrintTerm(swr, node.exception, libEnv, env, depth-1);
	  SynWr.Char(swr, ')');
	SynWr.End(swr);
    | ObTree.TermTry(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;try &quot;);
          SynWr.Break(swr);
	    PrintTerm(swr, node.body, libEnv, env, depth-1);
	    SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;except &quot;);
          SynWr.Break(swr);
            PrintTryList(swr, node.tryList, libEnv, env, depth);
	    SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermTryFinally(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;try &quot;);
          SynWr.Break(swr);
	    PrintTerm(swr, node.body, libEnv, env, depth-1);
	    SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;finally &quot;);
          SynWr.Break(swr);
            PrintTerm(swr, node.finally, libEnv, env, depth);
	    SynWr.Char(swr, ' ');
          SynWr.End(swr);
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObTree.TermWatch(node) =&gt;
        IF depth&lt;=0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
	SynWr.Beg(swr, 2);
	  SynWr.Text(swr, &quot;watch &quot;);
	SynWr.Break(swr);
	  PrintTerm(swr, node.condition, libEnv, env, depth);
	  SynWr.Char(swr, ' ');
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot; until &quot;);
	SynWr.Break(swr);
	  PrintTerm(swr, node.guard, libEnv, env, depth);
	  SynWr.Char(swr, ' ');
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
     ELSE
	SynWr.Text(swr, &quot;&lt;?&gt;&quot;);
    END;
  END PrintTerm;

  PROCEDURE <A NAME="PrintVarIndex"><procedure>PrintVarIndex</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) OR Text.Equal(arg, &quot;?&quot;) THEN
	SynWr.Text(SynWr.out, self.name &amp; &quot; {On Off} is &quot;);
	IF printVarIndex THEN SynWr.Text(SynWr.out, &quot;On&quot;);
	ELSE SynWr.Text(SynWr.out, &quot;Off&quot;); END;
	SynWr.NewLine(SynWr.out);
      ELSIF Text.Equal(arg, &quot;On&quot;) THEN printVarIndex:=TRUE;
      ELSIF Text.Equal(arg, &quot;Off&quot;) THEN printVarIndex:=FALSE;
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END PrintVarIndex;

  PROCEDURE <A NAME="PrintVariant"><procedure>PrintVariant</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) OR Text.Equal(arg, &quot;?&quot;) THEN
	SynWr.Text(SynWr.out , self.name &amp; &quot; {On Off} is &quot;);
	IF printVariant THEN SynWr.Text(SynWr.out , &quot;On&quot;);
	ELSE SynWr.Text(SynWr.out , &quot;Off&quot;); END;
	SynWr.NewLine(SynWr.out );	
      ELSIF Text.Equal(arg, &quot;On&quot;) THEN printVariant:=TRUE;
      ELSIF Text.Equal(arg, &quot;Off&quot;) THEN printVariant:=FALSE;
      ELSE
	SynWr.Text(SynWr.out , &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out );
      END;
    END PrintVariant;

  PROCEDURE <A NAME="PrintAlphaDecor"><procedure>PrintAlphaDecor</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) OR Text.Equal(arg, &quot;?&quot;) THEN
	SynWr.Text(SynWr.out , self.name &amp; &quot; {On Off} is &quot;);
	IF printAlphaDecor THEN SynWr.Text(SynWr.out , &quot;On&quot;);
	ELSE SynWr.Text(SynWr.out , &quot;Off&quot;); END;
	SynWr.NewLine(SynWr.out );	
      ELSIF Text.Equal(arg, &quot;On&quot;) THEN printAlphaDecor:=TRUE;
      ELSIF Text.Equal(arg, &quot;Off&quot;) THEN printAlphaDecor:=FALSE;
      ELSE
	SynWr.Text(SynWr.out , &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out );
      END;
    END PrintAlphaDecor;

BEGIN
END ObPrintTree.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
