<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqprint/src/ObPrintValue.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqprint/src/ObPrintValue.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObPrintValue.i3">ObPrintValue</A></implements></module>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../obliqrt/src/ObErr.i3">ObErr</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObTree.i3">ObTree</A>, <A HREF="ObPrintTree.i3">ObPrintTree</A>,
  <A HREF="../../obliqrt/src/ObCheck.i3">ObCheck</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>;

VAR
  printClosureGlobals: BOOLEAN;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
    BEGIN
      printClosureGlobals := FALSE;
      ObCommand.Register(ObTree.doCommandSet,
        NEW(ObCommand.T, name:=&quot;ShowClosureGlobals&quot;,
            sortingName:=&quot;ShowClosureGlobals&quot;,
            Exec:=PrintClosureGlobals));
    END Setup;

  PROCEDURE <A NAME="PrintValArray"><procedure>PrintValArray</procedure></A>(swr: SynWr.T; array: REF ObValue.Vals;
    libEnv: ObLib.Env; printEnv: ObTree.Env; depth: INTEGER) =
  VAR sep: TEXT; size: INTEGER;
  BEGIN
    TRY
      sep := &quot;&quot;;
      size := NUMBER(array^);
      FOR i:=0 TO size-1 DO
        SynWr.Text(swr, sep); sep := &quot;, &quot;;
        SynWr.Break(swr);
        SynWr.Beg(swr, 2);
        PrintVal(swr, array^[i], libEnv, printEnv, depth-1);
        SynWr.End(swr);
      END;
    EXCEPT NetObj.Error =&gt; SynWr.Text(swr, &quot;&lt;disconnected&gt;&quot;);
    END;
  END PrintValArray;

  PROCEDURE <A NAME="PrintVal"><procedure>PrintVal</procedure></A>(swr: SynWr.T; val: ObValue.Val;
    libEnv: ObLib.Env; printEnv: ObTree.Env; depth: INTEGER) =
  VAR val1: ObValue.Val; protected, serialized: BOOLEAN; who: TEXT;
    fields: REF ObValue.ObjFields;
  BEGIN
    IF val=NIL THEN SynWr.Char(swr, '_'); RETURN END;
    TYPECASE val OF
    | ObValue.ValVar(node) =&gt;
      TRY val1 := node.remote.Get();
      EXCEPT NetObj.Error =&gt; SynWr.Text(swr, &quot;&lt;remote variable disconnected&gt;&quot;);
      END;
      PrintVal(swr, val1, libEnv, printEnv, depth);
    | ObValue.ValOk =&gt; ObPrintTree.PrintOk(swr);
    | ObValue.ValBool(node) =&gt; ObPrintTree.PrintBool(swr, node.bool);
    | ObValue.ValChar(node) =&gt; ObPrintTree.PrintChar(swr, node.char);
    | ObValue.ValText(node) =&gt; ObPrintTree.PrintText(swr, node.text);
    | ObValue.ValInt(node) =&gt;
	ObPrintTree.PrintInt(swr, node.int);
	IF node.temp THEN SynWr.Text(swr, &quot;&lt;TEMP!&gt;&quot;) END;
    | ObValue.ValReal(node) =&gt;
	ObPrintTree.PrintReal(swr, node.real);
	IF node.temp THEN SynWr.Text(swr, &quot;&lt;TEMP!&gt;&quot;) END;
    | ObValue.ValOption(node) =&gt;
        IF depth &lt;= 0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;option &quot;);
	  SynWr.Break(swr);
            SynWr.Beg(swr, 4);
	      SynWr.Text(swr, node.tag);
	      SynWr.Text(swr, &quot; =&gt; &quot;);
            SynWr.End(swr);
	  SynWr.Break(swr);
	    PrintVal(swr, node.val, libEnv, printEnv, depth-1);
	    SynWr.Char(swr, ' ');
	  SynWr.End(swr);
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObValue.ValAlias(node) =&gt;
        IF depth &lt;= 0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;alias &quot;);
	  SynWr.Break(swr);
            SynWr.Beg(swr, 4);
	      SynWr.Text(swr, node.label);
	      SynWr.Text(swr, &quot; of &quot;);
            SynWr.End(swr);
	  SynWr.Break(swr);
	    PrintVal(swr, node.obj, libEnv, printEnv, depth-1);
	    SynWr.Char(swr, ' ');
	  SynWr.End(swr);
	SynWr.Break(swr);
	  SynWr.Text(swr, &quot;end&quot;);
	SynWr.End(swr);
    | ObValue.ValArray(node) =&gt;
        IF depth &lt;= 0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        SynWr.Beg(swr, 1);
          SynWr.Char(swr, '[');
          PrintValArray(swr, node.remote.Obtain(), libEnv, printEnv, depth);
          SynWr.Char(swr, ']');
	SynWr.End(swr);
    | ObValue.ValAnything(node) =&gt;
        SynWr.Text(swr, node.Print());
    | ObValue.ValFun(node) =&gt;
        IF depth &lt;= 0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        PrintClosure(swr, node.fun, node.fun.globals, node.global,
          libEnv, printEnv, depth);
    | ObValue.ValMeth(node) =&gt;
        IF depth &lt;= 0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        PrintClosure(swr, node.meth, node.meth.globals, node.global,
          libEnv, printEnv, depth);
   | ObValue.ValObj(node) =&gt;
        IF depth &lt;= 0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        TYPECASE node.remote OF
        | ObValue.RemObjServer(remObj) =&gt;
            who := remObj.Who((*out*)protected, (*out*)serialized);
            fields := remObj.Obtain(TRUE);
    	    SynWr.Beg(swr, 1);
    	    SynWr.Char(swr, '{');
            PrintProtected(swr, protected);
            PrintSerialized(swr, serialized);
            PrintValObjFields(swr, fields, libEnv, printEnv, depth);
    	    SynWr.Char(swr, '}');
    	    SynWr.End(swr);
        ELSE
          SynWr.Beg(swr, 1); SynWr.Char(swr, '{');
          TRY
            who := node.remote.Who((*out*)protected, (*out*)serialized);
            IF Text.Empty(who) THEN SynWr.Text(swr, &quot;&lt;unknown&gt;&quot;);
            ELSE SynWr.Text(swr, who);
            END;
          EXCEPT NetObj.Error =&gt; SynWr.Text(swr, &quot;&lt;disconnected&gt;&quot;);
          END;
          SynWr.Char(swr, '}'); SynWr.End(swr);
        END;
   | ObValue.ValEngine(node) =&gt;
        IF depth &lt;= 0 THEN SynWr.Text(swr, &quot;...&quot;); RETURN END;
        SynWr.Beg(swr, 1); SynWr.Text(swr, &quot;&lt;Engine &quot;);
        TRY SynWr.Text(swr, node.remote.Who())
        EXCEPT NetObj.Error =&gt; SynWr.Text(swr, &quot;&lt;disconnected&gt;&quot;);
        END;
        SynWr.Char(swr, '&gt;'); SynWr.End(swr);
    | ObValue.ValException(node) =&gt;
        SynWr.Text(swr, &quot;&lt;the exception '&quot; &amp; node.name &amp; &quot;'&gt;&quot;);
    ELSE SynWr.Text(swr, &quot;&lt;?&gt;&quot;);
    END;
  END PrintVal;

  PROCEDURE <A NAME="PrintValSummary"><procedure>PrintValSummary</procedure></A>(swr: SynWr.T; val: ObValue.Val;
    libEnv: ObLib.Env; printEnv: ObTree.Env) =
  VAR val1: ObValue.Val; protected, serialized: BOOLEAN; who: TEXT;
    fields: REF ObValue.ObjFields;
  BEGIN
    IF val=NIL THEN SynWr.Char(swr, '_'); RETURN END;
    TYPECASE val OF
    | ObValue.ValVar(node) =&gt;
      TRY val1 := node.remote.Get();
      EXCEPT NetObj.Error =&gt; SynWr.Text(swr, &quot;&lt;remote variable disconnected&gt;&quot;);
      END;
      PrintValSummary(swr, val1, libEnv, printEnv);
    | ObValue.ValOk, ObValue.ValBool, ObValue.ValChar,
      ObValue.ValInt, ObValue.ValReal =&gt;
        PrintVal(swr, val, libEnv, printEnv, 10);
    | ObValue.ValText =&gt; SynWr.Text(swr, &quot;\&quot; ... \&quot;&quot;);
    | ObValue.ValOption(node) =&gt;
        SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;option &quot;);
	  SynWr.Break(swr);
            SynWr.Beg(swr, 4);
	      SynWr.Text(swr, node.tag);
	      SynWr.Text(swr, &quot; =&gt; ... end&quot;);
            SynWr.End(swr);
	  SynWr.End(swr);
	SynWr.End(swr);
    | ObValue.ValAlias(node) =&gt;
        SynWr.Beg(swr);
          SynWr.Beg(swr, 2);
	    SynWr.Text(swr, &quot;alias &quot;);
	  SynWr.Break(swr);
            SynWr.Beg(swr, 4);
	      SynWr.Text(swr, node.label);
	      SynWr.Text(swr, &quot; of ... end&quot;);
            SynWr.End(swr);
	  SynWr.End(swr);
	SynWr.End(swr);
    | ObValue.ValArray =&gt;
	SynWr.Text(swr, &quot;[ ... ]&quot;);
    | ObValue.ValAnything(node) =&gt;
        SynWr.Text(swr, node.Print());
    | ObValue.ValFun(node) =&gt;
        ObPrintTree.PrintSignature(swr, node.fun, libEnv, printEnv);
    | ObValue.ValMeth(node) =&gt;
        ObPrintTree.PrintSignature(swr, node.meth, libEnv, printEnv);
    | ObValue.ValObj(node) =&gt;
        TYPECASE node.remote OF
        | ObValue.RemObjServer(remObj) =&gt;
            who := remObj.Who((*out*)protected, (*out*)serialized);
            fields := remObj.Obtain(TRUE);
    	    SynWr.Beg(swr, 1);
    	    SynWr.Char(swr, '{');
            PrintProtected(swr, protected);
            PrintSerialized(swr, serialized);
            PrintValObjFieldsSummary(swr, fields, libEnv, printEnv);
    	    SynWr.Char(swr, '}');
    	    SynWr.End(swr);
        ELSE
          SynWr.Beg(swr, 1); SynWr.Char(swr, '{');
          TRY
            who := node.remote.Who((*out*)protected, (*out*)serialized);
            IF Text.Empty(who) THEN SynWr.Text(swr, &quot;&lt;unknown&gt;&quot;);
            ELSE SynWr.Text(swr, who);
            END;
          EXCEPT NetObj.Error =&gt; SynWr.Text(swr, &quot;&lt;disconnected&gt;&quot;);
          END;
          SynWr.Char(swr, '}'); SynWr.End(swr);
        END;
   | ObValue.ValEngine(node) =&gt;
        SynWr.Beg(swr, 1); SynWr.Text(swr, &quot;&lt;Engine &quot;);
        TRY SynWr.Text(swr, node.remote.Who())
        EXCEPT NetObj.Error =&gt; SynWr.Text(swr, &quot;&lt;disconnected&gt;&quot;);
        END;
        SynWr.Char(swr, '&gt;'); SynWr.End(swr);
    | ObValue.ValException(node) =&gt;
        SynWr.Text(swr, &quot;&lt;the exception '&quot; &amp; node.name &amp; &quot;'&gt;&quot;);
    ELSE SynWr.Text(swr, &quot;&lt;?&gt;&quot;);
    END;
  END PrintValSummary;

  PROCEDURE <A NAME="PrintClosure"><procedure>PrintClosure</procedure></A>(swr: SynWr.T; fun: ObTree.Term;
    globalsList: ObTree.Globals; globalsEnv: ObValue.GlobalEnv;
    libEnv: ObLib.Env; printEnv: ObTree.Env; depth: INTEGER) =
  VAR sep: TEXT;
  BEGIN
    IF NUMBER(globalsEnv^)=0 THEN
      ObPrintTree.PrintTerm(swr, fun, libEnv, printEnv, depth);
    ELSIF printClosureGlobals THEN
      SynWr.Beg(swr, 2);
        ObPrintTree.PrintTerm(swr, fun, libEnv, printEnv, depth);
        SynWr.Char(swr, ' ');
      SynWr.Break(swr);
        SynWr.Text(swr, &quot;where &quot;);
        sep := &quot;&quot;;
        FOR i:=0 TO NUMBER(globalsEnv^)-1 DO
          SynWr.Text(swr, sep); sep:=&quot;, &quot;;
          SynWr.Break(swr);
          SynWr.Beg(swr, 2);
            SynWr.Beg(swr, 4);
              ObPrintTree.PrintIdeName(swr, globalsList.name, printEnv);
              SynWr.Text(swr, &quot; = &quot;);
            SynWr.End(swr);
          SynWr.Break(swr);
            PrintVal(swr, globalsEnv[i], libEnv, printEnv, depth-1);
          SynWr.End(swr);
          globalsList := globalsList.rest;
        END;
        SynWr.Char(swr, ' ');
      SynWr.Break(swr);
        SynWr.Text(swr, &quot;end&quot;);
      SynWr.End(swr);
    ELSE
      SynWr.Beg(swr, 2);
        SynWr.Beg(swr, 4);
          SynWr.Text(swr, &quot;global(&quot;);
          sep := &quot;&quot;;
          FOR i:=0 TO NUMBER(globalsEnv^)-1 DO
            SynWr.Text(swr, sep); sep:=&quot;,&quot;;
            SynWr.Break(swr);
            ObPrintTree.PrintIdeName(swr, globalsList.name, printEnv);
            globalsList := globalsList.rest;
          END;
          SynWr.Text(swr, &quot;) &quot;);
        SynWr.End(swr);
      SynWr.Break(swr);
        ObPrintTree.PrintTerm(swr, fun, libEnv, printEnv, depth);
      SynWr.End(swr);
    END;
  END PrintClosure;

  PROCEDURE <A NAME="PrintProtected"><procedure>PrintProtected</procedure></A>(swr: SynWr.T; protected: BOOLEAN) =
  BEGIN
    IF protected THEN
      SynWr.Break(swr);
      SynWr.Beg(swr, 2);
      SynWr.Text(swr, &quot;protected, &quot;);
      SynWr.End(swr);
    END;
  END PrintProtected;

  PROCEDURE <A NAME="PrintSerialized"><procedure>PrintSerialized</procedure></A>(swr: SynWr.T; serialized: BOOLEAN) =
  BEGIN
    IF serialized THEN
      SynWr.Break(swr);
      SynWr.Beg(swr, 2);
      SynWr.Text(swr, &quot;serialized, &quot;);
      SynWr.End(swr);
    END;
  END PrintSerialized;

  PROCEDURE <A NAME="PrintValObjFields"><procedure>PrintValObjFields</procedure></A>(swr: SynWr.T; fields: REF ObValue.ObjFields;
    libEnv: ObLib.Env; printEnv: ObTree.Env; depth: INTEGER) =
  VAR sep: TEXT;
  BEGIN
    sep := &quot;&quot;;
    FOR i:=0 TO NUMBER(fields^)-1 DO
	SynWr.Text(swr, sep); sep := &quot;, &quot;;
        SynWr.Break(swr);
        SynWr.Beg(swr, 2);
	  SynWr.Beg(swr, 4);
	    SynWr.Text(swr, fields^[i].label);
	    SynWr.Text(swr, &quot; =&gt; &quot;);
	  SynWr.End(swr);
	SynWr.Break(swr);
	  PrintVal(swr, fields^[i].field, libEnv, printEnv, depth-1);
	SynWr.End(swr);
    END;
  END PrintValObjFields;

  PROCEDURE <A NAME="PrintValObjFieldsSummary"><procedure>PrintValObjFieldsSummary</procedure></A>(swr: SynWr.T;
    fields: REF ObValue.ObjFields;
    libEnv: ObLib.Env; printEnv: ObTree.Env) =
  VAR sep: TEXT;
  BEGIN
    sep := &quot;&quot;;
    FOR i:=0 TO NUMBER(fields^)-1 DO
	SynWr.Text(swr, sep); sep := &quot;, &quot;;
        SynWr.Break(swr);
        SynWr.Beg(swr, 2);
	  SynWr.Beg(swr, 4);
	    SynWr.Text(swr, fields^[i].label);
	    SynWr.Text(swr, &quot;=&gt; ... &quot;);
	  SynWr.End(swr);
	SynWr.End(swr);
    END;
  END PrintValObjFieldsSummary;

PROCEDURE <A NAME="PrintPhraseLet"><procedure>PrintPhraseLet</procedure></A>(swr: SynWr.T; checkEnv, checkEnvStop: ObCheck.Env;
    env, envStop: ObValue.Env; var: BOOLEAN; libEnv: ObLib.Env; depth: INTEGER) =
  BEGIN
    SynWr.Beg(swr, 2);
      IF var THEN SynWr.Text(swr, &quot;var &quot;) ELSE SynWr.Text(swr, &quot;let &quot;) END;
      PrintTermBinding(swr, checkEnv, checkEnvStop, env, envStop, libEnv, depth);
    SynWr.End(swr);
    SynWr.NewLine(swr);
  END PrintPhraseLet;

PROCEDURE <A NAME="PrintTermBinding"><procedure>PrintTermBinding</procedure></A>(swr: SynWr.T; checkEnv, checkEnvStop: ObCheck.Env;
    env, envStop: ObValue.Env; libEnv: ObLib.Env; depth: INTEGER) =
  BEGIN
    IF (checkEnv=checkEnvStop) AND (env=envStop) THEN RETURN END;
    IF (checkEnv=checkEnvStop) OR (env=envStop) OR
	NOT ObTree.SameIdeName(checkEnv.name, env.name) THEN
	ObErr.Fault(swr, &quot;Envs do not match. (1)&quot;); &lt;* NOWARN *&gt;
    END;
    PrintTermBinding(swr, checkEnv.rest, checkEnvStop,
	env.rest, envStop, libEnv, depth);
    TYPECASE checkEnv OF
    | ObCheck.TermEnv(checkNode) =&gt;
	TYPECASE env OF
	| ObValue.LocalEnv(valueNode) =&gt;
            IF env.rest#envStop THEN SynWr.Text(swr, &quot;, &quot;) END;
            SynWr.Break(swr);
	    SynWr.Beg(swr, 2);
	      SynWr.Beg(swr, 4);
	        ObPrintTree.PrintIdeName(swr, checkNode.name, checkEnv);
                SynWr.Text(swr, &quot; = &quot;);
	      SynWr.End(swr);
	    SynWr.Break(swr);
              (* PrintVal(swr, valueNode.val, libEnv, checkNode.rest, depth-1); *)
              PrintValSummary(swr, valueNode.val, libEnv, checkNode.rest);
	    SynWr.End(swr);
	ELSE ObErr.Fault(swr, &quot;Envs do not match. (2)&quot;); &lt;* NOWARN *&gt;
	END;
    ELSE ObErr.Fault(swr, &quot;PrintTermBinding&quot;); &lt;* NOWARN *&gt;
    END;
  END PrintTermBinding;

  PROCEDURE <A NAME="PrintClosureGlobals"><procedure>PrintClosureGlobals</procedure></A>(self: ObCommand.T; arg: TEXT;
                                data: REFANY:=NIL) =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) OR Text.Equal(arg, &quot;?&quot;) THEN
	SynWr.Text(SynWr.out , self.name &amp; &quot; {On Off} is &quot;);
	IF printClosureGlobals THEN SynWr.Text(SynWr.out , &quot;On&quot;);
	ELSE SynWr.Text(SynWr.out , &quot;Off&quot;); END;
	SynWr.NewLine(SynWr.out );
      ELSIF Text.Equal(arg, &quot;On&quot;) THEN printClosureGlobals:=TRUE;
      ELSIF Text.Equal(arg, &quot;Off&quot;) THEN printClosureGlobals:=FALSE;
      ELSE
	SynWr.Text(SynWr.out , &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out );
      END;
    END PrintClosureGlobals;

BEGIN
END ObPrintValue.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
