<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqprint/src/ObliqPrinter.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqprint/src/ObliqPrinter.m3</H2></A><HR>
<inModule>
<PRE>
<A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObliqPrinter.i3">ObliqPrinter</A></implements></module>;
IMPORT <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../obliqrt/src/ObTree.i3">ObTree</A>, <A HREF="ObPrintTree.i3">ObPrintTree</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="ObPrintValue.i3">ObPrintValue</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>;

  VAR setupDone := FALSE;

  PROCEDURE <A NAME="PackageSetup"><procedure>PackageSetup</procedure></A>() =
  BEGIN
    Obliq.PackageSetup();
    IF NOT setupDone THEN
      setupDone := TRUE;
      ObPrintTree.Setup();
      ObPrintValue.Setup();
    END;
  END PackageSetup;

  PROCEDURE <A NAME="PrintTerm"><procedure>PrintTerm</procedure></A>(term: ObTree.Term; libEnv: ObLib.Env;
    swr: SynWr.T:=NIL; depth:=10) =
  BEGIN
    IF swr=NIL THEN swr := SynWr.out END;
    ObPrintTree.PrintTerm(swr, term, libEnv, NIL, depth);
  END PrintTerm;

  PROCEDURE <A NAME="PrintVal"><procedure>PrintVal</procedure></A>(val: ObValue.Val; libEnv: ObLib.Env;
     swr: SynWr.T:=NIL; depth:=10) =
  BEGIN
    IF swr=NIL THEN swr := SynWr.out END;
    ObPrintValue.PrintVal(swr, val, libEnv, NIL, depth);
  END PrintVal;

  PROCEDURE <A NAME="PrintText"><procedure>PrintText</procedure></A>(text: TEXT; swr: SynWr.T:=NIL) =
  BEGIN
    IF swr=NIL THEN swr := SynWr.out END;
    SynWr.Text(swr, text);
  END PrintText;

  PROCEDURE <A NAME="PrintFlush"><procedure>PrintFlush</procedure></A>(swr: SynWr.T:=NIL) =
  BEGIN
    IF swr=NIL THEN swr := SynWr.out END;
    SynWr.Flush(swr);
  END PrintFlush;

BEGIN
END ObliqPrinter.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
