<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/derived/ObValue_RemArray_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/derived/ObValue_RemArray_v1.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>ObValue_RemArray_v1</module> EXPORTS <A HREF="../src/ObValue.i3"><implements>ObValue</A></implements>, <A HREF="ObValue_RemArray_v1.i3"><implements>ObValue_RemArray_v1</A></implements>;

IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../src/ObValue.i3">ObValue</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {Obtain, Upd, Sub, Set, Get, Size};
      ReturnCodes = {OK, ObValue_ServerError};

  PROCEDURE <A NAME="Surrogate_Size"><procedure>Surrogate_Size</procedure></A>(self: ObValue.RemArray): INTEGER
       RAISES {NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: INTEGER;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Size));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InInteger(c, rep);
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Size;

  PROCEDURE <A NAME="Surrogate_Get"><procedure>Surrogate_Get</procedure></A>(self: ObValue.RemArray; i_arg: INTEGER)
      : ObValue.Val RAISES {ObValue.ServerError, NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: ObValue.Val;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Get));
          StubLib.OutInteger(c, i_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Get;

  PROCEDURE <A NAME="Surrogate_Set"><procedure>Surrogate_Set</procedure></A>(
      self: ObValue.RemArray;
      i_arg: INTEGER;
      val_arg: ObValue.Val) RAISES {ObValue.ServerError, NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Set));
          StubLib.OutInteger(c, i_arg);
          StubLib.OutRef(c, val_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_Set;

  PROCEDURE <A NAME="Surrogate_Sub"><procedure>Surrogate_Sub</procedure></A>(
      self: ObValue.RemArray;
      start_arg: INTEGER;
      size_arg: INTEGER): ObValue.ValArray RAISES {ObValue.ServerError,
      NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: ObValue.ValArray;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Sub));
          StubLib.OutInteger(c, start_arg);
          StubLib.OutInteger(c, size_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(ObValue.ValArray));
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Sub;

  PROCEDURE <A NAME="Surrogate_Upd"><procedure>Surrogate_Upd</procedure></A>(
      self: ObValue.RemArray;
      start_arg: INTEGER;
      size_arg: INTEGER;
      READONLY other_arg: REF ObValue.Vals) RAISES {ObValue.ServerError,
      NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Upd));
          StubLib.OutInteger(c, start_arg);
          StubLib.OutInteger(c, size_arg);
          StubLib.OutRef(c, other_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_Upd;

  PROCEDURE <A NAME="Surrogate_Obtain"><procedure>Surrogate_Obtain</procedure></A>(self: ObValue.RemArray): REF ObValue.Vals
       RAISES {NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: REF ObValue.Vals;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Obtain));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, -1);
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Obtain;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, ObValue.RemArray);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.Size) =&gt; Stub_Size(t, c, rep);
      | ORD(Methods.Get) =&gt; Stub_Get(t, c, rep);
      | ORD(Methods.Set) =&gt; Stub_Set(t, c, rep);
      | ORD(Methods.Sub) =&gt; Stub_Sub(t, c, rep);
      | ORD(Methods.Upd) =&gt; Stub_Upd(t, c, rep);
      | ORD(Methods.Obtain) =&gt; Stub_Obtain(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    | ObValue.ServerError(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.ObValue_ServerError));
        StubLib.OutRef(c, arg);
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_Size"><procedure>Stub_Size</procedure></A>(
    self: ObValue.RemArray;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR res: INTEGER;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.Size();
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutInteger(c, res);

  END Stub_Size;

PROCEDURE <A NAME="Stub_Get"><procedure>Stub_Get</procedure></A>(
    self: ObValue.RemArray;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.ServerError}=
  VAR i_arg: INTEGER;
      res: ObValue.Val;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    i_arg := StubLib.InInteger(c, rep);
    res := self.Get(i_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_Get;

PROCEDURE <A NAME="Stub_Set"><procedure>Stub_Set</procedure></A>(
    self: ObValue.RemArray;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.ServerError}=
  VAR i_arg: INTEGER;
      val_arg: ObValue.Val;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    i_arg := StubLib.InInteger(c, rep);
    val_arg := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
    self.Set(i_arg, val_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_Set;

PROCEDURE <A NAME="Stub_Sub"><procedure>Stub_Sub</procedure></A>(
    self: ObValue.RemArray;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.ServerError}=
  VAR start_arg: INTEGER;
      size_arg: INTEGER;
      res: ObValue.ValArray;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    start_arg := StubLib.InInteger(c, rep);
    size_arg := StubLib.InInteger(c, rep);
    res := self.Sub(start_arg, size_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_Sub;

PROCEDURE <A NAME="Stub_Upd"><procedure>Stub_Upd</procedure></A>(
    self: ObValue.RemArray;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.ServerError}=
  VAR start_arg: INTEGER;
      size_arg: INTEGER;
      other_arg: REF ObValue.Vals;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    start_arg := StubLib.InInteger(c, rep);
    size_arg := StubLib.InInteger(c, rep);
    other_arg := StubLib.InRef(c, rep, -1);
    self.Upd(start_arg, size_arg, other_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_Upd;

PROCEDURE <A NAME="Stub_Obtain"><procedure>Stub_Obtain</procedure></A>(
    self: ObValue.RemArray;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR res: REF ObValue.Vals;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.Obtain();
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_Obtain;

BEGIN
  StubLib.Register(TYPECODE(ObValue.RemArray), 1, TYPECODE(Surrogate_ObValue_RemArray), Invoke);
END ObValue_RemArray_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
