<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/derived/ObValue_RemEngine_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/derived/ObValue_RemEngine_v1.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>ObValue_RemEngine_v1</module> EXPORTS <A HREF="../src/ObValue.i3"><implements>ObValue</A></implements>, <A HREF="ObValue_RemEngine_v1.i3"><implements>ObValue_RemEngine_v1</A></implements>;

IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../src/ObValue.i3">ObValue</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {Eval, Who};
      ReturnCodes = {OK, ObValue_Error, ObValue_Exception,
        ObValue_ServerError};

  PROCEDURE <A NAME="Surrogate_Who"><procedure>Surrogate_Who</procedure></A>(self: ObValue.RemEngine): TEXT
       RAISES {NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: TEXT;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Who));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, -1);
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Who;

  PROCEDURE <A NAME="Surrogate_Eval"><procedure>Surrogate_Eval</procedure></A>(
      self: ObValue.RemEngine;
      proc_arg: ObValue.Val;
      mySelf_arg: ObValue.RemObj): ObValue.Val RAISES {ObValue.Error,
      ObValue.Exception, ObValue.ServerError, NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: ObValue.Val;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Eval));
          StubLib.OutRef(c, proc_arg);
          StubLib.OutRef(c, mySelf_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_Error) =&gt;
            VAR arg: ObValue.ErrorPacket;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(ObValue.ErrorPacket));
              reuse := TRUE;
              RAISE ObValue.Error(arg);

            END;
          | ORD(ReturnCodes.ObValue_Exception) =&gt;
            VAR arg: ObValue.ExceptionPacket;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(ObValue.ExceptionPacket));
              reuse := TRUE;
              RAISE ObValue.Exception(arg);

            END;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Eval;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, ObValue.RemEngine);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.Who) =&gt; Stub_Who(t, c, rep);
      | ORD(Methods.Eval) =&gt; Stub_Eval(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    | ObValue.ServerError(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.ObValue_ServerError));
        StubLib.OutRef(c, arg);

    | ObValue.Exception(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.ObValue_Exception));
        StubLib.OutRef(c, arg);

    | ObValue.Error(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.ObValue_Error));
        StubLib.OutRef(c, arg);
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_Who"><procedure>Stub_Who</procedure></A>(
    self: ObValue.RemEngine;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR res: TEXT;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.Who();
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_Who;

PROCEDURE <A NAME="Stub_Eval"><procedure>Stub_Eval</procedure></A>(
    self: ObValue.RemEngine;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.Error, ObValue.Exception,
    ObValue.ServerError}=
  VAR proc_arg: ObValue.Val;
      mySelf_arg: ObValue.RemObj;
      res: ObValue.Val;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    proc_arg := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
    mySelf_arg := StubLib.InRef(c, rep, TYPECODE(ObValue.RemObj));
    res := self.Eval(proc_arg, mySelf_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_Eval;

BEGIN
  StubLib.Register(TYPECODE(ObValue.RemEngine), 1, TYPECODE(Surrogate_ObValue_RemEngine), Invoke);
END ObValue_RemEngine_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
