<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/derived/ObValue_RemFileSystem_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/derived/ObValue_RemFileSystem_v1.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>ObValue_RemFileSystem_v1</module> EXPORTS <A HREF="../src/ObValue.i3"><implements>ObValue</A></implements>, <A HREF="ObValue_RemFileSystem_v1.i3"><implements>ObValue_RemFileSystem_v1</A></implements>;

IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../src/ObValue.i3">ObValue</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {OpenAppend, OpenWrite, OpenRead};
      ReturnCodes = {OK, ObValue_ServerError};

  PROCEDURE <A NAME="Surrogate_OpenRead"><procedure>Surrogate_OpenRead</procedure></A>(
      self: ObValue.RemFileSystem;
      fileName_arg: TEXT): Rd.T RAISES {NetObj.Error, ObValue.ServerError} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: Rd.T;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.OpenRead));
          StubLib.OutRef(c, fileName_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(Rd.T));
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_OpenRead;

  PROCEDURE <A NAME="Surrogate_OpenWrite"><procedure>Surrogate_OpenWrite</procedure></A>(
      self: ObValue.RemFileSystem;
      fileName_arg: TEXT): Wr.T RAISES {NetObj.Error, ObValue.ServerError} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: Wr.T;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.OpenWrite));
          StubLib.OutRef(c, fileName_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(Wr.T));
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_OpenWrite;

  PROCEDURE <A NAME="Surrogate_OpenAppend"><procedure>Surrogate_OpenAppend</procedure></A>(
      self: ObValue.RemFileSystem;
      fileName_arg: TEXT): Wr.T RAISES {NetObj.Error, ObValue.ServerError} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: Wr.T;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.OpenAppend));
          StubLib.OutRef(c, fileName_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(Wr.T));
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_OpenAppend;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, ObValue.RemFileSystem);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.OpenRead) =&gt; Stub_OpenRead(t, c, rep);
      | ORD(Methods.OpenWrite) =&gt; Stub_OpenWrite(t, c, rep);
      | ORD(Methods.OpenAppend) =&gt; Stub_OpenAppend(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    | ObValue.ServerError(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.ObValue_ServerError));
        StubLib.OutRef(c, arg);
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_OpenRead"><procedure>Stub_OpenRead</procedure></A>(
    self: ObValue.RemFileSystem;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.ServerError}=
  VAR fileName_arg: TEXT;
      res: Rd.T;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    fileName_arg := StubLib.InRef(c, rep, -1);
    res := self.OpenRead(fileName_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_OpenRead;

PROCEDURE <A NAME="Stub_OpenWrite"><procedure>Stub_OpenWrite</procedure></A>(
    self: ObValue.RemFileSystem;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.ServerError}=
  VAR fileName_arg: TEXT;
      res: Wr.T;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    fileName_arg := StubLib.InRef(c, rep, -1);
    res := self.OpenWrite(fileName_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_OpenWrite;

PROCEDURE <A NAME="Stub_OpenAppend"><procedure>Stub_OpenAppend</procedure></A>(
    self: ObValue.RemFileSystem;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.ServerError}=
  VAR fileName_arg: TEXT;
      res: Wr.T;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    fileName_arg := StubLib.InRef(c, rep, -1);
    res := self.OpenAppend(fileName_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_OpenAppend;

BEGIN
  StubLib.Register(TYPECODE(ObValue.RemFileSystem), 1, TYPECODE(Surrogate_ObValue_RemFileSystem), Invoke);
END ObValue_RemFileSystem_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
