<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/derived/ObValue_RemObj_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/derived/ObValue_RemObj_v1.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>ObValue_RemObj_v1</module> EXPORTS <A HREF="../src/ObValue.i3"><implements>ObValue</A></implements>, <A HREF="ObValue_RemObj_v1.i3"><implements>ObValue_RemObj_v1</A></implements>;

IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../src/ObValue.i3">ObValue</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {Obtain, Has, Redirect, Update, Invoke, Select, Who};
      ReturnCodes = {OK, ObValue_Error, ObValue_Exception,
        ObValue_ServerError};

  PROCEDURE <A NAME="Surrogate_Who"><procedure>Surrogate_Who</procedure></A>(
      self: ObValue.RemObj;
      VAR protected_arg: BOOLEAN;
      VAR serialized_arg: BOOLEAN): TEXT RAISES {NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: TEXT;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Who));
          StubLib.OutInteger(c, ORD(protected_arg));
          StubLib.OutInteger(c, ORD(serialized_arg));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            protected_arg := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
            serialized_arg := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
            res := StubLib.InRef(c, rep, -1);
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Who;

  PROCEDURE <A NAME="Surrogate_Select"><procedure>Surrogate_Select</procedure></A>(
      self: ObValue.RemObj;
      label_arg: TEXT;
      internal_arg: BOOLEAN;
      VAR hint_arg: INTEGER): ObValue.Val RAISES {ObValue.Error,
      ObValue.Exception, ObValue.ServerError, NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: ObValue.Val;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Select));
          StubLib.OutRef(c, label_arg);
          StubLib.OutInteger(c, ORD(internal_arg));
          StubLib.OutInteger(c, hint_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            hint_arg := StubLib.InInteger(c, rep);
            res := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_Error) =&gt;
            VAR arg: ObValue.ErrorPacket;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(ObValue.ErrorPacket));
              reuse := TRUE;
              RAISE ObValue.Error(arg);

            END;
          | ORD(ReturnCodes.ObValue_Exception) =&gt;
            VAR arg: ObValue.ExceptionPacket;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(ObValue.ExceptionPacket));
              reuse := TRUE;
              RAISE ObValue.Exception(arg);

            END;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Select;

  PROCEDURE <A NAME="Surrogate_Invoke"><procedure>Surrogate_Invoke</procedure></A>(
      self: ObValue.RemObj;
      label_arg: TEXT;
      argNo_arg: INTEGER;
      READONLY args_arg: ObValue.Vals;
      internal_arg: BOOLEAN;
      VAR hint_arg: INTEGER): ObValue.Val RAISES {ObValue.Error,
      ObValue.Exception, ObValue.ServerError, NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: ObValue.Val;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Invoke));
          StubLib.OutRef(c, label_arg);
          StubLib.OutInteger(c, argNo_arg);
          StubLib.OutInteger(c, NUMBER(args_arg));
          dataPresent := TRUE;
          StubLib.OutBoolean(c, dataPresent);
          IF dataPresent THEN
            FOR n1 := 0 TO LAST(args_arg) DO
              StubLib.OutRef(c, args_arg[n1]);
              END;
            END;
            StubLib.OutInteger(c, ORD(internal_arg));
          StubLib.OutInteger(c, hint_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            hint_arg := StubLib.InInteger(c, rep);
            res := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_Error) =&gt;
            VAR arg: ObValue.ErrorPacket;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(ObValue.ErrorPacket));
              reuse := TRUE;
              RAISE ObValue.Error(arg);

            END;
          | ORD(ReturnCodes.ObValue_Exception) =&gt;
            VAR arg: ObValue.ExceptionPacket;
            BEGIN
              arg := StubLib.InRef(c, rep, TYPECODE(ObValue.ExceptionPacket));
              reuse := TRUE;
              RAISE ObValue.Exception(arg);

            END;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Invoke;

  PROCEDURE <A NAME="Surrogate_Update"><procedure>Surrogate_Update</procedure></A>(
      self: ObValue.RemObj;
      label_arg: TEXT;
      val_arg: ObValue.Val;
      internal_arg: BOOLEAN;
      VAR hint_arg: INTEGER) RAISES {ObValue.ServerError, NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Update));
          StubLib.OutRef(c, label_arg);
          StubLib.OutRef(c, val_arg);
          StubLib.OutInteger(c, ORD(internal_arg));
          StubLib.OutInteger(c, hint_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            hint_arg := StubLib.InInteger(c, rep);
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_Update;

  PROCEDURE <A NAME="Surrogate_Redirect"><procedure>Surrogate_Redirect</procedure></A>(
      self: ObValue.RemObj;
      val_arg: ObValue.Val;
      internal_arg: BOOLEAN) RAISES {ObValue.ServerError, NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Redirect));
          StubLib.OutRef(c, val_arg);
          StubLib.OutInteger(c, ORD(internal_arg));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_Redirect;

  PROCEDURE <A NAME="Surrogate_Has"><procedure>Surrogate_Has</procedure></A>(
      self: ObValue.RemObj;
      label_arg: TEXT;
      VAR hint_arg: INTEGER): BOOLEAN RAISES {NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: BOOLEAN;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Has));
          StubLib.OutRef(c, label_arg);
          StubLib.OutInteger(c, hint_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            hint_arg := StubLib.InInteger(c, rep);
            res := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Has;

  PROCEDURE <A NAME="Surrogate_Obtain"><procedure>Surrogate_Obtain</procedure></A>(self: ObValue.RemObj; internal_arg: BOOLEAN)
      : REF ObValue.ObjFields RAISES {ObValue.ServerError, NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: REF ObValue.ObjFields;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Obtain));
          StubLib.OutInteger(c, ORD(internal_arg));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, -1);
            reuse := TRUE;
          | ORD(ReturnCodes.ObValue_ServerError) =&gt;
            VAR arg: TEXT;
            BEGIN
              arg := StubLib.InRef(c, rep, -1);
              reuse := TRUE;
              RAISE ObValue.ServerError(arg);

            END;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Obtain;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, ObValue.RemObj);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.Who) =&gt; Stub_Who(t, c, rep);
      | ORD(Methods.Select) =&gt; Stub_Select(t, c, rep);
      | ORD(Methods.Invoke) =&gt; Stub_Invoke(t, c, rep);
      | ORD(Methods.Update) =&gt; Stub_Update(t, c, rep);
      | ORD(Methods.Redirect) =&gt; Stub_Redirect(t, c, rep);
      | ORD(Methods.Has) =&gt; Stub_Has(t, c, rep);
      | ORD(Methods.Obtain) =&gt; Stub_Obtain(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    | ObValue.ServerError(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.ObValue_ServerError));
        StubLib.OutRef(c, arg);

    | ObValue.Exception(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.ObValue_Exception));
        StubLib.OutRef(c, arg);

    | ObValue.Error(arg) =&gt;
        StubLib.StartResult(c);
        StubLib.OutInt32(c, ORD(ReturnCodes.ObValue_Error));
        StubLib.OutRef(c, arg);
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_Who"><procedure>Stub_Who</procedure></A>(
    self: ObValue.RemObj;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR protected_arg: BOOLEAN;
      serialized_arg: BOOLEAN;
      res: TEXT;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    protected_arg := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
    serialized_arg := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
    res := self.Who(protected_arg, serialized_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutInteger(c, ORD(protected_arg));
    StubLib.OutInteger(c, ORD(serialized_arg));
    StubLib.OutRef(c, res);

  END Stub_Who;

PROCEDURE <A NAME="Stub_Select"><procedure>Stub_Select</procedure></A>(
    self: ObValue.RemObj;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.Error, ObValue.Exception,
    ObValue.ServerError}=
  VAR label_arg: TEXT;
      internal_arg: BOOLEAN;
      hint_arg: INTEGER;
      res: ObValue.Val;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    label_arg := StubLib.InRef(c, rep, -1);
    internal_arg := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
    hint_arg := StubLib.InInteger(c, rep);
    res := self.Select(label_arg, internal_arg, hint_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutInteger(c, hint_arg);
    StubLib.OutRef(c, res);

  END Stub_Select;

PROCEDURE <A NAME="Stub_Invoke"><procedure>Stub_Invoke</procedure></A>(
    self: ObValue.RemObj;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.Error, ObValue.Exception,
    ObValue.ServerError}=
  VAR label_arg: TEXT;
      argNo_arg: INTEGER;
      args_arg: REF ObValue.Vals;
      internal_arg: BOOLEAN;
      hint_arg: INTEGER;
      res: ObValue.Val;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    label_arg := StubLib.InRef(c, rep, -1);
    argNo_arg := StubLib.InInteger(c, rep);
    WITH n1 = StubLib.InInteger(c, rep) DO
      args_arg := NEW(REF ObValue.Vals, n1);
    END;
    dataPresent := StubLib.InBoolean(c);
    IF dataPresent THEN
      FOR n1 := 0 TO LAST(args_arg^) DO
        args_arg[n1] := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
        END;
      END;
      internal_arg := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
    hint_arg := StubLib.InInteger(c, rep);
    res := self.Invoke(label_arg, argNo_arg, args_arg^, internal_arg, hint_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutInteger(c, hint_arg);
    StubLib.OutRef(c, res);

  END Stub_Invoke;

PROCEDURE <A NAME="Stub_Update"><procedure>Stub_Update</procedure></A>(
    self: ObValue.RemObj;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.ServerError}=
  VAR label_arg: TEXT;
      val_arg: ObValue.Val;
      internal_arg: BOOLEAN;
      hint_arg: INTEGER;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    label_arg := StubLib.InRef(c, rep, -1);
    val_arg := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
    internal_arg := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
    hint_arg := StubLib.InInteger(c, rep);
    self.Update(label_arg, val_arg, internal_arg, hint_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutInteger(c, hint_arg);

  END Stub_Update;

PROCEDURE <A NAME="Stub_Redirect"><procedure>Stub_Redirect</procedure></A>(
    self: ObValue.RemObj;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.ServerError}=
  VAR val_arg: ObValue.Val;
      internal_arg: BOOLEAN;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    val_arg := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
    internal_arg := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
    self.Redirect(val_arg, internal_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_Redirect;

PROCEDURE <A NAME="Stub_Has"><procedure>Stub_Has</procedure></A>(
    self: ObValue.RemObj;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR label_arg: TEXT;
      hint_arg: INTEGER;
      res: BOOLEAN;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    label_arg := StubLib.InRef(c, rep, -1);
    hint_arg := StubLib.InInteger(c, rep);
    res := self.Has(label_arg, hint_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutInteger(c, hint_arg);
    StubLib.OutInteger(c, ORD(res));

  END Stub_Has;

PROCEDURE <A NAME="Stub_Obtain"><procedure>Stub_Obtain</procedure></A>(
    self: ObValue.RemObj;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted, ObValue.ServerError}=
  VAR internal_arg: BOOLEAN;
      res: REF ObValue.ObjFields;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    internal_arg := VAL(StubLib.InInteger(c, rep, 0,1), BOOLEAN);
    res := self.Obtain(internal_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_Obtain;

BEGIN
  StubLib.Register(TYPECODE(ObValue.RemObj), 1, TYPECODE(Surrogate_ObValue_RemObj), Invoke);
END ObValue_RemObj_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
