<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/derived/ObValue_RemVar_v1.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/derived/ObValue_RemVar_v1.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>ObValue_RemVar_v1</module> EXPORTS <A HREF="../src/ObValue.i3"><implements>ObValue</A></implements>, <A HREF="ObValue_RemVar_v1.i3"><implements>ObValue_RemVar_v1</A></implements>;

IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../src/ObValue.i3">ObValue</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;
CONST Protocol: StubLib.StubProtocol = 1;

TYPE
      Methods = {Set, Get};
      ReturnCodes = {OK};

  PROCEDURE <A NAME="Surrogate_Get"><procedure>Surrogate_Get</procedure></A>(self: ObValue.RemVar): ObValue.Val
       RAISES {NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;
        res: ObValue.Val;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Get));
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            res := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
      RETURN res;
    END Surrogate_Get;

  PROCEDURE <A NAME="Surrogate_Set"><procedure>Surrogate_Set</procedure></A>(self: ObValue.RemVar; val_arg: ObValue.Val)
       RAISES {NetObj.Error} =

    VAR reuse := FALSE;
        rep: StubLib.DataRep;
        c: StubLib.Conn;
        dataPresent: BOOLEAN; &lt;* NOWARN *&gt;

    BEGIN
      TRY
        c := StubLib.StartCall(self, Protocol);
        TRY
          StubLib.OutInt32(c, ORD(Methods.Set));
          StubLib.OutRef(c, val_arg);
          rep := StubLib.AwaitResult(c);
          CASE StubLib.InInt32(c, rep) OF
          | ORD(ReturnCodes.OK) =&gt;
            reuse := TRUE;
          ELSE
            StubLib.RaiseUnmarshalFailure();
          END
        FINALLY
          StubLib.EndCall(c, reuse);
        END;

      EXCEPT
      | Rd.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      | Wr.Failure(ec) =&gt; StubLib.RaiseCommFailure(ec);
      END;
    END Surrogate_Set;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A>(
    c: StubLib.Conn;
    obj: NetObj.T;
    rep: StubLib.DataRep;
    stubProt: StubLib.StubProtocol)
    RAISES {NetObj.Error, Rd.Failure,
            Wr.Failure, Thread.Alerted} =
  VAR t := NARROW(obj, ObValue.RemVar);
  BEGIN
    IF stubProt # Protocol THEN StubLib.RaiseUnmarshalFailure() END;
    TRY
      CASE StubLib.InInt32(c, rep) OF
      | ORD(Methods.Get) =&gt; Stub_Get(t, c, rep);
      | ORD(Methods.Set) =&gt; Stub_Set(t, c, rep);
      ELSE
        StubLib.RaiseUnmarshalFailure();
      END;
    EXCEPT
    END;
  END Invoke;

PROCEDURE <A NAME="Stub_Get"><procedure>Stub_Get</procedure></A>(
    self: ObValue.RemVar;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR res: ObValue.Val;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    res := self.Get();
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));
    StubLib.OutRef(c, res);

  END Stub_Get;

PROCEDURE <A NAME="Stub_Set"><procedure>Stub_Set</procedure></A>(
    self: ObValue.RemVar;
    c: StubLib.Conn;
    &lt;* NOWARN *&gt; rep: StubLib.DataRep) RAISES {NetObj.Error, Rd.Failure,
    Wr.Failure, Thread.Alerted}=
  VAR val_arg: ObValue.Val;
      dataPresent: BOOLEAN &lt;* NOWARN *&gt;;

  BEGIN
    val_arg := StubLib.InRef(c, rep, TYPECODE(ObValue.Val));
    self.Set(val_arg);
    StubLib.StartResult(c);
    StubLib.OutInt32(c, ORD(ReturnCodes.OK));

  END Stub_Set;

BEGIN
  StubLib.Register(TYPECODE(ObValue.RemVar), 1, TYPECODE(Surrogate_ObValue_RemVar), Invoke);
END ObValue_RemVar_v1.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
