<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/ObBuiltIn.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/ObBuiltIn.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObBuiltIn.i3">ObBuiltIn</A></implements></module>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../fmtlex/src/Lex.i3">Lex</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="ObLib.i3">ObLib</A>, <A HREF="ObValue.i3">ObValue</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>,
<A HREF="../../text/src/TextConv.i3">TextConv</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../params/src/Env.i3">Env</A>, <A HREF="../../params/src/Params.i3">Params</A>, <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="ObEval.i3">ObEval</A>, <A HREF="#x1">FloatMode</A>;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
    SetupSys();
    SetupBool();
    SetupInt();
    SetupReal(); (* after Int, so real_+ etc. have precedence *)
    SetupMath();
    SetupAscii();
    SetupText();
    SetupArray();
    SetupNet();
    SetupThread();
  END Setup;
</PRE> ============ <CODE>sys</CODE> package ============ 

<P><PRE>TYPE

  SysCode =
    {Address, GetEnvVar, GetParamCount, GetParam, CallFailure, Call, Copy};

  SysOpCode =
    ObLib.OpCode OBJECT
        code: SysCode;
      END;

  PackageSys =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalSys;
      END;

  PROCEDURE <A NAME="NewSysOC"><procedure>NewSysOC</procedure></A>(name: TEXT; arity: INTEGER; code: SysCode;
    fixity: ObLib.OpFixity:=ObLib.OpFixity.Qualified): SysOpCode =
  BEGIN
    RETURN NEW(SysOpCode, name:=name, arity:=arity, code:=code,
      fixity:=fixity);
  END NewSysOC;

  PROCEDURE <A NAME="SetupSys"><procedure>SetupSys</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(SysCode));
    opCodes^ :=
      OpCodes{
      NewSysOC(&quot;address&quot;, -1, SysCode.Address),
      NewSysOC(&quot;getEnvVar&quot;, 1, SysCode.GetEnvVar),
      NewSysOC(&quot;paramCount&quot;, -1, SysCode.GetParamCount),
      NewSysOC(&quot;getParam&quot;, 1, SysCode.GetParam),
      NewSysOC(&quot;callFailure&quot;, -1, SysCode.CallFailure),
      NewSysOC(&quot;call&quot;, 2, SysCode.Call),
      NewSysOC(&quot;copy&quot;, 1, SysCode.Copy, ObLib.OpFixity.Prefix)
      };
    ObLib.Register(
      NEW(PackageSys, name:=&quot;sys&quot;, opCodes:=opCodes));
  END SetupSys;

  PROCEDURE <A NAME="EvalSys"><procedure>EvalSys</procedure></A>(self: PackageSys; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR int1: INTEGER; text1, text2: TEXT; array1: REF ObValue.Vals;
        sysProc: ObValue.SysCallClosure;
    BEGIN
      TRY
      CASE NARROW(opCode, SysOpCode).code OF
      | SysCode.Address =&gt;
          RETURN ObValue.NewText(ObValue.machineAddress);
      | SysCode.GetEnvVar =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          text2 := Env.Get(text1);
          RETURN ObValue.NewText(text2);
      | SysCode.GetParamCount =&gt;
          RETURN NEW(ObValue.ValInt, int:=Params.Count, temp:=temp);
      | SysCode.GetParam =&gt;
          TYPECASE args[1] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(1, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF (int1&lt;0) OR (int1&gt;=Params.Count) THEN
            ObValue.BadArgVal(1, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          RETURN ObValue.NewText(Params.Get(int1));
      | SysCode.CallFailure =&gt;
          RETURN ObValue.sysCallFailure;
      | SysCode.Call =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF
          | ObValue.ValArray(node) =&gt; array1:=node.remote.Obtain();
          ELSE ObValue.BadArgType(2, &quot;array&quot;, self.name, opCode.name, loc) END;
          IF NOT ObValue.FetchSysCall(text1, (*out*)sysProc)
          THEN ObValue.RaiseException(ObValue.sysCallFailure,
              self.name&amp;&quot;_&quot;&amp;opCode.name&amp;&quot;: \&quot;&quot;&amp;text1&amp;&quot;\&quot; not found&quot;, loc);
          END;
          RETURN sysProc.SysCall(array1^, loc);
      | SysCode.Copy =&gt;
          RETURN ObValue.CopyVal(args[1], ObValue.NewTbl(), loc);
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
      EXCEPT
      | NetObj.Error(atoms) =&gt;
          ObValue.RaiseNetException(self.name&amp;&quot;_&quot;&amp;opCode.name, atoms, loc);
      END;
    END EvalSys;
</PRE> ============ <CODE>bool</CODE> package ============ 

<P><PRE>TYPE

  BoolCode = {Is, IsNot, Not, And, Or};

  BoolOpCode =
    ObLib.OpCode OBJECT
        code: BoolCode;
      END;

  PackageBool =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalBool;
      END;

  PROCEDURE <A NAME="NewBoolOC"><procedure>NewBoolOC</procedure></A>(name: TEXT; arity: INTEGER; code: BoolCode;
    fixity: ObLib.OpFixity:=ObLib.OpFixity.Qualified): BoolOpCode =
  BEGIN
    RETURN NEW(BoolOpCode, name:=name, arity:=arity, code:=code,
      fixity:=fixity);
  END NewBoolOC;

  VAR true, false: ObValue.ValBool;

  PROCEDURE <A NAME="SetupBool"><procedure>SetupBool</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(BoolCode));
    opCodes^ :=
      OpCodes{
      NewBoolOC(&quot;not&quot;, 1, BoolCode.Not, ObLib.OpFixity.Prefix),
      NewBoolOC(&quot;and&quot;, 2, BoolCode.And, ObLib.OpFixity.Infix),
      NewBoolOC(&quot;or&quot;, 2, BoolCode.Or, ObLib.OpFixity.Infix),
      NewBoolOC(&quot;is&quot;, 2, BoolCode.Is, ObLib.OpFixity.Infix),
      NewBoolOC(&quot;isnot&quot;, 2, BoolCode.IsNot, ObLib.OpFixity.Infix)
      };
    ObLib.Register(
      NEW(PackageBool, name:=&quot;bool&quot;, opCodes:=opCodes));
    true := NEW(ObValue.ValBool, bool:=TRUE);
    false := NEW(ObValue.ValBool, bool:=FALSE);
  END SetupBool;

  PROCEDURE <A NAME="EvalBool"><procedure>EvalBool</procedure></A>(self: PackageBool; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR bool1, bool2: BOOLEAN;
    BEGIN
      CASE NARROW(opCode, BoolOpCode).code OF
      | BoolCode.Not =&gt;
          TYPECASE args[1] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(1, &quot;bool&quot;, self.name, opCode.name, loc); END;
          IF NOT bool1 THEN RETURN true ELSE RETURN false END;
      | BoolCode.And =&gt;
          TYPECASE args[1] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(1, &quot;bool&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValBool(node) =&gt; bool2:=node.bool;
          ELSE ObValue.BadArgType(2, &quot;bool&quot;, self.name, opCode.name, loc); END;
	  IF bool1 AND bool2 THEN RETURN true ELSE RETURN false END;
      | BoolCode.Or =&gt;
          TYPECASE args[1] OF | ObValue.ValBool(node) =&gt; bool1:=node.bool;
          ELSE ObValue.BadArgType(1, &quot;bool&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValBool(node) =&gt; bool2:=node.bool;
          ELSE ObValue.BadArgType(2, &quot;bool&quot;, self.name, opCode.name, loc); END;
	  IF bool1 OR bool2 THEN RETURN true ELSE RETURN false END;
      | BoolCode.Is =&gt;
	  IF ObValue.Is(args[1], args[2], loc)
	  THEN RETURN true ELSE RETURN false END;
      | BoolCode.IsNot =&gt;
	  IF NOT ObValue.Is(args[1], args[2], loc)
	  THEN RETURN true ELSE RETURN false END;
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
    END EvalBool;
</PRE> ============ <CODE>int</CODE> package ============ 

<P><PRE>TYPE

  IntCode = {Minus, Add, Sub, Mult, Div, Mod, Less, More, LessEq, MoreEq};

  IntOpCode =
    ObLib.OpCode OBJECT
        code: IntCode;
      END;

  PackageInt =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalInt;
      END;

  PROCEDURE <A NAME="NewIntOC"><procedure>NewIntOC</procedure></A>(name: TEXT; arity: INTEGER; code: IntCode;
    fixity: ObLib.OpFixity:=ObLib.OpFixity.Qualified): IntOpCode =
  BEGIN
    RETURN NEW(IntOpCode, name:=name, arity:=arity, code:=code,
      fixity:=fixity);
  END NewIntOC;

  PROCEDURE <A NAME="SetupInt"><procedure>SetupInt</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(IntCode));
    opCodes^ :=
      OpCodes{
      NewIntOC(&quot;minus&quot;, 1, IntCode.Minus),
      NewIntOC(&quot;+&quot;, 2, IntCode.Add),
      NewIntOC(&quot;-&quot;, 2, IntCode.Sub),
      NewIntOC(&quot;*&quot;, 2, IntCode.Mult),
      NewIntOC(&quot;/&quot;, 2, IntCode.Div),
      NewIntOC(&quot;%&quot;, 2, IntCode.Mod, ObLib.OpFixity.Infix),
      NewIntOC(&quot;&lt;&quot;, 2, IntCode.Less),
      NewIntOC(&quot;&gt;&quot;, 2, IntCode.More),
      NewIntOC(&quot;&lt;=&quot;, 2, IntCode.LessEq),
      NewIntOC(&quot;&gt;=&quot;, 2, IntCode.MoreEq)
      };
    ObLib.Register(
      NEW(PackageInt, name:=&quot;int&quot;, opCodes:=opCodes));
  END SetupInt;

  PROCEDURE <A NAME="EvalInt"><procedure>EvalInt</procedure></A>(self: PackageInt; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR int1, int2: INTEGER; intCode: IntCode;
	intRes, intVal1, intVal2: ObValue.ValInt;
    BEGIN
      intCode := NARROW(opCode, IntOpCode).code;
      TYPECASE args[1] OF | ObValue.ValInt(node) =&gt;
	intVal1 := node; int1:=node.int;
      ELSE ObValue.BadArgType(1, &quot;int&quot;, self.name, opCode.name, loc); END;
      CASE intCode OF
      | IntCode.Minus =&gt; RETURN NEW(ObValue.ValInt, int:= -int1, temp:=temp);
      | IntCode.Add, IntCode.Sub, IntCode.Mult, IntCode.Div, IntCode.Mod,
        IntCode.Less, IntCode.More, IntCode.LessEq, IntCode.MoreEq =&gt;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt;
	    intVal2 := node; int2:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          CASE intCode OF
          | IntCode.Add =&gt;
		     RETURN NEW(ObValue.ValInt, int:=int1+int2, temp:=temp);
          | IntCode.Sub =&gt;
		    RETURN NEW(ObValue.ValInt, int:=int1-int2, temp:=temp);
          | IntCode.Mult =&gt;
		    RETURN NEW(ObValue.ValInt, int:=int1*int2, temp:=temp);
          | IntCode.Div =&gt;
              IF int2=0 THEN
                ObValue.BadArgVal(2, &quot;non-zero&quot;, self.name, opCode.name, loc);
              ELSE RETURN NEW(ObValue.ValInt, int:=int1 DIV int2, temp:=temp);
	      END;
          | IntCode.Mod =&gt;
              IF int2=0 THEN
                ObValue.BadArgVal(2, &quot;non-zero&quot;, self.name, opCode.name, loc);
              ELSE
	        IF intVal1.temp THEN intRes:=intVal1;
	        ELSIF intVal2.temp THEN intRes:=intVal2;
	        ELSE intRes:=NEW(ObValue.ValInt); END;
	        intRes.temp := temp;
	        intRes.int := int1 MOD int2;
	        RETURN intRes;
	      END;
          | IntCode.Less =&gt; RETURN NEW(ObValue.ValBool, bool:=int1&lt;int2);
          | IntCode.More =&gt; RETURN NEW(ObValue.ValBool, bool:=int1&gt;int2);
          | IntCode.LessEq =&gt; RETURN NEW(ObValue.ValBool, bool:=int1&lt;=int2);
          | IntCode.MoreEq =&gt; RETURN NEW(ObValue.ValBool, bool:=int1&gt;=int2);
          END;
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
    END EvalInt;
</PRE> ============ <CODE>real</CODE> package ============ 

<P><PRE>TYPE

  RealCode =
    {Minus, Add, Sub, Mult, Div, Less, More, LessEq, MoreEq,
     Round, Float, Floor, Ceiling};

  RealOpCode =
    ObLib.OpCode OBJECT
        code: RealCode;
      END;

  PackageReal =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalReal;
      END;

  PROCEDURE <A NAME="NewRealOC"><procedure>NewRealOC</procedure></A>(name: TEXT; arity: INTEGER; code: RealCode;
    fixity: ObLib.OpFixity:=ObLib.OpFixity.Qualified): RealOpCode =
  BEGIN
    RETURN NEW(RealOpCode, name:=name, arity:=arity, code:=code,
      fixity:=fixity);
  END NewRealOC;

  PROCEDURE <A NAME="SetupReal"><procedure>SetupReal</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(RealCode));
    opCodes^ :=
      OpCodes{
      NewRealOC(&quot;minus&quot;, 1, RealCode.Minus),
      NewRealOC(&quot;+&quot;, 2, RealCode.Add, ObLib.OpFixity.Infix),
      NewRealOC(&quot;-&quot;, 2, RealCode.Sub, ObLib.OpFixity.Infix),
      NewRealOC(&quot;*&quot;, 2, RealCode.Mult, ObLib.OpFixity.Infix),
      NewRealOC(&quot;/&quot;, 2, RealCode.Div, ObLib.OpFixity.Infix),
      NewRealOC(&quot;&lt;&quot;, 2, RealCode.Less, ObLib.OpFixity.Infix),
      NewRealOC(&quot;&gt;&quot;, 2, RealCode.More, ObLib.OpFixity.Infix),
      NewRealOC(&quot;&lt;=&quot;, 2, RealCode.LessEq, ObLib.OpFixity.Infix),
      NewRealOC(&quot;&gt;=&quot;, 2, RealCode.MoreEq, ObLib.OpFixity.Infix),
      NewRealOC(&quot;round&quot;, 1, RealCode.Round, ObLib.OpFixity.Prefix),
      NewRealOC(&quot;float&quot;, 1, RealCode.Float, ObLib.OpFixity.Prefix),
      NewRealOC(&quot;floor&quot;, 1, RealCode.Floor),
      NewRealOC(&quot;ceiling&quot;, 1, RealCode.Ceiling)
      };
    ObLib.Register(
      NEW(PackageReal, name:=&quot;real&quot;, opCodes:=opCodes));
  END SetupReal;

  PROCEDURE <A NAME="EvalReal"><procedure>EvalReal</procedure></A>(self: PackageReal; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR realRes, realVal1, realVal2: ObValue.ValReal; real1, real2: LONGREAL;
	intRes, intVal1, intVal2: ObValue.ValInt; int1, int2: INTEGER;
	realCode: RealCode; isReal1, isReal2: BOOLEAN;
    BEGIN
      realCode := NARROW(opCode, RealOpCode).code;
      TYPECASE args[1] OF
      | ObValue.ValReal(node) =&gt;
	  realVal1 := node; real1:=node.real; isReal1:=TRUE;
      | ObValue.ValInt(node) =&gt;
	  intVal1 := node; int1:=node.int; isReal1:=FALSE;
      ELSE
        ObValue.BadArgType(1, &quot;real or int&quot;, self.name, opCode.name, loc);
      END;
      CASE realCode OF
      | RealCode.Minus =&gt;
          IF isReal1 THEN
	    IF realVal1.temp THEN realRes:=realVal1;
	    ELSE realRes:=NEW(ObValue.ValReal); END;
	    realRes.temp := temp;
	    realRes.real := -real1;
	    RETURN realRes;
          ELSE
	    IF intVal1.temp THEN intRes:=intVal1;
	    ELSE intRes:=NEW(ObValue.ValInt); END;
	    intRes.temp := temp;
	    intRes.int := -int1;
	    RETURN intRes;
	  END;
      | RealCode.Float =&gt;
          IF isReal1 THEN
	    IF realVal1.temp THEN realVal1.temp := temp; END;
	    RETURN realVal1;
          ELSE RETURN
		NEW(ObValue.ValReal, real:=FLOAT(int1, LONGREAL), temp:=temp);
	  END;
      | RealCode.Round =&gt;
          IF isReal1 THEN
	    RETURN NEW(ObValue.ValInt, int:=ROUND(real1), temp:=temp);
          ELSE
	    IF intVal1.temp THEN intVal1.temp := temp END;
	    RETURN intVal1;
	  END;
      | RealCode.Floor =&gt;
          IF isReal1 THEN
	    RETURN NEW(ObValue.ValInt, int:=FLOOR(real1), temp:=temp);
          ELSE
	    IF intVal1.temp THEN intVal1.temp := temp END;
	    RETURN intVal1;
	  END;
      | RealCode.Ceiling =&gt;
          IF isReal1 THEN
	    RETURN NEW(ObValue.ValInt, int:=CEILING(real1), temp:=temp);
          ELSE
	    IF intVal1.temp THEN intVal1.temp := temp END;
	    RETURN intVal1;
	  END;
      | RealCode.Add, RealCode.Sub, RealCode.Mult, RealCode.Div =&gt;
          TYPECASE args[2] OF
          | ObValue.ValReal(node) =&gt;
	      realVal2 := node; real2:=node.real; isReal2:=TRUE;
          | ObValue.ValInt(node) =&gt;
	      intVal2 := node; int2:=node.int; isReal2:=FALSE;
          ELSE
            ObValue.BadArgType(2, &quot;real or int&quot;, self.name, opCode.name, loc);
          END;
          IF isReal1 # isReal2 THEN
            IF isReal1 THEN
              ObValue.BadArgType(2, &quot;real (like argument 1)&quot;,
                               self.name, opCode.name, loc);
            ELSE
              ObValue.BadArgType(2, &quot;int (like argument 1)&quot;,
                               self.name, opCode.name, loc);
            END;
          END;
          IF isReal1 THEN
	    IF realVal1.temp THEN realRes:=realVal1;
	    ELSIF realVal2.temp THEN realRes:=realVal2;
	    ELSE realRes:=NEW(ObValue.ValReal); END;
	    realRes.temp := temp;
	  ELSE
	    IF intVal1.temp THEN intRes:=intVal1;
	    ELSIF intVal2.temp THEN intRes:=intVal2;
	    ELSE intRes:=NEW(ObValue.ValInt); END;
	    intRes.temp := temp;
	  END;
          CASE realCode OF
          | RealCode.Add =&gt;
              IF isReal1 THEN
		realRes.real:=real1+real2; RETURN realRes;
              ELSE
		intRes.int := int1+int2; RETURN intRes;
	      END;
          | RealCode.Sub =&gt;
              IF isReal1 THEN
		realRes.real:=real1-real2;RETURN realRes;
              ELSE
		intRes.int := int1-int2; RETURN intRes;
	      END;
          | RealCode.Mult =&gt;
              IF isReal1 THEN
		realRes.real:=real1*real2; RETURN realRes;
              ELSE
		intRes.int := int1*int2; RETURN intRes;
	      END;
          | RealCode.Div =&gt;
              IF isReal1 THEN
                IF real2=0.0d0 THEN
                  ObValue.BadArgVal(2, &quot;a non-zero real&quot;,
                                    self.name, opCode.name, loc)
                ELSE
	  	  realRes.real:=real1/real2; RETURN realRes;
		END;
              ELSE
                IF int2=0 THEN
                  ObValue.BadArgVal(2, &quot;a non-zero int&quot;,
                                    self.name, opCode.name, loc)
                ELSE
	  	  intRes.int := int1 DIV int2; RETURN intRes;
	        END;
              END;
            ELSE &lt;*ASSERT FALSE*&gt;
	    END;
      | RealCode.Less, RealCode.More, RealCode.LessEq, RealCode.MoreEq =&gt;
          TYPECASE args[2] OF
          | ObValue.ValReal(node) =&gt; real2:=node.real; isReal2:=TRUE;
          | ObValue.ValInt(node) =&gt; int2:=node.int; isReal2:=FALSE;
          ELSE
            ObValue.BadArgType(2, &quot;real or int&quot;, self.name, opCode.name, loc);
          END;
          IF isReal1 # isReal2 THEN
            IF isReal1 THEN
              ObValue.BadArgType(2, &quot;real (like argument 1)&quot;,
                               self.name, opCode.name, loc);
            ELSE
              ObValue.BadArgType(2, &quot;int (like argument 1)&quot;,
                               self.name, opCode.name, loc);
            END;
          END;
          CASE realCode OF
          | RealCode.Less =&gt;
              IF isReal1 THEN
		IF real1&lt;real2 THEN RETURN true ELSE RETURN false END
              ELSE
		IF int1&lt;int2 THEN RETURN true ELSE RETURN false END
	      END;
          | RealCode.More =&gt;
              IF isReal1 THEN
		IF real1&gt;real2 THEN RETURN true ELSE RETURN false END
              ELSE
		IF int1&gt;int2 THEN RETURN true ELSE RETURN false END
	      END;
          | RealCode.LessEq =&gt;
              IF isReal1 THEN
		IF real1&lt;=real2 THEN RETURN true ELSE RETURN false END
              ELSE
		IF int1&lt;=int2 THEN RETURN true ELSE RETURN false END
	      END;
          | RealCode.MoreEq =&gt;
              IF isReal1 THEN
		IF real1&gt;=real2 THEN RETURN true ELSE RETURN false END
              ELSE
		IF int1&gt;=int2 THEN RETURN true ELSE RETURN false END
	      END;
          ELSE &lt;*ASSERT FALSE*&gt;
          END;
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
    END EvalReal;
</PRE> ============ <CODE>math</CODE> package ============ 

<P><PRE>TYPE

  MathCode =
    {Pi, E, Degree, Exp, Log, Sqrt, Pow, Cos, Sin, Tan, Acos,
     Asin, Atan, Atan2, Hypot};

  MathOpCode =
    ObLib.OpCode OBJECT
        code: MathCode;
      END;

  PackageMath =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalMath;
      END;

  VAR MathPi, MathE, MathDegree: ObValue.Val;

  PROCEDURE <A NAME="NewMathOC"><procedure>NewMathOC</procedure></A>(name: TEXT; arity: INTEGER; code: MathCode)
    : MathOpCode =
  BEGIN
    RETURN NEW(MathOpCode, name:=name, arity:=arity, code:=code);
  END NewMathOC;

  PROCEDURE <A NAME="SetupMath"><procedure>SetupMath</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(MathCode));
    opCodes^ :=
      OpCodes{
      NewMathOC(&quot;pi&quot;, -1, MathCode.Pi),
      NewMathOC(&quot;e&quot;, -1, MathCode.E),
      NewMathOC(&quot;degree&quot;, -1, MathCode.Degree),
      NewMathOC(&quot;exp&quot;, 1, MathCode.Exp),
      NewMathOC(&quot;log&quot;, 1, MathCode.Log),
      NewMathOC(&quot;sqrt&quot;, 1, MathCode.Sqrt),
      NewMathOC(&quot;pow&quot;, 2, MathCode.Pow),
      NewMathOC(&quot;cos&quot;, 1, MathCode.Cos),
      NewMathOC(&quot;sin&quot;, 1, MathCode.Sin),
      NewMathOC(&quot;tan&quot;, 1, MathCode.Tan),
      NewMathOC(&quot;acos&quot;, 1, MathCode.Acos),
      NewMathOC(&quot;asin&quot;, 1, MathCode.Asin),
      NewMathOC(&quot;atan&quot;, 1, MathCode.Atan),
      NewMathOC(&quot;atan2&quot;, 2, MathCode.Atan2),
      NewMathOC(&quot;hypot&quot;, 2, MathCode.Hypot)
      };
    ObLib.Register(
      NEW(PackageMath, name:=&quot;math&quot;, opCodes:=opCodes));
    MathPi :=
      NEW(ObValue.ValReal, real:= FLOAT(Math.Pi, LONGREAL), temp:=FALSE);
    MathE :=
      NEW(ObValue.ValReal, real:= FLOAT(Math.E, LONGREAL), temp:=FALSE);
    MathDegree :=
      NEW(ObValue.ValReal, real:= FLOAT(Math.Degree, LONGREAL), temp:=FALSE);
  END SetupMath;

  PROCEDURE <A NAME="EvalMath"><procedure>EvalMath</procedure></A>(self: PackageMath; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR real1, real2: LONGREAL; realRes, realVal1, realVal2: ObValue.ValReal;
    BEGIN
      CASE NARROW(opCode, MathOpCode).code OF
      | MathCode.Pi =&gt; RETURN MathPi;
      | MathCode.E =&gt; RETURN MathE;
      | MathCode.Degree =&gt; RETURN MathDegree;
      | MathCode.Exp =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt;
	    IF node.temp THEN realRes := node;
	    ELSE realRes := NEW(ObValue.ValReal); END;
	    realRes.temp := temp; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
	  realRes.real := Math.exp(real1);
	  RETURN realRes;
      | MathCode.Log =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt;
	    IF node.temp THEN realRes := node;
	    ELSE realRes := NEW(ObValue.ValReal); END;
	    realRes.temp := temp; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
	  realRes.real := Math.log(real1);
	  RETURN realRes;
      | MathCode.Sqrt =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt;
	    IF node.temp THEN realRes := node;
	    ELSE realRes := NEW(ObValue.ValReal); END;
	    realRes.temp := temp; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
	  realRes.real := Math.sqrt(real1);
	  RETURN realRes;
      | MathCode.Pow =&gt;
          TYPECASE args[1] OF
	  | ObValue.ValReal(node) =&gt; realVal1 := node; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF
	  | ObValue.ValReal(node) =&gt; realVal2 := node; real2:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
	  IF realVal1.temp THEN realRes := realVal1;
	  ELSIF realVal2.temp THEN realRes := realVal2;
	  ELSE realRes := NEW(ObValue.ValReal); END;
	  realRes.temp := temp;
	  realRes.real := Math.pow(real1, real2);
	  RETURN realRes;
      | MathCode.Cos =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt;
	    IF node.temp THEN realRes := node;
	    ELSE realRes := NEW(ObValue.ValReal); END;
	    realRes.temp := temp; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
	  realRes.real := Math.cos(real1);
	  RETURN realRes;
      | MathCode.Sin =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt;
	    IF node.temp THEN realRes := node;
	    ELSE realRes := NEW(ObValue.ValReal); END;
	    realRes.temp := temp; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
	  realRes.real := Math.sin(real1);
	  RETURN realRes;
      | MathCode.Tan =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt;
	    IF node.temp THEN realRes := node;
	    ELSE realRes := NEW(ObValue.ValReal); END;
	    realRes.temp := temp; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
	  realRes.real := Math.tan(real1);
	  RETURN realRes;
      | MathCode.Acos =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt;
	    IF node.temp THEN realRes := node;
	    ELSE realRes := NEW(ObValue.ValReal); END;
	    realRes.temp := temp; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
	  realRes.real := Math.acos(real1);
	  RETURN realRes;
      | MathCode.Asin =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt;
	    IF node.temp THEN realRes := node;
	    ELSE realRes := NEW(ObValue.ValReal); END;
	    realRes.temp := temp; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
	  realRes.real := Math.asin(real1);
	  RETURN realRes;
      | MathCode.Atan =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt;
	    IF node.temp THEN realRes := node;
	    ELSE realRes := NEW(ObValue.ValReal); END;
	    realRes.temp := temp; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
	  realRes.real := Math.atan(real1);
	  RETURN realRes;
      | MathCode.Atan2 =&gt;
          TYPECASE args[1] OF
	  | ObValue.ValReal(node) =&gt; realVal1 := node; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF
	  | ObValue.ValReal(node) =&gt; realVal2 := node; real2:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
	  IF realVal1.temp THEN realRes := realVal1;
	  ELSIF realVal2.temp THEN realRes := realVal2;
	  ELSE realRes := NEW(ObValue.ValReal); END;
	  realRes.temp := temp;
	  realRes.real := Math.atan2(real1, real2);
	  RETURN realRes;
      | MathCode.Hypot =&gt;
          TYPECASE args[1] OF
	  | ObValue.ValReal(node) =&gt; realVal1 := node; real1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF
	  | ObValue.ValReal(node) =&gt; realVal2 := node; real2:=node.real;
          ELSE ObValue.BadArgType(2, &quot;real&quot;, self.name, opCode.name, loc); END;
	  IF realVal1.temp THEN realRes := realVal1;
	  ELSIF realVal2.temp THEN realRes := realVal2;
	  ELSE realRes := NEW(ObValue.ValReal); END;
	  realRes.temp := temp;
	  realRes.real := Math.hypot(real1, real2);
	  RETURN realRes;
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
    END EvalMath;
</PRE> ============ <CODE>ascii</CODE> package ============ 

<P><PRE>TYPE

  AsciiCode = {Char, Val};

  AsciiOpCode =
    ObLib.OpCode OBJECT
        code: AsciiCode;
      END;

  PackageAscii =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalAscii;
      END;

  PROCEDURE <A NAME="NewAsciiOC"><procedure>NewAsciiOC</procedure></A>(name: TEXT; arity: INTEGER; code: AsciiCode)
    : AsciiOpCode =
  BEGIN
    RETURN NEW(AsciiOpCode, name:=name, arity:=arity, code:=code);
  END NewAsciiOC;

  PROCEDURE <A NAME="SetupAscii"><procedure>SetupAscii</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(AsciiCode));
    opCodes^ :=
      OpCodes{
      NewAsciiOC(&quot;char&quot;, 1, AsciiCode.Char),
      NewAsciiOC(&quot;val&quot;, 1, AsciiCode.Val)
      };
    ObLib.Register(
      NEW(PackageAscii, name:=&quot;ascii&quot;, opCodes:=opCodes));
  END SetupAscii;

  PROCEDURE <A NAME="EvalAscii"><procedure>EvalAscii</procedure></A>(self: PackageAscii; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR int1: INTEGER; char1: CHAR;
    BEGIN
      CASE NARROW(opCode, AsciiOpCode).code OF
      | AsciiCode.Char =&gt;
          TYPECASE args[1] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(1, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF (int1&lt;0) OR (int1&gt;255) THEN
            ObValue.BadArgVal(1, &quot;0..255&quot;, self.name, opCode.name, loc);
          END;
          RETURN NEW(ObValue.ValChar, char:=VAL(int1, CHAR));
      | AsciiCode.Val =&gt;
          TYPECASE args[1] OF | ObValue.ValChar(node) =&gt; char1:=node.char;
          ELSE ObValue.BadArgType(1, &quot;char&quot;, self.name, opCode.name, loc); END;
          RETURN NEW(ObValue.ValInt, int:=ORD(char1), temp:=temp);
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
    END EvalAscii;
</PRE> ============ <CODE>text</CODE> package ============ 

<P><PRE>TYPE

  TextCode =
    {New, Empty, Length, Equal, Char, Sub, Cat, Precedes, Encode, Decode, Implode, Explode, Hash, ToInt, FromInt, FindFirstChar, FindLastChar, FindFirst, FindLast, ReplaceAll};

  TextOpCode =
    ObLib.OpCode OBJECT
        code: TextCode;
      END;

  PackageText =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalText;
      END;

  PROCEDURE <A NAME="NewTextOC"><procedure>NewTextOC</procedure></A>(name: TEXT; arity: INTEGER; code: TextCode;
    fixity: ObLib.OpFixity:=ObLib.OpFixity.Qualified): TextOpCode =
  BEGIN
    RETURN NEW(TextOpCode, name:=name, arity:=arity, code:=code,
      fixity:=fixity);
  END NewTextOC;

  PROCEDURE <A NAME="SetupText"><procedure>SetupText</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(TextCode));
    opCodes^ :=
      OpCodes{
      NewTextOC(&quot;new&quot;, 2, TextCode.New),
      NewTextOC(&quot;empty&quot;, 1, TextCode.Empty),
      NewTextOC(&quot;length&quot;, 1, TextCode.Length),
      NewTextOC(&quot;equal&quot;, 2, TextCode.Equal),
      NewTextOC(&quot;char&quot;, 2, TextCode.Char),
      NewTextOC(&quot;sub&quot;, 3, TextCode.Sub),
      NewTextOC(&quot;&amp;&quot;, 2, TextCode.Cat, ObLib.OpFixity.Infix),
      NewTextOC(&quot;precedes&quot;, 2, TextCode.Precedes),
      NewTextOC(&quot;encode&quot;, 1, TextCode.Encode),
      NewTextOC(&quot;decode&quot;, 1, TextCode.Decode),
      NewTextOC(&quot;implode&quot;, 2, TextCode.Implode),
      NewTextOC(&quot;explode&quot;, 2, TextCode.Explode),
      NewTextOC(&quot;hash&quot;, 1, TextCode.Hash),
      NewTextOC(&quot;toInt&quot;, 1, TextCode.ToInt),
      NewTextOC(&quot;fromInt&quot;, 1, TextCode.FromInt),
      NewTextOC(&quot;findFirstChar&quot;, 3, TextCode.FindFirstChar),
      NewTextOC(&quot;findLastChar&quot;, 3, TextCode.FindLastChar),
      NewTextOC(&quot;findFirst&quot;, 3, TextCode.FindFirst),
      NewTextOC(&quot;findLast&quot;, 3, TextCode.FindLast),
      NewTextOC(&quot;replaceAll&quot;, 3, TextCode.ReplaceAll)
      };
    ObLib.Register(
      NEW(PackageText, name:=&quot;text&quot;, opCodes:=opCodes));
  END SetupText;

  PROCEDURE <A NAME="EvalText"><procedure>EvalText</procedure></A>(self: PackageText; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    TYPE Chars = REF ARRAY OF CHAR;
    TYPE Texts = REF ARRAY OF TEXT;
    TYPE Vals = REF ARRAY OF ObValue.Val;
    VAR text1, text2, text3: TEXT; int1, int2, len: INTEGER; char1: CHAR;
      chars: Chars; val: ObValue.Val; texts: Texts; array1: Vals;
      chSet: SET OF CHAR;
    BEGIN
      TRY
      CASE NARROW(opCode, TextOpCode).code OF
      | TextCode.New =&gt;
          TYPECASE args[1] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(1, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValChar(node) =&gt; char1:=node.char;
          ELSE ObValue.BadArgType(2, &quot;char&quot;, self.name, opCode.name, loc); END;
          IF int1&lt;0 THEN
            ObValue.BadArgVal(1, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          chars := NEW(Chars, int1);
          FOR i:=0 TO int1-1 DO chars^[i] := char1; END;
          RETURN ObValue.NewText(Text.FromChars(chars^));
      | TextCode.Empty =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
	  IF Text.Empty(text1) THEN RETURN true ELSE RETURN false END;
      | TextCode.Length =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          RETURN NEW(ObValue.ValInt, int:=Text.Length(text1), temp:=temp);
      | TextCode.Equal =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          IF Text.Equal(text1, text2) THEN RETURN true ELSE RETURN false END;
      | TextCode.Char =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF (int1&lt;0) OR (int1&gt;=Text.Length(text1)) THEN
            ObValue.BadArgVal(2, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          RETURN NEW(ObValue.ValChar, char:=Text.GetChar(text1, int1));
      | TextCode.Sub =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValInt(node) =&gt; int2:=node.int;
          ELSE ObValue.BadArgType(3, &quot;int&quot;, self.name, opCode.name, loc); END;
          len := Text.Length(text1);
          IF (int1&lt;0) OR (int1&gt;len) THEN
            ObValue.BadArgVal(2, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
          IF (int2&lt;0) OR (int1+int2&gt;len) THEN
            ObValue.BadArgVal(3, &quot;in range&quot;, self.name, opCode.name, loc);
          END;
         RETURN ObValue.NewText(Text.Sub(text1, int1, int2));
      | TextCode.Cat =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          RETURN ObValue.NewText(Text.Cat(text1, text2));
      | TextCode.Precedes =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          IF Text.Compare(text1, text2)&lt;0 THEN RETURN true ELSE RETURN false END;
      | TextCode.Encode =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          RETURN ObValue.NewText(TextConv.Encode(text1, FALSE));
      | TextCode.Decode =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TRY val :=
            ObValue.NewText(TextConv.Decode(text1, FALSE));
          EXCEPT TextConv.Fail =&gt;
            ObValue.BadArgVal(1,
              &quot;a well-formed encoded text&quot;, self.name, opCode.name, loc);
          END;
          RETURN val;
      | TextCode.Implode =&gt;
          TYPECASE args[1] OF | ObValue.ValChar(node) =&gt; char1:=node.char;
          ELSE ObValue.BadArgType(1, &quot;char&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF
          | ObValue.ValArray(node) =&gt; array1:=node.remote.Obtain();
          ELSE ObValue.BadArgType(2, &quot;array&quot;, self.name, opCode.name, loc); END;
          texts := NEW(Texts, NUMBER(array1^));
          FOR i := 0 TO NUMBER(texts^)-1 DO
            TYPECASE array1^[i] OF
            | ObValue.ValText(node) =&gt; texts^[i] := node.text;
            ELSE ObValue.BadArgType(1,&quot;array(text)&quot;,self.name,opCode.name,loc);
            END;
          END;
          RETURN ObValue.NewText(TextConv.Implode(texts^, char1));
      | TextCode.Explode =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          chSet := CharSet(text2);
          texts := NEW(Texts, TextConv.ExplodedSize(text1, chSet));
          TextConv.Explode(text1, texts^, chSet);
          array1 := NEW(Vals, NUMBER(texts^));
          FOR i:=0 TO NUMBER(array1^)-1 DO
            array1[i] := ObValue.NewText(texts[i]);
          END;
          RETURN ObValue.NewArrayFromVals(array1);
       | TextCode.Hash =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          RETURN NEW(ObValue.ValInt, int:=Text.Hash(text1), temp:=temp);
       | TextCode.ToInt =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TRY RETURN
	    NEW(ObValue.ValInt, int:=Lex.Int(TextRd.New(text1)), temp:=temp);
          EXCEPT Lex.Error, Rd.Failure, FloatMode.Trap =&gt;
            ObValue.BadArgVal(1,&quot;a well-formed int&quot;, self.name,
              opCode.name, loc);
          END;
       | TextCode.FromInt =&gt;
          TYPECASE args[1] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(1, &quot;int&quot;, self.name, opCode.name, loc); END;
          RETURN ObValue.NewText(Fmt.Int(int1));
      | TextCode.FindFirstChar =&gt;
          TYPECASE args[1] OF | ObValue.ValChar(node) =&gt; char1:=node.char;
          ELSE ObValue.BadArgType(1, &quot;char&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(3, &quot;int&quot;, self.name, opCode.name, loc); END;
          RETURN NEW(ObValue.ValInt,
		int:=Text.FindChar(text1, char1, int1), temp:=temp);
      | TextCode.FindLastChar =&gt;
          TYPECASE args[1] OF | ObValue.ValChar(node) =&gt; char1:=node.char;
          ELSE ObValue.BadArgType(1, &quot;char&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(3, &quot;int&quot;, self.name, opCode.name, loc); END;
          RETURN NEW(ObValue.ValInt,
		int:=Text.FindCharR(text1, char1, int1), temp:=temp);
      | TextCode.FindFirst =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(3, &quot;int&quot;, self.name, opCode.name, loc); END;
          RETURN NEW(ObValue.ValInt,
		int:=FindFirst(text2, int1, text1), temp:=temp);
      | TextCode.FindLast =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(3, &quot;int&quot;, self.name, opCode.name, loc); END;
          RETURN NEW(ObValue.ValInt,
		int:=FindLast(text2, int1, text1), temp:=temp);
      | TextCode.ReplaceAll =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValText(node) =&gt; text3:=node.text;
          ELSE ObValue.BadArgType(3, &quot;text&quot;, self.name, opCode.name, loc); END;
          RETURN ObValue.NewText(ReplaceAll(text3, text1, text2));
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
      EXCEPT
      | NetObj.Error(atoms) =&gt;
          ObValue.RaiseNetException(self.name&amp;&quot;_&quot;&amp;opCode.name, atoms, loc);
      | Thread.Alerted =&gt;
          ObValue.RaiseException(ObValue.threadAlerted,
                                 self.name&amp;&quot;_&quot;&amp;opCode.name, loc);
      END;
    END EvalText;

PROCEDURE <A NAME="CharSet"><procedure>CharSet</procedure></A>(text: TEXT): SET OF CHAR =
  VAR s: SET OF CHAR;
  BEGIN
    s := SET OF CHAR{};
    FOR i:=0 TO Text.Length(text)-1 DO
      s := s + SET OF CHAR{Text.GetChar(text,i)};
    END;
    RETURN s;
 END CharSet;

PROCEDURE <A NAME="FindFirst"><procedure>FindFirst</procedure></A>(source: TEXT; start: INTEGER; pattern: TEXT) : INTEGER =
   VAR i, ii, j, srcLimit, patLimit: INTEGER; patFirst: CHAR;
   BEGIN
     srcLimit := Text.Length(source)-start;
     patLimit := Text.Length(pattern);
     IF patLimit=0 THEN RETURN 0 END;
     patFirst := Text.GetChar(pattern,0);
     i := start;
     LOOP
       IF i &gt;= srcLimit THEN RETURN -1 END;
       IF Text.GetChar(source,i) = patFirst THEN
         ii:=i; j:=0;
         LOOP
           INC(j);
           IF j &gt;= patLimit THEN RETURN i END;
           INC(ii);
           IF ii &gt;= srcLimit THEN EXIT END;
           IF Text.GetChar(source,ii) # Text.GetChar(pattern,j) THEN EXIT END;
         END;
       END;
       INC(i);
     END;
   END FindFirst;

PROCEDURE <A NAME="FindLast"><procedure>FindLast</procedure></A>(source: TEXT; start: INTEGER; pattern: TEXT) : INTEGER =
   VAR i, ii, j, patLength: INTEGER; patLast: CHAR;
   BEGIN
     patLength := Text.Length(pattern);
     IF patLength=0 THEN RETURN i END;
     patLast := Text.GetChar(pattern, patLength-1);
     i := MIN(Text.Length(source),start);
     LOOP
       DEC(i);
       IF i &lt; 0 THEN RETURN -1 END;
       IF Text.GetChar(source,i) = patLast THEN
         ii:=i; j:=patLength-1;
         LOOP
           DEC(j);
           IF j &lt; 0 THEN RETURN ii END;
           DEC(ii);
           IF ii &lt; 0 THEN EXIT END;
           IF Text.GetChar(source,ii) # Text.GetChar(pattern,j) THEN EXIT END;
         END;
       END;
     END;
   END FindLast;

PROCEDURE <A NAME="ReplaceAll"><procedure>ReplaceAll</procedure></A>(source: TEXT; pattern: TEXT; repl: TEXT) : TEXT =
   VAR i, ii, j, k, srcLimit, patLimit, replLength, count: INTEGER;
     patFirst, ch: CHAR; res: REF ARRAY OF CHAR;
   BEGIN
     srcLimit := Text.Length(source);
     patLimit := Text.Length(pattern);
     IF patLimit=0 THEN RETURN source END;
     patFirst := Text.GetChar(pattern,0);
     count := 0;
     i := 0;
     LOOP
       IF i &gt;= srcLimit THEN EXIT END;
       IF Text.GetChar(source,i) = patFirst THEN
         ii:=i; j:=0;
         LOOP
           INC(j);
           IF j &gt;= patLimit THEN INC(count); INC(i,patLimit); EXIT; END;
           INC(ii);
           IF (ii &gt;= srcLimit) OR
             (Text.GetChar(source,ii) # Text.GetChar(pattern,j))
           THEN
             INC(i);
             EXIT;
           END;
         END;
       ELSE
         INC(i);
       END;
     END;
     replLength := Text.Length(repl);
     res := NEW(REF ARRAY OF CHAR,
              (srcLimit-(count*patLimit))+(count*replLength));
     i := 0;
     k := 0;
     LOOP
       IF i &gt;= srcLimit THEN EXIT END;
       ch := Text.GetChar(source,i);
       IF ch = patFirst THEN
         ii:=i; j:=0;
         LOOP
           INC(j);
           IF j &gt;= patLimit THEN
             Text.SetChars(SUBARRAY(res^,k,replLength), repl);
             INC(k, replLength);
             INC(i, patLimit);
             EXIT;
           END;
           INC(ii);
           IF (ii &gt;= srcLimit) OR
             (Text.GetChar(source,ii) # Text.GetChar(pattern,j))
           THEN
             res^[k] := ch;
             INC(k);
             INC(i);
             EXIT;
           END;
         END;
       ELSE
         res^[k] := ch;
         INC(k);
         INC(i);
       END;
     END;
     RETURN Text.FromChars(res^);
   END ReplaceAll;
</PRE> ============ <CODE>array</CODE> package ============ 

<P><PRE>TYPE

  ArrayCode = {New, Gen, Size, Get, Set, Sub, Upd, Cat};

  ArrayOpCode =
    ObLib.OpCode OBJECT
        code: ArrayCode;
      END;

  PackageArray =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalArray;
      END;

  PROCEDURE <A NAME="NewArrayOC"><procedure>NewArrayOC</procedure></A>(name: TEXT; arity: INTEGER; code: ArrayCode;
    fixity: ObLib.OpFixity:=ObLib.OpFixity.Qualified): ArrayOpCode =
  BEGIN
    RETURN NEW(ArrayOpCode, name:=name, arity:=arity, code:=code,
      fixity:=fixity);
  END NewArrayOC;

  PROCEDURE <A NAME="SetupArray"><procedure>SetupArray</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(ArrayCode));
    opCodes^ :=
      OpCodes{
      NewArrayOC(&quot;new&quot;, 2, ArrayCode.New),
      NewArrayOC(&quot;gen&quot;, 2, ArrayCode.Gen),
      NewArrayOC(&quot;#&quot;, 1, ArrayCode.Size, ObLib.OpFixity.Prefix),
      NewArrayOC(&quot;get&quot;, 2, ArrayCode.Get),
      NewArrayOC(&quot;set&quot;, 3, ArrayCode.Set),
      NewArrayOC(&quot;sub&quot;, 3, ArrayCode.Sub),
      NewArrayOC(&quot;upd&quot;, 4, ArrayCode.Upd),
      NewArrayOC(&quot;@&quot;, 2, ArrayCode.Cat, ObLib.OpFixity.Infix)
      };
    ObLib.Register(
      NEW(PackageArray, name:=&quot;array&quot;, opCodes:=opCodes));
  END SetupArray;

  PROCEDURE <A NAME="EvalArray"><procedure>EvalArray</procedure></A>(self: PackageArray; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    TYPE Vals = REF ARRAY OF ObValue.Val;
    VAR int1, int2: INTEGER;
      vals, array1, array2: Vals; rem1: ObValue.RemArray;
      badOp: INTEGER:=0; clos1: ObValue.ValFun;
    BEGIN
      TRY
      CASE NARROW(opCode, ArrayOpCode).code OF
      | ArrayCode.New =&gt;
          TYPECASE args[1] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(1, &quot;int&quot;, self.name, opCode.name, loc); END;
          IF int1&lt;0 THEN
            ObValue.BadArgVal(1, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          vals := NEW(Vals, int1);
          FOR i:=0 TO int1-1 DO vals^[i] := args[2]; END;
          RETURN ObValue.NewArrayFromVals(vals);
      | ArrayCode.Gen =&gt;
          TYPECASE args[1] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(1, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValFun(node) =&gt; clos1:=node;
          ELSE ObValue.BadArgType(1, &quot;procedure&quot;, self.name, opCode.name, loc); END;
          IF int1&lt;0 THEN
            ObValue.BadArgVal(1, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          vals := NEW(Vals, int1);
          FOR i:=0 TO int1-1 DO
            vals^[i] :=
              ObEval.Call(clos1,
                ObValue.Vals{NEW(ObValue.ValInt, int:=i, temp:=FALSE)}, loc);
          END;
          RETURN ObValue.NewArrayFromVals(vals);
     | ArrayCode.Size =&gt;
          TYPECASE args[1] OF
          | ObValue.ValArray(node) =&gt;
            RETURN NEW(ObValue.ValInt, int:=node.remote.Size(), temp:=temp);
          ELSE ObValue.BadArgType(1, &quot;array&quot;, self.name, opCode.name, loc); END;
      | ArrayCode.Get =&gt;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[1] OF
          | ObValue.ValArray(node) =&gt; badOp := 2; RETURN node.remote.Get(int1);
          ELSE ObValue.BadArgType(1, &quot;array&quot;, self.name, opCode.name, loc); END;
      | ArrayCode.Set =&gt;
          TYPECASE args[1] OF
          | ObValue.ValArray(node) =&gt; rem1:=node.remote;
          ELSE ObValue.BadArgType(1, &quot;array&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          rem1.Set(int1, args[3]);
          badOp := 2;
          RETURN ObValue.valOk;
      | ArrayCode.Sub =&gt;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValInt(node) =&gt; int2:=node.int;
          ELSE ObValue.BadArgType(3, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[1] OF
          | ObValue.ValArray(node) =&gt;
            badOp:=3; RETURN node.remote.Sub(int1, int2);
          ELSE ObValue.BadArgType(1, &quot;array&quot;, self.name, opCode.name, loc); END;
      | ArrayCode.Upd =&gt;
          TYPECASE args[1] OF
          | ObValue.ValArray(node) =&gt; rem1:=node.remote;
          ELSE ObValue.BadArgType(1, &quot;array&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValInt(node) =&gt; int2:=node.int;
          ELSE ObValue.BadArgType(3, &quot;int&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[4] OF
          | ObValue.ValArray(node) =&gt; array1:=node.remote.Obtain();
          ELSE ObValue.BadArgType(4, &quot;array&quot;, self.name, opCode.name, loc); END;
          badOp := 3;
          rem1.Upd(int1, int2, array1);
          RETURN ObValue.valOk;
      | ArrayCode.Cat =&gt;
          TYPECASE args[1] OF
          | ObValue.ValArray(node) =&gt; array1:=node.remote.Obtain();
          ELSE ObValue.BadArgType(1, &quot;array&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF
          | ObValue.ValArray(node) =&gt; array2:=node.remote.Obtain();
          ELSE ObValue.BadArgType(2, &quot;array&quot;, self.name, opCode.name, loc); END;
          badOp := 1;
          RETURN ObValue.ArrayCat(array1, array2);
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
      EXCEPT
      | ObValue.ServerError =&gt;
          ObValue.BadArgVal(badOp, &quot;in range&quot;, self.name, opCode.name, loc);
      | NetObj.Error(atoms) =&gt;
          ObValue.RaiseNetException(self.name&amp;&quot;_&quot;&amp;opCode.name, atoms, loc);
      END;
    END EvalArray;
</PRE> ============ <CODE>net</CODE> package ============ 

<P><PRE>TYPE

  NetCode = {Error, Who, Export, Import, ExportEngine, ImportEngine};

  NetOpCode =
    ObLib.OpCode OBJECT
        code: NetCode;
      END;

  PackageNet =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalNet;
      END;

  PROCEDURE <A NAME="NewNetOC"><procedure>NewNetOC</procedure></A>(name: TEXT; arity: INTEGER; code: NetCode)
    : NetOpCode =
  BEGIN
    RETURN NEW(NetOpCode, name:=name, arity:=arity, code:=code);
  END NewNetOC;

  PROCEDURE <A NAME="SetupNet"><procedure>SetupNet</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(NetCode));
    opCodes^ :=
      OpCodes{
      NewNetOC(&quot;failure&quot;, -1, NetCode.Error),
      NewNetOC(&quot;who&quot;, 1, NetCode.Who),
      NewNetOC(&quot;export&quot;, 3, NetCode.Export),
      NewNetOC(&quot;import&quot;, 2, NetCode.Import),
      NewNetOC(&quot;exportEngine&quot;, 3, NetCode.ExportEngine),
      NewNetOC(&quot;importEngine&quot;, 2, NetCode.ImportEngine)
      };
    ObLib.Register(
      NEW(PackageNet, name:=&quot;net&quot;, opCodes:=opCodes));
  END SetupNet;

  PROCEDURE <A NAME="EvalNet"><procedure>EvalNet</procedure></A>(self: PackageNet; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR text1, text2: TEXT; remObj: ObValue.RemObj;
    BEGIN
      CASE NARROW(opCode, NetOpCode).code OF
      | NetCode.Error =&gt;
          RETURN ObValue.netException;
      | NetCode.Who =&gt;
          TYPECASE args[1] OF
          | ObValue.ValObj(node) =&gt; RETURN NetObjectWho(node.remote, loc);
          | ObValue.ValEngine(node) =&gt; RETURN NetEngineWho(node.remote, loc);
          ELSE ObValue.BadArgType(1, &quot;object or engine&quot;,
                  self.name, opCode.name, loc); END;
      | NetCode.Export =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[3] OF | ObValue.ValObj(node) =&gt; remObj:=node.remote;
          ELSE ObValue.BadArgType(3, &quot;object&quot;, self.name, opCode.name, loc); END;
          NetExport(text1, text2, remObj, loc);
          RETURN args[3];
      | NetCode.Import =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          RETURN NetImport(text1, text2, loc);
      | NetCode.ExportEngine =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          NetExportEngine(text1, text2, args[3], loc);
          RETURN ObValue.valOk;
      | NetCode.ImportEngine =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          RETURN NetImportEngine(text1, text2, loc);
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
    END EvalNet;

  PROCEDURE <A NAME="NetLocate"><procedure>NetLocate</procedure></A>(server: TEXT; VAR (*out*)address: TEXT;
      VAR (*out*)netAddress :NetObj.Address; location: SynLocation.T)
      RAISES {ObValue.Exception} =
  BEGIN
    IF Text.Empty(server)
    THEN
      address:=ObValue.machineAddress;
      netAddress:=NIL;
    ELSE
      address := server;
      TRY netAddress:=NetObj.Locate(address);
      EXCEPT
      | NetObj.Invalid, NetObj.Error =&gt;
          ObValue.RaiseNetException(
            &quot;Could not locate name server for '&quot; &amp; address &amp; &quot;'&quot;,
            NIL, location);
      | Thread.Alerted =&gt;
          ObValue.RaiseException(ObValue.threadAlerted, &quot;net_locate&quot;, location);
      END;
    END;
  END NetLocate;

  PROCEDURE <A NAME="NetObjectWho"><procedure>NetObjectWho</procedure></A>(remObj: ObValue.RemObj; loc: SynLocation.T)
    : ObValue.Val RAISES {ObValue.Exception} =
  VAR protected, serialized: BOOLEAN;
  BEGIN
    TRY
      RETURN ObValue.NewText(remObj.Who((*out*)protected, (*out*)serialized));
    EXCEPT
      | NetObj.Error(atoms) =&gt;
          ObValue.RaiseNetException(&quot;net_who&quot;, atoms, loc);
    | Thread.Alerted =&gt;
        ObValue.RaiseException(ObValue.threadAlerted, &quot;net_who&quot;, loc);
    END;
  END NetObjectWho;

  PROCEDURE <A NAME="NetEngineWho"><procedure>NetEngineWho</procedure></A>(remObj: ObValue.RemEngine; loc: SynLocation.T)
    : ObValue.Val RAISES {ObValue.Exception} =
  BEGIN
    TRY RETURN ObValue.NewText(remObj.Who());
    EXCEPT
      | NetObj.Error(atoms) =&gt;
          ObValue.RaiseNetException(&quot;net_who&quot;, atoms, loc);
    | Thread.Alerted =&gt;
        ObValue.RaiseException(ObValue.threadAlerted, &quot;net_who&quot;, loc);
    END;
  END NetEngineWho;

  PROCEDURE <A NAME="NetExport"><procedure>NetExport</procedure></A>(name, server: TEXT; remObj: ObValue.RemObj;
    loc: SynLocation.T) RAISES {ObValue.Exception} =
  VAR address: TEXT; netAddress: NetObj.Address;
  BEGIN
    NetLocate(server, (*out*)address, (*out*)netAddress, loc);
    TRY NetObj.Export(name, remObj, netAddress);
    EXCEPT
    | NetObj.Error(atoms) =&gt;
        ObValue.RaiseNetException(&quot;net_export: '&quot; &amp; name &amp;
        &quot;' at '&quot; &amp; address &amp; &quot;'&quot;, atoms, loc);
    | Thread.Alerted =&gt;
        ObValue.RaiseException(ObValue.threadAlerted, &quot;net_export: '&quot; &amp; name &amp;
        &quot;' at '&quot; &amp; address &amp; &quot;'&quot;, loc);
    END;
    TYPECASE remObj OF
    | ObValue.RemObjServer(serv) =&gt;
      IF Text.Empty(serv.who) THEN
        serv.who := name &amp; &quot;@&quot; &amp; address;
      END;
    ELSE
    END;
  END NetExport;

  PROCEDURE <A NAME="NetImport"><procedure>NetImport</procedure></A>(name, server: TEXT;
    loc: SynLocation.T): ObValue.Val RAISES {ObValue.Exception} =
  VAR address: TEXT; netAddress: NetObj.Address; netObj: NetObj.T;
  BEGIN
    NetLocate(server, (*out*)address, (*out*)netAddress, loc);
    TRY netObj :=NetObj.Import(name, netAddress);
    EXCEPT
    | NetObj.Error(atoms) =&gt;
        ObValue.RaiseNetException(&quot;net_import: '&quot; &amp; name &amp;
        &quot;' at '&quot; &amp; address &amp; &quot;'&quot;, atoms, loc);
    | Thread.Alerted =&gt;
        ObValue.RaiseException(ObValue.threadAlerted, &quot;net_import: '&quot; &amp; name &amp;
        &quot;' at '&quot; &amp; address &amp; &quot;'&quot;, loc);
    END;
    IF netObj=NIL THEN
      ObValue.RaiseException(ObValue.netException, &quot;net_import: '&quot; &amp; name &amp;
        &quot;' was not found at '&quot; &amp; address &amp; &quot;'&quot;, loc);
    END;
    TYPECASE netObj OF
    | ObValue.RemObj(remObj) =&gt;
        RETURN NEW(ObValue.ValObj, remote:=remObj);
    ELSE ObValue.RaiseException(ObValue.netException, &quot;net_import failed: '&quot; &amp;
           name &amp; &quot;' at '&quot;&amp; address &amp; &quot;' is not a network object&quot;, loc);
    END;
  END NetImport;

  PROCEDURE <A NAME="NetExportEngine"><procedure>NetExportEngine</procedure></A>(name, server: TEXT; arg: ObValue.Val;
    loc: SynLocation.T) RAISES {ObValue.Exception} =
  VAR address: TEXT; netAddress: NetObj.Address;
    remEngine: ObValue.RemEngine;
  BEGIN
    NetLocate(server, (*out*)address, (*out*)netAddress, loc);
    remEngine := NEW(ObValue.RemEngineServer,
          who := name &amp; &quot;@&quot; &amp; address, arg := arg);
    TRY NetObj.Export(name, remEngine, netAddress);
    EXCEPT
    | NetObj.Error(atoms) =&gt;
        ObValue.RaiseNetException(&quot;net_exportEngine: '&quot; &amp;
        name &amp; &quot;' at '&quot; &amp; address &amp; &quot;'&quot;, atoms, loc);
    | Thread.Alerted =&gt;
      ObValue.RaiseException(ObValue.threadAlerted, &quot;net_exportEngine: '&quot; &amp;
        name &amp; &quot;' at '&quot; &amp; address &amp; &quot;'&quot;, loc);
    END;
  END NetExportEngine;

  PROCEDURE <A NAME="NetImportEngine"><procedure>NetImportEngine</procedure></A>(name, server: TEXT;
    loc: SynLocation.T): ObValue.Val RAISES {ObValue.Exception} =
  VAR address: TEXT; netAddress: NetObj.Address; netObj: NetObj.T;
  BEGIN
    NetLocate(server, (*out*)address, (*out*)netAddress, loc);
    TRY netObj :=NetObj.Import(name, netAddress);
    EXCEPT
    | NetObj.Error(atoms) =&gt;
        ObValue.RaiseNetException(&quot;net_importEngine: '&quot; &amp;
        name &amp; &quot;' at '&quot; &amp; address &amp; &quot;'&quot;, atoms, loc);
    | Thread.Alerted =&gt;
      ObValue.RaiseException(ObValue.threadAlerted, &quot;net_importEngine: '&quot; &amp;
        name &amp; &quot;' at '&quot; &amp; address &amp; &quot;'&quot;, loc);
    END;
    IF netObj=NIL THEN
      ObValue.RaiseException(ObValue.netException, &quot;net_importEngine: '&quot; &amp;
        name &amp; &quot;' was not found at '&quot; &amp; address &amp; &quot;'&quot;, loc);
    END;
    TYPECASE netObj OF
    | ObValue.RemEngine(remEngine) =&gt;
        RETURN NEW(ObValue.ValEngine, remote:=remEngine);
    ELSE ObValue.RaiseException(ObValue.netException,
           &quot;net_importEngine failed: '&quot; &amp;
           name &amp; &quot;' at '&quot;&amp; address &amp; &quot;' is not a network engine&quot;, loc);
    END;
  END NetImportEngine;
</PRE> ============ <CODE>thread</CODE> package ============ 

<P><PRE>TYPE

  ThreadCode = {Alerted, NewMutex, NewCondition, Self, Fork, Join, Wait,
                Acquire, Release, Broadcast, Signal, Pause, Alert, TestAlert,
                AlertWait, AlertJoin, AlertPause, Lock};

  ThreadOpCode =
    ObLib.OpCode OBJECT
        code: ThreadCode;
      END;

  PackageThread =
    ObLib.T OBJECT
      OVERRIDES
        Eval:=EvalThread;
      END;

  PROCEDURE <A NAME="IsMutex"><procedure>IsMutex</procedure></A>(self: ValMutex; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValMutex(oth)=&gt; RETURN self.mutex = oth.mutex;
    ELSE RETURN FALSE END;
  END IsMutex;

  PROCEDURE <A NAME="IsCondition"><procedure>IsCondition</procedure></A>(self: ValCondition; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValCondition(oth)=&gt; RETURN self.condition = oth.condition;
    ELSE RETURN FALSE END;
  END IsCondition;

  PROCEDURE <A NAME="IsThread"><procedure>IsThread</procedure></A>(self: ValThread; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF ValThread(oth)=&gt; RETURN self.thread = oth.thread;
    ELSE RETURN FALSE END;
  END IsThread;

  PROCEDURE <A NAME="CopyMutex"><procedure>CopyMutex</procedure></A>(self: ObValue.ValAnything; tbl: ObValue.Tbl;
    loc: SynLocation.T): ObValue.ValAnything RAISES {ObValue.Error} =
  BEGIN
    RETURN NEW(ValMutex, what:=&quot;&lt;a Thread.Mutex&gt;&quot;, picklable:=FALSE,
               mutex:=NEW(Thread.Mutex));
  END CopyMutex;

  PROCEDURE <A NAME="CopyCondition"><procedure>CopyCondition</procedure></A>(self: ObValue.ValAnything; tbl: ObValue.Tbl;
    loc: SynLocation.T): ObValue.ValAnything RAISES {ObValue.Error} =
  BEGIN
    RETURN NEW(ValCondition, what:=&quot;&lt;a Thread.Condition&gt;&quot;, picklable:=FALSE,
               condition:= NEW(Thread.Condition));
  END CopyCondition;

  TYPE ThreadClosure =
    Thread.SizedClosure OBJECT
      fun: ObValue.ValFun;
      location: SynLocation.T;
      result: ObValue.Val;
      error: ObValue.ErrorPacket;
      exception: ObValue.ExceptionPacket;
    OVERRIDES
      apply := ApplyThreadClosure;
    END;

  PROCEDURE <A NAME="ApplyThreadClosure"><procedure>ApplyThreadClosure</procedure></A>(self: ThreadClosure): REFANY =
    VAR noArgs: ARRAY [0..-1] OF ObValue.Val;
    BEGIN
      TRY
        self.result := ObEval.Call(self.fun, noArgs, self.location);
      EXCEPT
      | ObValue.Error(packet) =&gt; self.error := packet;
      | ObValue.Exception(packet) =&gt; self.exception := packet;
      END;
      RETURN self;
    END ApplyThreadClosure;

  PROCEDURE <A NAME="ForkThread"><procedure>ForkThread</procedure></A>(fun: ObValue.ValFun; stackSize: INTEGER;
	loc: SynLocation.T): ValThread =
  VAR thread: Thread.T; threadClosure: ThreadClosure;
  BEGIN
    stackSize := MIN(MAX(stackSize,4096), LAST(CARDINAL));
    threadClosure :=
      NEW(ThreadClosure, stackSize := stackSize,
            fun:=fun, location:=loc,
            result:=NIL, error:=NIL, exception:=NIL);
    thread := Thread.Fork(threadClosure);
      RETURN
        NEW(ValThread, what:=&quot;&lt;a Thread.T&gt;&quot;, picklable:=FALSE,
          thread:=thread, joinedMu:=NEW(Thread.Mutex), joined:=FALSE);
  END ForkThread;

  PROCEDURE <A NAME="JoinThread"><procedure>JoinThread</procedure></A>(threadVal: ValThread; loc: SynLocation.T): ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  VAR threadClosure: ThreadClosure;
  BEGIN
    LOCK threadVal.joinedMu DO
      IF threadVal.joined THEN
        ObValue.RaiseError(&quot;Thread already joined&quot;, loc);
      ELSE
        threadVal.joined := TRUE;
      END;
    END;
    threadClosure := Thread.Join(threadVal.thread);
    IF threadClosure.error # NIL THEN
      RAISE ObValue.Error(threadClosure.error);
    ELSIF threadClosure.exception # NIL THEN
      RAISE ObValue.Exception(threadClosure.exception);
    ELSE
      RETURN threadClosure.result;
    END;
  END JoinThread;

  PROCEDURE <A NAME="NewThreadOC"><procedure>NewThreadOC</procedure></A>(name: TEXT; arity: INTEGER; code: ThreadCode;
    fixity: ObLib.OpFixity:=ObLib.OpFixity.Qualified)
    : ThreadOpCode =
  BEGIN
    RETURN NEW(ThreadOpCode, name:=name, arity:=arity, code:=code,
      fixity:=fixity);
  END NewThreadOC;

  PROCEDURE <A NAME="SetupThread"><procedure>SetupThread</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(ThreadCode));
    opCodes^ :=
      OpCodes{
      NewThreadOC(&quot;alerted&quot;, -1, ThreadCode.Alerted),
      NewThreadOC(&quot;mutex&quot;, 0, ThreadCode.NewMutex, ObLib.OpFixity.Prefix),
      NewThreadOC(&quot;condition&quot;, 0, ThreadCode.NewCondition, ObLib.OpFixity.Prefix),
      NewThreadOC(&quot;self&quot;, 0, ThreadCode.Self),
      NewThreadOC(&quot;fork&quot;, 2, ThreadCode.Fork, ObLib.OpFixity.Prefix),
      NewThreadOC(&quot;join&quot;, 1, ThreadCode.Join, ObLib.OpFixity.Prefix),
      NewThreadOC(&quot;wait&quot;, 2, ThreadCode.Wait, ObLib.OpFixity.Prefix),
      NewThreadOC(&quot;acquire&quot;, 1, ThreadCode.Acquire),
      NewThreadOC(&quot;release&quot;, 1, ThreadCode.Release),
      NewThreadOC(&quot;broadcast&quot;, 1, ThreadCode.Broadcast, ObLib.OpFixity.Prefix),
      NewThreadOC(&quot;signal&quot;, 1, ThreadCode.Signal, ObLib.OpFixity.Prefix),
      NewThreadOC(&quot;pause&quot;, 1, ThreadCode.Pause, ObLib.OpFixity.Prefix),
      NewThreadOC(&quot;alert&quot;, 1, ThreadCode.Alert),
      NewThreadOC(&quot;testAlert&quot;, 0, ThreadCode.TestAlert),
      NewThreadOC(&quot;alertWait&quot;, 2, ThreadCode.AlertWait),
      NewThreadOC(&quot;alertJoin&quot;, 1, ThreadCode.AlertJoin),
      NewThreadOC(&quot;alertPause&quot;, 1, ThreadCode.AlertPause),
      NewThreadOC(&quot;lock&quot;, 2, ThreadCode.Lock)
      };
    ObLib.Register(
      NEW(PackageThread, name:=&quot;thread&quot;, opCodes:=opCodes));
    ObValue.InhibitTransmission(TYPECODE(ValMutex),
      &quot;mutexes cannot be transmitted/duplicated&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValCondition),
      &quot;conditions cannot be transmitted/duplicated&quot;);
    ObValue.InhibitTransmission(TYPECODE(ValThread),
      &quot;threads cannot be transmitted/duplicated&quot;);
  END SetupThread;

  PROCEDURE <A NAME="EvalThread"><procedure>EvalThread</procedure></A>(self: PackageThread; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR thread1: Thread.T; threadVal1: ValThread;
      fun1: ObValue.ValFun; mutex1: Thread.Mutex;
      condition1: Thread.Condition; longReal1: LONGREAL;
      card1:CARDINAL; int1: INTEGER;
      noArgs: ARRAY [0..-1] OF ObValue.Val;
    BEGIN
      CASE NARROW(opCode, ThreadOpCode).code OF
      | ThreadCode.Alerted =&gt;
          RETURN ObValue.threadAlerted;
      | ThreadCode.NewMutex =&gt;
          mutex1 := NEW(Thread.Mutex);
          RETURN
            NEW(ValMutex, what:=&quot;&lt;a Thread.Mutex&gt;&quot;, picklable:=FALSE,
              mutex:=mutex1);
      | ThreadCode.NewCondition =&gt;
          condition1 := NEW(Thread.Condition);
          RETURN
            NEW(ValCondition, what:=&quot;&lt;a Thread.Condition&gt;&quot;, picklable:=FALSE,
                condition:=condition1);
      | ThreadCode.Self =&gt;
          thread1 := Thread.Self();
          RETURN
            NEW(ValThread, what:=&quot;&lt;a Thread.T&gt;&quot;, picklable:=FALSE,
                thread:=thread1, joinedMu:=NEW(Thread.Mutex), joined:=FALSE);
      | ThreadCode.Fork =&gt;
          TYPECASE args[1] OF | ObValue.ValFun(node) =&gt; fun1:=node;
          ELSE ObValue.BadArgType(1, &quot;procedure&quot;, self.name, opCode.name, loc);
          END;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
	  RETURN ForkThread(fun1, card1, loc);
      | ThreadCode.Join =&gt;
          TYPECASE args[1] OF | ValThread(node) =&gt; threadVal1 := node;
          ELSE ObValue.BadArgType(1, &quot;thread&quot;, self.name, opCode.name, loc); END;
	  RETURN JoinThread(threadVal1, loc);
      | ThreadCode.Wait =&gt;
          TYPECASE args[1] OF | ValMutex(node) =&gt; mutex1 := node.mutex;
          ELSE ObValue.BadArgType(1, &quot;mutex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ValCondition(node) =&gt;
            condition1 := node.condition;
          ELSE ObValue.BadArgType(2, &quot;condition&quot;, self.name, opCode.name, loc); END;
          Thread.Wait(mutex1, condition1);
          RETURN ObValue.valOk;
      | ThreadCode.Acquire =&gt;
          TYPECASE args[1] OF | ValMutex(node) =&gt; mutex1 := node.mutex;
          ELSE ObValue.BadArgType(1, &quot;mutex&quot;, self.name, opCode.name, loc); END;
          Thread.Acquire(mutex1);
          RETURN ObValue.valOk;
      | ThreadCode.Release =&gt;
          TYPECASE args[1] OF | ValMutex(node) =&gt; mutex1 := node.mutex;
          ELSE ObValue.BadArgType(1, &quot;mutex&quot;, self.name, opCode.name, loc); END;
          Thread.Release(mutex1);
          RETURN ObValue.valOk;
      | ThreadCode.Broadcast =&gt;
          TYPECASE args[1] OF | ValCondition(node) =&gt;
            condition1 := node.condition;
          ELSE ObValue.BadArgType(1, &quot;condition&quot;, self.name, opCode.name, loc); END;
          Thread.Broadcast(condition1);
          RETURN ObValue.valOk;
      | ThreadCode.Signal =&gt;
          TYPECASE args[1] OF | ValCondition(node) =&gt;
            condition1 := node.condition;
          ELSE ObValue.BadArgType(1, &quot;condition&quot;, self.name, opCode.name, loc); END;
          Thread.Signal(condition1);
          RETURN ObValue.valOk;
      | ThreadCode.Pause =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt; longReal1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
          IF longReal1 &lt; 0.0d0 THEN
            ObValue.BadArgVal(1, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          Thread.Pause(longReal1);
          RETURN ObValue.valOk;
      | ThreadCode.Alert =&gt;
          TYPECASE args[1] OF | ValThread(node) =&gt; thread1 := node.thread;
          ELSE ObValue.BadArgType(1, &quot;thread&quot;, self.name, opCode.name, loc); END;
          Thread.Alert(thread1);
          RETURN ObValue.valOk;
      | ThreadCode.TestAlert =&gt;
	  IF Thread.TestAlert() THEN RETURN true ELSE RETURN false END;
      | ThreadCode.AlertJoin =&gt;
          TYPECASE args[1] OF | ValThread(node) =&gt; thread1 := node.thread;
          ELSE ObValue.BadArgType(1, &quot;thread&quot;, self.name, opCode.name, loc); END;
          TRY
            RETURN Thread.AlertJoin(thread1);
          EXCEPT Thread.Alerted =&gt;
            ObValue.RaiseException(ObValue.threadAlerted, opCode.name, loc);
          END;
      | ThreadCode.AlertWait =&gt;
          TYPECASE args[1] OF | ValMutex(node) =&gt; mutex1 := node.mutex;
          ELSE ObValue.BadArgType(1, &quot;mutex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ValCondition(node) =&gt;
            condition1 := node.condition;
          ELSE ObValue.BadArgType(2, &quot;condition&quot;, self.name, opCode.name, loc); END;
          TRY
            Thread.AlertWait(mutex1, condition1);
            RETURN ObValue.valOk;
          EXCEPT Thread.Alerted =&gt;
            ObValue.RaiseException(ObValue.threadAlerted, opCode.name, loc);
          END;
      | ThreadCode.AlertPause =&gt;
          TYPECASE args[1] OF | ObValue.ValReal(node) =&gt; longReal1:=node.real;
          ELSE ObValue.BadArgType(1, &quot;real&quot;, self.name, opCode.name, loc); END;
          IF longReal1&lt;0.0d0 THEN
            ObValue.BadArgVal(1, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          TRY
            Thread.AlertPause(longReal1);
            RETURN ObValue.valOk;
          EXCEPT Thread.Alerted =&gt;
            ObValue.RaiseException(ObValue.threadAlerted, opCode.name, loc);
          END;
      | ThreadCode.Lock =&gt;
          TYPECASE args[1] OF | ValMutex(node) =&gt; mutex1 := node.mutex;
          ELSE ObValue.BadArgType(1, &quot;mutex&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValFun(node) =&gt; fun1:=node;
          ELSE ObValue.BadArgType(2, &quot;procedure&quot;, self.name, opCode.name, loc);
          END;
          LOCK mutex1 DO RETURN ObEval.Call(fun1, noArgs, loc) END;
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
    END EvalThread;

BEGIN
END ObBuiltIn.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
