<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/ObCheck.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/ObCheck.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObCheck.i3">ObCheck</A></implements></module>;
IMPORT <A HREF="ObErr.i3">ObErr</A>, <A HREF="ObTree.i3">ObTree</A>;

  REVEAL

    <A NAME="Env">Env</A> =
      ObTree.Env BRANDED OBJECT END;

    <A NAME="TermEnv">TermEnv</A> =
      TermEnvBase BRANDED OBJECT END;

PROCEDURE <A NAME="NewTermEnv"><procedure>NewTermEnv</procedure></A>(name: ObTree.IdeName; rest: Env): Env =
  VAR env: Env;
  BEGIN
    env := NEW(TermEnv);
    ObTree.BeEnv(env, name, rest);
    RETURN env;
  END NewTermEnv;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
    BEGIN
    END Setup;

PROCEDURE <A NAME="CheckTermBindingSeq"><procedure>CheckTermBindingSeq</procedure></A>(binding: ObTree.TermBinding; initEnv, env: Env)
    : Env RAISES {ObErr.Fail} =
  VAR env1: Env;
  BEGIN
    TYPECASE binding OF
    | NULL =&gt; RETURN env;
    | ObTree.TermBinding(node) =&gt;
        env1 := initEnv;
	CheckTerm(node.term, (*in-out*)env1);
	RETURN CheckTermBindingSeq(node.rest, initEnv,
	  NewTermEnv(node.binder, env));
    END;
  END CheckTermBindingSeq;

PROCEDURE <A NAME="CheckTermBindingRec1"><procedure>CheckTermBindingRec1</procedure></A>(binding: ObTree.TermBinding; env: Env)
    : Env RAISES {ObErr.Fail} =
  BEGIN
    TYPECASE binding OF
    | NULL =&gt; RETURN env;
    | ObTree.TermBinding(node) =&gt;
	RETURN CheckTermBindingRec1(node.rest,
	  NewTermEnv(node.binder, env));
    END;
  END CheckTermBindingRec1;

PROCEDURE <A NAME="CheckTermBindingRec2"><procedure>CheckTermBindingRec2</procedure></A>(binding: ObTree.TermBinding; recEnv: Env)
    RAISES {ObErr.Fail} =
  VAR env1: Env;
  BEGIN
    TYPECASE binding OF
    | NULL =&gt;
    | ObTree.TermBinding(node) =&gt;
        env1 := recEnv;
	CheckTerm(node.term, (*in-out*)env1);
	CheckTermBindingRec2(node.rest, recEnv);
    END;
  END CheckTermBindingRec2;

PROCEDURE <A NAME="CheckTerm"><procedure>CheckTerm</procedure></A>(term: ObTree.Term; VAR (*in-out*)env: Env)
    RAISES {ObErr.Fail} =
  BEGIN
    TYPECASE term OF
    | ObTree.TermLet(node) =&gt;
        IF node.rec THEN
          env := CheckTermBindingRec1(node.binding, env);
          CheckTermBindingRec2(node.binding, env);
        ELSE
          env := CheckTermBindingSeq(node.binding, env, env);
        END;
</PRE><BLOCKQUOTE><EM><P>
    <PRE>
      NULL =&gt; ObErr.Fault(&quot;Check.Term NIL&quot;);
          ObTree.TermIde =&gt;
          ObTree.TermOk =&gt;
          ObTree.TermBool =&gt;
          ObTree.TermChar =&gt;
          ObTree.TermText =&gt;
          ObTree.TermInt =&gt;
          ObTree.TermReal =&gt;
          ObTree.TermArray =&gt;
          ObTree.TermOption =&gt;
          ObTree.TermAlias =&gt;
          ObTree.TermOp =&gt;
          ObTree.TermFun =&gt;
          ObTree.TermAppl =&gt;
          ObTree.TermMeth =&gt;
          ObTree.TermObj =&gt;
          ObTree.TermClone =&gt;
          ObTree.TermRedirect =&gt;
          ObTree.TermSelect =&gt;
          ObTree.TermUpdate =&gt;
          ObTree.TermSeq =&gt;
          ObTree.TermAssign =&gt;
          ObTree.TermIf =&gt;
          ObTree.TermCase =&gt;
          ObTree.TermLoop =&gt;
          ObTree.TermExit =&gt;
          ObTree.TermFor =&gt; (* check binder 
</EM></BLOCKQUOTE><PRE>
    | ObTree.TermForeach =&gt; (* check binder *)
    | ObTree.TermException =&gt;
    | ObTree.TermRaise =&gt;
    | ObTree.TermTry =&gt;
    | ObTree.TermTryFinally =&gt;
    | ObTree.TermWatch =&gt;
*)
    ELSE
    END;
  END CheckTerm;

BEGIN
END ObCheck.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
