<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/ObCommand.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/ObCommand.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObCommand.i3">ObCommand</A></implements></module>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="ObErr.i3">ObErr</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>;

TYPE
  List = OBJECT
      first: T;
      rest: List;
    END;

REVEAL
  <A NAME="Set">Set</A> =
    BRANDED OBJECT
      list: List;
    END;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
    BEGIN
    END Setup;

  PROCEDURE <A NAME="NewSet"><procedure>NewSet</procedure></A>(): Set =
    BEGIN
      RETURN NEW(Set, list:=NIL);
   END NewSet;

  PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A>(command: T; list: List): List =
    BEGIN
      IF list=NIL THEN
	RETURN NEW(List, first:=command, rest:=list);
      ELSIF Text.Compare(command.sortingName, list.first.sortingName) &lt; 0 THEN
	RETURN NEW(List, first:=command, rest:=list);
      ELSE
	list.rest := Insert(command, list.rest);
	RETURN list;
      END;
  END Insert;

  PROCEDURE <A NAME="Register"><procedure>Register</procedure></A>(set: Set; command: T) =
    BEGIN
      set.list:=Insert(command, set.list);
    END Register;

  PROCEDURE <A NAME="ReRegister"><procedure>ReRegister</procedure></A>(set: Set; name: TEXT; proc: Proc) =
    VAR scan: List;
    BEGIN
      scan := set.list;
      WHILE scan#NIL DO
	IF Text.Equal(name, scan.first.name) THEN
          scan.first.Exec := proc;
        END;
	scan:=scan.rest;
      END;
    END ReRegister;

  PROCEDURE <A NAME="Exec"><procedure>Exec</procedure></A>(name: TEXT; arg: TEXT:=NIL; set: Set; data: REFANY:=NIL)
      RAISES {ObErr.Fail} =
    VAR scan: List;
    BEGIN
      IF Text.Equal(name, &quot;?&quot;) THEN
	scan := set.list;
	WHILE scan#NIL DO
	  IF scan.first.Exec # NIL THEN
            scan.first.Exec(scan.first, &quot;!&quot;, data);
          END;
	  scan:=scan.rest;
	END;
	SynWr.Flush(SynWr.out);
      ELSE
        scan:=set.list;
	WHILE scan#NIL DO
	  IF Text.Equal(name, scan.first.name) THEN
	    IF scan.first.Exec # NIL THEN
              scan.first.Exec(scan.first, arg, data);
            END;
	    SynWr.Flush(SynWr.out);
	    RETURN;
	  END;
	  scan:=scan.rest;
	END;
        SynWr.Text(SynWr.out, &quot;Command not found: &quot; &amp; name &amp; &quot;\n&quot;);
	SynWr.Flush(SynWr.out);
      END;
    END Exec;

BEGIN

END ObCommand.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
