<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/ObEval.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/ObEval.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObEval.i3">ObEval</A></implements></module>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="ObTree.i3">ObTree</A>, <A HREF="ObValue.i3">ObValue</A>, <A HREF="ObLib.i3">ObLib</A>, <A HREF="ObBuiltIn.i3">ObBuiltIn</A>,
<A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
    BEGIN
    END Setup;

  PROCEDURE <A NAME="LookupIde"><procedure>LookupIde</procedure></A>(name: ObTree.IdeName; place: ObTree.IdePlace;
    lValue: BOOLEAN; env: ObValue.Env; glob: ObValue.GlobalEnv;
    loc: SynLocation.T) : ObValue.Val RAISES {ObValue.Exception} =
  VAR i: INTEGER; val: ObValue.Val;
  BEGIN
    TYPECASE place OF
    | ObTree.IdePlaceGlobal(node) =&gt;
      val := glob^[node.index-1];
    | ObTree.IdePlaceLocal(node) =&gt;
      i := node.index;
      LOOP
	    (* IF i&lt;0 THEN ObErr.Fault(&quot;Eval.LookupIde&quot;) END; *)
	    TYPECASE env OF
            (*
	    | NULL =&gt;
	        ObErr.Fault(&quot;Eval.LookupIde: Unbound var: &quot;
	          &amp; ObTree.FmtIde(name, place, NIL));
            *)
	    | ObValue.LocalEnv(node) =&gt;
	        IF i=1 THEN
	          (*
	          IF NOT ObTree.SameIdeName(name, node.name) THEN
		        ObErr.Fault(&quot;Eval.LookupIde&quot;);
	          END;
                  *)
	          val := node.val;
              EXIT;
	        ELSE
	          DEC(i);
	          env := node.rest;
	        END;
        ELSE &lt;*ASSERT FALSE*&gt;
	    END;
      END;
    ELSE &lt;*ASSERT FALSE*&gt;
    END;
    IF lValue THEN RETURN val;
    ELSE
      TYPECASE val OF
      | ObValue.ValVar(node) =&gt;
        TRY RETURN node.remote.Get();
        EXCEPT NetObj.Error(atoms) =&gt;
          ObValue.RaiseNetException(
            &quot;on remote access to variable '&quot; &amp; name.text &amp; &quot;'&quot;, atoms, loc);
		  &lt;*ASSERT FALSE*&gt;
        END;
      ELSE RETURN val;
      END;
    END;
  END LookupIde;

  PROCEDURE <A NAME="TermBindingSeq"><procedure>TermBindingSeq</procedure></A>(binding: ObTree.TermBinding; var: BOOLEAN;
      initEnv, env: ObValue.Env; glob: ObValue.GlobalEnv;
      mySelf: ObValue.RemObj): ObValue.Env
      RAISES {ObValue.Error, ObValue.Exception} =
    VAR val: ObValue.Val; env1: ObValue.Env;
    BEGIN
      TYPECASE binding OF
      | NULL =&gt; RETURN env;
      | ObTree.TermBinding(node) =&gt;
          env1 := initEnv;
	  val:=Term(node.term, (*in-out*)env1, glob, mySelf);
	  IF var THEN val := ObValue.NewVar(val)  END;
	  RETURN
	    TermBindingSeq(node.rest, var, initEnv,
	      NEW(ObValue.LocalEnv, name:=node.binder, val:=val, rest:=env),
	      glob, mySelf);
      END;
    END TermBindingSeq;

  PROCEDURE <A NAME="TermBindingRec"><procedure>TermBindingRec</procedure></A>(binding: ObTree.TermBinding; var: BOOLEAN;
    env: ObValue.LocalEnv; glob: ObValue.GlobalEnv;
      mySelf: ObValue.RemObj): ObValue.Env
      RAISES {ObValue.Error, ObValue.Exception} =
  (* Executes definitions backwards, but it's ok since they are all
     functions. *)
    VAR val: ObValue.Val; dumFun: ObValue.ValFun; recEnv,recEnv1: ObValue.Env;
    BEGIN
      TYPECASE binding OF
      | NULL =&gt; RETURN env;
      | ObTree.TermBinding(node) =&gt;
	  dumFun:=NEW(ObValue.ValFun, fun:=NIL, global:=NIL);
	  IF var
	  THEN val := ObValue.NewVar(dumFun);
          ELSE val:=dumFun;
	  END;
	  recEnv :=
	    TermBindingRec(node.rest, var,
	      NEW(ObValue.LocalEnv, name:=node.binder, val:=val, rest:=env),
              glob, mySelf);
          recEnv1 := recEnv;
          TYPECASE Term(node.term, (*in-out*)recEnv1, glob, mySelf) OF
          | ObValue.ValFun(valFun) =&gt;
            dumFun.fun := valFun.fun;
            dumFun.global := valFun.global;
          ELSE ObValue.RaiseError(&quot;Recursive definition of a non-function&quot;,
                 binding.location);
          END;
          RETURN recEnv;
      END;
    END TermBindingRec;

  PROCEDURE <A NAME="Term"><procedure>Term</procedure></A>(term: ObTree.Term;
      VAR (*in-out*)env: ObValue.Env; glob: ObValue.GlobalEnv;
      mySelf: ObValue.RemObj): ObValue.Val
      RAISES {ObValue.Error, ObValue.Exception} =
    TYPE Vals = REF ARRAY OF ObValue.Val;
    VAR  result: ObValue.Val;
    BEGIN
      IF interrupt THEN
        interrupt := FALSE;
        ObValue.RaiseError(&quot;Interrupt&quot;, term.location);
      END;
      TYPECASE term OF
      (* | NULL =&gt; ObErr.Fault(&quot;Eval.Term NIL&quot;); *)
      | ObTree.TermIde(node) =&gt;
	  result :=
            LookupIde(node.name, node.place, FALSE, env, glob, term.location);
      | ObTree.TermOk =&gt;
	  result := ObValue.valOk;
      | ObTree.TermBool(node) =&gt;
	  IF node.cache=NIL THEN
	    node.cache := NEW(ObValue.ValBool, bool:=node.bool);
	  END;
	  result := node.cache;
      | ObTree.TermChar(node) =&gt;
	  IF node.cache=NIL THEN
	    node.cache := NEW(ObValue.ValChar, char:=node.char);
	  END;
	  result := node.cache;
      | ObTree.TermText(node) =&gt;
	  IF node.cache=NIL THEN
	    node.cache := ObValue.NewText(node.text);
	  END;
	  result := node.cache;
      | ObTree.TermInt(node) =&gt;
	  IF node.cache=NIL THEN
	    node.cache := NEW(ObValue.ValInt, int:=node.int, temp:=FALSE);
	  END;
	  result := node.cache;
      | ObTree.TermReal(node) =&gt;
	  IF node.cache=NIL THEN
	    node.cache := NEW(ObValue.ValReal, real:=node.real, temp:=FALSE);
	  END;
	  result := node.cache;
      | ObTree.TermOption(node) =&gt;
          VAR
            env1: ObValue.Env;
          BEGIN
            env1 := env;
	    result :=
              NEW(ObValue.ValOption,
                tag:=node.tag.text,
                val:=Term(node.term, (*in-out*)env1, glob, mySelf));
          END;
      | ObTree.TermAlias(node) =&gt;
          VAR
            env1: ObValue.Env; val: ObValue.Val;
          BEGIN
            env1 := env;
            val := Term(node.term, (*in-out*)env1, glob, mySelf);
            TYPECASE val OF
            | ObValue.ValObj(obj) =&gt;
              result := ObValue.NewAlias(obj, node.label.text, term.location);
            ELSE ObValue.RaiseError(&quot;Aliasing must operate on an object&quot;,
                    term.location);
            END;
          END;
      | ObTree.TermArray(node) =&gt;
          VAR
            vals := NEW(Vals, node.elemsNo);
            argList := node.elems;
            env1: ObValue.Env;
          BEGIN
            FOR i := 0 TO node.elemsNo-1 DO
              env1 := env;
              vals[i]:=Term(argList.first, (*in-out*)env1, glob, mySelf);
              argList := argList.rest;
            END;
            result := ObValue.NewArrayFromVals(vals);
          END;
      | ObTree.TermOp(node) =&gt;
        VAR
          argList := node.args;
          opCode := NARROW(node.opCode, ObLib.OpCode);
          argArray: ObValue.ArgArray;
          env1: ObValue.Env;
          msg: TEXT;
        BEGIN
          IF (opCode.arity &gt;= -1) AND (node.argsNo # opCode.arity) THEN
            IF opCode.arity = -1 THEN
              msg := &quot;Not expecting an argument list for procedure: &quot; &amp;
                         node.pkg.text &amp; &quot;_&quot; &amp; node.op.text;
            ELSIF node.argsNo = -1 THEN
              msg := &quot;Expecting an argument list for procedure: &quot; &amp;
                         node.pkg.text &amp; &quot;_&quot; &amp; node.op.text;
            ELSE
              msg := ObValue.BadArgsNoMsg(opCode.arity, node.argsNo,
                         &quot;procedure&quot;, node.pkg.text &amp; &quot;_&quot; &amp; node.op.text);
            END;
            ObValue.RaiseError(msg, term.location);
          END;
          IF node.argsNo &gt; NUMBER(argArray) THEN
            ObValue.RaiseError(&quot;Too many arguments&quot;, term.location);
          END;
          FOR i:=1 TO node.argsNo DO
            env1 := env;
            argArray[i]:=Term(argList.first, (*in-out*)env1, glob, mySelf);
            argList := argList.rest;
          END;
          result :=
            NARROW(node.package, ObLib.T)
              .Eval(opCode, node.argsNo, argArray, node.temp, term.location);
        END;
      | ObTree.TermFun(node) =&gt;
          VAR
            newGlob := NEW(ObValue.GlobalEnv, node.globalsNo);
            globals := node.globals;
          BEGIN
            FOR i:=0 TO node.globalsNo-1 DO
              newGlob^[i] :=
                LookupIde(globals.name, globals.place, TRUE, env, glob,
                  term.location);
              globals := globals.rest;
            END;
	    result := NEW(ObValue.ValFun, fun:=node, global:=newGlob);
          END;
      | ObTree.TermMeth(node) =&gt;
          VAR
            newGlob := NEW(ObValue.GlobalEnv, node.globalsNo);
            globals := node.globals;
          BEGIN
            FOR i:=0 TO node.globalsNo-1 DO
              newGlob^[i] :=
                LookupIde(globals.name, globals.place, TRUE, env, glob,
                  term.location);
              globals := globals.rest;
            END;
	    result := NEW(ObValue.ValMeth, meth:=node, global:=newGlob);
          END;
      | ObTree.TermAppl(node) =&gt;
        VAR
          env1, newEnv: ObValue.Env;
          newGlob: ObValue.GlobalEnv;
          binderList: ObTree.IdeList;
          argList: ObTree.TermList;
          val: ObValue.Val;
        BEGIN
          env1 := env;
          TYPECASE Term(node.fun, (*in-out*)env1, glob, mySelf) OF
          | ObValue.ValFun(clos) =&gt;
              IF node.argsNo # clos.fun.bindersNo THEN
                ObValue.RaiseError(ObValue.BadArgsNoMsg(clos.fun.bindersNo,
                  node.argsNo, &quot;&quot;, &quot;&quot;), term.location);
              END;
              newGlob := clos.global;
              newEnv := NIL;
              binderList := clos.fun.binders;
              argList := node.args;
              FOR i:=1 TO node.argsNo DO
                env1 := env;
                newEnv :=
	          NEW(ObValue.LocalEnv,
	            name:=binderList.first,
	            val:=Term(argList.first, (*in-out*)env1, glob, mySelf),
	            rest:=newEnv);
	        binderList := binderList.rest;
                argList := argList.rest;
              END;
	      result := Term(clos.fun.body, (*in-out*)newEnv, newGlob, mySelf);
          | ObValue.ValEngine(engine) =&gt;
              IF node.argsNo # 1 THEN
                ObValue.RaiseError(ObValue.BadArgsNoMsg(1,
                  node.argsNo, &quot;&quot;, &quot;&quot;), term.location);
              END;
              env1 := env;
	      val:=Term(node.args.first, (*in-out*)env1, glob, mySelf);
	      TRY result := engine.remote.Eval(val, mySelf);
              EXCEPT
              | ObValue.ServerError(msg) =&gt;
                  ObValue.RaiseError(msg, term.location);
              | NetObj.Error(atoms) =&gt;
                  ObValue.RaiseNetException(
                    &quot;on remote engine execution&quot;, atoms, term.location);
              END;
          ELSE ObValue.RaiseError(&quot;Application of a non-procedure&quot;,
                  term.location);
          END;
        END;
      | ObTree.TermObj(node) =&gt;
        VAR
          sync: ObValue.Sync;
          fields := NEW(REF ObValue.ObjFields, node.fieldsNo);
          fieldList := node.fields;
          env1: ObValue.Env;
        BEGIN
          CASE node.sync OF
          | ObTree.Sync.None =&gt;
            sync:=NIL;
          | ObTree.Sync.Monitored =&gt;
            sync := NEW(ObValue.Sync, mutex := NEW(Thread.Mutex));
          ELSE &lt;*ASSERT FALSE*&gt;
          END;
          FOR i:=0 TO node.fieldsNo-1 DO
            env1:=env;
            fields^[i].label := fieldList.label.text;
            fields^[i].field:=
              Term(fieldList.term, (*in-out*)env1, glob, mySelf);
            fieldList := fieldList.rest;
          END;
          result := ObValue.NewObjectFromFields(fields, &quot;&quot;,
              node.protected, sync);
        END;
      | ObTree.TermClone(node) =&gt;
        VAR
          env1: ObValue.Env;
          objs: ObTree.TermList;
          remObjs: REF ARRAY OF ObValue.RemObj;
        BEGIN
          TRY
            IF node.objsNo=1 THEN
              env1 := env;
              TYPECASE Term(node.objs.first, (*in-out*)env1, glob, mySelf) OF
              | ObValue.ValObj(obj) =&gt;
                  result := ObValue.ObjClone1(obj.remote, mySelf);
              ELSE ObValue.RaiseError(&quot;Arguments of clone must be objects&quot;,
                     term.location);
              END;
            ELSE
              objs := node.objs;
              remObjs := NEW(REF ARRAY OF ObValue.RemObj, node.objsNo);
              FOR i:=0 TO node.objsNo-1 DO
                env1 := env;
                TYPECASE Term(objs.first, (*in-out*)env1, glob, mySelf) OF
                | ObValue.ValObj(obj) =&gt;
                    remObjs^[i] := obj.remote;
                ELSE ObValue.RaiseError(&quot;Arguments of clone must be objects&quot;,
                       term.location);
                END;
                objs := objs.rest;
              END;
              result := ObValue.ObjClone((*readonly*) remObjs^, mySelf);
            END;
          EXCEPT
          | ObValue.ServerError(msg) =&gt;
              ObValue.RaiseError(msg, term.location);
          | NetObj.Error(atoms) =&gt;
              ObValue.RaiseNetException(
                &quot;on remote object cloning&quot;, atoms, term.location);
          END;
        END;
      | ObTree.TermRedirect(node) =&gt;
        VAR
          env1: ObValue.Env;
          toObj: ObValue.Val;
        BEGIN
          env1 := env;
          TYPECASE Term(node.obj, (*in-out*)env1, glob, mySelf) OF
          | ObValue.ValObj(obj) =&gt;
              env1 := env;
              toObj:=Term(node.toObj, (*in-out*)env1, glob, mySelf);
              TRY
                obj.remote.Redirect(toObj, obj.remote=mySelf);
              EXCEPT
              | ObValue.ServerError(msg) =&gt;
                  ObValue.RaiseError(msg, term.location);
              | NetObj.Error(atoms) =&gt;
                  ObValue.RaiseNetException(
                      &quot;on remote object invocation&quot;, atoms, term.location);
              END;
              result := ObValue.valOk;
          ELSE ObValue.RaiseError(&quot;Redirection must operate on an object&quot;,
                  term.location);
          END;
        END;
      | ObTree.TermSelect(node) =&gt;
        VAR
          env1: ObValue.Env;
          argList: ObTree.TermList;
          argArray: ObValue.ArgArray;
        BEGIN
          IF node.argsNo &gt; NUMBER(argArray) THEN
            ObValue.RaiseError(&quot;Too many arguments.&quot;, term.location);
          END;
          env1 := env;
          TYPECASE Term(node.obj, (*in-out*)env1, glob, mySelf) OF
          | ObValue.ValObj(obj) =&gt;
              argList := node.args;
              FOR i:=1 TO node.argsNo DO
                env1 := env;
                argArray[i]:=Term(argList.first, (*in-out*)env1, glob, mySelf);
                argList := argList.rest;
              END;
              TRY
                IF node.invoke THEN
                  FOR i:=node.argsNo+1 TO NUMBER(argArray) DO
                    argArray[i] := NIL; (* Clear for transmission *)
                  END;
                  result := obj.remote.Invoke(node.label.text,
                    node.argsNo, argArray, obj.remote=mySelf,
                      (*var*) node.labelIndexHint);
                ELSE
                  result :=
                    obj.remote.Select(node.label.text, obj.remote=mySelf,
                       (*var*) node.labelIndexHint);
                END;
              EXCEPT
              | ObValue.ServerError(msg) =&gt;
                  ObValue.RaiseError(msg, term.location);
              | NetObj.Error(atoms) =&gt;
                  ObValue.RaiseNetException(
                      &quot;on remote object invocation&quot;, atoms, term.location);
              END;
          ELSE ObValue.RaiseError(&quot;Selection must operate on an object&quot;,
                  term.location);
          END;
        END;
      | ObTree.TermUpdate(node) =&gt;
        VAR
          env1: ObValue.Env;
          val: ObValue.Val;
        BEGIN
          env1 := env;
          TYPECASE Term(node.obj, (*in-out*)env1, glob, mySelf) OF
          | ObValue.ValObj(obj) =&gt;
              env1 := env;
              val := Term(node.term, (*in-out*)env1, glob, mySelf);
              TRY
                obj.remote.Update(node.label.text, val, obj.remote=mySelf,
                  (*var*) node.labelIndexHint);
              EXCEPT
              | ObValue.ServerError(msg) =&gt;
                  ObValue.RaiseError(msg, term.location);
              | NetObj.Error(atoms) =&gt;
                  ObValue.RaiseNetException(
                      &quot;on remote object update&quot;, atoms, term.location);
              END;
              result := ObValue.valOk;
          ELSE ObValue.RaiseError(&quot;Update must operate on an object&quot;,
                 term.location);
          END;
        END;
      | ObTree.TermSeq =&gt;
        VAR
          term1 := term;
          env1 := env;
        BEGIN
          LOOP
            TYPECASE term1 OF
            | ObTree.TermSeq(seq) =&gt;
              EVAL Term(seq.before, (*in-out*) env1, glob, mySelf);
              term1 := seq.after;
            ELSE
              result := Term(term1, (*in-out*) env1, glob, mySelf);
              EXIT;
            END;
          END;
        END;
      | ObTree.TermLet(node) =&gt;
          IF node.rec THEN
            env :=
              TermBindingRec(node.binding, node.var, env, glob, mySelf);
          ELSE
            env :=
              TermBindingSeq(node.binding, node.var, env, env, glob, mySelf);
          END;
          result := ObValue.valOk;
      | ObTree.TermAssign(node) =&gt;
        VAR
          env1: ObValue.Env;
          val: ObValue.Val;
        BEGIN
          TYPECASE LookupIde(node.name, node.place, TRUE, env, glob,
                             term.location) OF
          | ObValue.ValVar(var) =&gt;
            env1 := env;
            val := Term(node.val, (*in-out*)env1, glob, mySelf);
            TRY var.remote.Set(val);
            EXCEPT NetObj.Error(atoms) =&gt;
              ObValue.RaiseNetException(
                  &quot;on remote assigment to variable '&quot; &amp; node.name.text &amp; &quot;'&quot;,
                  atoms, term.location);
            END;
          ELSE ObValue.RaiseError(&quot;Assigment must operate on a variable&quot;,
                 term.location);
          END;
          result := ObValue.valOk;
        END;
      | ObTree.TermIf(node) =&gt;
        VAR
          env1: ObValue.Env;
        BEGIN
          env1 := env;
          TYPECASE Term(node.test, (*in-out*)env1, glob, mySelf) OF
          | ObValue.ValBool(bool) =&gt;
              IF bool.bool THEN
                env1 := env;
                result := Term(node.ifTrue, (*in-out*)env1, glob, mySelf);
              ELSIF node.ifFalse=NIL THEN
                result := ObValue.valOk;
              ELSE
                env1 := env;
                result := Term(node.ifFalse, (*in-out*)env1, glob, mySelf);
              END;
          ELSE ObValue.RaiseError(&quot;Conditional test must be a boolean&quot;,
                 term.location);
          END;
        END;
      | ObTree.TermCase(node) =&gt;
        VAR
          env1: ObValue.Env;
          caseList: ObTree.TermCaseList;
        BEGIN
          env1 := env;
          TYPECASE Term(node.option, (*in-out*)env1, glob, mySelf) OF
          | ObValue.ValOption(option) =&gt;
              caseList := node.caseList;
              LOOP
                IF caseList = NIL THEN
                  ObValue.RaiseError(&quot;No case branch applies to tag: &quot; &amp;
                    option.tag, term.location);
                END;
                IF caseList.tag = NIL THEN (* &quot;else&quot; case *)
                  env1 := env;
                  result := Term(caseList.body, (*in-out*)env1, glob, mySelf);
                  EXIT;
                END;
                IF Text.Equal(option.tag, caseList.tag.text) THEN
                  IF caseList.binder = NIL THEN
                    env1 := env;
                  ELSE
                    env1 := NEW(ObValue.LocalEnv, name:=caseList.binder,
	              val:=option.val, rest:=env);
                  END;
                  result := Term(caseList.body, (*in-out*)env1, glob, mySelf);
                  EXIT;
                END;
                caseList := caseList.rest;
             END;
          ELSE
            ObValue.RaiseError(&quot;Case over a non-option value&quot;, term.location);
          END;
        END;
      | ObTree.TermLoop(node) =&gt;
        VAR
          env1: ObValue.Env;
        BEGIN
          TRY
            LOOP
              env1 := env;
              EVAL Term(node.loop, (*in-out*)env1, glob, mySelf);
            END;
          EXCEPT
          | ObValue.Error(pkt) =&gt;
              IF NOT Text.Equal(pkt.msg, &quot;exit&quot;) THEN
                RAISE ObValue.Error(pkt);
              END;
          END;
          result := ObValue.valOk;
        END;
      | ObTree.TermExit(node) =&gt;
          RAISE
            ObValue.Error(
              NEW(ObValue.ErrorPacket,
                  msg:=&quot;exit&quot;, location:=node.location));
      | ObTree.TermFor(node) =&gt;
        VAR
          env1: ObValue.Env;
          forEnv: ObValue.LocalEnv;
          lbVal, ubVal: ObValue.Val;
          i, ub: INTEGER;
        BEGIN
          env1 := env;
          lbVal := Term(node.lb, (*in-out*)env1, glob, mySelf);
          TYPECASE lbVal OF | ObValue.ValInt(node) =&gt; i:=node.int;
          ELSE ObValue.RaiseError(&quot;Lower bound of 'for' must be an integer&quot;,
                 term.location);
          END;
          env1 := env;
          ubVal := Term(node.ub, (*in-out*)env1, glob, mySelf);
          TYPECASE ubVal OF | ObValue.ValInt(node) =&gt; ub:=node.int;
          ELSE ObValue.RaiseError(&quot;Upper bound of 'for' must be an integer&quot;,
                 term.location);
          END;
          forEnv :=
            NEW(ObValue.LocalEnv, name:=node.binder, val:=NIL, rest:=env);
          TRY
            LOOP
              IF i&gt;ub THEN EXIT END;
              forEnv.val := NEW(ObValue.ValInt, int:=i, temp:=FALSE);
              env1 := forEnv;
              EVAL Term(node.body, (*in-out*)env1, glob, mySelf);
              INC(i);
            END;
          EXCEPT
          | ObValue.Error(pkt) =&gt;
              IF NOT Text.Equal(pkt.msg, &quot;exit&quot;) THEN
                RAISE ObValue.Error(pkt);
              END;
          END;
          result := ObValue.valOk;
        END;
      | ObTree.TermForeach(node) =&gt;
        VAR
          env1: ObValue.Env;
          forEnv: ObValue.LocalEnv;
          val, rangeVal: ObValue.Val;
          vals, oldVals, array1: Vals;
          i, ub: INTEGER;
        BEGIN
          env1 := env;
          rangeVal := Term(node.range, (*in-out*)env1, glob, mySelf);
          TYPECASE rangeVal OF
          | ObValue.ValArray(node) =&gt;
            TRY array1:=node.remote.Obtain();
            EXCEPT NetObj.Error(atoms) =&gt;
              ObValue.RaiseNetException(
                  &quot;on remote array access&quot;, atoms, term.location);
            END;
          ELSE ObValue.RaiseError(&quot;Range of 'for' must be an array&quot;,
                 term.location);
          END;
          i := 0;
          forEnv :=
            NEW(ObValue.LocalEnv, name:=node.binder, val:=NIL, rest:=env);
          TRY
            ub := NUMBER(array1^);
            IF node.map THEN
              vals := NEW(Vals, ub);
            END;
            LOOP
              IF i&gt;=ub THEN EXIT END;
              forEnv.val := array1^[i];
              env1 := forEnv;
              val := Term(node.body, (*in-out*)env1, glob, mySelf);
              IF node.map THEN vals^[i] := val END;
              INC(i);
            END;
          EXCEPT
          | ObValue.Error(pkt) =&gt;
              IF NOT Text.Equal(pkt.msg, &quot;exit&quot;) THEN
                RAISE ObValue.Error(pkt);
              ELSIF node.map THEN
                oldVals := vals;
                vals:=NEW(Vals, i);
                vals^ := SUBARRAY(oldVals^,0,i);
              END;
          | NetObj.Error(atoms) =&gt;
               ObValue.RaiseNetException(&quot;for&quot;, atoms, node.location);
          END;
          IF node.map THEN
            result := ObValue.NewArrayFromVals(vals);
          ELSE
            result := ObValue.valOk;
          END;
        END;
      | ObTree.TermException(node) =&gt;
        VAR
          env1: ObValue.Env;
        BEGIN
          env1 := env;
          TYPECASE Term(node.name, (*in-out*)env1, glob, mySelf) OF
          | ObValue.ValText(str) =&gt;
            result := NEW(ObValue.ValException, name:=str.text);
          ELSE ObValue.RaiseError(&quot;Argument of exception must be a text&quot;,
                 term.location);
          END;
        END;
      | ObTree.TermRaise(node) =&gt;
        VAR
          env1: ObValue.Env;
        BEGIN
          env1 := env;
          TYPECASE Term(node.exception, (*in-out*)env1, glob, mySelf) OF
          | ObValue.ValException(exc) =&gt;
              ObValue.RaiseException(exc, &quot;&quot;, node.location);
          ELSE ObValue.RaiseError(&quot;Argument of raise must be an exception&quot;,
                 term.location);
          END;
        END;
      | ObTree.TermTry(node) =&gt;
        VAR
          env1: ObValue.Env;
          tryList: ObTree.TermTryList;
        BEGIN
          TRY
            env1 := env;
            result := Term(node.body, (*in-out*)env1, glob, mySelf);
          EXCEPT
          | ObValue.Exception(packet) =&gt;
             tryList := node.tryList;
             LOOP
               IF tryList = NIL THEN RAISE ObValue.Exception(packet) END;
               IF tryList.exception = NIL THEN (* &quot;else&quot; case *)
                 env1 := env;
                 result := Term(tryList.recover, (*in-out*)env1, glob, mySelf);
                 EXIT;
               END;
               env1 := env;
               TYPECASE Term(tryList.exception, (*in-out*)env1, glob, mySelf) OF
               | ObValue.ValException(exc) =&gt;
                   IF ObValue.SameException(exc, packet.exception) THEN
                     env1 := env;
                     result :=
                       Term(tryList.recover, (*in-out*)env1, glob, mySelf);
                     EXIT;
                   END;
                   tryList := tryList.rest;
               ELSE ObValue.RaiseError(&quot;Guard of try must be an exception&quot;,
                   term.location);
               END;
             END;
          | ObValue.Error(packet) =&gt;
             tryList := node.tryList;
             LOOP
               IF tryList = NIL THEN RAISE ObValue.Error(packet);END;
               IF tryList.exception = NIL THEN (* &quot;else&quot; case *)
                 env1 := env;
                 result := Term(tryList.recover, (*in-out*)env1, glob, mySelf);
                 EXIT;
               END;
               tryList := tryList.rest;
             END;
          END;
        END;
      | ObTree.TermTryFinally(node) =&gt;
        VAR
          env1: ObValue.Env;
        BEGIN
          TRY
            env1 := env;
            result := Term(node.body, (*in-out*)env1, glob, mySelf);
          FINALLY
            env1 := env;
            result := Term(node.finally, (*in-out*)env1, glob, mySelf);
          END;
        END;
      | ObTree.TermWatch(node) =&gt;
        VAR
          env1: ObValue.Env;
          myLocalSelf: ObValue.RemObjServer;
        BEGIN
          TYPECASE mySelf OF
          | NULL =&gt; myLocalSelf := NIL;
          | ObValue.RemObjServer(remObjServer) =&gt;
              myLocalSelf := remObjServer;
          ELSE ObValue.RaiseError(
            &quot;watch-until does not work on remote objects&quot;, term.location);
          END;
          env1 := env;
          TYPECASE Term(node.condition, (*in-out*)env1, glob, mySelf) OF
          | ObBuiltIn.ValCondition(cond) =&gt;
              IF myLocalSelf=NIL THEN
                ObValue.RaiseError(&quot;watch-until must be used inside a method&quot;,
                  term.location);
              ELSIF myLocalSelf.sync=NIL THEN
                ObValue.RaiseError(
                  &quot;watch-until must be used inside a protected object&quot;,
                  term.location);
              ELSE
                LOOP
                  env1 := env;
                  TYPECASE Term(node.guard, (*in-out*)env1, glob, mySelf) OF
                  | ObValue.ValBool(guard) =&gt;
                      IF guard.bool THEN EXIT
                      ELSE Thread.Wait(myLocalSelf.sync.mutex, cond.condition);
                      END;
                  ELSE ObValue.RaiseError(
                    &quot;Argument 2 of watch-until must be a boolean&quot;,
                     term.location);
                  END;
                END;
                result := ObValue.valOk;
              END;
          ELSE ObValue.RaiseError(
            &quot;Argument 1 of watch-until must be a condition&quot;,
             term.location);
          END;
        END;
      ELSE &lt;*ASSERT FALSE*&gt;
      END;
      RETURN result;
    END Term;

  PROCEDURE <A NAME="Call"><procedure>Call</procedure></A>(clos: ObValue.ValFun;
    READONLY args: ObValue.Vals; loc: SynLocation.T:=NIL): ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  VAR env: ObValue.Env; binders: ObTree.IdeList;
  BEGIN
        IF clos.fun.bindersNo # NUMBER(args) THEN
          ObValue.RaiseError(ObValue.BadArgsNoMsg(clos.fun.bindersNo,
            NUMBER(args), &quot;&quot;, &quot;&quot;), loc);
        END;
        env := NIL;
        binders := clos.fun.binders;
        FOR i := 0 TO NUMBER(args)-1 DO
          env := NEW(ObValue.LocalEnv,
                name := binders.first, val := args[i],
                rest := env);
          binders := binders.rest;
        END;
        RETURN Term(clos.fun.body, (*in-out*)env, clos.global, NIL);
  END Call;

  PROCEDURE <A NAME="CallEngine"><procedure>CallEngine</procedure></A>(engine: ObValue.ValEngine; arg: ObValue.Val;
    loc: SynLocation.T:=NIL): ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
   BEGIN
	      TRY RETURN engine.remote.Eval(arg, NIL);
              EXCEPT
              | ObValue.ServerError(msg) =&gt;
                  ObValue.RaiseError(msg, loc); &lt;*ASSERT FALSE*&gt;
              | NetObj.Error(atoms) =&gt;
                  ObValue.RaiseNetException(
                    &quot;on remote engine execution&quot;, atoms, loc); &lt;*ASSERT FALSE*&gt;
              END;
  END CallEngine;

BEGIN
END ObEval.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
