<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/ObLib.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/ObLib.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="ObLib.m3">ObLib</A></interface>;
IMPORT <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="ObCommand.i3">ObCommand</A>, <A HREF="ObValue.i3">ObValue</A>;
</PRE> To set up a library one must provide (1) a name, (2) an array of opcodes,
   (3) an evaluator for the opcodes, (4) optionally, a help routine.
   Then one calls <CODE>ObLib.Register(...)</CODE> and <CODE>ObLib.RegisterHelp(...).
   Look at the end for an example. 

<P><PRE>TYPE

  T = (* To be subtyped. *)
    OBJECT
      name: TEXT;
        (* The name the obliq parser recognizes as the name of the library. *)

      opCodes: REF OpCodes;
        (* The array of opcodes for the operations in this library. *)

    METHODS
      Eval(code: OpCode; arity: OpArity; READONLY args: ObValue.ArgArray;
        temp: BOOLEAN; location: SynLocation.T): ObValue.Val
          RAISES {ObValue.Error, ObValue.Exception};
      (* To be overridden; the routine that evaluates opcodes.
         &quot;args&quot; is a 1-based array of ObValue.Val, filled with as
         many good arguments as specified by the arity.
         (arity&gt;=-1 is the arity of the call; arity=code.arity unless
          code.arity=-2). &quot;location&quot; is to be passed along to error
         message routines.
	*)
       (*
	 A TRUE temp parameter means that the value returned by this
	 operation is &quot;temporary&quot;, that is, it will immediately be passed
	 as a parameter to another operation. A temp optimization
	 is implemented for integers and reals, to recycle their allocated
	 value cells, within the built-in &quot;int&quot;, &quot;real&quot;, and &quot;math&quot; libraries.
	 IMPORTANT: Any library operations that returns an integer or a
	 real cells must obey these invariants: (A) It is sufficient to
	 actively ensure cell.temp=FALSE for any int or real result cell.
         (B) However, it is preferable to satisfy the following: (1) The temp
	 field of an int or real cell that is returned more than once must be
	 set to FALSE. (2) The temp field of a newly allocated int or real
	 cell that is returned must be set to the temp parameter of Eval.
	 (3) An int or real cell that is received as an argument has cell.temp
	 already set to FALSE (except for &quot;int&quot;, &quot;real&quot;, and &quot;math&quot; operations)..
	 (C) In any other situation, the temp parameter may be ignored.
       *)

      Encode(opName: TEXT; VAR(*out*)code: OpCode;
        location: SynLocation.T): BOOLEAN := EncodeTermOp;
      (* Not to be overridden. *)

    END;

  OpCodes = ARRAY OF OpCode;

  OpCode = (* To be subtyped *)
    OBJECT
      name: TEXT;
      (* The name the obliq parser recognizes as the name of the operation. *)

      arity: OpArity;
      (* &quot;arity&quot; &gt;= 0 for library procedures of &quot;arity&quot; arguments,
         &quot;arity&quot; = -1 for library constants.
         &quot;arity&quot; = -2 for &quot;don't check the arity&quot; (internal use).
      *)

      fixity: OpFixity:=OpFixity.Qualified;
      (* Its fixity (see below). *)
    END;

  OpArity = INTEGER;

  OpFixity =
    (* Fixity of a library operation. For library &quot;l&quot; and operation &quot;o&quot;,
       the operation can be invoked as follows within obliq: *)
    {Undefined,    (*  *)
     Qualified,    (*  &quot;l_o(...)&quot; *)
     Prefix,       (* &quot;o(...)&quot; or &quot;l_o(...)&quot; *)
     Infix         (* &quot;a1 o a2&quot;, &quot;o(a1,a2)&quot;, or &quot;l_o(a1,a2)&quot; *)
    };

  HelpProc =
    PROCEDURE(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL);

  Env =
    BRANDED OBJECT
      library: T;
      rest: Env;
    END;
    (* May contain multiple libraries of the same name, non-contiguously,
       forming a single conceptual library. *)

  VAR libraries: Env;
    (* Registered libraries are consend in front of this list. *)

  PROCEDURE <A HREF="ObLib.m3#Setup">Setup</A>();
  (* To be called before any other use of this module *)

  PROCEDURE <A HREF="ObLib.m3#Extend">Extend</A>(library: T; env: Env): Env;
  (* Add a library to the head of a library environment. The new library
     is searched before all the existing ones. If a library of the same name
     already exists in env, then the two libraries are conceptually merged. *)

  PROCEDURE <A HREF="ObLib.m3#Register">Register</A>(library: T);
  (* Register a library. (Same as libraries:=Extend(library, libraries,
     allowMerge).) Multiple libraries can be registered under the same name,
     achieving the effect of a single library with the union of the operations.
     (E.g. one can extend the built-in libraries this way.) *)

  PROCEDURE <A HREF="ObLib.m3#RegisterHelp">RegisterHelp</A>(name: TEXT; helpProc: HelpProc);
  (* Register a Help proc under the name &quot;name&quot;; this name does not have
     to be a library name, but usually will be one. *)

  (* Internal use. *)
  PROCEDURE <A HREF="ObLib.m3#Lookup">Lookup</A>(name: TEXT; env: Env): Env;
  (* Return the first enviroment cell whose library has the given name,
     or NIL if not found. *)
  PROCEDURE <A HREF="ObLib.m3#LookupFixity">LookupFixity</A>(opName: TEXT; env: Env; VAR (*out*)pkgName: TEXT)
    : OpFixity;
  PROCEDURE <A HREF="ObLib.m3#EncodeTermOp">EncodeTermOp</A>(self: T; opName: TEXT;
      VAR(*out*)code: OpCode; location: SynLocation.T): BOOLEAN;
  VAR helpCommandSet: ObCommand.Set;

END ObLib.
</PRE> ================= Example of a user library ================
   A library called <CODE>foo</CODE> with operations <CODE>failure</CODE> and <CODE>op1</CODE>
<P>
TYPE
  FooCode =
    {Failure, Op1}
<P>
  FooOpCode =
    ObLib.OpCode OBJECT
      code: FooCode;
    END;
<P>
  LibraryFoo =
    ObLib.T OBJECT
        (* data for EvalFoo 
      <PRE>OVERRIDES
        Eval := EvalFoo;
      END;

  VAR fooException: ObValue.Val;

  PROCEDURE SetupFoo() =
  VAR opCodes: ObLib.OpCodes;
  BEGIN
    opCodes := NEW(REF ObLib.OpCodes, NUMBER(FooCode));
    opCodes^ :=
        ObLib.OpCodes{
          NEW(FooOpCode, name:=&quot;failure&quot;, arity:=-1, code:=FooCode.Failure);
          NEW(FooOpCode, name:=&quot;op1&quot;, arity:=1, code:=FooCode.Op1)
        };
    fooException := Obliq.NewException(&quot;foo_failure&quot;);
    ObLib.Register(NEW(LibraryFoo, name:=&quot;foo&quot;, opCodes:=opCodes));
  END SetupFoo;

  PROCEDURE EvalFoo(self: LibraryFoo; opCode: ObLib.OpCode;
      READONLY args: ObValue.ArgArray; temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR int1: INTEGER;
    BEGIN
      CASE NARROW(opCode, FooOpCode).code OF
      | FooCode.Failure =&gt;
          RETURN fooException;
      | FooCode.Op1 =&gt;
          TYPECASE args[1] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(1, &quot;int&quot;, self.name, opCode.name, loc) END;
          IF (int1 &lt; 0) THEN (* Raise an error *)
            ObValue.BadArgVal(1, &quot;non-negative&quot;, self.name, opCode.name, loc);
          END;
          IF (int1 &gt; 99) THEN (* Raise an exception *)
            ObValue.RaiseException(fooException,
              self.name &amp; &quot;_&quot; &amp; opCode.name &amp; &quot;: argument too big&quot;, loc);
          END;

          (* Do whatever you want with the argument *)

          RETURN ObValue.valOk;
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
    END EvalFoo;

NOTES:
  How to structure the body of EvalFoo is up to you; this is just an
    example with efficient opcode dispatching. The body could also be a big
    if-then-else testing the text names of the opcodes.

  In ObValue.BadArgType, &quot;1&quot; is the argument number, and &quot;int&quot; is
    the expected argument type.

  In ObValue.BadArgVal, &quot;1&quot; is the argument number, and &quot;non-negative&quot;
    completes the error message &quot;argument 1 must be ...&quot;.

  Results must be legal ObValue.Val (not NIL!). See Obliq.i3
    for convenient value constructors and constants.
*)
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
