<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/ObLib.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/ObLib.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObLib.i3">ObLib</A></implements></module>;
IMPORT <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="ObCommand.i3">ObCommand</A>, <A HREF="../../text/src/Text.i3">Text</A>;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>()  =
  BEGIN
    libraries := NIL;
    helpCommandSet := ObCommand.NewSet();
  END Setup;

  PROCEDURE <A NAME="Extend"><procedure>Extend</procedure></A>(library: T; env: Env): Env =
    BEGIN
      IF Lookup(library.name, env)#NIL THEN
        RETURN NEW(Env, library:=library, rest:=env);
      ELSE
        RETURN NEW(Env, library:=library, rest:=env);
      END;
    END Extend;

  PROCEDURE <A NAME="Register"><procedure>Register</procedure></A>(library: T) =
    BEGIN
      libraries := Extend(library, libraries);
    END Register;

  PROCEDURE <A NAME="RegisterHelp"><procedure>RegisterHelp</procedure></A>(name: TEXT; helpProc: HelpProc) =
    BEGIN
      ObCommand.Register(helpCommandSet,
          NEW(ObCommand.T, name:=name,
              sortingName:=&quot;mod &quot; &amp; name,
              Exec:=helpProc));
    END RegisterHelp;

  PROCEDURE <A NAME="Lookup"><procedure>Lookup</procedure></A>(name: TEXT; env: Env): Env =
    BEGIN
      LOOP
        IF env=NIL THEN RETURN NIL END;
        IF Text.Equal(name, env.library.name) THEN RETURN env END;
        env := env.rest;
      END;
    END Lookup;

  PROCEDURE <A NAME="LookupFixity"><procedure>LookupFixity</procedure></A>(opName: TEXT; env: Env; VAR (*out*)libName: TEXT)
      : OpFixity =
    VAR opCodes: REF ARRAY OF OpCode;
    BEGIN
      LOOP
        IF env=NIL THEN RETURN OpFixity.Undefined END;
        opCodes := env.library.opCodes;
        FOR i:=0 TO NUMBER(opCodes^)-1 DO
          IF Text.Equal(opName, opCodes^[i].name) THEN
            libName := env.library.name;
            RETURN opCodes^[i].fixity;
          END;
        END;
        env := env.rest;
      END;
    END LookupFixity;

  PROCEDURE <A NAME="EncodeTermOp"><procedure>EncodeTermOp</procedure></A>(self: T; opName: TEXT;
      VAR(*out*)code: OpCode; &lt;*UNUSED*&gt;location: SynLocation.T): BOOLEAN =
    BEGIN
      FOR i:=FIRST(self.opCodes^) TO LAST(self.opCodes^) DO
        IF Text.Equal(opName, self.opCodes^[i].name) THEN
          code := self.opCodes^[i];
          RETURN TRUE;
        END;
      END;
      RETURN FALSE;
    END EncodeTermOp;

BEGIN
END ObLib.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
