<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/ObScope.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/ObScope.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObScope.i3">ObScope</A></implements></module>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="ObErr.i3">ObErr</A>, <A HREF="ObTree.i3">ObTree</A>, <A HREF="ObLib.i3">ObLib</A>;

REVEAL

  <A NAME="Env">Env</A> = BRANDED OBJECT END;

  <A NAME="TermEnv">TermEnv</A> =
    Env BRANDED OBJECT
      location: SynLocation.T;
      name: ObTree.IdeName;
      rest: Env;
    END;

PROCEDURE <A NAME="ScopeErrorMsg"><procedure>ScopeErrorMsg</procedure></A>(msg: TEXT; location: SynLocation.T) =
    BEGIN
      SynWr.Text(SynWr.out, msg, loud:=TRUE);
      SynWr.NewLine(SynWr.out, loud:=TRUE);
      SynWr.Text(SynWr.out, &quot;  &quot;, loud:=TRUE);
      SynLocation.PrintLocation(SynWr.out, location);
      SynWr.NewLine(SynWr.out, loud:=TRUE);
      SynWr.Flush(SynWr.out, loud:=TRUE);
   END ScopeErrorMsg;

PROCEDURE <A NAME="ScopeError"><procedure>ScopeError</procedure></A>(msg: TEXT; location: SynLocation.T)
    RAISES {ObErr.Fail} =
  BEGIN
    ScopeErrorMsg(msg, location);
    RAISE ObErr.Fail;
  END ScopeError;

PROCEDURE <A NAME="UnboundIdeMsg"><procedure>UnboundIdeMsg</procedure></A>(name: ObTree.IdeName; location: SynLocation.T) =
  BEGIN
    ScopeErrorMsg(&quot;Unbound term identifier: &quot; &amp; name.text, location);
  END UnboundIdeMsg;

PROCEDURE <A NAME="UnboundIdes"><procedure>UnboundIdes</procedure></A>(freeEnv: Env) RAISES {ObErr.Fail} =
  BEGIN
    IF freeEnv=NIL THEN RETURN END;
    LOOP
      TYPECASE freeEnv OF
      | NULL =&gt; EXIT;
      | TermEnv(node) =&gt;
          UnboundIdeMsg(node.name, node.location);
          freeEnv := node.rest;
      ELSE &lt;*ASSERT FALSE*&gt;
      END
    END;
    RAISE ObErr.Fail;
  END UnboundIdes;

PROCEDURE <A NAME="NewTermEnv"><procedure>NewTermEnv</procedure></A>(location: SynLocation.T; name: ObTree.IdeName;
     libEnv: ObLib.Env; rest: TermEnv): TermEnv RAISES {ObErr.Fail} =
  BEGIN
    CheckBuiltInIde(name, libEnv, location);
    RETURN NEW(TermEnv, location:=location, name:=name, rest:=rest);
  END NewTermEnv;

PROCEDURE <A NAME="ExtendEnv"><procedure>ExtendEnv</procedure></A>(binders: ObTree.IdeList; libEnv: ObLib.Env; env: Env;
    VAR(*in-out*)no: INTEGER): Env RAISES {ObErr.Fail} =
  BEGIN
    IF binders = NIL THEN RETURN env;
    ELSE
      INC(no);
      RETURN
        ExtendEnv(binders.rest, libEnv,
          NewTermEnv(binders.location, binders.first, libEnv, env),
          (*in-out*)no);
    END;
  END ExtendEnv;

PROCEDURE <A NAME="EnvLength"><procedure>EnvLength</procedure></A>(env: TermEnv): INTEGER =
VAR i: INTEGER;
BEGIN
  i:=0; WHILE env#NIL DO env:=env.rest; INC(i); END; RETURN i;
END EnvLength;

PROCEDURE <A NAME="CheckBuiltInIde"><procedure>CheckBuiltInIde</procedure></A>(name: ObTree.IdeName; libEnv: ObLib.Env;
    location: SynLocation.T) RAISES {ObErr.Fail} =
  VAR pkgName: TEXT;
  BEGIN
      IF ObLib.Lookup(name.text, libEnv)#NIL THEN
          ScopeError(&quot;Identifier '&quot; &amp; name.text &amp;
            &quot;' is reserved as the name of a module&quot;,
            location);
      END;
      CASE ObLib.LookupFixity(name.text, libEnv, (*out*)pkgName) OF
      | ObLib.OpFixity.Undefined, ObLib.OpFixity.Qualified =&gt;
      | ObLib.OpFixity.Infix, ObLib.OpFixity.Prefix =&gt;
          ScopeError(&quot;Identifier '&quot; &amp; name.text &amp;
            &quot;' is reserved by module '&quot; &amp; pkgName &amp; &quot;'&quot;,
            location);
      END;
  END CheckBuiltInIde;

PROCEDURE <A NAME="LookupTermIdeGlobal"><procedure>LookupTermIdeGlobal</procedure></A>(name: ObTree.IdeName; libEnv: ObLib.Env;
    location: SynLocation.T; VAR (*in-out*)global: Env): ObTree.IdePlace
    RAISES {ObErr.Fail}=
  VAR env: TermEnv;
  BEGIN
    env := global;
    LOOP
      IF env=NIL THEN
        global := NewTermEnv(location, name, libEnv, global);
        RETURN NEW(ObTree.IdePlaceGlobal, index:=EnvLength(global));
      ELSE
	IF ObTree.SameIdeName(name, env.name) THEN
	  RETURN NEW(ObTree.IdePlaceGlobal, index:=EnvLength(env));
	ELSE env := env.rest;
	END;
      END;
    END;
  END LookupTermIdeGlobal;

PROCEDURE <A NAME="LookupTermIde"><procedure>LookupTermIde</procedure></A>(name: ObTree.IdeName; libEnv: ObLib.Env;
        location: SynLocation.T;
	local: Env; VAR (*in-out*)global: Env):
	ObTree.IdePlace RAISES {ObErr.Fail} =
  VAR index: INTEGER;
  BEGIN
    index := 1;
    LOOP
      TYPECASE local OF
      | NULL =&gt;
        RETURN LookupTermIdeGlobal(name, libEnv, location, (*in-out*)global);
      | TermEnv(node) =&gt;
	    IF ObTree.SameIdeName(name, node.name) THEN
	      RETURN NEW(ObTree.IdePlaceLocal, index:=index);
	    ELSE
	      INC(index);
	      local := node.rest;
	    END;
      ELSE &lt;*ASSERT FALSE*&gt;
      END;
    END;
  END LookupTermIde;

PROCEDURE <A NAME="LookupTermGlobals"><procedure>LookupTermGlobals</procedure></A>(free: Env; local: Env; libEnv: ObLib.Env;
    VAR (*in-out*)global: Env; VAR (*in-out*)globalsNo: INTEGER)
    : ObTree.Globals RAISES {ObErr.Fail}=
  VAR closure: ObTree.Globals;
  BEGIN
    closure := NIL;
    LOOP
      TYPECASE free OF
      | NULL =&gt; RETURN closure;
      | TermEnv(node) =&gt;
        closure :=
          NEW(ObTree.Globals,
            location := node.location,
            name := node.name,
            place :=
              LookupTermIde(node.name, libEnv,
                            node.location, local, (*in-out*)global),
            rest := closure);
        INC(globalsNo);
        free := node.rest;
	  ELSE &lt;*ASSERT FALSE*&gt;
      END;
    END;
  END LookupTermGlobals;

PROCEDURE <A NAME="ScopeTermBinding"><procedure>ScopeTermBinding</procedure></A>(binding: ObTree.TermBinding; libEnv: ObLib.Env;
    initEnv,env: Env;  VAR (*in-out*)global: Env): Env RAISES {ObErr.Fail} =
  VAR local1: Env;
  BEGIN
    TYPECASE binding OF
    | NULL =&gt; RETURN env;
    | ObTree.TermBinding(node) =&gt;
        local1 := initEnv;
	ScopeTerm(node.term, libEnv, (*in-out*)local1, (*in-out*)global);
	RETURN ScopeTermBinding(node.rest, libEnv, initEnv,
	  NewTermEnv(binding.location,
	      node.binder, libEnv, env), (*in-out*)global);
    END;
  END ScopeTermBinding;

PROCEDURE <A NAME="ScopeTermBindingRec1"><procedure>ScopeTermBindingRec1</procedure></A>(binding: ObTree.TermBinding; libEnv: ObLib.Env;
    env: Env): Env RAISES {ObErr.Fail} =
  BEGIN
    TYPECASE binding OF
    | NULL =&gt; RETURN env;
    | ObTree.TermBinding(node) =&gt;
        IF NOT ISTYPE(node.term, ObTree.TermFun) THEN
          ScopeError(&quot;Non-function found in recursive definition: &quot; &amp;
            node.binder.text, node.location);
        END;
	RETURN ScopeTermBindingRec1(node.rest, libEnv,
	  NewTermEnv(binding.location, node.binder, libEnv, env));
    END;
  END ScopeTermBindingRec1;

PROCEDURE <A NAME="ScopeTermBindingRec2"><procedure>ScopeTermBindingRec2</procedure></A>(binding: ObTree.TermBinding; libEnv: ObLib.Env;
    recEnv: Env; VAR (*in-out*)global: Env) RAISES {ObErr.Fail} =
  VAR local1: Env;
  BEGIN
    TYPECASE binding OF
    | NULL =&gt;
    | ObTree.TermBinding(node) =&gt;
        local1 := recEnv;
	ScopeTerm(node.term, libEnv, (*in-out*)local1, (*in-out*)global);
	ScopeTermBindingRec2(node.rest, libEnv, recEnv, (*in-out*)global);
    END;
  END ScopeTermBindingRec2;

PROCEDURE <A NAME="ScopeTermList"><procedure>ScopeTermList</procedure></A>(list: ObTree.TermList; libEnv: ObLib.Env; local: Env;
    VAR (*in-out*)global: Env; temp: BOOLEAN:=FALSE): INTEGER
    RAISES {ObErr.Fail} =
  VAR local1: Env;
  BEGIN
    TYPECASE list OF
    | NULL =&gt; RETURN 0;
    | ObTree.TermList(node) =&gt;
        local1 := local;
        ScopeTerm(node.first, libEnv, (*in-out*)local1, (*in-out*)global, temp);
        RETURN 1 + ScopeTermList(node.rest, libEnv, local,
			(*in-out*)global, temp);
    END;
  END ScopeTermList;
</PRE> Temporary value analysis done for constants, and conditionals. 
   Could be extended to case and let 

<P><PRE>PROCEDURE <A NAME="ScopeTerm"><procedure>ScopeTerm</procedure></A>(term: ObTree.Term; libEnv: ObLib.Env;
    VAR (*in-out*)local,global: Env; temp: BOOLEAN:=FALSE) RAISES {ObErr.Fail} =
  VAR local1, newLocal, newGlobal: Env; libName: TEXT;
      lib: ObLib.Env; opCode: ObLib.OpCode;
      optimizeTemps: BOOLEAN;
  BEGIN
    TYPECASE term OF
    | NULL =&gt; ObErr.Fault(SynWr.out, &quot;ScopeTerm NIL&quot;);
    | ObTree.TermIde(node) =&gt;
	node.place :=
	  LookupTermIde(node.name, libEnv,
                        node.location, local, (*in-out*)global);
    | ObTree.TermConstant =&gt;
    | ObTree.TermArray(node) =&gt;
        node.elemsNo :=
	  ScopeTermList(node.elems, libEnv, local, (*in-out*)global);
    | ObTree.TermOption(node) =&gt;
        local1 := local;
        ScopeTerm(node.term, libEnv, local1, (*in-out*)global);
    | ObTree.TermAlias(node) =&gt;
        local1 := local;
        ScopeTerm(node.term, libEnv, local1, (*in-out*)global);
    | ObTree.TermOp(node) =&gt;
	libName := node.pkg.text;
        lib := ObLib.Lookup(libName, libEnv);
	IF lib = NIL THEN
          ScopeError(&quot;Unknown module: &quot; &amp; node.pkg.text, term.location);
        END;
	optimizeTemps :=
	  Text.Equal(libName, &quot;int&quot;) OR Text.Equal(libName, &quot;real&quot;)
	    OR  Text.Equal(libName, &quot;math&quot;);
        LOOP
          IF lib.library.Encode(node.op.text, (*out*)opCode, term.location)
          THEN
            IF node.argsNo#-1 (* not a TermOpConst *) THEN
              node.argsNo :=
                ScopeTermList(node.args, libEnv, local, (*in-out*)global,
		  optimizeTemps);
            END;
	    node.temp := temp;
            node.package := lib.library;
            node.opCode := opCode;
            EXIT;
          END;
          lib := ObLib.Lookup(node.pkg.text, lib.rest);
          IF lib=NIL THEN
            ScopeError(&quot;Unknown operation: &quot; &amp;
              node.pkg.text &amp; &quot;_&quot; &amp; node.op.text, term.location);
          END;
        END;
    | ObTree.TermFun(node) =&gt;
        node.bindersNo:=0;
        newLocal :=
            ExtendEnv(node.binders, libEnv, NIL, (*in-out*)node.bindersNo);
        newGlobal := NIL;
	ScopeTerm(node.body, libEnv, (*in-out*)newLocal, (*in-out*)newGlobal);
	node.globalsNo := 0;
	node.globals :=
	  LookupTermGlobals(newGlobal, local, libEnv,
	    (*in-out*)global, (*in-out*)node.globalsNo)
    | ObTree.TermAppl(node) =&gt;
        local1 := local;
	ScopeTerm(node.fun, libEnv, (*in-out*)local1, (*in-out*)global);
	node.argsNo := ScopeTermList(node.args, libEnv, local, (*in-out*)global);
    | ObTree.TermObj(node) =&gt;
        node.fieldsNo :=
          ScopeObjFields(node.fields, libEnv, local, (*in-out*)global);
    | ObTree.TermMeth(node) =&gt;
        node.bindersNo:=0;
        newLocal :=
            ExtendEnv(node.binders, libEnv, NIL, (*in-out*)node.bindersNo);
        newGlobal := NIL;
	ScopeTerm(node.body, libEnv, (*in-out*)newLocal, (*in-out*)newGlobal);
	node.globalsNo := 0;
	node.globals :=
	  LookupTermGlobals(newGlobal, local, libEnv,
	    (*in-out*)global, (*in-out*)node.globalsNo)
    | ObTree.TermClone(node) =&gt;
        node.objsNo := ScopeTermList(node.objs, libEnv, local, (*in-out*)global);
    | ObTree.TermSelect(node) =&gt;
        local1 := local;
        ScopeTerm(node.obj, libEnv, (*in-out*)local1, (*in-out*)global);
        IF node.invoke THEN
	  node.argsNo := ScopeTermList(node.args, libEnv, local, (*in-out*)global);
	END;
    | ObTree.TermRedirect(node) =&gt;
        local1 := local;
	ScopeTerm(node.obj, libEnv, (*in-out*)local1, (*in-out*)global);
        local1 := local;
	ScopeTerm(node.toObj, libEnv, (*in-out*)local1, (*in-out*)global);
    | ObTree.TermUpdate(node) =&gt;
        local1 := local;
	ScopeTerm(node.obj, libEnv, (*in-out*)local1, (*in-out*)global);
        local1 := local;
	ScopeTerm(node.term, libEnv, (*in-out*)local1, (*in-out*)global);
    | ObTree.TermLet(node) =&gt;
        IF node.rec THEN
          local := ScopeTermBindingRec1(node.binding, libEnv, local);
          ScopeTermBindingRec2(node.binding, libEnv, local, (*in-out*)global);
        ELSE
          local :=
            ScopeTermBinding(node.binding, libEnv, local, local, (*in-out*)global);
        END;
    | ObTree.TermSeq(node) =&gt;
        local1 := local;
	ScopeTerm(node.before, libEnv, (*in-out*)local1, (*in-out*)global);
	ScopeTerm(node.after, libEnv, (*in-out*)local1, (*in-out*)global);
    | ObTree.TermAssign(node) =&gt;
	node.place :=
	  LookupTermIde((*mod*)node.name, libEnv, node.location,
	    local, (*in-out*)global);
        local1 := local;
        ScopeTerm(node.val, libEnv, (*in-out*)local1, (*in-out*)global);
    | ObTree.TermIf(node) =&gt;
        local1 := local;
	ScopeTerm(node.test, libEnv, (*in-out*)local1, (*in-out*)global);
        local1 := local;
	ScopeTerm(node.ifTrue, libEnv,
		(*in-out*)local1, (*in-out*)global, temp);
        IF node.ifFalse # NIL THEN
          local1 := local;
	  ScopeTerm(node.ifFalse, libEnv,
		(*in-out*)local1, (*in-out*)global, temp);
        END;
    | ObTree.TermCase(node) =&gt;
        local1 := local;
	ScopeTerm(node.option, libEnv, (*in-out*)local1, (*in-out*)global);
	ScopeTermCaseList(node.caseList, libEnv, local, (*in-out*)global);
    | ObTree.TermLoop(node) =&gt;
        local1 := local;
	ScopeTerm(node.loop, libEnv, (*in-out*)local1, (*in-out*)global);
    | ObTree.TermExit =&gt;
    | ObTree.TermFor(node) =&gt;
        local1 := local;
	ScopeTerm(node.lb, libEnv, (*in-out*)local1, (*in-out*)global);
        local1 := local;
	ScopeTerm(node.ub, libEnv, (*in-out*)local1, (*in-out*)global);
        local1 := NewTermEnv(node.location, node.binder, libEnv, local);
	ScopeTerm(node.body, libEnv, (*in-out*)local1, (*in-out*)global);
    | ObTree.TermForeach(node) =&gt;
        local1 := local;
	ScopeTerm(node.range, libEnv, (*in-out*)local1, (*in-out*)global);
        local1 := NewTermEnv(node.location, node.binder, libEnv, local);
	ScopeTerm(node.body, libEnv, (*in-out*)local1, (*in-out*)global);
    | ObTree.TermException(node) =&gt;
        local1 := local;
	ScopeTerm(node.name, libEnv, (*in-out*)local1, (*in-out*)global);
    | ObTree.TermRaise(node) =&gt;
        local1 := local;
	ScopeTerm(node.exception, libEnv, (*in-out*)local1, (*in-out*)global);
    | ObTree.TermTry(node) =&gt;
        local1 := local;
	ScopeTerm(node.body, libEnv, (*in-out*)local1, (*in-out*)global);
	ScopeTermTryList(node.tryList, libEnv, local, (*in-out*)global);
    | ObTree.TermTryFinally(node) =&gt;
        local1 := local;
	ScopeTerm(node.body, libEnv, (*in-out*)local1, (*in-out*)global);
        local1 := local;
	ScopeTerm(node.finally, libEnv, (*in-out*)local1, (*in-out*)global);
    | ObTree.TermWatch(node) =&gt;
        local1 := local;
	ScopeTerm(node.condition, libEnv, (*in-out*)local1, (*in-out*)global);
        local1 := local;
	ScopeTerm(node.guard, libEnv, (*in-out*)local1, (*in-out*)global);
    ELSE ObErr.Fault(SynWr.out, &quot;ScopeTerm&quot;);
    END;
  END ScopeTerm;

PROCEDURE <A NAME="ScopeObjFields"><procedure>ScopeObjFields</procedure></A>(fields: ObTree.TermObjFields; libEnv: ObLib.Env;
    local: Env; VAR (*in-out*)global: Env): INTEGER RAISES {ObErr.Fail} =
  VAR local1: Env;
  BEGIN
    TYPECASE fields OF
    | NULL =&gt; RETURN 0;
    | ObTree.TermObjFields(node) =&gt;
        local1 := local;
        ScopeTerm(node.term, libEnv, (*in-out*)local1, (*in-out*)global);
        RETURN 1 + ScopeObjFields(node.rest, libEnv, local, (*in-out*)global);
    END
  END ScopeObjFields;

PROCEDURE <A NAME="ScopeTermCaseList"><procedure>ScopeTermCaseList</procedure></A>(list: ObTree.TermCaseList; libEnv: ObLib.Env;
    local: Env; VAR (*in-out*)global: Env) RAISES {ObErr.Fail} =
  VAR local1: Env;
  BEGIN
    TYPECASE list OF
    | NULL =&gt;
    | ObTree.TermCaseList(node) =&gt;
        IF node.binder=NIL THEN
          local1 := local;
        ELSE
          local1 := NewTermEnv(node.location, node.binder, libEnv, local);
        END;
        ScopeTerm(node.body, libEnv, (*in-out*)local1, (*in-out*)global);
        ScopeTermCaseList(node.rest, libEnv, local, (*in-out*)global);
    END;
  END ScopeTermCaseList;

PROCEDURE <A NAME="ScopeTermTryList"><procedure>ScopeTermTryList</procedure></A>(list: ObTree.TermTryList; libEnv: ObLib.Env;
    local: Env; VAR (*in-out*)global: Env) RAISES {ObErr.Fail} =
  VAR local1: Env;
  BEGIN
    TYPECASE list OF
    | NULL =&gt;
    | ObTree.TermTryList(node) =&gt;
        IF node.exception#NIL THEN
          local1 := local;
          ScopeTerm(node.exception, libEnv, (*in-out*)local1,
                    (*in-out*)global)
        END;
        local1 := local;
        ScopeTerm(node.recover, libEnv, (*in-out*)local1, (*in-out*)global);
        ScopeTermTryList(node.rest, libEnv, local, (*in-out*)global);
    END;
  END ScopeTermTryList;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
  END Setup;

BEGIN
END ObScope.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
