<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/ObTree.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/ObTree.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="ObTree.m3">ObTree</A></interface>;
IMPORT <A HREF="ObCommand.i3">ObCommand</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

TYPE

  IdeName =
    SynLocation.Located BRANDED &quot;IdeName&quot; OBJECT
      text: TEXT;
      variant: INTEGER;
    END;

  IdePlace = BRANDED &quot;IdePlace&quot; OBJECT END;
  IdePlaceLocal = IdePlace BRANDED &quot;IdePlaceLocal&quot; OBJECT
      index: INTEGER; (* &gt; 0 *)
    END;
  IdePlaceGlobal = IdePlace BRANDED &quot;IdePlaceGlobal&quot; OBJECT
      index: INTEGER; (* &gt; 0 *)
    END;

  Globals =
    SynLocation.Located BRANDED &quot;Globals&quot; OBJECT
      name: IdeName;
      place: IdePlace;
      rest: Globals;
    END;

  Phrase =
    SynLocation.Located BRANDED OBJECT END;

  PhraseCommand =
    Phrase BRANDED OBJECT
      set: ObCommand.Set;
      name, arg: TEXT;
    END;

  PhraseTerm =
    Phrase BRANDED OBJECT
      term: Term;
      printDepth: INTEGER;
    END;

  TermBinding =
    SynLocation.Located BRANDED &quot;TermBinding&quot; OBJECT
      binder: IdeName;
      term: Term;
      rest: TermBinding;
    END;

  Term =
    SynLocation.Located BRANDED &quot;Term&quot; OBJECT END;

  TermConstant =
    Term BRANDED &quot;TermConstant&quot; OBJECT
      cache: REFANY:=NIL;
    END;

  TermIde =
    Term BRANDED &quot;TermIde&quot; OBJECT
      name: IdeName;
      place: IdePlace;
    END;

  TermOk =
    TermConstant BRANDED &quot;TermOk&quot; OBJECT
    END;

  TermBool =
    TermConstant BRANDED &quot;TermBool&quot; OBJECT
      bool: BOOLEAN;
    END;

  TermChar =
    TermConstant BRANDED &quot;TermChar&quot; OBJECT
      char: CHAR;
    END;

  TermText =
    TermConstant BRANDED &quot;TermText&quot; OBJECT
      text: TEXT;
    END;

  TermInt =
    TermConstant BRANDED &quot;TermInt&quot; OBJECT
      int: INTEGER;
    END;

  TermReal =
    TermConstant BRANDED &quot;TermReal&quot; OBJECT
      real: LONGREAL
    END;

  TermArray =
    Term BRANDED &quot;TermArray&quot; OBJECT
      elems: TermList;
      elemsNo: INTEGER;
    END;

  TermOption =
    Term BRANDED &quot;TermOption&quot; OBJECT
      tag: IdeName;
      term: Term;
    END;

  TermOp =
    Term BRANDED &quot;TermOp&quot; OBJECT
      pkg, op: IdeName;
      args: TermList;
      argsNo: INTEGER;
      temp: BOOLEAN; (* Is the result a temporary value? *)
      package: ROOT (* ObPkg.T *);
      opCode: ROOT (* ObPkg.OpCode *);
    END;

  TermFun =
    Term BRANDED &quot;TermFun&quot; OBJECT
      binders: IdeList;
      bindersNo: INTEGER;
      body: Term;
      globals: Globals;
      globalsNo: INTEGER;
    END;

  TermAppl =
    Term BRANDED &quot;TermAppl&quot; OBJECT
      fun: Term;
      args: TermList;
      argsNo: INTEGER;
    END;

  TermMeth =
    Term BRANDED &quot;TermMeth&quot; OBJECT
      binders: IdeList;
      bindersNo: INTEGER;
      body: Term;
      globals: Globals;
      globalsNo: INTEGER;
    END;

  TermAlias =
    Term BRANDED &quot;TermAlias&quot; OBJECT
      label: IdeName;
      term: Term;
    END;

  TermObj =
    Term BRANDED &quot;TermObj&quot; OBJECT
      protected: BOOLEAN;
      sync: Sync; (* NIL if not synchronized. *)
      fields: TermObjFields;
      fieldsNo: INTEGER;
    END;

  Sync = {None, Monitored, Reentrant};

  TermObjFields =
    SynLocation.Located BRANDED &quot;TermObjFields&quot; OBJECT
      label: IdeName;
      term: Term;
      rest: TermObjFields;
    END;

  TermClone =
    Term BRANDED &quot;TermClone&quot; OBJECT
      objs: TermList;
      objsNo: INTEGER;
    END;

  TermRedirect =
    Term BRANDED &quot;TermRedirect&quot; OBJECT
      obj: Term;
      toObj: Term;
    END;

  TermSelect =
    Term BRANDED &quot;TermSelect&quot; OBJECT
      obj: Term;
      label: IdeName;
      labelIndexHint: INTEGER;
      invoke: BOOLEAN;
      args: TermList;
      argsNo: INTEGER;
    END;

  TermUpdate =
    Term BRANDED &quot;TermUpdate&quot; OBJECT
      obj: Term;
      label: IdeName;
      labelIndexHint: INTEGER;
      term: Term;
    END;

  TermSeq =
    Term BRANDED &quot;TermSeq&quot; OBJECT
      before,after: Term;
    END;

  TermLet =
    Term BRANDED &quot;TermLet&quot; OBJECT
      var, rec: BOOLEAN;
      binding: TermBinding;
    END;

  TermAssign =
    Term BRANDED &quot;TermAssign&quot; OBJECT
      name: IdeName;
      place: IdePlace;
      val: Term;
    END;

  TermIf =
    Term BRANDED &quot;TermIf&quot; OBJECT
      test,ifTrue: Term;
      ifFalse: Term; (* NIL if no else branch *)
    END;

  TermCase =
    Term BRANDED &quot;TermCase&quot; OBJECT
      option: Term;
      caseList: TermCaseList;
    END;

  TermLoop =
    Term BRANDED &quot;TermLoop&quot; OBJECT
      loop: Term;
    END;

  TermExit =
    Term BRANDED &quot;TermExit&quot; OBJECT
    END;

  TermFor =
    Term BRANDED &quot;TermFor&quot; OBJECT
      binder: IdeName;
      lb,ub,body: Term;
    END;

  TermForeach =
    Term BRANDED &quot;TermForeach&quot; OBJECT
      binder: IdeName;
      range, body: Term;
      map: BOOLEAN;
    END;

  TermException =
    Term BRANDED &quot;TermException&quot; OBJECT
      name: Term;
    END;

  TermRaise =
    Term BRANDED &quot;TermRaise&quot; OBJECT
      exception: Term;
    END;

  TermTry =
    Term BRANDED &quot;TermTry&quot; OBJECT
      body: Term;
      tryList: TermTryList;
    END;

  TermTryFinally =
    Term BRANDED &quot;TermFinally&quot; OBJECT
      body: Term;
      finally: Term;
    END;

  TermWatch =
    Term BRANDED &quot;TermWatch&quot; OBJECT
      condition, guard: Term;
    END;

  TermCaseList =
    SynLocation.Located BRANDED &quot;TermCaseList&quot; OBJECT
      tag: IdeName;       (* NIL for &quot;else&quot; *)
      binder: IdeName;    (* NIL for &quot;else&quot; or for no binder *)
      body: Term;
      rest: TermCaseList; (* NIL for &quot;else&quot; *)
    END;

  TermTryList =
    SynLocation.Located BRANDED &quot;TermTryList&quot; OBJECT
      exception: Term;    (* NIL for &quot;else&quot; *)
      recover: Term;
      rest: TermTryList;  (* NIL for &quot;else&quot; *)
    END;

  IdeList =
    SynLocation.Located BRANDED &quot;TermIdeList&quot; OBJECT
      first: IdeName;
      rest: IdeList;
    END;

  TermList =
    SynLocation.Located BRANDED &quot;TermList&quot; OBJECT
      first: Term;
      rest: TermList;
    END;

  Env =
     OBJECT
        name: IdeName;
        decoration: INTEGER;
        rest: Env;
     END;

  PROCEDURE <A HREF="ObTree.m3#Setup">Setup</A>();
  (* To be called before any other use of this module *)

  PROCEDURE <A HREF="ObTree.m3#ExtendEnv">ExtendEnv</A>(binders: IdeList; env: Env): Env;
  PROCEDURE <A HREF="ObTree.m3#NewEnv">NewEnv</A>(name: IdeName; rest: Env): Env;
  PROCEDURE <A HREF="ObTree.m3#BeEnv">BeEnv</A>(env: Env; name: IdeName; rest: Env);
  PROCEDURE <A HREF="ObTree.m3#FreshDecoration">FreshDecoration</A>(name: IdeName; env: Env): INTEGER;

  VAR
    noName: IdeName;
    doCommandSet: ObCommand.Set;

  PROCEDURE <A HREF="ObTree.m3#SameIdeName">SameIdeName</A>(name1, name2: IdeName): BOOLEAN;

  PROCEDURE <A HREF="ObTree.m3#FmtBool">FmtBool</A>(bool: BOOLEAN): TEXT;

  PROCEDURE <A HREF="ObTree.m3#FmtInt">FmtInt</A>(int: INTEGER): TEXT;

  PROCEDURE <A HREF="ObTree.m3#FmtReal">FmtReal</A>(real: LONGREAL): TEXT;

END ObTree.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
