<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/ObTree.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/ObTree.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObTree.i3">ObTree</A></implements></module>;
IMPORT <A HREF="ObCommand.i3">ObCommand</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>;

  PROCEDURE <A NAME="SameIdeName"><procedure>SameIdeName</procedure></A>(name1, name2: IdeName): BOOLEAN  =
    BEGIN
      RETURN Text.Equal(name1.text, name2.text) AND
        (name1.variant=name2.variant);
    END SameIdeName;

  PROCEDURE <A NAME="BeEnv"><procedure>BeEnv</procedure></A>(env: Env; name: IdeName; rest: Env)  =
  BEGIN
    env.name := name;
    env.decoration := FreshDecoration(name, rest);
    env.rest := rest;
  END BeEnv;

  PROCEDURE <A NAME="NewEnv"><procedure>NewEnv</procedure></A>(name: IdeName; rest: Env): Env  =
  VAR env: Env;
  BEGIN
    env := NEW(Env);
    BeEnv(env, name, rest);
    RETURN env;
  END NewEnv;

  PROCEDURE <A NAME="ExtendEnv"><procedure>ExtendEnv</procedure></A>(binders: IdeList; env: Env): Env  =
  BEGIN
    IF binders=NIL THEN RETURN env;
    ELSE RETURN ExtendEnv(binders.rest, NewEnv(binders.first, env));
    END;
  END ExtendEnv;

  PROCEDURE <A NAME="FreshDecoration"><procedure>FreshDecoration</procedure></A>(name: IdeName; env: Env): INTEGER  =
  BEGIN
    LOOP
      IF env=NIL THEN RETURN 0 END;
      IF Text.Equal(env.name.text, name.text) THEN RETURN env.decoration+1 END;
      env := env.rest;
    END;
  END FreshDecoration;

  PROCEDURE <A NAME="FmtBool"><procedure>FmtBool</procedure></A>(bool: BOOLEAN): TEXT =
  BEGIN
    IF bool
    THEN RETURN &quot;true&quot;;
    ELSE RETURN &quot;false&quot;;
    END;
  END FmtBool;

  PROCEDURE <A NAME="FmtInt"><procedure>FmtInt</procedure></A>(int: INTEGER): TEXT =
  BEGIN
    IF int &gt;=0
    THEN RETURN Fmt.Int(int);
    ELSE RETURN &quot;~&quot; &amp; Fmt.Int(-int);
    END;
  END FmtInt;

  PROCEDURE <A NAME="FmtReal"><procedure>FmtReal</procedure></A>(real: LONGREAL): TEXT =
  VAR r: TEXT;
  BEGIN
    IF real &gt;= 0.0d0 THEN
      r := Fmt.LongReal(real);
    ELSE
      r := Fmt.LongReal(-real);
    END;
    IF (Text.FindChar(r, '.')=-1) AND (Text.FindChar(r, 'e')=-1)
      AND (Text.FindChar(r, 'D')=-1)
      (* -- 'D' check is temporary, until the reimplementation of Fmt *)
    THEN
      r := r &amp; &quot;.0&quot;;
    END;
    IF real &gt;= 0.0d0
    THEN RETURN r;
    ELSE RETURN &quot;~&quot; &amp; r;
    END;
  END FmtReal;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>()  =
  BEGIN
    noName := NEW(IdeName, text:=&quot;&quot;, variant:=-1);
    doCommandSet := ObCommand.NewSet();
  END Setup;

BEGIN
END ObTree.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
