<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/ObValue.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/ObValue.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObValue.i3">ObValue</A></implements></module>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="ObTree.i3">ObTree</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../atom/src/Atom.i3">Atom</A>,
  <A HREF="ObEval.i3">ObEval</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../pickle/src/Pickle.i3">Pickle</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>, <A HREF="../../types/src/Refany.i3">Refany</A>,
  <A HREF="../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../rw/src/Common/FileWr.i3">FileWr</A>;
IMPORT <A HREF="../../params/src/Env.i3">Env</A> AS ProcEnv;

  REVEAL
    <A NAME="RemVarServer">RemVarServer</A> =
      RemVar BRANDED &quot;RemVarServer&quot; OBJECT
        val: Val;
      OVERRIDES
        Get := VarGet;
        Set := VarSet;
      END;

   <A NAME="RemArrayServer">RemArrayServer</A> =
     RemArray BRANDED &quot;RemArrayServer&quot; OBJECT
       array: REF Vals;
     OVERRIDES
       Size := ArraySize;
       Get := ArrayGet;
       Set := ArraySet;
       Sub := ArraySub;
       Upd := ArrayUpd;
       Obtain := ArrayObtain;
     END;

    <A NAME="RemObjServer">RemObjServer</A> =
      RemObjServerPublic BRANDED &quot;RemObjServer&quot; OBJECT
        self: ValObj;
        fields: REF ObjFields;
        protected: BOOLEAN;
      OVERRIDES
        Who := ObjWho;
        Select := ObjSelect;
        Invoke := ObjInvoke;
        Update := ObjUpdate;
        Redirect := ObjRedirect;
        Has := ObjHas;
        Obtain := ObjObtain;
      END;

    <A NAME="RemFileSystemServer">RemFileSystemServer</A> =
      RemFileSystem BRANDED &quot;RemFileSystemServer&quot; OBJECT
        readOnly: BOOLEAN;
      OVERRIDES
        OpenRead := FileSystemOpenRead;
        OpenWrite := FileSystemOpenWrite;
        OpenAppend := FileSystemOpenAppend;
      END;

VAR
  sysCallTable: TextRefTbl.Default;

  (* -- There should be a better way. *)
  PROCEDURE <A NAME="ThisMachine"><procedure>ThisMachine</procedure></A>(): TEXT =
    VAR address: TEXT;
    BEGIN
      address := ProcEnv.Get(&quot;MYMACHINE&quot;);
      IF (address=NIL) OR Text.Empty(address) THEN
        address:=ProcEnv.Get(&quot;MACHINE&quot;);
      END;
      IF (address=NIL) OR Text.Empty(address) THEN
        address:=&quot;&lt;unknown&gt;&quot;;
      END;
      RETURN address;
    END ThisMachine;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
    BEGIN
      valOk := NEW(ValOk);
      netException := NEW(ValException, name:=&quot;net_failure&quot;);
      threadAlerted := NEW(ValException, name:=&quot;thread_alerted&quot;);
      machineAddress := ThisMachine();

      sysCallTable := NEW(TextRefTbl.Default).init();
      sysCallFailure := NEW(ValException, name:=&quot;sys_callFailure&quot;);
      showNetObjMsgs := FALSE;

      localProcessor := NewProcessor();
      InhibitTransmission(TYPECODE(ValProcessor),
                          &quot;processors cannot be transmitted/duplicated&quot;);
    END Setup;

  PROCEDURE <A NAME="RaiseError"><procedure>RaiseError</procedure></A>(msg: TEXT; location: SynLocation.T) RAISES {Error} =
  BEGIN
    RAISE Error(NEW(ErrorPacket, msg:=msg, location:=location));
  END RaiseError;

  PROCEDURE <A NAME="RaiseServerError"><procedure>RaiseServerError</procedure></A>(msg: TEXT) RAISES {ServerError} =
  BEGIN
    RAISE ServerError(msg);
  END RaiseServerError;

  PROCEDURE <A NAME="SameException"><procedure>SameException</procedure></A>(exc1, exc2: ValException): BOOLEAN =
    BEGIN
      RETURN Text.Equal(exc1.name, exc2.name);
    END SameException;

  PROCEDURE <A NAME="RaiseException"><procedure>RaiseException</procedure></A>(exception: ValException; msg: TEXT;
      loc: SynLocation.T) RAISES {Exception} =
    BEGIN
      RAISE Exception(
        NEW(ExceptionPacket, msg:=msg,
            location:=loc, exception:=exception, data:=NIL));
    END RaiseException;

  PROCEDURE <A NAME="RaiseNetException"><procedure>RaiseNetException</procedure></A>(msg: TEXT; atoms: AtomList.T; loc: SynLocation.T)
    RAISES {Exception} =
  BEGIN
    IF showNetObjMsgs THEN
      msg := msg &amp; &quot; (NetObj says:&quot;;
      WHILE atoms # NIL DO
        msg := msg &amp; &quot; &quot; &amp; Atom.ToText(atoms.head);
        atoms := atoms.tail;
      END;
      msg := msg &amp; &quot;)&quot;;
    END;
    RaiseException(netException, msg, loc);
  END RaiseNetException;

    PROCEDURE <A NAME="ErrorMsg"><procedure>ErrorMsg</procedure></A>(swr: SynWr.T; packet: ErrorPacket) =
    BEGIN
      Msg(swr, &quot;Execution error &quot;, packet.msg, packet.location);
    END ErrorMsg;

  PROCEDURE <A NAME="ExceptionMsg"><procedure>ExceptionMsg</procedure></A>(swr: SynWr.T; packet: ExceptionPacket) =
    VAR name: TEXT;
    BEGIN
      name := packet.exception.name;
      IF NOT Text.Empty(packet.msg) THEN
        name := name &amp; &quot; (&quot; &amp; packet.msg &amp; &quot;)&quot;;
      END;
      Msg(swr, &quot;Uncaught exception &quot;, name, packet.location);
    END ExceptionMsg;

  PROCEDURE <A NAME="Msg"><procedure>Msg</procedure></A>(swr: SynWr.T; msgKind, msg: TEXT;
      sourceLocation: SynLocation.T)  =
    BEGIN
      SynWr.Beg(swr, 2, loud:=TRUE);
        SynWr.Text(swr, msgKind, loud:=TRUE);
        SynLocation.PrintLocation(swr, sourceLocation);
      SynWr.End(swr, loud:=TRUE);
      SynWr.NewLine(swr, loud:=TRUE);

      SynWr.Text(swr, msg, loud:=TRUE);
      SynWr.NewLine(swr, loud:=TRUE);
      SynWr.Flush(swr, loud:=TRUE);
    END Msg;

  PROCEDURE <A NAME="BadOp"><procedure>BadOp</procedure></A>(pkg, op: TEXT; location: SynLocation.T) RAISES {Error} =
  BEGIN
    RaiseError(&quot;Unknown operation: &quot; &amp; pkg &amp; &quot;_&quot; &amp; op, location);
  END BadOp;

  PROCEDURE <A NAME="BadArgType"><procedure>BadArgType</procedure></A>(argNo: INTEGER; expected, pkg, op: TEXT;
    location: SynLocation.T) RAISES {Error} =
  BEGIN
    RaiseError(
      &quot;Argument &quot; &amp; Fmt.Int(argNo) &amp; &quot; of &quot; &amp; pkg &amp; &quot;_&quot; &amp; op
      &amp; &quot; must have type &quot; &amp; expected, location);
  END BadArgType;

  PROCEDURE <A NAME="BadArgVal"><procedure>BadArgVal</procedure></A>(argNo: INTEGER; expected, pkg, op: TEXT;
    location: SynLocation.T) RAISES {Error} =
  BEGIN
    RaiseError(
      &quot;Argument &quot; &amp; Fmt.Int(argNo) &amp; &quot; of &quot; &amp; pkg &amp; &quot;_&quot; &amp; op
      &amp; &quot; must be &quot; &amp; expected, location);
  END BadArgVal;

  PROCEDURE <A NAME="NewEnv"><procedure>NewEnv</procedure></A>(name: ObTree.IdeName; env: Env): Env =
  BEGIN
    RETURN NEW(LocalEnv, name:=name, val:=NIL, rest:=env);
  END NewEnv;

  PROCEDURE <A NAME="ExtendEnv"><procedure>ExtendEnv</procedure></A>(binders: ObTree.IdeList; env: Env): Env =
  BEGIN
    IF binders=NIL THEN RETURN env;
    ELSE RETURN ExtendEnv(binders.rest, NewEnv(binders.first, env));
    END;
  END ExtendEnv;

  PROCEDURE <A NAME="PrintWhat"><procedure>PrintWhat</procedure></A>(self: ValAnything): TEXT =
  BEGIN
    RETURN self.what;
  END PrintWhat;

  PROCEDURE <A NAME="IsSelfOther"><procedure>IsSelfOther</procedure></A>(self, other: ValAnything): BOOLEAN =
  BEGIN
    RETURN self=other;
  END IsSelfOther;

  PROCEDURE <A NAME="Is"><procedure>Is</procedure></A>(v1,v2: Val; &lt;*UNUSED*&gt;location: SynLocation.T): BOOLEAN =
  BEGIN
    TYPECASE v1 OF
    | ValOk =&gt;
        TYPECASE v2 OF
        | ValOk =&gt; RETURN TRUE;
        ELSE RETURN FALSE;
        END;
    | ValBool(node1) =&gt;
        TYPECASE v2 OF
        | ValBool(node2) =&gt; RETURN node1.bool = node2.bool;
        ELSE RETURN FALSE;
        END;
    | ValChar(node1) =&gt;
        TYPECASE v2 OF
        | ValChar(node2) =&gt; RETURN node1.char = node2.char;
        ELSE RETURN FALSE;
        END;
    | ValText(node1) =&gt;
        TYPECASE v2 OF
        | ValText(node2) =&gt; RETURN Text.Equal(node1.text, node2.text);
        ELSE RETURN FALSE;
        END;
    | ValException(node1) =&gt;
        TYPECASE v2 OF
        | ValException(node2) =&gt; RETURN Text.Equal(node1.name, node2.name);
        ELSE RETURN FALSE;
        END;
    | ValInt(node1) =&gt;
        TYPECASE v2 OF
        | ValInt(node2) =&gt; RETURN node1.int = node2.int;
        ELSE RETURN FALSE;
        END;
    | ValReal(node1) =&gt;
        TYPECASE v2 OF
        | ValReal(node2) =&gt; RETURN node1.real = node2.real;
        ELSE RETURN FALSE;
        END;
    | ValArray(node1) =&gt;
        TYPECASE v2 OF
        | ValArray(node2) =&gt; RETURN node1.remote = node2.remote;
        ELSE RETURN FALSE;
        END;
    | ValAnything(node1) =&gt;
        TYPECASE v2 OF
        | ValAnything(node2) =&gt; RETURN node1.Is(node2);
        ELSE RETURN FALSE;
        END;
    | ValOption(node1) =&gt;
        TYPECASE v2 OF
        | ValOption(node2) =&gt; RETURN node1 = node2;
        ELSE RETURN FALSE;
        END;
    | ValFun(node1) =&gt;
        TYPECASE v2 OF
        | ValFun(node2) =&gt; RETURN node1 = node2;
        ELSE RETURN FALSE;
        END;
    | ValMeth(node1) =&gt;
        TYPECASE v2 OF
        | ValMeth(node2) =&gt; RETURN node1 = node2;
        ELSE RETURN FALSE;
        END;
    | ValObj(node1) =&gt;
        TYPECASE v2 OF
        | ValObj(node2) =&gt; RETURN node1.remote = node2.remote;
        ELSE RETURN FALSE;
        END;
    | ValAlias(node1) =&gt;
        TYPECASE v2 OF
        | ValAlias(node2) =&gt; RETURN node1 = node2;
        ELSE RETURN FALSE;
        END;
    | ValEngine(node1) =&gt;
        TYPECASE v2 OF
        | ValEngine(node2) =&gt; RETURN node1.remote = node2.remote;
        ELSE RETURN FALSE;
        END;
    ELSE &lt;*ASSERT FALSE*&gt;
    END;
  END Is;

  PROCEDURE <A NAME="NewText"><procedure>NewText</procedure></A>(text: TEXT): Val =
  BEGIN
    IF text=NIL THEN text:=&quot;&quot; END;
    RETURN NEW(ValText, text:=text);
  END NewText;

  PROCEDURE <A NAME="NewVar"><procedure>NewVar</procedure></A>(val: Val): ValVar =
  BEGIN
    RETURN
      NEW(ValVar,
        remote := NEW(RemVarServer, val:=val));
  END NewVar;

  PROCEDURE <A NAME="VarGet"><procedure>VarGet</procedure></A>(self: RemVarServer): Val RAISES {} =
  BEGIN
    RETURN self.val;
  END VarGet;

  PROCEDURE <A NAME="VarSet"><procedure>VarSet</procedure></A>(self: RemVarServer; val: Val) RAISES {} =
  BEGIN
    self.val := val;
  END VarSet;

  PROCEDURE <A NAME="NewArray"><procedure>NewArray</procedure></A>(READONLY vals: Vals): ValArray =
  VAR newVals: REF Vals;
  BEGIN
    newVals := NEW(REF Vals, NUMBER(vals));
    newVals^ := vals;
    RETURN NewArrayFromVals(newVals);
  END NewArray;

  PROCEDURE <A NAME="NewArrayFromVals"><procedure>NewArrayFromVals</procedure></A>(vals: REF Vals): ValArray =
  BEGIN
    RETURN
      NEW(ValArray,
        remote := NEW(RemArrayServer, array:=vals));
  END NewArrayFromVals;

  PROCEDURE <A NAME="ArraySize"><procedure>ArraySize</procedure></A>(arr: RemArrayServer): INTEGER RAISES {} =
  BEGIN
    RETURN NUMBER(arr.array^);
  END ArraySize;

  PROCEDURE <A NAME="ArrayGet"><procedure>ArrayGet</procedure></A>(self: RemArrayServer; i: INTEGER): Val
    RAISES {ServerError} =
  BEGIN
    IF (i&lt;0) OR (i&gt;=NUMBER(self.array^)) THEN
      RaiseServerError(&quot;arg not in range&quot;)
    END;
    RETURN self.array^[i];
  END ArrayGet;

  PROCEDURE <A NAME="ArraySet"><procedure>ArraySet</procedure></A>(self: RemArrayServer; i: INTEGER; val: Val)
    RAISES {ServerError} =
  BEGIN
    IF (i&lt;0) OR (i&gt;=NUMBER(self.array^)) THEN
      RaiseServerError(&quot;arg 1 not in range&quot;);
    END;
    self.array^[i]:=val;
  END ArraySet;

  PROCEDURE <A NAME="ArraySub"><procedure>ArraySub</procedure></A>(self: RemArrayServer; start,size: INTEGER)
    : ValArray RAISES {ServerError} =
  VAR len: INTEGER; vals: REF Vals;
  BEGIN
    len := NUMBER(self.array^);
    IF (start&lt;0) OR (start&gt;len) THEN
      RaiseServerError(&quot;arg 2 not in range&quot;);
    END;
    IF (size&lt;0) OR (start+size&gt;len) THEN
      RaiseServerError(&quot;arg 3 not in range&quot;);
    END;
    vals := NEW(REF Vals, size);
    FOR i:=0 TO size-1 DO vals^[i] := self.array^[start+i]; END;
    RETURN NEW(ValArray,
      remote:=NEW(RemArrayServer, array:=vals));
  END ArraySub;

  PROCEDURE <A NAME="ArrayUpd"><procedure>ArrayUpd</procedure></A>(self: RemArrayServer; start, size: INTEGER;
    READONLY otherArr: REF Vals) RAISES {ServerError, NetObj.Error} =
  VAR selfLen, otherLen: INTEGER; selfArr: REF Vals;
  BEGIN
    selfArr := self.array;
    selfLen := NUMBER(selfArr^);
    IF (start&lt;0) OR (start&gt;selfLen) THEN
      RaiseServerError(&quot;arg 2 not in range&quot;);
    END;
    IF (size&lt;0) OR (start+size&gt;selfLen) THEN
      RaiseServerError(&quot;arg 3 not in range of arg 1&quot;);
    END;
    otherLen := NUMBER(otherArr^);
    IF size&gt;otherLen THEN
      RaiseServerError(&quot;arg 3 not in range of arg 4&quot;);
    END;
    FOR i:=size-1 TO 0 BY -1 DO selfArr^[start+i] := otherArr^[i]; END;
  END ArrayUpd;

  PROCEDURE <A NAME="ArrayObtain"><procedure>ArrayObtain</procedure></A>(self: RemArrayServer): REF Vals
    RAISES {} =
  BEGIN
    RETURN self.array;
  END ArrayObtain;

  PROCEDURE <A NAME="ArrayCat"><procedure>ArrayCat</procedure></A>(vals1, vals2: REF Vals):
    Val RAISES {} =
  VAR len1, len2: INTEGER; vals: REF Vals;
  BEGIN
    len1 := NUMBER(vals1^);
    len2 := NUMBER(vals2^);
    vals := NEW(REF Vals, len1+len2);
    FOR i:=0 TO len1-1 DO vals^[i] := vals1^[i]; END;
    FOR i:=0 TO len2-1 DO vals^[len1+i] := vals2^[i]; END;
    RETURN NEW(ValArray, remote:=NEW(RemArrayServer, array:=vals));
  END ArrayCat;

  PROCEDURE <A NAME="NewObject"><procedure>NewObject</procedure></A>(READONLY fields: ObjFields;
    who: TEXT:=&quot;&quot;; protected: BOOLEAN:=FALSE; sync: Sync:=NIL): ValObj =
  VAR remFields: REF ObjFields;
  BEGIN
    remFields := NEW(REF ObjFields, NUMBER(fields));
    remFields^ := fields;
    RETURN NewObjectFromFields(remFields, who, protected, sync);
  END NewObject;

  PROCEDURE <A NAME="NewObjectFromFields"><procedure>NewObjectFromFields</procedure></A>(fields: REF ObjFields;
    who: TEXT; protected: BOOLEAN; sync: Sync): ValObj =
  VAR remObjServ: RemObjServer;
  BEGIN
    remObjServ :=
      NEW(RemObjServer,
        who:=who,
        self:=NEW(ValObj, remote:=NIL),
        fields:=fields,
        protected := protected,
        sync := sync);
    remObjServ.self.remote := remObjServ;
    RETURN remObjServ.self;
  END NewObjectFromFields;

  PROCEDURE <A NAME="ObjWho"><procedure>ObjWho</procedure></A>(self: RemObjServer;
    VAR(*out*) protected, serialized: BOOLEAN): TEXT RAISES {} =
  BEGIN
    protected := self.protected;
    serialized := self.sync # NIL;
    RETURN self.who;
  END ObjWho;

  PROCEDURE <A NAME="ObjClone1"><procedure>ObjClone1</procedure></A>(remObj: RemObj; mySelf: RemObj): ValObj
      RAISES {ServerError, NetObj.Error} =
    VAR res: RemObjServer; resWho, remWho: TEXT;
    VAR fieldsOf1: REF ObjFields;
    VAR resSize: INTEGER; resFields: REF ObjFields;
    VAR protected, serialized: BOOLEAN; sync: Sync;
  BEGIN
    remWho := remObj.Who((*out*)protected, (*out*) serialized);
    IF Text.Empty(remWho) THEN remWho := &quot;someone&quot; END;
    resWho := &quot;clone of &quot; &amp; remWho;
    fieldsOf1 := remObj.Obtain(remObj=mySelf);
    resSize := NUMBER(fieldsOf1^);
    resFields := NEW(REF ObjFields, resSize);
    resFields^ := fieldsOf1^;
    IF serialized THEN sync := NEW(Sync, mutex:=NEW(Thread.Mutex))
    ELSE sync:=NIL
    END;
    res := NEW(RemObjServer,
      who:=resWho,
      self:=NEW(ValObj, remote:=NIL),
      fields:=resFields,
      protected := protected,
      sync := sync);
    res.self.remote := res;
    RETURN res.self;
  END ObjClone1;

  PROCEDURE <A NAME="ObjClone"><procedure>ObjClone</procedure></A>(READONLY remObjs: ARRAY OF RemObj; mySelf: RemObj): ValObj
      RAISES {ServerError, NetObj.Error} =
    VAR res: RemObjServer; resWho, remWho: TEXT;
    VAR fieldsOfN: REF ARRAY OF REF ObjFields;
    VAR resSize,k: INTEGER; ithFields, resFields: REF ObjFields;
    VAR protected, protected1, serialized, serialized1: BOOLEAN; sync: Sync;
  BEGIN
    resWho := &quot;clone of&quot;;
    protected := FALSE; serialized := FALSE;
    fieldsOfN := NEW(REF ARRAY OF REF ObjFields, NUMBER(remObjs));
    FOR i:=0 TO NUMBER(remObjs)-1 DO
      remWho := remObjs[i].Who((*out*)protected1, (*out*)serialized1);
      IF i=0 THEN
        protected := protected1; serialized := serialized1;
      END;
      IF Text.Empty(remWho) THEN remWho := &quot;someone&quot; END;
      resWho := resWho &amp; &quot; &quot; &amp; remWho;
      fieldsOfN^[i] := remObjs[i].Obtain(remObjs[i]=mySelf);
    END;
    resSize := 0;
    FOR i:=0 TO NUMBER(fieldsOfN^)-1 DO
      ithFields := fieldsOfN^[i];
      INC(resSize, NUMBER(ithFields^));
    END;
    resFields := NEW(REF ObjFields, resSize);
    k := 0;
    FOR i:=0 TO NUMBER(fieldsOfN^)-1 DO
      ithFields := fieldsOfN^[i];
      FOR j:=0 TO NUMBER(ithFields^)-1 DO
        resFields^[k] := ithFields^[j];
        INC(k);
      END;
    END;
    IF NUMBER(fieldsOfN^) &gt; 1 THEN
      FOR i:=0 TO resSize-1 DO
        FOR j:=i+1 TO resSize-1 DO
          IF Text.Equal(resFields^[i].label, resFields^[j].label) THEN
              RaiseServerError(
                &quot;duplicated field on cloning: &quot; &amp; resFields^[i].label);
          END;
        END;
      END;
    END;
    IF serialized THEN sync := NEW(Sync, mutex:=NEW(Thread.Mutex))
    ELSE sync:=NIL
    END;
    res := NEW(RemObjServer,
      who:=resWho,
      self:=NEW(ValObj, remote:=NIL),
      fields:=resFields,
      protected := protected,
      sync := sync);
    res.self.remote := res;
    RETURN res.self;
  END ObjClone;

  PROCEDURE <A NAME="BadArgsNoMsg"><procedure>BadArgsNoMsg</procedure></A>(desired, found: INTEGER;
      routineKind, routineName: TEXT): TEXT =
    VAR msg: TEXT;
    BEGIN
      msg := &quot;Expecting &quot; &amp; Fmt.Int(desired);
      IF desired=1 THEN
        msg := msg &amp; &quot; argument&quot;;
      ELSE
        msg := msg &amp; &quot; arguments&quot;;
      END;
      msg := msg &amp; &quot;, not &quot; &amp; Fmt.Int(found);
      IF NOT Text.Empty(routineKind) THEN
        msg := msg &amp; &quot;, for &quot; &amp; routineKind &amp; &quot;: &quot; &amp; routineName;
      END;
      RETURN  msg;
    END BadArgsNoMsg;

  PROCEDURE <A NAME="ObjSelect"><procedure>ObjSelect</procedure></A>(self: RemObjServer; label: TEXT;
    internal: BOOLEAN; VAR (*in-out*) hint: INTEGER): Val
    RAISES {ServerError, Error, Exception, NetObj.Error} =
  VAR lock: BOOLEAN; fields: REF ObjFields; newEnv: Env;
    fieldsNo, fieldIndex: INTEGER; fieldVal: Val; objMu: Thread.Mutex;
  BEGIN
    lock := (NOT internal) AND (self.sync # NIL);
    IF lock THEN objMu:=self.sync.mutex; Thread.Acquire(objMu) END;
    TRY

      fields := self.fields;
      fieldsNo := NUMBER(fields^);
      fieldIndex := -1;
      IF (hint&gt;=0) AND (hint&lt;fieldsNo) AND Text.Equal(label, fields^[hint].label)
      THEN fieldIndex := hint;
      ELSE
        FOR i:=0 TO fieldsNo-1 DO
          IF Text.Equal(label, fields^[i].label) THEN
            fieldIndex := i; EXIT;
          END;
        END;
        IF fieldIndex=-1 THEN
          RaiseServerError(&quot;Field not found in object: &quot; &amp; label);
        END;
        hint := fieldIndex;
      END;
      fieldVal := fields^[fieldIndex].field;

      TYPECASE fieldVal OF
      | ValMeth(meth) =&gt;
          (* Consider a method with zero parameters as a field. *)
          IF meth.meth.bindersNo-1 # 0 THEN
            RaiseServerError(
              BadArgsNoMsg(meth.meth.bindersNo-1, 0, &quot;method&quot;, label));
          END;
	  newEnv := NEW(LocalEnv, name:=meth.meth.binders.first,
	    val:=self.self, rest:=NIL);
          RETURN ObEval.Term(meth.meth.body, (*in-out*)newEnv, meth.global, self);
      | ValAlias(alias) =&gt;
          TYPECASE alias.obj OF
          | ValObj(valObj) =&gt;
              RETURN valObj.remote.Select(alias.label, valObj.remote=self,
                (*var*)alias.labelIndexHint);
          END;
      ELSE RETURN fieldVal;
      END;

    FINALLY IF lock THEN Thread.Release(objMu) END;
    END;
  END ObjSelect;

  PROCEDURE <A NAME="ObjHas"><procedure>ObjHas</procedure></A>(self: RemObjServer; label: TEXT; VAR hint: INTEGER)
    : BOOLEAN RAISES {NetObj.Error} =
  VAR fields: REF ObjFields;
  BEGIN
    fields := self.fields;
    FOR i:=0 TO NUMBER(fields^)-1 DO
        IF Text.Equal(label, fields^[i].label) THEN
          hint := i;
          RETURN TRUE;
        END;
    END;
    RETURN FALSE;
  END ObjHas;

  PROCEDURE <A NAME="ObjInvoke"><procedure>ObjInvoke</procedure></A>(self: RemObjServer; label: TEXT;
    argsNo: INTEGER; READONLY args: Vals; internal: BOOLEAN;
    VAR (*in-out*) hint: INTEGER): Val
    RAISES {ServerError, Error, Exception, NetObj.Error} =
  VAR lock: BOOLEAN; fields: REF ObjFields; binderList: ObTree.IdeList;
    newEnv: Env; fieldsNo, fieldIndex: INTEGER; fieldVal: Val;
    objMu: Thread.Mutex;
  BEGIN
    lock := (NOT internal) AND (self.sync # NIL);
    IF lock THEN objMu:=self.sync.mutex; Thread.Acquire(objMu) END;
    TRY

      fields := self.fields;
      fieldsNo := NUMBER(fields^);
      fieldIndex := -1;
      IF (hint&gt;=0) AND (hint&lt;fieldsNo) AND
          Text.Equal(label, fields^[hint].label) THEN
        fieldIndex := hint;
      ELSE
        FOR i:=0 TO fieldsNo-1 DO
          IF Text.Equal(label, fields^[i].label) THEN
            fieldIndex := i; EXIT;
          END;
        END;
        IF fieldIndex=-1 THEN
          RaiseServerError(&quot;Field not found in object: &quot; &amp; label);
        END;
        hint := fieldIndex;
      END;
      fieldVal := fields^[fieldIndex].field;

      TYPECASE fieldVal OF
      | ValMeth(meth) =&gt;
          IF meth.meth.bindersNo-1 # argsNo THEN
            RaiseServerError(
              BadArgsNoMsg(meth.meth.bindersNo-1, argsNo, &quot;method&quot;, label));
          END;
          binderList := meth.meth.binders;
	      newEnv :=
	        NEW(LocalEnv, name:=binderList.first, val:=self.self, rest:=NIL);
              binderList := binderList.rest;
          FOR i:=0 TO argsNo-1 DO
            newEnv := NEW(LocalEnv, name:=binderList.first,
	          val:=args[i], rest:=newEnv);
	        binderList := binderList.rest;
          END;
	      RETURN
	        ObEval.Term(meth.meth.body, (*in-out*)newEnv, meth.global, self);
      | ValAlias(alias) =&gt;
        TYPECASE alias.obj OF
        | ValObj(valObj) =&gt;
            RETURN valObj.remote.Invoke(alias.label, argsNo, args,
              valObj.remote=self, (*in-out*)alias.labelIndexHint);
        END;
      ELSE RaiseServerError(&quot;Field used as a method: &quot; &amp; label); &lt;*ASSERT FALSE*&gt;
      END;

    FINALLY IF lock THEN Thread.Release(objMu) END;
    END;
  END ObjInvoke;

  PROCEDURE <A NAME="ObjUpdate"><procedure>ObjUpdate</procedure></A>(self: RemObjServer; label: TEXT; val: Val;
    internal: BOOLEAN; VAR (*in-out*) hint: INTEGER)
    RAISES {ServerError, NetObj.Error} =
  VAR lock: BOOLEAN; fields: REF ObjFields; fieldsNo, fieldIndex: INTEGER;
    objMu: Thread.Mutex;
  BEGIN
    lock := (NOT internal) AND (self.sync # NIL);
    IF lock THEN objMu:=self.sync.mutex; Thread.Acquire(objMu) END;
    TRY

      IF self.protected AND (NOT internal) THEN
        RaiseServerError(&quot;Cannot update protected object&quot;);
      END;
      fields := self.fields;
      fieldsNo := NUMBER(fields^);
      fieldIndex := -1;
      IF (hint&gt;=0) AND (hint&lt;fieldsNo) AND Text.Equal(label, fields^[hint].label)
      THEN fieldIndex := hint;
      ELSE
        FOR i:=0 TO fieldsNo-1 DO
          IF Text.Equal(label, fields^[i].label) THEN
            fieldIndex := i; EXIT;
          END;
        END;
        IF fieldIndex=-1 THEN
          RaiseServerError(&quot;Field not found in object: &quot; &amp; label);
        END;
        hint := fieldIndex;
      END;

      TYPECASE fields^[fieldIndex].field OF
      | ValAlias(alias) =&gt;
        TYPECASE alias.obj OF
        | ValObj(valObj) =&gt;
            TYPECASE val OF
            | ValAlias =&gt; fields^[fieldIndex].field := val
            ELSE valObj.remote.Update(alias.label, val, valObj.remote=self,
                (*in-out*)alias.labelIndexHint);
            END;
        END;
      ELSE fields^[fieldIndex].field := val;
      END;

    FINALLY IF lock THEN Thread.Release(objMu) END;
    END;
  END ObjUpdate;

  PROCEDURE <A NAME="ObjRedirect"><procedure>ObjRedirect</procedure></A>(self: RemObjServer; val: Val;
    internal: BOOLEAN) RAISES {ServerError, NetObj.Error} =
  VAR lock: BOOLEAN; fields, newFields: REF ObjFields; fieldsNo: INTEGER;
      label: TEXT; hint: INTEGER; objMu: Thread.Mutex;
  BEGIN
    lock := (NOT internal) AND (self.sync # NIL);
    IF lock THEN objMu:=self.sync.mutex; Thread.Acquire(objMu) END;
    TRY

      IF self.protected AND (NOT internal) THEN
        RaiseServerError(&quot;Cannot redirect protected object&quot;);
      END;
      fields := self.fields;
      fieldsNo := NUMBER(fields^);
      newFields := NEW(REF ObjFields, fieldsNo);
      TYPECASE val OF
      | ValObj(obj) =&gt;
          FOR i:=0 TO fieldsNo-1 DO
            label := fields^[i].label;
            newFields^[i].label := label;
            IF obj.remote.Has(label, (*in-out*)hint) THEN
              newFields^[i].field :=
                NEW(ValAlias, label:=label, labelIndexHint := hint, obj:=obj);
            ELSE RaiseServerError(&quot;Field not found in object on redirection: &quot;
              &amp; label);
            END;
          END;
          self.fields := newFields; (* atomic swap *)
      ELSE RaiseServerError(&quot;Redirection target must be an object&quot;);
      END;

    FINALLY IF lock THEN Thread.Release(objMu) END;
    END;
  END ObjRedirect;

  PROCEDURE <A NAME="ObjObtain"><procedure>ObjObtain</procedure></A>(self: RemObjServer; internal: BOOLEAN): REF ObjFields
    RAISES {ServerError, NetObj.Error} =
  VAR lock: BOOLEAN; objMu: Thread.Mutex;
  BEGIN
    lock := (NOT internal) AND (self.sync # NIL);
    IF lock THEN objMu:=self.sync.mutex; Thread.Acquire(objMu) END;
    TRY

      IF self.protected AND (NOT internal) THEN
        RaiseServerError(&quot;Cannot obtain protected object&quot;);
      END;
      RETURN self.fields;

    FINALLY IF lock THEN Thread.Release(objMu) END;
    END;
  END ObjObtain;

  PROCEDURE <A NAME="NewAlias"><procedure>NewAlias</procedure></A>(obj: ValObj; label: TEXT;location: SynLocation.T)
    : ValAlias RAISES {Error, Exception} =
  VAR hint: INTEGER;
  BEGIN
    TRY
      IF obj.remote.Has(label, (*var*)hint) THEN
        RETURN
          NEW(ValAlias, label:=label,
            labelIndexHint := hint, obj:=obj);
      ELSE
        RaiseError(&quot;Field not found in object: &quot; &amp; label, location); &lt;*ASSERT FALSE*&gt;
      END;
    EXCEPT
    | NetObj.Error(atoms) =&gt;
       RaiseNetException(&quot;on remote object access&quot;, atoms, location); &lt;*ASSERT FALSE*&gt;
    END;
  END NewAlias;

  PROCEDURE <A NAME="EngineWho"><procedure>EngineWho</procedure></A>(self: RemEngineServer): TEXT RAISES {} =
  BEGIN
    RETURN self.who;
  END EngineWho;

  PROCEDURE <A NAME="EngineEval"><procedure>EngineEval</procedure></A>(self: RemEngineServer; proc: Val; mySelf: RemObj)
    : Val RAISES {Error, Exception, ServerError, NetObj.Error} =
  VAR newEnv: Env; newGlob: GlobalEnv;
  BEGIN
    TYPECASE proc OF
    | ValFun(clos) =&gt;
       IF 1 # clos.fun.bindersNo THEN
         RaiseServerError(&quot;Engine needs a procedure of 1 argument as argument&quot;);
        END;
        newGlob := clos.global;
        newEnv := NEW(LocalEnv, name:=clos.fun.binders.first,
	            val:=self.arg, rest:=NIL);
        RETURN ObEval.Term(clos.fun.body,
	    (*in-out*)newEnv, newGlob, mySelf);
    ELSE RaiseServerError(&quot;Engine needs a procedure as argument&quot;); &lt;*ASSERT FALSE*&gt;
    END;
  END EngineEval;

  PROCEDURE <A NAME="NewFileSystem"><procedure>NewFileSystem</procedure></A>(readOnly: BOOLEAN): ValFileSystem =
  BEGIN
    RETURN
      NEW(ValFileSystem,
          picklable := FALSE,
          what:=&quot;&lt;FileSystem at &quot; &amp; machineAddress &amp; &quot;&gt;&quot;,
          remote := NEW(RemFileSystemServer, readOnly:=readOnly));
  END NewFileSystem;

  PROCEDURE <A NAME="FileSystemIs"><procedure>FileSystemIs</procedure></A>(self: ValFileSystem; other: ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF
    | ValFileSystem(oth) =&gt;
      RETURN self.remote = oth.remote;
    ELSE RETURN FALSE;
    END;
  END FileSystemIs;

  PROCEDURE <A NAME="FileSystemOpenRead"><procedure>FileSystemOpenRead</procedure></A>(&lt;*UNUSED*&gt;self: RemFileSystemServer; fileName: TEXT)
    : Rd.T RAISES {NetObj.Error, ServerError} =
  BEGIN
    TRY RETURN FileRd.Open(fileName);
    EXCEPT OSError.E =&gt; RaiseServerError(&quot;FileSystemOpenRead&quot;); &lt;*ASSERT FALSE*&gt; END;
  END FileSystemOpenRead;

  PROCEDURE <A NAME="FileSystemOpenWrite"><procedure>FileSystemOpenWrite</procedure></A>(self: RemFileSystemServer; fileName: TEXT)
    : Wr.T RAISES {NetObj.Error, ServerError} =
  BEGIN
    IF self.readOnly THEN RaiseServerError(&quot;FileSystemOpenWrite&quot;) END;
    TRY RETURN FileWr.Open(fileName);
    EXCEPT OSError.E =&gt; RaiseServerError(&quot;FileSystemOpenWrite&quot;); &lt;*ASSERT FALSE*&gt; END;
  END FileSystemOpenWrite;

  PROCEDURE <A NAME="FileSystemOpenAppend"><procedure>FileSystemOpenAppend</procedure></A>(self: RemFileSystemServer; fileName: TEXT)
    : Wr.T RAISES {NetObj.Error, ServerError} =
  BEGIN
    IF self.readOnly THEN RaiseServerError(&quot;FileSystemOpenAppend&quot;) END;
    TRY RETURN FileWr.OpenAppend(fileName);
    EXCEPT OSError.E =&gt; RaiseServerError(&quot;FileSystemOpenAppend&quot;); &lt;*ASSERT FALSE*&gt; END;
  END FileSystemOpenAppend;

  PROCEDURE <A NAME="NewProcessor"><procedure>NewProcessor</procedure></A>(): ValProcessor =
  BEGIN
    RETURN
      NEW(ValProcessor,
          picklable := FALSE,
          what:=&quot;&lt;Processor at &quot; &amp; machineAddress &amp; &quot;&gt;&quot;);
  END NewProcessor;

  PROCEDURE <A NAME="RegisterSysCall"><procedure>RegisterSysCall</procedure></A>(name: TEXT; clos: SysCallClosure) =
  VAR v: Refany.T;
  BEGIN
    IF clos = NIL THEN EVAL sysCallTable.delete(name, (*out*)v);
    ELSE EVAL sysCallTable.put(name, clos);
    END;
  END RegisterSysCall;

  PROCEDURE <A NAME="FetchSysCall"><procedure>FetchSysCall</procedure></A>(name: TEXT; VAR(*out*) clos: SysCallClosure): BOOLEAN =
  VAR v: Refany.T; found: BOOLEAN;
  BEGIN
    found := sysCallTable.get(name, (*out*)v);
    clos := NARROW(v, SysCallClosure);
    RETURN found;
  END FetchSysCall;

  (* === GC-safe hash table of refanys :-) === *)

  TYPE TblArr = ARRAY OF RECORD old,new: REFANY END;
  REVEAL <A NAME="Tbl">Tbl</A> =
    BRANDED OBJECT
      a: REF TblArr;
      top: INTEGER := 0;
    METHODS
      Get(old: REFANY; VAR(*out*) new: REFANY): BOOLEAN := TblGet;
      Put(old, new: REFANY) := TblPut;
    END;

  PROCEDURE <A NAME="NewTbl"><procedure>NewTbl</procedure></A>(): Tbl =
  BEGIN
    RETURN NEW(Tbl, a:=NEW(REF TblArr, 256), top:=0);
  END NewTbl;

  PROCEDURE <A NAME="TblGet"><procedure>TblGet</procedure></A>(self: Tbl; old: REFANY; VAR(*out*) new: REFANY): BOOLEAN =
  BEGIN
    FOR i := self.top-1 TO 0 BY -1 DO
      IF self.a^[i].old = old THEN new := self.a^[i].new; RETURN TRUE END;
    END;
    RETURN FALSE;
  END TblGet;

  PROCEDURE <A NAME="TblPut"><procedure>TblPut</procedure></A>(self: Tbl; old, new: REFANY) =
  VAR newArr: REF TblArr;
  BEGIN
    self.a^[self.top].old := old;
    self.a^[self.top].new := new;
    INC(self.top);
    IF self.top &gt;= NUMBER(self.a^) THEN
      newArr := NEW(REF TblArr, 2*NUMBER(self.a^));
      SUBARRAY(newArr^, 0, NUMBER(self.a^)) := self.a^;
      self.a := newArr;
    END;
  END TblPut;

  (* === Copy === *)

  TYPE CopyStyle = {ValToVal, ValToLocal, LocalToVal};

  TYPE ValVarLocal =
    Val BRANDED &quot;ValVarLocal&quot; OBJECT
      val: Val;
    END;

  TYPE ValArrayLocal =
    Val BRANDED &quot;ValArrayLocal&quot; OBJECT
      array: REF Vals;
    END;

  TYPE ValObjLocal =
    Val BRANDED &quot;ValObjLocal&quot; OBJECT
      who: TEXT;
      fields: REF ObjFields;
      protected, serialized: BOOLEAN;
    END;

  PROCEDURE <A NAME="CopyVal"><procedure>CopyVal</procedure></A>(val: Val; tbl: Tbl; loc: SynLocation.T)
    : Val RAISES {Error, NetObj.Error} =
  BEGIN
    RETURN Copy(val, tbl, loc, CopyStyle.ValToVal);
  END CopyVal;

  PROCEDURE <A NAME="CopyValToLocal"><procedure>CopyValToLocal</procedure></A>(val: Val; tbl: Tbl; loc: SynLocation.T)
    : Val RAISES {Error, NetObj.Error} =
  BEGIN
    RETURN Copy(val, tbl, loc, CopyStyle.ValToLocal);
  END CopyValToLocal;

  PROCEDURE <A NAME="CopyLocalToVal"><procedure>CopyLocalToVal</procedure></A>(val: Val; tbl: Tbl; loc: SynLocation.T)
    : Val RAISES {Error, NetObj.Error} =
  BEGIN
    RETURN Copy(val, tbl, loc, CopyStyle.LocalToVal);
  END CopyLocalToVal;

  PROCEDURE <A NAME="Copy"><procedure>Copy</procedure></A>(val: Val; tbl: Tbl; loc: SynLocation.T; style: CopyStyle)
    : Val RAISES {Error, NetObj.Error} =
  VAR cache: REFANY;
  BEGIN
    TYPECASE val OF
    | ValVar(node) =&gt;
      VAR newVar: ValVar; newVarLocal: ValVarLocal;
      BEGIN
        IF tbl.Get(node.remote, (*out*)cache) THEN RETURN cache END;
        CASE style OF
        | CopyStyle.ValToVal =&gt;
            newVar := NEW(ValVar, remote := NIL);
            tbl.Put(node.remote, newVar);
            newVar.remote :=
              NEW(RemVarServer, val:=Copy(node.remote.Get(), tbl, loc, style));
            RETURN newVar;
        | CopyStyle.ValToLocal =&gt;
            newVarLocal := NEW(ValVarLocal, val := NIL);
            tbl.Put(node.remote, newVarLocal);
            newVarLocal.val := Copy(node.remote.Get(), tbl, loc, style);
            RETURN newVarLocal;
        ELSE &lt;*ASSERT FALSE*&gt;
        END;
      END;
    | ValVarLocal(node) =&gt;
      VAR newVar: ValVar;
      BEGIN
        IF tbl.Get(node, (*out*)cache) THEN RETURN cache END;
        CASE style OF
        | CopyStyle.LocalToVal =&gt;
            newVar := NEW(ValVar, remote := NIL);
            tbl.Put(node, newVar);
            newVar.remote :=
              NEW(RemVarServer, val:=Copy(node.val, tbl, loc, style));
            RETURN newVar;
        ELSE &lt;*ASSERT FALSE*&gt;
        END;
      END;
    | ValOk, ValBool, ValChar, ValText, ValInt, ValReal, ValException,
        ValEngine =&gt; RETURN val;
    | ValOption(node) =&gt;
      VAR newOpt: ValOption;
      BEGIN
        IF tbl.Get(node, (*out*)cache) THEN RETURN cache END;
        newOpt := NEW(ValOption, tag:=node.tag, val:=NIL);
        tbl.Put(node, newOpt);
        newOpt.val := Copy(node.val, tbl, loc, style);
        RETURN newOpt;
      END;
    | ValAlias(node) =&gt;
      VAR newAlias: ValAlias;
      BEGIN
        IF tbl.Get(node, (*out*)cache) THEN RETURN cache END;
        newAlias := NEW(ValAlias, label:=node.label,
          labelIndexHint:=node.labelIndexHint, obj:=NIL);
        tbl.Put(node, newAlias);
        newAlias.obj := Copy(node.obj, tbl, loc, style);
        RETURN newAlias;
      END;
    | ValArray(node) =&gt;
      VAR vals, newVals: REF Vals;
          newArr: ValArray; newArrLocal: ValArrayLocal;
      BEGIN
        IF tbl.Get(node.remote, (*out*)cache) THEN RETURN cache END;
        vals := node.remote.Obtain();
        newVals := NEW(REF Vals, NUMBER(vals^));
        CASE style OF
        | CopyStyle.ValToVal =&gt;
            newArr := NEW(ValArray, remote:=NIL);
            tbl.Put(node.remote, newArr);
            FOR i := 0 TO NUMBER(vals^)-1 DO
              newVals^[i] := Copy(vals^[i], tbl, loc, style);
            END;
            newArr.remote := NEW(RemArrayServer, array:=newVals);
            RETURN newArr;
        | CopyStyle.ValToLocal =&gt;
            newArrLocal := NEW(ValArrayLocal, array:=NIL);
            tbl.Put(node.remote, newArrLocal);
            FOR i := 0 TO NUMBER(vals^)-1 DO
              newVals^[i] := Copy(vals^[i], tbl, loc, style);
            END;
            newArrLocal.array := newVals;
            RETURN newArrLocal;
        ELSE &lt;*ASSERT FALSE*&gt;
        END;
      END;
    | ValArrayLocal(node) =&gt;
      VAR vals, newVals: REF Vals; newArr: ValArray;
      BEGIN
        IF tbl.Get(node, (*out*)cache) THEN RETURN cache END;
        vals := node.array;
        newVals := NEW(REF Vals, NUMBER(vals^));
        CASE style OF
        | CopyStyle.LocalToVal =&gt;
            newArr := NEW(ValArray, remote:=NIL);
            tbl.Put(node, newArr);
            FOR i := 0 TO NUMBER(vals^)-1 DO
              newVals^[i] := Copy(vals^[i], tbl, loc, style);
            END;
            newArr.remote := NEW(RemArrayServer, array:=newVals);
            RETURN newArr;
        ELSE &lt;*ASSERT FALSE*&gt;
        END;
      END;
    | ValAnything(node) =&gt;
        CASE style OF
        | CopyStyle.ValToVal =&gt;
            RETURN node.Copy(tbl, loc);
        | CopyStyle.ValToLocal, CopyStyle.LocalToVal =&gt;
            IF node.picklable THEN RETURN node
            ELSE RaiseError(&quot;Cannot pickle: &quot; &amp; node.what, loc); &lt;*ASSERT FALSE*&gt;
            END;
        ELSE &lt;*ASSERT FALSE*&gt;
        END;
    | ValFun(node) =&gt;
      VAR newProc: ValFun;
      BEGIN
        IF tbl.Get(node, (*out*)cache) THEN RETURN cache END;
        newProc := NEW(ValFun, fun:=node.fun,
          global:=NEW(REF Vals, NUMBER(node.global^)));
        tbl.Put(node, newProc);
        FOR i := 0 TO NUMBER(node.global^)-1 DO
          newProc.global^[i] := Copy(node.global^[i], tbl,loc, style);
        END;
        RETURN newProc;
      END;
    | ValMeth(node) =&gt;
      VAR newMeth: ValMeth;
      BEGIN
        IF tbl.Get(node, (*out*)cache) THEN RETURN cache END;
        newMeth := NEW(ValMeth, meth:=node.meth,
          global:=NEW(REF Vals, NUMBER(node.global^)));
        tbl.Put(node, newMeth);
        FOR i := 0 TO NUMBER(node.global^)-1 DO
          newMeth.global^[i] := Copy(node.global^[i], tbl, loc, style);
        END;
        RETURN newMeth;
      END;
    | ValObj(node) =&gt;
      VAR newObj: ValObj; newObjLocal: ValObjLocal; newObjServ: RemObjServer;
          fields, newFields: REF ObjFields;
          who: TEXT; protected, serialized: BOOLEAN; sync: Sync;
      BEGIN
        IF tbl.Get(node.remote, (*out*)cache) THEN RETURN cache END;
        TRY
          who := node.remote.Who((*out*)protected, (*out*)serialized);
          fields := node.remote.Obtain(FALSE);
          newFields := NEW(REF ObjFields, NUMBER(fields^));
        EXCEPT ServerError(msg) =&gt; RaiseError(msg, loc);
        END;
        IF serialized THEN sync := NEW(Sync, mutex:=NEW(Thread.Mutex))
        ELSE sync:=NIL
        END;
        CASE style OF
        | CopyStyle.ValToVal =&gt;
            newObj := NEW(ValObj, remote:=NIL);
            tbl.Put(node.remote, newObj);
            FOR i := 0 TO NUMBER(fields^)-1 DO
              newFields^[i].label := fields^[i].label;
              newFields^[i].field := Copy(fields^[i].field, tbl, loc, style);
            END;
            newObjServ :=
              NEW(RemObjServer, who:=who, self:=NIL, fields := newFields,
                protected := protected, sync := sync);
            newObj.remote := newObjServ;
            newObjServ.self := newObj;
            RETURN newObj;
        | CopyStyle.ValToLocal =&gt;
            newObjLocal := NEW(ValObjLocal, who:=who, fields:=NIL,
                protected:=protected, serialized:=serialized);
            tbl.Put(node.remote, newObjLocal);
            FOR i := 0 TO NUMBER(fields^)-1 DO
              newFields^[i].label := fields^[i].label;
              newFields^[i].field := Copy(fields^[i].field, tbl, loc, style);
            END;
            newObjLocal.fields := newFields;
            RETURN newObjLocal;
	    ELSE &lt;*ASSERT FALSE*&gt;
        END;
      END;
    | ValObjLocal(node) =&gt;
      VAR newObj: ValObj; newObjServ: RemObjServer;
          fields, newFields: REF ObjFields; sync: Sync;
      BEGIN
        IF tbl.Get(node, (*out*)cache) THEN RETURN cache END;
        fields := node.fields;
        newFields := NEW(REF ObjFields, NUMBER(fields^));
        IF node.serialized THEN sync := NEW(Sync, mutex:=NEW(Thread.Mutex))
        ELSE sync:=NIL
        END;
        CASE style OF
        | CopyStyle.LocalToVal =&gt;
            newObj := NEW(ValObj, remote:=NIL);
            tbl.Put(node, newObj);
            FOR i := 0 TO NUMBER(fields^)-1 DO
              newFields^[i].label := fields^[i].label;
              newFields^[i].field := Copy(fields^[i].field, tbl, loc, style);
            END;
            newObjServ :=
              NEW(RemObjServer, who:=node.who, self:=NIL, fields := newFields,
                protected := node.protected, sync := sync);
            newObj.remote := newObjServ;
            newObjServ.self := newObj;
            RETURN newObj;
        ELSE &lt;*ASSERT FALSE*&gt;
        END;
      END;
    ELSE &lt;*ASSERT FALSE*&gt;
    END;
  END Copy;

  PROCEDURE <A NAME="CopyId"><procedure>CopyId</procedure></A>(self: ValAnything; &lt;*UNUSED*&gt;tbl: Tbl; &lt;*UNUSED*&gt;loc: SynLocation.T)
    : ValAnything =
  BEGIN
    RETURN self;
  END CopyId;

  PROCEDURE <A NAME="CopyError"><procedure>CopyError</procedure></A>(self: ValAnything; &lt;*UNUSED*&gt;tbl: Tbl;
    loc: SynLocation.T): ValAnything RAISES {Error} =
  BEGIN
    RaiseError(&quot;Cannot copy: &quot; &amp; self.what, loc); &lt;*ASSERT FALSE*&gt;
  END CopyError;

  TYPE
    InhibitSpecial =
      Pickle.Special OBJECT
        reason: TEXT;
        OVERRIDES
          write := WriteInhibitTransmission;
          read := ReadInhibitTransmission;
        END;

  PROCEDURE <A NAME="WriteInhibitTransmission"><procedure>WriteInhibitTransmission</procedure></A>(self: InhibitSpecial; &lt;*UNUSED*&gt;ref: REFANY;
    &lt;*UNUSED*&gt;wr: Pickle.Writer) RAISES {Pickle.Error, Wr.Failure, Thread.Alerted} =
  BEGIN
    RAISE Pickle.Error(self.reason);
  END WriteInhibitTransmission;

  PROCEDURE <A NAME="ReadInhibitTransmission"><procedure>ReadInhibitTransmission</procedure></A>(self: InhibitSpecial;
    &lt;*UNUSED*&gt;rd: Pickle.Reader; &lt;*UNUSED*&gt;id: Pickle.RefID): REFANY
    RAISES {Pickle.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  BEGIN
    RAISE Pickle.Error(self.reason);
  END ReadInhibitTransmission;

  PROCEDURE <A NAME="InhibitTransmission"><procedure>InhibitTransmission</procedure></A>(tc: INTEGER; reason: TEXT) =
  BEGIN
    Pickle.RegisterSpecial(NEW(InhibitSpecial, sc:=tc, reason:=reason));
  END InhibitTransmission;

BEGIN
END ObValue.
</PRE> -- This was an attempt to convince the NetObj runtime to do the right
   thing on pickling. Has been replaced by the current obliq pickling code,
   using Copy.
<P>
   There should be a way to temporarily register specials for NetObj.T's.
   The array of specials should be a parameter to Pickle.Read/Pickle.Write.
<P>
   In Setup:
      Pickle.RegisterSpecial(NEW(ValArraySpecial, sc:=TYPECODE(ValArray)));
<P>
  TYPE
    ValArraySpecial =
      Pickle.Special OBJECT
        OVERRIDES
          write := WriteValArray;
          read := ReadValArray;
        END;
<P>
  PROCEDURE WriteValArray(self: ValArraySpecial; ref: REFANY; 
    wr: Pickle.Writer) RAISES {Pickle.Error, Wr.Failure, Thread.Alerted} =
  BEGIN
    TYPECASE ref OF
    <PRE>
      ValArray(valArray) =&gt;
      </PRE>
TYPECASE valArray.remote OF
      <PRE>
      RemArrayServer(remArrayServer) =&gt;
          </PRE>
wr.write(remArrayServer.array);
      ELSE RAISE Wr.Failure(NIL);
      END;
    ELSE RAISE Wr.Failure(NIL);
    END;
  END WriteValArray;
<P>
  PROCEDURE ReadValArray(self: ValArraySpecial;
    rd: Pickle.Reader; id: Pickle.RefID): REFANY
    RAISES {Pickle.Error, Rd.EndOfFile, Rd.Failure, Thread.Alerted} =
  VAR res: ValArray;
  BEGIN
    res := NEW(ValArray, remote := NEW(RemArrayServer, array := NIL));
    rd.noteRef(res, id);
    NARROW(res.remote, RemArrayServer).array := rd.read();
    RETURN res;
  END ReadValArray;


</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
