<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/Obliq.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/Obliq.i3</H2></A><HR>
<inInterface>
<PRE>
<A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="Obliq.m3">Obliq</A></interface>;
IMPORT <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="ObTree.i3">ObTree</A>, <A HREF="ObValue.i3">ObValue</A>, <A HREF="ObScope.i3">ObScope</A>, <A HREF="ObCheck.i3">ObCheck</A>, <A HREF="ObLib.i3">ObLib</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;
FROM <A HREF="ObValue.i3">ObValue</A> IMPORT Error, Exception;
</PRE> Program interface to Obliq run-time values and evaluation.
   Other important interfaces are ObTree and ObValue, but the
   present interface attempts to be fairly self-contained.


<P> ====== Setup ====== 

<P>  <PRE>PROCEDURE <A HREF="Obliq.m3#PackageSetup">PackageSetup</A>();
  (* To be called at least once before any other use of the obliqrt package. *)
</PRE> ====== Types ====== 

<P>  <PRE>TYPE
    Term = ObTree.Term;
    Phrase = ObTree.Phrase;
    Val = ObValue.Val;
    Vals = ARRAY OF Val;
    Fields = ObValue.ObjFields;
    Location = SynLocation.T;
      (* Error locations: if one is passed to your procedures, pass it along
         to other procedures that take location parameters. Otherwise
         use the NIL defaults for location (for pretty good error reporting)
         or synthesize you own locations (for optimal error reporting). *)
    Env =
      BRANDED OBJECT
        frameName: TEXT; (* the module name, to handle reloading *)
        forName: TEXT;   (* the qualified name for the operations. *)
        libEnv: ObLib.Env;
        scopeEnv: ObScope.Env;
        checkEnv: ObCheck.Env;
        valueEnv: ObValue.Env;
        nextFrame: Env;
      END;
      (* An interpreter environment. Consider this opaque. *)
</PRE> ====== Environments ====== 

<P>  <PRE>PROCEDURE <A HREF="Obliq.m3#EmptyEnv">EmptyEnv</A>(): Env;
  (* The empty evaluation environment, containing the currently registered
     built-in modules. This is a legal environment. *)

  PROCEDURE <A HREF="Obliq.m3#NewEnv">NewEnv</A>(name: TEXT; val: Val; rest: Env; loc: Location:=NIL)
    : Env RAISES {Error};
  (* Extend an evaluation environment with a new association name-val.
     This is a legal environment if &quot;rest&quot; is, and if &quot;val&quot; is
     a legal value. *)

  PROCEDURE <A HREF="Obliq.m3#Lookup">Lookup</A>(name: TEXT; env: Env): Val RAISES {Error};
  (* Retrieve the value associated with name in env, or Error if not found. *)
</PRE> ====== Eval ====== 

<P>  <PRE>PROCEDURE <A HREF="Obliq.m3#EvalTerm">EvalTerm</A>(term: Term; env: Env; loc: Location:=NIL)
    : Val RAISES {Error, Exception};
  (* Check and evaluate a term in an environment. &quot;env&quot; must be a legal
     environment. Produces a legal value, or an exception.
     A Term can be obtained via ObliqParser.i3. *)

  PROCEDURE <A HREF="Obliq.m3#EvalPhrase">EvalPhrase</A>(phrase: Phrase; VAR (*in-out*) env: Env;
    loc: Location:=NIL): Val RAISES {Error, Exception};
  (* Check and evaluate a term, definition, or command phrase in an
     environment. &quot;env&quot; must be a legal environment. Produces an enriched
     legal environment or an exception. (The result environment is enriched
     with new bindings when phrase is a definition.) A Phrase can be obtained
     via ObliqParser.i3.
     N.B. This procedure does NOT evaluate load phrases and module phrases;
     ObliqParser.EvalPhrase is a more general general procedure that
     also does that. *)
</PRE> ====== Ground types ====== 

<P>  <PRE>VAR (*READONLY*) ok: Val;

  VAR (*READONLY*) true, false: Val;
  PROCEDURE <A HREF="Obliq.m3#NewBool">NewBool</A>(bool: BOOLEAN): Val;
  PROCEDURE <A HREF="Obliq.m3#ToBool">ToBool</A>(val: Val; loc: Location:=NIL): BOOLEAN RAISES{Error};
  PROCEDURE <A HREF="Obliq.m3#Is">Is</A>(val1, val2: Val): BOOLEAN;

  VAR (*READONLY*) zero, one: Val;
  PROCEDURE <A HREF="Obliq.m3#NewInt">NewInt</A>(int: INTEGER): Val;
  PROCEDURE <A HREF="Obliq.m3#ToInt">ToInt</A>(val: Val; loc: Location:=NIL): INTEGER RAISES{Error};

  VAR (*READONLY*) zeroPointZero, onePointZero: Val;
  PROCEDURE <A HREF="Obliq.m3#NewReal">NewReal</A>(real: LONGREAL): Val;
  PROCEDURE <A HREF="Obliq.m3#ToReal">ToReal</A>(val: Val; loc: Location:=NIL): LONGREAL RAISES{Error};

  VAR (*READONLY*) char: ARRAY [0..255] OF Val;
  PROCEDURE <A HREF="Obliq.m3#NewChar">NewChar</A>(char: CHAR): Val;
  PROCEDURE <A HREF="Obliq.m3#ToChar">ToChar</A>(val: Val; loc: Location:=NIL): CHAR RAISES{Error};

  VAR (*READONLY*) emptyText: Val;
  PROCEDURE <A HREF="Obliq.m3#NewText">NewText</A>(text: TEXT): Val; (* Converts NIL to &quot;&quot; *)
  PROCEDURE <A HREF="Obliq.m3#ToText">ToText</A>(val: Val; loc: Location:=NIL): TEXT RAISES{Error};
</PRE> ====== Objects ====== 

<P>  <PRE>PROCEDURE <A HREF="Obliq.m3#NewObject">NewObject</A>(READONLY fields: Fields): Val;
  (* Allocates a legal object from a list of fields. This is a legal
     value if the fields have unique names and contain legal values. *)

  (* The fields parameter should contain non-method values only.
     Constructing methods by hand requires knowledge beyond the scope
     of this interface, and is highly obliq-implementation-dependent.
     It is much better to call Eval with appropriate arguments, so that
     objects-with-methods are produced. *)

  PROCEDURE <A HREF="Obliq.m3#ObjectSelect">ObjectSelect</A>(object: Val; label: TEXT; loc: Location:=NIL): Val
    RAISES {Error, Exception};
  (* Selects the contents of a field of an object. The value produced
     (if any) is a legal value provided that &quot;object&quot; is both a legal value
     and an object. *)

  PROCEDURE <A HREF="Obliq.m3#ObjectInvoke">ObjectInvoke</A>(object: Val; label: TEXT; args: Vals;
    loc: Location:=NIL): Val RAISES {Error, Exception};
  (* Invokes a method of an object. The value produced (if any) is a
     legal value provided that &quot;object&quot; is both a legal value and
     an object, and args is an array of legal values. *)

  PROCEDURE <A HREF="Obliq.m3#ObjectUpdate">ObjectUpdate</A>(object: Val; label: TEXT; val: Val;
    loc: Location:=NIL) RAISES {Error, Exception};
  (* Updates a field or method of an object. The value produced (if any) is a
     legal value provided that &quot;object&quot; is both a legal value and
     an object, and val is a legal value. *)

  PROCEDURE <A HREF="Obliq.m3#ObjectClone1">ObjectClone1</A>(object: Val; loc: Location:=NIL): Val
    RAISES {Error, Exception};
  (* Clone a single object. The value produced (if any) is a legal value
     provided that &quot;object&quot; is both a legal value and an object. *)

  PROCEDURE <A HREF="Obliq.m3#ObjectClone">ObjectClone</A>(READONLY objects: Vals; loc: Location:=NIL): Val
    RAISES {Error, Exception};
  (* Clone many objects into one. The value produced (if any) is a legal value
     provided that &quot;objects&quot; are both legal values and objects. *)

  PROCEDURE <A HREF="Obliq.m3#ObjectHas">ObjectHas</A>(object: Val; label: TEXT; loc: Location:=NIL):
    BOOLEAN RAISES{Error, Exception};
  (* Whether the object has a field called label. *)
</PRE> ====== Network Objects and Engines ====== 

<P>  <PRE>PROCEDURE <A HREF="Obliq.m3#NetExport">NetExport</A>(name, server: TEXT; object: Val;
    loc: SynLocation.T:=NIL) RAISES {Error, Exception};
  (* Export an object to a name server under a name. object must be an object;
     server must be the IP address of a machine running a network object
     daemon. Otherwise an exception is raised. *)

  PROCEDURE <A HREF="Obliq.m3#NetImport">NetImport</A>(name, server: TEXT;
    loc: SynLocation.T:=NIL): Val RAISES {Exception};
  (* Import a named object from a name server. server must be the IP address
     of a machine running a network object, holding the named object.
     The result is an object, or an exception is raised if the named
     object cannot be obtained. *)

  PROCEDURE <A HREF="Obliq.m3#NetExportEngine">NetExportEngine</A>(name, server: TEXT; arg: Val;
    loc: SynLocation.T:=NIL) RAISES {Error, Exception};
  (* Export an engine to a name server under a name. arg is given as an
     argument to engine clients; server must be the IP address of a machine
     running a network object daemon. Otherwise an exception is raised. *)

  PROCEDURE <A HREF="Obliq.m3#NetImportEngine">NetImportEngine</A>(name, server: TEXT;
    loc: SynLocation.T:=NIL): Val RAISES {Exception};
  (* Import a named engine from a name server. server must be the IP address
     of a machine running a network object, holding the named object.
     The result is an engine that accepts procedures of one argument,
     (use &quot;Call&quot; to invoke) or an exception is raised if the named engine
     cannot be obtained. *)

  PROCEDURE <A HREF="Obliq.m3#NetWho">NetWho</A>(object: Val; loc: SynLocation.T:=NIL): TEXT
    RAISES {Error, Exception};
  (* Return a description of the origin of an object.
     The precise format is not determined at this moment. *)
</PRE> ====== Arrays ====== 

<P>  <PRE>PROCEDURE <A HREF="Obliq.m3#NewArray">NewArray</A>(READONLY vals: Vals): Val;
  (* Allocates an array value from an array of values. *)

  PROCEDURE <A HREF="Obliq.m3#ArraySize">ArraySize</A>(array: Val; loc: Location:=NIL): INTEGER RAISES {Error};
  (* The size of an array value. *)

  PROCEDURE <A HREF="Obliq.m3#ArrayGet">ArrayGet</A>(array: Val; i: INTEGER; loc: Location:=NIL)
    : Val RAISES {Error};
  (* The ith component of an array value. *)

  PROCEDURE <A HREF="Obliq.m3#ArraySet">ArraySet</A>(array: Val; i: INTEGER; val: Val;
    loc: Location:=NIL) RAISES {Error};
  (* Set the ith componet of an array value to val. *)

  PROCEDURE <A HREF="Obliq.m3#ArraySub">ArraySub</A>(array: Val; start,size: INTEGER; loc: Location:=NIL)
    : Val RAISES {Error};
  (* Extract a subarray an array value. *)

  PROCEDURE <A HREF="Obliq.m3#ArrayUpd">ArrayUpd</A>(array: Val; start, size: INTEGER; sub: Val;
    loc: Location:=NIL) RAISES {Error};
  (* Update array[start for size] with sub[0 for size]. *)

  PROCEDURE <A HREF="Obliq.m3#ArrayCat">ArrayCat</A>(array1, array2: Val; loc: Location:=NIL)
    : Val RAISES {Error};
  (* A new array that is the concatenation of two others. *)

  PROCEDURE <A HREF="Obliq.m3#ToArray">ToArray</A>(val: Val; VAR(*out*) array:  Vals; loc: Location:=NIL)
    RAISES {Error};
  (* Put the elements of an array value into an array. The size of &quot;array&quot;
     must much the array size of &quot;val&quot;. *)

  PROCEDURE <A HREF="Obliq.m3#NewIntArray">NewIntArray</A>(READONLY array: ARRAY OF INTEGER): Val;
  PROCEDURE <A HREF="Obliq.m3#ToIntArray">ToIntArray</A>(val: Val; VAR(*out*) array: ARRAY OF INTEGER;
    loc: Location:=NIL) RAISES {Error};
  PROCEDURE <A HREF="Obliq.m3#NewRealArray">NewRealArray</A>(READONLY array: ARRAY OF LONGREAL): Val;
  PROCEDURE <A HREF="Obliq.m3#ToRealArray">ToRealArray</A>(val: Val; VAR(*out*) array: ARRAY OF LONGREAL;
    loc: Location:=NIL) RAISES {Error};
  PROCEDURE <A HREF="Obliq.m3#NewTextArray">NewTextArray</A>(READONLY array: ARRAY OF TEXT): Val;
  PROCEDURE <A HREF="Obliq.m3#ToTextArray">ToTextArray</A>(val: Val; VAR(*out*) array: ARRAY OF TEXT;
    loc: Location:=NIL) RAISES {Error};
  (* These utility array routines maps to and from arrays of ground
     types. They use NewArray and ToArray with appopriate coercions
     for the array elements. *)
</PRE> ====== Variables ====== 

<P>  <PRE>PROCEDURE <A HREF="Obliq.m3#NewVar">NewVar</A>(val: Val): Val;
    (* Create a new variable with given contents. *)

  PROCEDURE <A HREF="Obliq.m3#VarGet">VarGet</A>(var: Val; loc: Location:=NIL): Val RAISES {Error};
  (* The contents of a variable. *)

  PROCEDURE <A HREF="Obliq.m3#VarSet">VarSet</A>(var: Val; val: Val; loc: Location:=NIL) RAISES {Error};
  (* Set the contents of a variable to val. *)
</PRE> ====== Procedures ====== 

<P>  <PRE>PROCEDURE <A HREF="Obliq.m3#Call">Call</A>(proc: Val; READONLY args: Vals; loc: Location:=NIL): Val
    RAISES {Error, Exception};
  (* Take a procedure value with N parameters (i.e. the result of evaluating
     an Obliq program of the form &quot;proc(x1..xn)...end&quot;), and call it
     (do the equivalent of &quot;(proc(x1..xn)...end)(a1..an)&quot;), returning
     its result. N.B. the original procedure text may have global variables.
     Moreover, proc may be an engine, with the single arg a procedure of
     one argument.
  *)

 (* Constructing procedure values by hand requires knowledge beyond the scope
    of this interface, and is highly obliq-implementation-dependent.
    It is much better to call Eval with appropriate arguments, so that
    procedure values are produced. *)
</PRE> ====== Threads Etc. ====== 

<P>  <PRE>PROCEDURE <A HREF="Obliq.m3#NewMutex">NewMutex</A>(): Val;
    (* Create a new mutex. *)

  PROCEDURE <A HREF="Obliq.m3#MutexGet">MutexGet</A>(mutex: Val; loc: Location:=NIL): Thread.Mutex
    RAISES {Error};
    (* The Thread.Mutex of a mutex. *)

  PROCEDURE <A HREF="Obliq.m3#NewCondition">NewCondition</A>(): Val;
    (* Create a new condition. *)

  PROCEDURE <A HREF="Obliq.m3#ConditionGet">ConditionGet</A>(mutex: Val; loc: Location:=NIL): Thread.Condition
    RAISES {Error};
    (* The Thread.Condition of a condition. *)

  PROCEDURE <A HREF="Obliq.m3#Fork">Fork</A>(proc: Val; stackSize: INTEGER; loc: Location:=NIL): Val
    RAISES {Error};
    (* Fork a procedure of no arguments and return a thread value. *)

  PROCEDURE <A HREF="Obliq.m3#Join">Join</A>(thread: Val; loc: Location:=NIL): Val
    RAISES {Error, Exception};
    (* Join a thread and return its result. *)
</PRE> ====== Calling Modula-3 from Obliq via sys_call ====== 

<P>  <PRE>VAR
    sysCallFailure: ObValue.ValException;
    (* An exception to be raised by SysCall procedures. *)

  TYPE
    SysCallClosure = OBJECT
    METHODS
      SysCall(READONLY args: Vals; loc: Location:=NIL): Val
        RAISES{Error, Exception};
      (* To be overridden. It should return an obliq Val, or raise an error
         by calling RaiseError, or raise an exception by calling
         RaiseException. The raised exception should normally be
         sysCallFailure. The loc parameter should be passed through whenever
         appropriate, or appriate error locations should be synthesized.
         Alternatively, errors and exceptions may be left uncought, so
         that they propagate back to Obliq; however this may result
         in poor error location reporting. *)
    END;

  PROCEDURE <A HREF="Obliq.m3#RegisterSysCall">RegisterSysCall</A>(name: TEXT; clos: SysCallClosure);
    (* To register a Modula-3 procedure that can be called from Obliq,
       under a given name. Re-registering for the same name overrides
       the previous proc for that name. Use clos=NIL to unregister. *)

  PROCEDURE <A HREF="Obliq.m3#RaiseSysCallFailure">RaiseSysCallFailure</A>(self: SysCallClosure; READONLY args: Vals;
    loc: Location:=NIL): Val RAISES{Error, Exception};
    (* A SysCallProc that simply raises sysCallFailure. *)
</PRE> ====== Errors and Exceptions ====== 

<P>  <PRE>PROCEDURE <A HREF="Obliq.m3#RaiseError">RaiseError</A>(msg: TEXT; loc: Location:=NIL) RAISES {Error};
    (* Raises an Obliq error. *)

  PROCEDURE <A HREF="Obliq.m3#NewException">NewException</A>(name: TEXT): ObValue.ValException;
    (* Creates a new obliq exception; the name is used for exception
       matching in try expressions. *)

  PROCEDURE <A HREF="Obliq.m3#RaiseException">RaiseException</A>(exception: ObValue.ValException; msg: TEXT;
    loc: Location:=NIL) RAISES {Exception};
    (* Raises an Obliq exception. *)

  PROCEDURE <A HREF="Obliq.m3#ReportError">ReportError</A>(swr: SynWr.T; packet: ObValue.ErrorPacket);
  PROCEDURE <A HREF="Obliq.m3#ReportException">ReportException</A>(swr: SynWr.T; packet: ObValue.ExceptionPacket);
  (* Report error conditions and return normally.
     Use to intercept Obliq errors and report them:
       TRY
          ... code that raises ObValue.Error and ObValue.Exception ...
       EXCEPT ObValue.Error(packet) =&gt; Obliq.ReportError(swr, packet);
       |      ObValue.Exception(packet) =&gt; Obliq.ReportException(swr, packet);
       END; *)

END Obliq.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
