<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqrt/src/Obliq.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqrt/src/Obliq.m3</H2></A><HR>
<inModule>
<PRE>
<A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Obliq.i3">Obliq</A></implements></module>;
IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="ObErr.i3">ObErr</A>, <A HREF="ObCommand.i3">ObCommand</A>, <A HREF="ObLib.i3">ObLib</A>, <A HREF="ObTree.i3">ObTree</A>, <A HREF="ObScope.i3">ObScope</A>,
<A HREF="ObCheck.i3">ObCheck</A>, <A HREF="ObValue.i3">ObValue</A>, <A HREF="ObEval.i3">ObEval</A>, <A HREF="ObBuiltIn.i3">ObBuiltIn</A>, <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../text/src/Text.i3">Text</A>;
FROM <A HREF="ObValue.i3">ObValue</A> IMPORT Error, Exception;

  VAR
    setupDone := FALSE;

  PROCEDURE <A NAME="PackageSetup"><procedure>PackageSetup</procedure></A>() =
  BEGIN
    IF NOT setupDone THEN
      setupDone := TRUE;
      ObCommand.Setup();
      ObLib.Setup();
      ObTree.Setup();
      ObScope.Setup();
      ObCheck.Setup();
      ObValue.Setup();
      ObEval.Setup();
      ObBuiltIn.Setup();
      Setup();
    END;
  END PackageSetup;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
    Thread.IncDefaultStackSize(64*1024);

    ok := ObValue.valOk;
    true := NEW(ObValue.ValBool, bool:=TRUE);
    false := NEW(ObValue.ValBool, bool:=FALSE);
    zero := NEW(ObValue.ValInt, int:=0, temp:=FALSE);
    one := NEW(ObValue.ValInt, int:=1, temp:=FALSE);
    zeroPointZero := NEW(ObValue.ValReal, real:=0.0d0, temp:=FALSE);
    onePointZero := NEW(ObValue.ValReal, real:=1.0d0, temp:=FALSE);
    FOR i:=0 TO 255 DO char[i] := NEW(ObValue.ValChar, char:=VAL(i, CHAR)) END;
    emptyText := NEW(ObValue.ValText, text:=&quot;&quot;);

    sysCallFailure := ObValue.sysCallFailure;
  END Setup;

  PROCEDURE <A NAME="EmptyEnv"><procedure>EmptyEnv</procedure></A>(): Env =
  VAR env: Env;
  BEGIN
    env :=
      NEW(Env, frameName := &quot;&quot;, forName := &quot;&quot;,
          libEnv := ObLib.libraries,
          scopeEnv := NIL, checkEnv := NIL, valueEnv := NIL,
          nextFrame := NIL);
    env := NewEnv(&quot;fileSysReader&quot;, ObValue.NewFileSystem(readOnly:=TRUE), env);
    env := NewEnv(&quot;fileSys&quot;, ObValue.NewFileSystem(readOnly:=FALSE), env);
    env := NewEnv(&quot;processor&quot;, ObValue.localProcessor, env);
    RETURN env;
  END EmptyEnv;

  PROCEDURE <A NAME="NewEnv"><procedure>NewEnv</procedure></A>(name: TEXT; val: Val; rest: Env; loc: Location:=NIL)
    : Env RAISES {Error} =
  VAR ideName: ObTree.IdeName;
  BEGIN
    IF loc=NIL THEN loc:=SourceLocation(&quot;Obliq.NewEnv&quot;) END;
    TRY
      ideName := NEW(ObTree.IdeName, text:=name, variant:=0);
      (* return a copy of rest, but whose component envs grow by 1 *)
      RETURN NEW(Env,
        frameName := rest.frameName,
        forName := rest.forName,
        libEnv := rest.libEnv,
        scopeEnv :=
            ObScope.NewTermEnv(loc, ideName, rest.libEnv, rest.scopeEnv),
        checkEnv := ObCheck.NewTermEnv(ideName, rest.checkEnv),
        valueEnv :=
          NEW(ObValue.LocalEnv, name:=ideName, val:=val, rest:=rest.valueEnv),
        nextFrame := rest.nextFrame);
    EXCEPT
    | ObErr.Fail =&gt;
        SynWr.Flush(SynWr.out);
        RaiseError(&quot;Static Error&quot;, loc);
    END;
  END NewEnv;

  PROCEDURE <A NAME="Lookup"><procedure>Lookup</procedure></A>(name: TEXT; env: Env): Val RAISES {Error} =
  VAR checkEnv: ObCheck.Env; valueEnv: ObValue.Env;
  BEGIN
    checkEnv := env.checkEnv;
    valueEnv := env.valueEnv;
    LOOP
      IF (checkEnv=NIL) OR (valueEnv=NIL) THEN EXIT END;
      TYPECASE checkEnv OF
      | ObCheck.TermEnv(checkNode) =&gt;
	  TYPECASE valueEnv OF
	  | ObValue.LocalEnv(valueNode) =&gt;
	    IF Text.Equal(name, checkNode.name.text) THEN
	      RETURN valueNode.val;
	    END;
	  ELSE EXIT
	  END;
      ELSE EXIT
      END;
      checkEnv := checkEnv.rest;
      valueEnv := valueEnv.rest;
    END;
    RaiseError(&quot;Obliq.Lookup: '&quot; &amp; name &amp; &quot;' not found&quot;, NIL);
  END Lookup;

  PROCEDURE <A NAME="EvalTerm"><procedure>EvalTerm</procedure></A>(term: Term; env: Env; loc :Location:=NIL)
    : Val RAISES {Error, Exception} =
  VAR scopeEnv, freeEnv: ObScope.Env; checkEnv: ObCheck.Env;
    valueEnv: ObValue.Env;
  BEGIN
    IF loc=NIL THEN loc:=term.location END;
    TRY
      scopeEnv := env.scopeEnv;
      checkEnv := env.checkEnv;
      valueEnv := env.valueEnv;
      freeEnv := NIL;
      ObScope.ScopeTerm(term, env.libEnv,
                        (*in-out*)scopeEnv, (*in-out*)freeEnv);
      ObScope.UnboundIdes(freeEnv);
      ObCheck.CheckTerm(term, (*in-out*)checkEnv);
      RETURN ObEval.Term(term, (*in-out*)valueEnv, NIL, NIL);
    EXCEPT
    | ObErr.Fail =&gt;
        SynWr.Flush(SynWr.out);
        RaiseError(&quot;Static Error&quot;, loc);
    END;
  END EvalTerm;

  PROCEDURE <A NAME="EvalPhrase"><procedure>EvalPhrase</procedure></A>(phrase: Phrase; VAR (*in-out*) env: Env;
    loc: Location:=NIL): Val RAISES {Error, Exception} =
  VAR newEnv: Env; freeEnv: ObScope.Env; val: Val;
  BEGIN
    IF loc=NIL THEN loc:=phrase.location END;
    TRY
      (* start with copy newEnv of env; its components are extended below. *)
      newEnv :=
          NEW(Env, frameName := env.frameName, forName := env.forName,
              libEnv := env.libEnv,
              scopeEnv:=env.scopeEnv, checkEnv:=env.checkEnv,
              valueEnv:=env.valueEnv, nextFrame:= env.nextFrame);
      TYPECASE phrase OF
      | ObTree.PhraseCommand(node) =&gt;
          ObCommand.Exec(node.name, node.arg, node.set, env);
      | ObTree.PhraseTerm(node) =&gt;
          freeEnv := NIL;
          ObScope.ScopeTerm(node.term, newEnv.libEnv,
            (*in-out*)newEnv.scopeEnv, (*in-out*)freeEnv);
          ObScope.UnboundIdes(freeEnv);
          ObCheck.CheckTerm(node.term, (*in-out*)newEnv.checkEnv);
          val := ObEval.Term(node.term, (*in-out*)newEnv.valueEnv, NIL, NIL);
      END;
      env := newEnv;
      RETURN val;
    EXCEPT
    | ObErr.Fail =&gt;
        SynWr.Flush(SynWr.out);
        RaiseError(&quot;Static Error&quot;, loc);
    END;
  END EvalPhrase;

  PROCEDURE <A NAME="NewBool"><procedure>NewBool</procedure></A>(bool: BOOLEAN): Val =
  BEGIN
    RETURN NEW(ObValue.ValBool, bool:=bool);
  END NewBool;

  PROCEDURE <A NAME="ToBool"><procedure>ToBool</procedure></A>(val: Val; loc: Location:=NIL): BOOLEAN RAISES {Error} =
  BEGIN
    TYPECASE val OF
    | ObValue.ValBool(node) =&gt; RETURN node.bool;
    ELSE RaiseError(&quot;Obliq.ToBool: not an ValBool&quot;, loc);
    END;
  END ToBool;

  PROCEDURE <A NAME="Is"><procedure>Is</procedure></A>(val1, val2: Val): BOOLEAN =
  BEGIN
    RETURN ObValue.Is(val1, val2, SourceLocation(&quot;Obliq.Is&quot;));
  END Is;

  PROCEDURE <A NAME="NewInt"><procedure>NewInt</procedure></A>(int: INTEGER): Val =
  BEGIN
    RETURN NEW(ObValue.ValInt, int:=int, temp:=FALSE);
  END NewInt;

  PROCEDURE <A NAME="ToInt"><procedure>ToInt</procedure></A>(val: Val; loc: Location:=NIL): INTEGER RAISES {Error} =
  BEGIN
    TYPECASE val OF
    | ObValue.ValInt(node) =&gt; RETURN node.int;
    ELSE RaiseError(&quot;Obliq.ToInt: not a ValInt&quot;, loc);
    END;
  END ToInt;

  PROCEDURE <A NAME="NewReal"><procedure>NewReal</procedure></A>(real: LONGREAL): Val =
  BEGIN
    RETURN NEW(ObValue.ValReal, real:=real, temp:=FALSE);
  END NewReal;

  PROCEDURE <A NAME="ToReal"><procedure>ToReal</procedure></A>(val: Val; loc: Location:=NIL): LONGREAL RAISES {Error} =
  BEGIN
    TYPECASE val OF
    | ObValue.ValReal(node) =&gt; RETURN node.real;
    ELSE RaiseError(&quot;Obliq.ToReal: not a ValReal&quot;, loc);
    END;
  END ToReal;

  PROCEDURE <A NAME="NewChar"><procedure>NewChar</procedure></A>(char: CHAR): Val =
  BEGIN
    RETURN NEW(ObValue.ValChar, char:=char);
  END NewChar;

  PROCEDURE <A NAME="ToChar"><procedure>ToChar</procedure></A>(val: Val; loc: Location:=NIL): CHAR RAISES {Error} =
  BEGIN
    TYPECASE val OF
    | ObValue.ValChar(node) =&gt; RETURN node.char;
    ELSE RaiseError(&quot;Obliq.ToChar: not a ValChar&quot;, loc);
    END;
  END ToChar;

  PROCEDURE <A NAME="NewText"><procedure>NewText</procedure></A>(text: TEXT): Val =
  BEGIN
    IF text=NIL THEN text:=&quot;&quot; END;
    RETURN NEW(ObValue.ValText, text:=text);
  END NewText;

  PROCEDURE <A NAME="ToText"><procedure>ToText</procedure></A>(val: Val; loc: Location:=NIL): TEXT RAISES {Error} =
  BEGIN
    TYPECASE val OF
    | ObValue.ValText(node) =&gt; RETURN node.text;
    ELSE RaiseError(&quot;Obliq.ToText: not a ValText&quot;, loc);
    END;
  END ToText;

  PROCEDURE <A NAME="NewArray"><procedure>NewArray</procedure></A>(READONLY vals: Vals): Val =
  BEGIN
    RETURN ObValue.NewArray(vals)
  END NewArray;

  PROCEDURE <A NAME="ArraySize"><procedure>ArraySize</procedure></A>(array: Val; loc: Location:=NIL): INTEGER RAISES {Error} =
  BEGIN
    TYPECASE array OF
    | ObValue.ValArray(arr) =&gt;
        TRY RETURN arr.remote.Size();
        EXCEPT
        | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
        | NetObj.Error =&gt; RaiseError(&quot;on remote array access&quot;, loc);
        END;
    ELSE RaiseError(&quot;Obliq.ArraySize: array expected&quot;, loc);
    END;
  END ArraySize;

  PROCEDURE <A NAME="ArrayGet"><procedure>ArrayGet</procedure></A>(array: Val; i: INTEGER; loc: Location:=NIL)
    : Val RAISES {Error} =
  BEGIN
    TYPECASE array OF
    | ObValue.ValArray(arr) =&gt;
        TRY RETURN arr.remote.Get(i);
        EXCEPT
        | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
        | NetObj.Error =&gt; RaiseError(&quot;on remote array access&quot;, loc);
        END;
    ELSE RaiseError(&quot;Obliq.ArrayGet: array expected&quot;, loc);
    END;
  END ArrayGet;

  PROCEDURE <A NAME="ArraySet"><procedure>ArraySet</procedure></A>(array: Val; i: INTEGER; val: Val; loc: Location:=NIL)
    RAISES {Error} =
  BEGIN
    TYPECASE array OF
    | ObValue.ValArray(arr) =&gt;
        TRY arr.remote.Set(i, val);
        EXCEPT
        | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
        | NetObj.Error =&gt; RaiseError(&quot;on remote array access&quot;, loc);
        END;
    ELSE RaiseError(&quot;Obliq.ArraySet: array expected&quot;, loc);
    END;
  END ArraySet;

  PROCEDURE <A NAME="ArraySub"><procedure>ArraySub</procedure></A>(array: Val; start,size: INTEGER; loc: Location:=NIL)
    : Val RAISES {Error} =
  BEGIN
    TYPECASE array OF
    | ObValue.ValArray(arr) =&gt;
        TRY RETURN arr.remote.Sub(start, size);
        EXCEPT
        | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
        | NetObj.Error =&gt; RaiseError(&quot;on remote array access&quot;, loc);
        END;
    ELSE RaiseError(&quot;Obliq.ArraySub: array expected&quot;, loc);
    END;
  END ArraySub;

  PROCEDURE <A NAME="ArrayUpd"><procedure>ArrayUpd</procedure></A>(array: Val; start, size: INTEGER; sub: Val;
    loc: Location:=NIL) RAISES {Error} =
  VAR subArr1: REF Vals;
  BEGIN
    TYPECASE array OF
    | ObValue.ValArray(arr) =&gt;
        TYPECASE sub OF
        | ObValue.ValArray(subArr) =&gt;
            TRY subArr1 := subArr.remote.Obtain()
            EXCEPT
            | NetObj.Error =&gt; RaiseError(&quot;on remote array access&quot;, loc);
            END;
        ELSE RaiseError(&quot;Obliq.ArrayUpd: array expected (arg 3)&quot;, loc);
        END;
        TRY arr.remote.Upd(start, size, subArr1);
        EXCEPT
        | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
        | NetObj.Error =&gt; RaiseError(&quot;on remote array access&quot;, loc);
        END;
    ELSE RaiseError(&quot;Obliq.ArrayUpd: array expected (arg 1)&quot;, loc);
    END;
  END ArrayUpd;

  PROCEDURE <A NAME="ArrayCat"><procedure>ArrayCat</procedure></A>(array1,array2: Val; loc: Location:=NIL)
    : Val RAISES {Error} =
  VAR vals1, vals2: REF ObValue.Vals;
  BEGIN
    TRY
      TYPECASE array1 OF
      | ObValue.ValArray(arr1) =&gt; vals1 := arr1.remote.Obtain();
      ELSE RaiseError(&quot;Obliq.ArrayCat: array expected (arg 1)&quot;, loc);
      END;
      TYPECASE array2 OF
      | ObValue.ValArray(arr2) =&gt; vals2 := arr2.remote.Obtain();
      ELSE RaiseError(&quot;Obliq.ArrayCat: array expected (arg 2)&quot;, loc);
      END;
      RETURN ObValue.ArrayCat(vals1, vals2);
    EXCEPT
    | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
    | NetObj.Error =&gt; RaiseError(&quot;on remote array access&quot;, loc);
    END;
  END ArrayCat;

  PROCEDURE <A NAME="ToArray"><procedure>ToArray</procedure></A>(val: Val; VAR(*out*) array: Vals; loc: Location:=NIL)
    RAISES {Error} =
  VAR size: INTEGER; vals: REF Vals;
  BEGIN
    TYPECASE val OF
    | ObValue.ValArray(arr) =&gt;
        TRY vals := arr.remote.Obtain();
        EXCEPT
        | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
        | NetObj.Error =&gt; RaiseError(&quot;on remote array access&quot;, loc);
        END;
    ELSE RaiseError(&quot;Obliq.ToArray: array expected&quot;, loc);
    END;
    size := NUMBER(vals^);
    IF size # NUMBER(array) THEN
      RaiseError(&quot;Obliq.ToArray: array sizes do not match&quot;, loc);
    END;
    FOR i:=0 TO size-1 DO array[i] := vals^[i]; END;
  END ToArray;

  PROCEDURE <A NAME="NewIntArray"><procedure>NewIntArray</procedure></A>(READONLY array: ARRAY OF INTEGER): Val =
  VAR vals: REF Vals;
  BEGIN
    vals := NEW(REF Vals, NUMBER(array));
    FOR i:=0 TO NUMBER(array)-1 DO
      vals[i] := NEW(ObValue.ValInt, int:=array[i], temp:=FALSE);
    END;
    RETURN ObValue.NewArrayFromVals(vals);
  END NewIntArray;

  PROCEDURE <A NAME="ToIntArray"><procedure>ToIntArray</procedure></A>(val: Val; VAR(*out*) array: ARRAY OF INTEGER;
    loc: Location:=NIL) RAISES{Error} =
  VAR size: INTEGER; vals: REF Vals;
  BEGIN
    size := ArraySize(val, loc);
    vals := NEW(REF Vals, size);
    ToArray(val, (*out*) vals^, loc);
    FOR i:=0 TO size-1 DO array[i] := ToInt(vals[i], loc) END;
  END ToIntArray;

  PROCEDURE <A NAME="NewRealArray"><procedure>NewRealArray</procedure></A>(READONLY array: ARRAY OF LONGREAL): Val =
  VAR vals: REF Vals;
  BEGIN
    vals := NEW(REF Vals, NUMBER(array));
    FOR i:=0 TO NUMBER(array)-1 DO
      vals[i] := NEW(ObValue.ValReal, real:=array[i], temp:=FALSE);
    END;
    RETURN ObValue.NewArrayFromVals(vals);
  END NewRealArray;

  PROCEDURE <A NAME="ToRealArray"><procedure>ToRealArray</procedure></A>(val: Val; VAR(*out*) array: ARRAY OF LONGREAL;
    loc: Location:=NIL) RAISES{Error} =
  VAR size: INTEGER; vals: REF Vals;
  BEGIN
    size := ArraySize(val, loc);
    vals := NEW(REF Vals, size);
    ToArray(val, (*out*) vals^, loc);
    FOR i:=0 TO size-1 DO array[i] := ToReal(vals[i], loc) END;
  END ToRealArray;

  PROCEDURE <A NAME="NewTextArray"><procedure>NewTextArray</procedure></A>(READONLY array: ARRAY OF TEXT): Val =
  VAR vals: REF Vals;
  BEGIN
    vals := NEW(REF Vals, NUMBER(array));
    FOR i:=0 TO NUMBER(array)-1 DO
      vals[i] := ObValue.NewText(array[i]);
    END;
    RETURN ObValue.NewArrayFromVals(vals);
  END NewTextArray;

  PROCEDURE <A NAME="ToTextArray"><procedure>ToTextArray</procedure></A>(val: Val; VAR(*out*) array: ARRAY OF TEXT;
    loc: Location:=NIL) RAISES{Error} =
  VAR size: INTEGER; vals: REF Vals;
  BEGIN
    size := ArraySize(val, loc);
    vals := NEW(REF Vals, size);
    ToArray(val, (*out*) vals^, loc);
    FOR i:=0 TO size-1 DO array[i] := ToText(vals[i], loc) END;
  END ToTextArray;

  PROCEDURE <A NAME="NewObject"><procedure>NewObject</procedure></A>(READONLY fields: Fields): Val =
  BEGIN
    RETURN ObValue.NewObject((*readonly*) fields, &quot;&quot;, FALSE, NIL);
  END NewObject;

  PROCEDURE <A NAME="ObjectSelect"><procedure>ObjectSelect</procedure></A>(object: Val; label: TEXT; loc: Location:=NIL): Val
    RAISES {Error, Exception} =
    VAR hint:=-1;
  BEGIN
    TRY
      TYPECASE object OF
      | ObValue.ValObj(obj) =&gt;
          RETURN obj.remote.Select(label, FALSE, (*var*)hint);
      ELSE RaiseError(&quot;Obliq.ObjectSelect: object expected&quot;, loc);
      END;
    EXCEPT
    | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
    | NetObj.Error =&gt;
        RaiseException(ObValue.netException,
          &quot;on remote object selection&quot;, loc);
    END;
  END ObjectSelect;

  PROCEDURE <A NAME="ObjectInvoke"><procedure>ObjectInvoke</procedure></A>(object: Val; label: TEXT; args: Vals;
    loc: Location:=NIL): Val RAISES {Error, Exception} =
    VAR hint := -1;
  BEGIN
    TRY
      TYPECASE object OF
      | ObValue.ValObj(obj) =&gt;
            RETURN obj.remote.Invoke(label, NUMBER(args), args,
              FALSE, (*var*) hint);
      ELSE RaiseError(&quot;Obliq.ObjectInvoke: object expected&quot;, loc);
      END;
    EXCEPT
    | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
    | NetObj.Error =&gt;
        RaiseException(ObValue.netException,
          &quot;on remote object invocation&quot;, loc);
    END;
  END ObjectInvoke;

  PROCEDURE <A NAME="ObjectUpdate"><procedure>ObjectUpdate</procedure></A>(object: Val; label: TEXT; val: Val;
    loc: Location:=NIL) RAISES {Error, Exception} =
    VAR hint := -1;
  BEGIN
      TYPECASE object OF
      | ObValue.ValObj(obj) =&gt;
          TRY
            obj.remote.Update(label, val, FALSE, (*var*) hint);
          EXCEPT
          | ObValue.ServerError(msg) =&gt;
              RaiseError(msg, loc);
          | NetObj.Error =&gt;
              RaiseException(ObValue.netException,
                &quot;on remote object update&quot;, loc);
          END;
      ELSE RaiseError(&quot;Obliq.ObjectUpdate: object expected&quot;, loc);
      END;
  END ObjectUpdate;

  PROCEDURE <A NAME="ObjectHas"><procedure>ObjectHas</procedure></A>(object: Val; label: TEXT; loc: Location:=NIL): BOOLEAN
    RAISES {Error, Exception} =
  VAR hint: INTEGER;
  BEGIN
      TYPECASE object OF
      | ObValue.ValObj(obj) =&gt;
          TRY
            RETURN obj.remote.Has(label, (*var*) hint);
          EXCEPT
          | NetObj.Error =&gt;
              RaiseException(ObValue.netException,
                &quot;on remote object 'has'&quot;, loc);
          END;
      ELSE RaiseError(&quot;Obliq.ObjectSelect: object expected&quot;, loc);
      END;
  END ObjectHas;

  PROCEDURE <A NAME="ObjectClone1"><procedure>ObjectClone1</procedure></A>(object: Val; loc: Location:=NIL): Val
    RAISES {Error, Exception} =
  BEGIN
    TRY
      TYPECASE object OF
      | ObValue.ValObj(obj) =&gt;
          RETURN ObValue.ObjClone1(obj.remote, NIL);
      ELSE RaiseError(&quot;Obliq.ObjectClone1: object expected&quot;, loc);
      END;
    EXCEPT
    | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
    | NetObj.Error =&gt;
        RaiseException(ObValue.netException,
          &quot;on remote object cloning&quot;, loc);
    END;
  END ObjectClone1;

  PROCEDURE <A NAME="ObjectClone"><procedure>ObjectClone</procedure></A>(READONLY objects: Vals; loc: Location:=NIL): Val
    RAISES {Error, Exception} =
  VAR remObjs: REF ARRAY OF ObValue.RemObj;
  BEGIN
    remObjs := NEW(REF ARRAY OF ObValue.RemObj, NUMBER(objects));
    FOR i:=0 TO NUMBER(objects)-1 DO
      TYPECASE objects[i] OF
      | ObValue.ValObj(obj) =&gt; remObjs[i] := obj.remote;
      ELSE RaiseError(&quot;Obliq.ObjectClone: object expected&quot;, loc);
      END;
    END;
    TRY
      RETURN ObValue.ObjClone(remObjs^, NIL);
    EXCEPT
    | ObValue.ServerError(msg) =&gt; RaiseError(msg, loc);
    | NetObj.Error =&gt;
        RaiseException(ObValue.netException,
          &quot;on remote object cloning&quot;, loc);
    END;
  END ObjectClone;

  PROCEDURE <A NAME="NetExport"><procedure>NetExport</procedure></A>(name, server: TEXT; object: Val;
    loc: SynLocation.T:=NIL) RAISES {Error, Exception} =
  BEGIN
      TYPECASE object OF
      | ObValue.ValObj(object) =&gt;
          ObBuiltIn.NetExport(name, server, object.remote, loc);
      ELSE RaiseError(&quot;Obliq.NetExport: network object expected&quot;, loc);
      END;
  END NetExport;

  PROCEDURE <A NAME="NetImport"><procedure>NetImport</procedure></A>(name, server: TEXT;
    loc: SynLocation.T:=NIL): Val RAISES {Exception} =
  BEGIN
      RETURN ObBuiltIn.NetImport(name, server, loc);
  END NetImport;

  PROCEDURE <A NAME="NetExportEngine"><procedure>NetExportEngine</procedure></A>(name, server: TEXT; arg: Val;
    loc: SynLocation.T:=NIL) RAISES {Exception} =
  BEGIN
    ObBuiltIn.NetExportEngine(name, server, arg, loc);
  END NetExportEngine;

  PROCEDURE <A NAME="NetImportEngine"><procedure>NetImportEngine</procedure></A>(name, server: TEXT;
    loc: SynLocation.T:=NIL): Val RAISES {Exception} =
  BEGIN
      RETURN ObBuiltIn.NetImportEngine(name, server, loc);
  END NetImportEngine;

  PROCEDURE <A NAME="NetWho"><procedure>NetWho</procedure></A>(object: Val; loc: SynLocation.T:=NIL): TEXT
    RAISES {Error, Exception} =
  BEGIN
      TYPECASE object OF
      | ObValue.ValObj(object) =&gt;
          RETURN ToText(ObBuiltIn.NetObjectWho(object.remote, loc), loc);
      | ObValue.ValEngine(engine) =&gt;
          RETURN ToText(ObBuiltIn.NetEngineWho(engine.remote, loc), loc);
      ELSE RaiseError(&quot;Obliq.NetWho: network object or engine expected&quot;, loc);
      END;
  END NetWho;

  PROCEDURE <A NAME="NewVar"><procedure>NewVar</procedure></A>(val: Val): Val =
  BEGIN
    RETURN ObValue.NewVar(val);
  END NewVar;

  PROCEDURE <A NAME="VarGet"><procedure>VarGet</procedure></A>(var: Val; loc: Location:=NIL): Val RAISES {Error} =
  BEGIN
    TYPECASE var OF
    | ObValue.ValVar(valVar) =&gt;
        TRY RETURN valVar.remote.Get();
        EXCEPT
        | NetObj.Error =&gt; RaiseError(&quot;on remote variable access&quot;, loc);
        END;
    ELSE RaiseError(&quot;Obliq.VarGet: variable expected&quot;, loc);
    END;
  END VarGet;

  PROCEDURE <A NAME="VarSet"><procedure>VarSet</procedure></A>(var: Val; val: Val; loc: Location:=NIL) RAISES {Error} =
  BEGIN
    TYPECASE var OF
    | ObValue.ValVar(valVar) =&gt;
        TRY valVar.remote.Set(val);
        EXCEPT
        | NetObj.Error =&gt; RaiseError(&quot;on remote variable access&quot;, loc);
        END;
    ELSE RaiseError(&quot;Obliq.VarSet: variable expected&quot;, loc);
    END;
  END VarSet;

  PROCEDURE <A NAME="Call"><procedure>Call</procedure></A>(proc: Val; READONLY args: Vals; loc: Location:=NIL): Val
    RAISES {Error, Exception} =
  BEGIN
      TYPECASE proc OF
      | ObValue.ValFun(clos) =&gt;
        RETURN ObEval.Call(clos, args, loc);
      | ObValue.ValEngine(eng) =&gt;
        IF NUMBER(args)=1 THEN
          RETURN ObEval.CallEngine(eng, args[0], loc);
        ELSE
          RaiseError(&quot;Obliq.Call: engine expects 1 argument&quot;, loc);
        END;
      ELSE RaiseError(&quot;Obliq.Call: procedure or engine expected&quot;, loc);
      END;
  END Call;

  PROCEDURE <A NAME="Fork"><procedure>Fork</procedure></A>(proc: Val; stackSize: INTEGER; loc: Location:=NIL): Val
    RAISES {Error} =
  BEGIN
      TYPECASE proc OF
      | ObValue.ValFun(clos) =&gt;
	RETURN ObBuiltIn.ForkThread(clos, stackSize, loc);
      ELSE RaiseError(&quot;Obliq.Fork: procedure expected&quot;, loc);
      END;
  END Fork;

  PROCEDURE <A NAME="Join"><procedure>Join</procedure></A>(thread: Val; loc: Location:=NIL): Val
    RAISES {Error, Exception} =
  BEGIN
      TYPECASE thread OF
      | ObBuiltIn.ValThread(threadVal) =&gt;
	RETURN ObBuiltIn.JoinThread(threadVal, loc);
      ELSE RaiseError(&quot;Obliq.Join: thread expected&quot;, loc);
      END;
  END Join;

  PROCEDURE <A NAME="NewMutex"><procedure>NewMutex</procedure></A>(): Val =
  BEGIN
    RETURN NEW(ObBuiltIn.ValMutex, what:=&quot;&lt;a Thread.Mutex&gt;&quot;, picklable:=FALSE,
               mutex:=NEW(Thread.Mutex));
  END NewMutex;

  PROCEDURE <A NAME="MutexGet"><procedure>MutexGet</procedure></A>(mutex: Val; loc: Location:=NIL): Thread.Mutex
    RAISES {Error} =
  BEGIN
    TYPECASE mutex OF
    | ObBuiltIn.ValMutex(valMutex) =&gt;
        RETURN valMutex.mutex;
    ELSE RaiseError(&quot;Obliq.MutexGet: mutex expected&quot;, loc);
    END;
  END MutexGet;

  PROCEDURE <A NAME="NewCondition"><procedure>NewCondition</procedure></A>(): Val =
  BEGIN
    RETURN NEW(ObBuiltIn.ValCondition, what:=&quot;&lt;a Thread.Condition&gt;&quot;,
	picklable:=FALSE, condition:= NEW(Thread.Condition));
  END NewCondition;

  PROCEDURE <A NAME="ConditionGet"><procedure>ConditionGet</procedure></A>(condition: Val; loc: Location:=NIL): Thread.Condition
    RAISES {Error} =
  BEGIN
    TYPECASE condition OF
    | ObBuiltIn.ValCondition(valCondition) =&gt;
        RETURN valCondition.condition;
    ELSE RaiseError(&quot;Obliq.ConditionGet: condition expected&quot;, loc);
    END;
  END ConditionGet;

  PROCEDURE <A NAME="ReportError"><procedure>ReportError</procedure></A>(swr: SynWr.T; packet: ObValue.ErrorPacket) =
  BEGIN
    ObValue.ErrorMsg(swr, packet);
  END ReportError;

  PROCEDURE <A NAME="ReportException"><procedure>ReportException</procedure></A>(swr: SynWr.T; packet: ObValue.ExceptionPacket) =
  BEGIN
    ObValue.ExceptionMsg(swr, packet);
  END ReportException;

  PROCEDURE <A NAME="RaiseError"><procedure>RaiseError</procedure></A>(msg: TEXT; loc: Location:=NIL) RAISES {Error} =
  BEGIN
    IF loc=NIL THEN loc:=SourceLocation(&quot;Obliq.RaiseError&quot;) END;
    ObValue.RaiseError(msg, loc);
  END RaiseError;

  PROCEDURE <A NAME="NewException"><procedure>NewException</procedure></A>(name: TEXT): ObValue.ValException =
  BEGIN
    RETURN NEW(ObValue.ValException, name:=name);
  END NewException;

  PROCEDURE <A NAME="RaiseException"><procedure>RaiseException</procedure></A>(exception: ObValue.ValException; msg: TEXT;
    loc: Location:=NIL) RAISES{Exception} =
  BEGIN
    IF loc=NIL THEN loc:=SourceLocation(&quot;Obliq.RaiseException&quot;) END;
    ObValue.RaiseException(exception, msg, loc);
  END RaiseException;

  PROCEDURE <A NAME="RaiseSysCallFailure"><procedure>RaiseSysCallFailure</procedure></A>(self: SysCallClosure; READONLY args: Vals;
    loc: Location:=NIL): Val RAISES{Error, Exception} =
  BEGIN
    IF loc=NIL THEN loc:=SourceLocation(&quot;Obliq.RaiseSysCallFailure&quot;) END;
    ObValue.RaiseException(sysCallFailure, &quot;Default sys_call procedure&quot;, loc);
  END RaiseSysCallFailure;

  PROCEDURE <A NAME="RegisterSysCall"><procedure>RegisterSysCall</procedure></A>(name: TEXT; clos: SysCallClosure) =
  BEGIN
    ObValue.RegisterSysCall(name, clos);
  END RegisterSysCall;

  PROCEDURE <A NAME="SourceLocation"><procedure>SourceLocation</procedure></A>(where: TEXT): SynLocation.T =
  BEGIN
    RETURN
      SynLocation.NewLineLocation(
        SynLocation.Info{fileName:=where, line:=0, lineChar:=0, char:=0});
  END SourceLocation;

BEGIN
END Obliq.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
