<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/Common/FS.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/Common/FS.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The <CODE>FS</CODE> interface provides persistent storage (files) and naming
   (directories).
   \index{directory}


<P><PRE>INTERFACE <interface><A HREF="#x1">FS</A></interface>;

IMPORT <A HREF="OSError.i3">OSError</A>, <A HREF="File.i3">File</A>, <A HREF="Pathname.i3">Pathname</A>, <A HREF="../../../time/src/Common/Time.i3">Time</A>;

PROCEDURE <A HREF="#x2">GetAbsolutePathname</A>(p: Pathname.T): Pathname.T
   RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Return an absolute pathname referring to the same file or
   directory as <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The new pathname will not involve any symbolic links or relative
   arcs (that is, occurrences of <CODE>Pathname.Parent</CODE> or
   <CODE>Pathname.Current</CODE>.
   \index{absolute pathname!from relative pathname}
   

<P> The procedures <CODE>OpenFile</CODE> and <CODE>OpenFileReadonly</CODE> look up a pathname
   and return a file handle, which is an object allowing a file to be
   read and perhaps written.  The returned value will be of some
   subtype of <CODE>File.T</CODE>, depending on the kind of object named by <CODE>p</CODE>.
   If the object is a regular file, the type will be <CODE>RegularFile.T</CODE>.
   If the object is a terminal, the type will be <CODE>Terminal.T</CODE>.  Other,
   system-specific subtypes are also possible. Under appropriate
   conditions, <CODE>OpenFile</CODE> can create a new regular file.  <CODE>OSError.E</CODE>
   is raised if the pathname passed to <CODE>OpenFile</CODE> or
   <CODE>OpenFileReadonly</CODE> is that of a directory. 

<P><PRE>TYPE
  CreateOption = {Never, Ok, Always};
  AccessOption = {OnlyOwnerCanRead, ReadOnly, Default};

PROCEDURE <A HREF="#x3">OpenFile</A>(
    p: Pathname.T;
    truncate: BOOLEAN := TRUE;
    create: CreateOption := CreateOption.Ok;
    template: File.T := NIL;
    access: AccessOption := AccessOption.Default): File.T
  RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Return an object permitting writing and reading an existing or
   newly-created file named <CODE>p</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> Suppose <CODE>p</CODE> names an existing regular file.  If <CODE>create = Always</CODE>,
   then <CODE>OSError.E</CODE> is raised.  Otherwise, the existing file is
   opened, after truncating it to zero size if <CODE>truncate = TRUE</CODE>.
<P>
   On the other hand, suppose the file named by <CODE>p</CODE> does not exist.
   If <CODE>create = Never</CODE>, then <CODE>OSError.E</CODE> is raised.  Otherwise, a new
   file is created.  Normally the new file is a regular file, but some
   implementations may determine the type of the new file from the
   identity of the directory in which it is being created.  The access
   control settings of the new file are set using the values of
   <CODE>template</CODE> and <CODE>access</CODE>.  If <CODE>template # NIL</CODE>, then <CODE>access</CODE> is
   ignored and the new file is given the same per-file access control
   settings as <CODE>template</CODE>.  If <CODE>template = NIL</CODE>, the file's access
   control settings are determined by an implementation-defined
   default value, with possible restrictions determined by the value
   of <CODE>access</CODE>:
<P>
   \begin{description}
   \item[<CODE>OnlyOwnerCanRead</CODE>] read access is allowed only by this user
   \item[<CODE>ReadOnly</CODE>] write access is allowed to no one (except via the
                     <CODE>File.T</CODE> returned by this call of <CODE>OpenFile</CODE>)
   \item[<CODE>Default</CODE>] the default applies with no restrictions.
   \end{description}
   \index{creating a file}
   \index{file!creation}
<P>
   A newly-created file <CODE>f</CODE> has
<P>
<PRE>
      buffer(f) = stable(f) = <KBD>empty sequence</KBD>
      mtime(f) = <KBD>current time</KBD>
      locked(f) = Process.NullID
</PRE>
   <CODE>OpenFile</CODE> doesn't change <CODE>mtime(f)</CODE> of an existing file <CODE>f</CODE>.
<P>
   If <CODE>OpenFile</CODE> returns a regular file handle, say <CODE>h</CODE>, then its
   initial state will be:
<P>
<PRE>
      type(h) = RegularFile.FileType
      readable(h) = writable(h) = TRUE
      cur(h) = 0
      file(h) = <KBD>file with pathname </KBD>p<KBD></KBD>
</PRE>
   To append to an existing file, perform the call
<P>
<PRE>
      EVAL h.seek(Origin.End, 0)
</PRE>
   after opening <CODE>h</CODE>. 

<P><PRE>PROCEDURE <A HREF="#x4">OpenFileReadonly</A>(p: Pathname.T): File.T
  RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Return an object permitting reading the file named by <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>p</CODE> names a regular file, the call <CODE>OpenFileReadonly(p)</CODE> returns
   a file handle <CODE>h</CODE> with
<P>
<PRE>
      type(h) = Atom.FromText(&quot;RegularFile&quot;)
      readable(h) = TRUE
      writable(h) = FALSE
      cur(h) = 0
      file(h) = <KBD>file with pathname </KBD>p<KBD></KBD>
</PRE>


<P><PRE>PROCEDURE <A HREF="#x5">CreateDirectory</A>(p: Pathname.T) RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Create a directory named by <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x6">DeleteDirectory</A>(p: Pathname.T) RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Delete the directory named by <CODE>p</CODE>.  <CODE>OSError.E</CODE> is raised if the
   directory contains entries (other than perhaps <CODE>Pathname.Current</CODE>
   and <CODE>Pathname.Parent</CODE>). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x7">DeleteFile</A>(p: Pathname.T)
  RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Delete the file or device named by <CODE>p</CODE>.  <CODE>OSError.E</CODE> is raised if <CODE>p</CODE>
   names a directory. </EM></BLOCKQUOTE><PRE>
</PRE> Note: Under Win32, <CODE>DeleteFile</CODE> raises <CODE>OSError.E</CODE> if <CODE>p</CODE> is open.
   Under POSIX, an open file may be deleted; the file doesn't actually
   disappear until every link (pathname) for it is deleted. 

<P><PRE>PROCEDURE <A HREF="#x8">Rename</A>(p0, p1: Pathname.T)
  RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Rename the file or directory named <CODE>p0</CODE> as <CODE>p1</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> Some implementations automatically delete an existing file named
   <CODE>p1</CODE>, others raise <CODE>OSError.E</CODE>.  Some implementations disallow a
   rename where <CODE>p0</CODE> and <CODE>p1</CODE> name different physical storage devices
   (different root directories or file systems).  

<P><PRE>TYPE
  <A HREF="#x9">Iterator</A> &lt;: PublicIterator;
  PublicIterator = OBJECT METHODS
    next(VAR (*OUT*) name: TEXT): BOOLEAN;
    nextWithStatus(VAR (*OUT*) name: TEXT;
      VAR (*OUT*) stat: File.Status): BOOLEAN RAISES {OSError.E};
    close();
  END;

VAR (*CONST*) DirectoryFileType: File.Type;
</PRE><BLOCKQUOTE><EM> Equal to {\tt Atom.FromText("Directory").} </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x10">Iterate</A>(p: Pathname.T): Iterator
  RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Return an iterator for the entries of the directory named by <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> An <CODE>Iterator</CODE> supplies information about the entries in a
   directory: names and, optionally, status.  The iteration does not
   include entries corresponding to <CODE>Pathname.Current</CODE> or
   <CODE>Pathname.Parent</CODE>.
<P>
   The methods have the following specifications: 
<P>
   If more entries remain, the call <CODE>i.next(n)</CODE> sets <CODE>n</CODE> to the name
   of the next one and returns <CODE>TRUE</CODE>.  It returns <CODE>FALSE</CODE> without
   setting <CODE>n</CODE> if no more entries remain.
<P>
   If more entries remain, the call <CODE>i.nextWithStatus(n, s)</CODE> sets <CODE>n</CODE>
   to the name of the next one, sets <CODE>s</CODE> to the status of that entry,
   and returns <CODE>TRUE</CODE>.  The value of <CODE>s.type</CODE> is <CODE>DirectoryFileType</CODE>
   if the entry is a directory.  The call returns <CODE>FALSE</CODE> without
   setting <CODE>n</CODE> or <CODE>s</CODE> if no more entries remain.
<P>
   The call <CODE>i.close()</CODE> releases the resources used by <CODE>i</CODE>, after
   which time it is a checked runtime error to use <CODE>i</CODE>.  Every
   iterator should be closed.
<P>
   You iterate over the entries in a directory with code like this:
<P>
<PRE>
      VAR
        i := FS.Iterate(pathname);
        name: TEXT;
      BEGIN
        TRY
          WHILE i.next(name) DO
            <KBD>Process </KBD>name<KBD></KBD>
          END
        FINALLY
          i.close()
        END
      END
</PRE>
   Use <CODE>nextWithStatus</CODE> instead of <CODE>next</CODE> if you would otherwise call
   <CODE>Status</CODE> (or the <CODE>File.T</CODE> <CODE>status</CODE> method) on most of the entries
   (in some implementations, <CODE>nextWithStatus</CODE> requires an extra disk
   access).
<P>
   What can be assumed if a directory is being updated concurrently
   with an iteration?  An entry that is not inserted or deleted will
   occur in the iteration at least once, and an entry that occurs in
   the iteration must have been in the directory at some moment.  

<P><PRE>PROCEDURE <A HREF="#x11">Status</A>(p: Pathname.T): File.Status
  RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Return information about the file or directory named by <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> Possible values of <CODE>stat.type</CODE> include
<P>
<PRE>
      FS.DirectoryFileType <KBD>(a directory)</KBD>
      RegularFile.FileType <KBD>(a disk file)</KBD>
      Terminal.FileType <KBD>(a terminal)</KBD>
</PRE>
   If <CODE>p</CODE> is a disk file, <CODE>stat.modificationTime</CODE> and <CODE>stat.size</CODE> will
   be set.
<P>
   See also the <CODE>status</CODE> method of <CODE>File.T</CODE> and the <CODE>nextWithStatus</CODE>
   method of <CODE>Iterator</CODE>.  

<P><PRE>PROCEDURE <A HREF="#x12">SetModificationTime</A>(
    p: Pathname.T;
    READONLY t: Time.T)
  RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Change the modification time of the file or directory named by <CODE>p</CODE>
   to <CODE>t</CODE>.  </EM></BLOCKQUOTE><PRE>

END FS.
</PRE>
</inInterface>
<HR>
<A NAME="x1">FS's implementation  is in:
</A><UL>
<LI><A HREF="FS.m3#0TOP0">os/src/Common/FS.m3</A>
<LI><A HREF="../POSIX/FSPosix.m3#0TOP0">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#0TOP0">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure FS.GetAbsolutePathname is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#GetAbsolutePathname">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#GetAbsolutePathname">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure FS.OpenFile is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#OpenFile">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#OpenFile">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure FS.OpenFileReadonly is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#OpenFileReadonly">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#OpenFileReadonly">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure FS.CreateDirectory is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#CreateDirectory">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#CreateDirectory">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure FS.DeleteDirectory is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#DeleteDirectory">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#DeleteDirectory">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x7">procedure FS.DeleteFile is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#DeleteFile">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#DeleteFile">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x8">procedure FS.Rename is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#Rename">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#Rename">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x9">opaque type FS.Iterator is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#Iterator">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#Iterator">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x10">procedure FS.Iterate is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#Iterate">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#Iterate">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x11">procedure FS.Status is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#Status">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#Status">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x12">procedure FS.SetModificationTime is in:
</A><UL>
<LI><A HREF="../POSIX/FSPosix.m3#SetModificationTime">os/src/POSIX/FSPosix.m3</A>
<LI><A HREF="../WIN32/FSWin32.m3#SetModificationTime">os/src/WIN32/FSWin32.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
