<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/Common/File.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/Common/File.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>File.T</CODE>, or {\em file handle}, is a source and/or sink of bytes.
   File handles provide an operating-system independent way to perform
   raw I/O.  For buffered I/O, use the <CODE>FileRd</CODE> and <CODE>FileWr</CODE>
   interfaces instead.  A file handle is created using <CODE>OpenFile</CODE> or
   <CODE>OpenFileReadonly</CODE> in the <CODE>FS</CODE> interface.
   \index{file!handle}
   \index{unbuffered file I/O}
   \index{file!unbuffered I/O}
   \index{I/O!unbuffered}


<P><PRE>INTERFACE <interface>File</interface>;

IMPORT <A HREF="../../../atom/src/Atom.i3">Atom</A>, <A HREF="OSError.i3">OSError</A>, <A HREF="../../../time/src/Common/Time.i3">Time</A>;

TYPE
  T &lt;: Public;
  Public = OBJECT METHODS
    read(VAR (*OUT*) b: ARRAY OF Byte;
      mayBlock: BOOLEAN := TRUE): INTEGER RAISES {OSError.E};
    write(READONLY b: ARRAY OF Byte) RAISES {OSError.E};
    status(): Status RAISES {OSError.E};
    close() RAISES {OSError.E}
  END;
  Byte = BITS 8 FOR [0 .. 255];
  Status = RECORD
    type: Type;
    modificationTime: Time.T;
    size: CARDINAL
  END;
  Type = Atom.T;

END File.
</PRE> Formally, a file handle <CODE>h</CODE> has the components:
<P>
<PRE>
      type(h)      <KBD>an atom, the type of file</KBD>
      readable(h)  <KBD>a boolean</KBD>
      writable(h)  <KBD>a boolean</KBD>
      src(h)       <KBD>(a </KBD>REF<KBD> to) a sequence of bytes</KBD>
      srcCur(h)    <KBD>an integer in the range </KBD>[0..len(src(h))]<KBD></KBD>
      srcEof(h)    <KBD>a boolean</KBD>
      snk(h)       <KBD>(a </KBD>REF<KBD> to) a sequence of bytes</KBD>
      snkCur(h)    <KBD>an integer in the range </KBD>[0..len(snk(h))]<KBD></KBD>
</PRE>
   The <CODE>src...</CODE> components are meaningful only if <CODE>readable(h)</CODE>.  The
   sequence <CODE>src(h)</CODE> is zero-based: <CODE>src(h)[i]</CODE> is valid for <CODE>i</CODE> from
   <CODE>0</CODE> to <CODE>len(src(h))-1</CODE>.  For some subtypes of <CODE>File.T</CODE>, the
   sequence <CODE>src(h)</CODE> can grow without bound.
<P>
   The <CODE>snk...</CODE> components are meaningful only if <CODE>writable(h)</CODE>.  The
   sequence <CODE>snk(h)</CODE> is zero based: <CODE>snk(h)[i]</CODE> is valid for <CODE>i</CODE> from
   <CODE>0</CODE> to <CODE>len(snk(h))-1</CODE>.
<P>
   For full details on the semantics of a file handle, consult the
   interface defining the particular subtype, for example, <CODE>Pipe.T</CODE>,
   <CODE>Terminal.T</CODE>, or <CODE>RegularFile.T</CODE>.  In the case where no exceptions
   are raised, the methods of the subtypes of <CODE>File.T</CODE> obey the
   following specifications:
<P>
   The call
<P>
<PRE>
      h.read(b, mayBlock)
</PRE>
   is equivalent to
<P>
<PRE>
      IF NOT readable(h) OR NUMBER(b) = 0 THEN
        <KBD>Cause checked runtime error</KBD>
      END;
      IF srcCur(h) = len(src(h)) AND NOT srcEof(h) THEN
        IF NOT mayBlock THEN RETURN -1 END;
        <KBD>Block until </KBD>srcCur(h) &lt; len(src(h)) OR srcEof(h)<KBD></KBD>
      END;
      IF srcCur(h) = len(src(h)) THEN RETURN 0 END;
      <KBD>Choose </KBD>k<KBD> such that:</KBD>
        1 &lt;= k &lt;= MIN(NUMBER(b), len(src(h))-srcCur(h));
      FOR i := 0 TO k-1 DO
        b[i] := src(h)[srcCur(h)];
        INC(srcCur(h))
      END;
      RETURN k
</PRE>
   \index{non-blocking read}
<P>
   A result of zero always means end of file.  The meaning of a
   subsequent read after end of file has been reached is undefined for
   a <CODE>File.T</CODE> but may be defined for a particular subtype.
<P>
   The call
<P>
<PRE>
      h.write(b)
</PRE>
   is equivalent to
<P>
<PRE>
      IF NOT writable(h) THEN <KBD>Cause checked runtime error</KBD> END;
      FOR i := 0 TO NUMBER(b)-1 DO
        IF snkCur(h) = len(snk(h)) THEN
          <KBD>Extend </KBD>snk(h)<KBD> by one byte</KBD>
        END;
        snk(h)[snkCur(h)] := b[i]
        INC(srcCur(h))
      END;
</PRE>
   The <CODE>read</CODE> and <CODE>write</CODE> methods are not alertable because it isn't
   possible to alert a thread blocked in a Win32 <CODE>ReadFile</CODE> or
   <CODE>WriteFile</CODE> system call.
<P>
   The call
<P>
<PRE>
      h.status()
</PRE>
   returns a result whose <CODE>type</CODE> field contains <CODE>type(h)</CODE>.  See the
   documentation for each subtype of <CODE>File.T</CODE> for more details,
   including the values of the <CODE>modificationTime</CODE> and <CODE>size</CODE> fields of
   the result, if any.
<P>
   The call
<P>
<PRE>
      h.close()
</PRE>
   is equivalent to
<P>
<PRE>
      readable(h) := FALSE;
      writable(h) := FALSE
</PRE>
   Additionally, it releases any subtype-specific resources used by
   <CODE>h</CODE>.  Every file handle should be closed.
<P>
   Clients should assume that file handles are unmonitored and should
   avoid concurrent accesses to a file handle from multiple threads.
   A particular subtype of <CODE>File.T</CODE> may provide a stronger
   specification with respect to atomicity.
<P>


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
