<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/Common/Pathname.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/Common/Pathname.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>Pathname</CODE> defines procedures for manipulating pathnames in a
   portable fashion.  

<P><PRE>INTERFACE <interface><A HREF="#x1">Pathname</A></interface>;

IMPORT <A HREF="../../../libm3/derived/TextSeq.i3">TextSeq</A>;

TYPE
  T = TEXT;
  Arcs = TextSeq.T;
</PRE> Most operating systems include a file system providing persistent
   storage (files) and naming (directories).  The name space is
   usually a directed, rooted graph in which interior nodes are
   directories and exterior nodes are files and empty directories.
   Each arc is labeled with a character string called an arc name; the
   arc names in any one directory are distinct.  A <CODE>Pathname.T</CODE> (or
   just a pathname) is a text conforming to the syntax of the
   underlying operating system.  It consists of a sequence of arc
   names specifying a path starting from some distinguished directory
   and ending at the referent of the pathname.
<P>
   A pathname may be absolute, in which case it begins with the name
   of a root directory.  If a pathname is not absolute, it is
   interpreted relative to the working directory associated with the
   process (see <CODE>GetWorkingDirectory</CODE> in the <CODE>Process</CODE> interface).
   \index{absolute pathname}
   \index{relative pathname}
<P>
   Not all operating systems use the same syntax for pathnames, so we
   define the type <CODE>Arcs</CODE> to represent a pathname in a standard form
   allowing manipulations by portable programs.  Suppose <CODE>a</CODE> is of
   type <CODE>Arcs</CODE>.  Then <CODE>a</CODE> is non-<CODE>NIL</CODE>, <CODE>a.getlo()</CODE> indicates whether
   or not the pathname is absolute, and <CODE>TextSeq.Sub(a, 1)</CODE> represents
   a sequence (possibly empty) of arc names (all non-<CODE>NIL</CODE>).  If <CODE>a</CODE>
   represents an absolute pathname, then <CODE>a.getlo()</CODE> is the root
   directory name and is non-<CODE>NIL</CODE>; if <CODE>a</CODE> represents a relative
   pathname, then <CODE>a.getlo()</CODE> is <CODE>NIL</CODE>.
<P>
   It is often useful to view an arc name as having two parts, a base
   and an extension, separated by a period, for example <CODE>Pathname.i3</CODE>.
   \index{extension of pathname}
   \index{base of pathname}
<P>
   See the end of this interface for operating-system specific
   details.
<P>


<P><PRE>EXCEPTION Invalid;

PROCEDURE <A HREF="#x2">Valid</A>(pn: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> iff <CODE>pn</CODE> conforms to the pathname syntax of this
   operating system. </EM></BLOCKQUOTE><PRE>
</PRE> When a pathname with invalid syntax is passed to a procedure in
   this interface not declared as raising the exception <CODE>Invalid</CODE>,
   the result is undefined, but safe. 

<P><PRE>PROCEDURE <A HREF="#x3">Decompose</A>(pn: T): Arcs RAISES {Invalid};
</PRE><BLOCKQUOTE><EM> Parse <CODE>pn</CODE>, returning a sequence whose first element is a root
   directory name (possibly <CODE>NIL</CODE>) and whose remaining elements
   consist of zero or more arc names.  Raise <CODE>Invalid</CODE> if <CODE>Valid(pn)</CODE>
   is <CODE>FALSE</CODE>.  </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Decompose</CODE> returns exactly the sequence of arc names present in
   <CODE>pn</CODE>; it doesn't attempt to produce a canonical form. Some
   operating systems allow zero-length arc names (see the discussion
   of specific systems at the end of this section.) 

<P><PRE>PROCEDURE <A HREF="#x4">Compose</A>(a: Arcs): T RAISES {Invalid};
</PRE><BLOCKQUOTE><EM> Combine the elements of <CODE>a</CODE> to form a pathname corresponding to the
   syntax of this operating system.  Raise <CODE>Invalid</CODE> if <CODE>a</CODE> is <CODE>NIL</CODE>,
   if <CODE>a.getlo()</CODE> is neither <CODE>NIL</CODE> nor a valid root directory name, or
   if one of the elments of <CODE>TextSeq.Sub(a, 1)</CODE> is not a valid arc
   name. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x5">Absolute</A>(pn: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> iff <CODE>pn</CODE> is an absolute pathname.  Equivalent to
   <CODE>Decompose(pn).getlo() # NIL</CODE>, but faster. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x6">Prefix</A>(pn: T): T;
</PRE><BLOCKQUOTE><EM> Return a pathname equal to <CODE>pn</CODE> up to, but not including, the final
   arc name.  If <CODE>pn</CODE> consists only of a root directory name,
   <CODE>Prefix(pn)</CODE> returns <CODE>pn</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x7">Last</A>(pn: T): T;
</PRE><BLOCKQUOTE><EM> Return the final arc name in <CODE>pn</CODE>.  If <CODE>pn</CODE> consists only of a root
   directory name, <CODE>Last(pn)</CODE> returns the empty string.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x8">Base</A>(pn: T): T;
</PRE><BLOCKQUOTE><EM> Return a pathname equal to <CODE>pn</CODE> except with <CODE>Last(pn)</CODE> replaced by
   its base. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x9">Join</A>(pn, base: T; ext: TEXT): T;
</PRE><BLOCKQUOTE><EM> Return a pathname formed by prepending <CODE>pn</CODE> to <CODE>base</CODE> (if <CODE>pn</CODE> is
   not <CODE>NIL</CODE>) and appending <CODE>ext</CODE> to <CODE>base</CODE> (if <CODE>ext</CODE> is not <CODE>NIL</CODE>).
   More precisely, this is equivalent to the following, in which <CODE>a</CODE>
   is a local variable of type <CODE>Arcs</CODE>: </EM></BLOCKQUOTE><PRE>
</PRE><P>
<PRE>
      IF pn = NIL THEN a := NIL
      ELSE
        IF Absolute(base) THEN <KBD>Cause checked runtime error</KBD> END;
        a := Decompose(pn)
      END;
      IF ext # NIL THEN base := base &amp; &quot;.&quot; &amp; ext END;
      RETURN Compose(
        TextSeq.Cat(a, TextSeq.Sub(Decompose(base), 1)))


<P> </PRE>
The value returned by <CODE>Join</CODE> will be a valid pathname only if the
   <CODE>base</CODE> and <CODE>ext</CODE> conform to the syntax of the particular operating
   system, as specified at the end of this section. 

<P><PRE>PROCEDURE <A HREF="#x10">LastBase</A>(pn: T): T;
</PRE><BLOCKQUOTE><EM> Return the base of the final arc name of <CODE>pn</CODE>.  It is a checked
   runtime error if <CODE>pn</CODE> is empty or consists only of a root directory
   name. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x11">LastExt</A>(pn: T): TEXT;
</PRE><BLOCKQUOTE><EM> Return the extension of the last arc name of <CODE>pn</CODE>.  It is a checked
   runtime error if <CODE>pn</CODE> is empty or consists only of a root directory
   name. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x12">ReplaceExt</A>(pn: T; ext: TEXT): T;
</PRE><BLOCKQUOTE><EM> Return a pathname equal to <CODE>pn</CODE> except with the extension of the
   final arc name replaced with <CODE>ext</CODE>, which must be non-<CODE>NIL</CODE>. </EM></BLOCKQUOTE><PRE>

VAR (*CONST*)
  Parent: TEXT;
</PRE><BLOCKQUOTE><EM> A special arc name that, when encountered during a pathname lookup,
   stands for the parent of the directory currently being examined.
   </EM></BLOCKQUOTE><PRE>
  Current: TEXT;
</PRE><BLOCKQUOTE><EM> A special arc name that, when encountered during a pathname lookup,
   stands for the directory currently being examined. </EM></BLOCKQUOTE><PRE>

END Pathname.
</PRE><P>
<P>
\paragraph*{POSIX.} Pathnames have the syntax:
<P>
<PRE>
      Pathname = Absolute | Relative.
      Absolute = &quot;/&quot; Relative.
      Relative = [ArcName {&quot;/&quot; ArcName}].
</PRE>
   <CODE>Parent</CODE> is ``..'' and <CODE>Current</CODE> is ``.''.
<P>
   There is only one root directory and it is named ``/''. A
   POSIX-compliant system must support arc names at least as long as
   fourteen characters.  An arc name longer than the maximum supported
   is either silently truncated by the operating system or is reported
   as an error, depending on a configuration option.  A zero-length
   arc name is treated the same as ``.''.  An arc name may contain any
   character except ``/'' and the null character, but for maximum
   portability the POSIX specification recommends they be restricted
   to upper and lower case letters, digits, and these special
   characters:
<P>
<PRE>
       . <KBD>{\tt _}</KBD> -
</PRE>
   Furthermore, it is recommended that arc names not start with hyphen
   (-).
<P>
   The extension of an arc name is the suffix starting after the last
   ``.''.
<P>
   The base of an arc name is the prefix up to, but not including, the
   final ``.'' if the extension is nonempty; it is the entire arc name
   if the extension is empty.
<P>
\paragraph*{Win32.} Pathnames have the syntax, where backslash is not
   an escape character but a literal character:
<P>
<PRE>
      Pathname = Absolute | Relative.
      Absolute = Volume &quot;<KBD>{\tt \}</KBD>&quot; Relative.
      Relative = [ArcName {&quot;\&quot; ArcName}].
      ArcName  = Base &quot;.&quot; Extension | &quot;.&quot; | &quot;..&quot;.
      Volume   = Drive &quot;:&quot; | &quot;<KBD>{\tt \\}</KBD>&quot; Server &quot;<KBD>{\tt \}</KBD>&quot; Share.
      Server   = ?
      Share    = ?
</PRE>
   <CODE>Parent</CODE> is ``..'' and <CODE>Current</CODE> is ``.''.
<P>
   The FAT (MS-DOS) file system restricts <CODE>Drive</CODE> to a single letter,
   and <CODE>Base</CODE> to between one and eight letters, digits, or these
   special characters:
<P>
<PRE>
      $ % ' - _ @ { } <KBD>~</KBD> <KBD>`</KBD> ! # ( )
</PRE>
   <CODE>Extension</CODE> is one to three characters from the same set.  Certain
   <CODE>Base</CODE>s, including AUX, CLOCK\$, COM1, CON, LPT1, NUL, and PRN are
   reserved---they name devices, regardless of the directory or
   extension.  Embedded (but not trailing) spaces are allowed in the
   <CODE>Base</CODE> of a file name (but not a directory name).
<P>
   The HPFS and NTFS file systems allow arc names up to 254
   characters, and these additional special characters are allowed:
<P>
<PRE>
      , + = [ ] ; 
</PRE>
   Additionally, blank is significant anywhere in an arc name except
   at the end.  Win32 allows a programmer to use either ANSI or
   Unicode representation for pathname strings.  The NTFS file system
   stores full Unicode pathnames in the directories.
<P>
\paragraph*{Macintosh.} Pathnames have the syntax:
<P>
<PRE>
      Pathname   = Absolute | Relative.
      Absolute   = Volume &quot;:&quot; [ArcName {Colons ArcName}].
      Relative   = ArcName
                 | Colons ArcName {Colons ArcName}.
      Colons     = &quot;:&quot; {&quot;:&quot;}.
</PRE>
   <CODE>Parent</CODE> is ``::'' and <CODE>Current</CODE> is ``:''.
<P>
   A <CODE>Volume</CODE> is one to twenty-seven printing characters excluding
   colon (:).  An arc name is one to thirty-one printing characters
   excluding colon.  A single colon is a separator; <CODE>n+1</CODE> adjacent
   colons means the <CODE>n</CODE>th parent.
<P>
   The extension of an arc name is the suffix starting after the last
   ``.''; if there is no ``.'', the extension is empty.
<P>
   The base of an arc name is the prefix up to, but not including, the
   final ``.'' if the extension is nonempty; it is the entire arc name
   if the extension is empty.
<P>


</inInterface>
<HR>
<A NAME="x1">Pathname's implementation  is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#0TOP0">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#0TOP0">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Pathname.Valid is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#Valid">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#Valid">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure Pathname.Decompose is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#Decompose">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#Decompose">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure Pathname.Compose is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#Compose">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#Compose">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure Pathname.Absolute is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#Absolute">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#Absolute">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure Pathname.Prefix is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#Prefix">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#Prefix">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x7">procedure Pathname.Last is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#Last">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#Last">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x8">procedure Pathname.Base is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#Base">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#Base">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x9">procedure Pathname.Join is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#Join">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#Join">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x10">procedure Pathname.LastBase is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#LastBase">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#LastBase">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x11">procedure Pathname.LastExt is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#LastExt">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#LastExt">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x12">procedure Pathname.ReplaceExt is in:
</A><UL>
<LI><A HREF="../POSIX/PathnamePosix.m3#ReplaceExt">os/src/POSIX/PathnamePosix.m3</A>
<LI><A HREF="../WIN32/PathnameWin32.m3#ReplaceExt">os/src/WIN32/PathnameWin32.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
