<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/Common/Pipe.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/Common/Pipe.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>Pipe.T</CODE>, or pipe, is a file handle that provides access to one
   endpoint of a unidirectional channel that is typically used to
   communicate between a parent and a child process or two sibling
   processes.  (See <CODE>Process.Create</CODE>.) 

<P><PRE>INTERFACE <interface><A HREF="#x1">Pipe</A></interface>;

IMPORT <A HREF="File.i3">File</A>, <A HREF="OSError.i3">OSError</A>;

TYPE T &lt;: File.T;

VAR (*CONST*) FileType: File.Type;
</PRE><BLOCKQUOTE><EM> Equal to {\tt Atom.FromText("Pipe").} </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x2">Open</A>(VAR (*OUT*) hr, hw: T) RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Create a new channel allowing bytes written to <CODE>hw</CODE> to be read from
   <CODE>hr</CODE>.  </EM></BLOCKQUOTE><PRE>

END Pipe.
</PRE> Like every <CODE>File.T</CODE>, a pipe <CODE>h</CODE> has the components
<P>
<PRE>
      type(h)      <KBD>an atom, equal to </KBD>FileType<KBD></KBD>
      readable(h)  <KBD>a boolean</KBD>
      writable(h)  <KBD>a boolean</KBD>
</PRE>
   Exactly one of <CODE>readable(h)</CODE> and <CODE>writable(h)</CODE> is true (until the
   pipe is closed).
<P>
   A pipe <CODE>h</CODE> also has the component
<P>
<PRE>
      channel(h)   <KBD>a channel</KBD>
</PRE>
   If there are pipes <CODE>hw</CODE> and <CODE>hr</CODE> with <CODE>channel(hw) = channel(hr)</CODE>,
   <CODE>writable(hw)</CODE>, and <CODE>readable(hr)</CODE>, then a process holding <CODE>hw</CODE> can
   send information to a process holding <CODE>hr</CODE>.
<P>
   A channel <CODE>c</CODE> has the components
<P>
<PRE>
      seq(c)  <KBD>a sequence of bytes</KBD>
      w(c)    <KBD>a non-negative integer, the index of the next byte to write</KBD>
      r(c)    <KBD>a non-negative integer, the index of the next byte to read</KBD>
      nw(c)   <KBD>a non-negative integer, the number of pipes writing </KBD>c<KBD></KBD>
      nr(c)   <KBD>a non-negative integer, the number of pipes reading </KBD>c<KBD></KBD>
</PRE>
   It is possible (but not very useful) for a channel to have values of
   <CODE>nw(c)</CODE> or <CODE>nr(c)</CODE> other than zero or one (see <CODE>Process.Create</CODE>).
<P>
   <CODE>Open</CODE> creates a channel <CODE>c</CODE> with
<P>
<PRE>
      w(c) = r(c) = 0
      nw(c) = nr(c) = 1
</PRE>
   and two pipes <CODE>hr</CODE> and <CODE>hw</CODE> with
<P>
<PRE>
      type(hr) = type(hw) = FileType
      readable(hr) = writable(hw) = TRUE
      writable(hr) = readable(hw) = FALSE
      channel(hr) = channel(hw) = c
</PRE>
<P>
   The meaning of the call
<P>
<PRE>
      h.read(b, mayBlock)
</PRE>
   is given by the specification of <CODE>File.T.read</CODE> together with these
   definitions, where <CODE>c = channel(h)</CODE>:
<P>
<PRE>
      src(h)    = seq(c)
      srcCur(h) = r(c)
      srcEof(h) = (nw(c) = 0)
</PRE>
   Note that end-of-file is not reported until after the last pipe
   that can write on the channel is closed; subsequent reads are legal
   but always report end-of-file.
<P>
   The meaning of the call
<P>
<PRE>
      h.write(b)
</PRE>
   is given by the specification of <CODE>File.T.write</CODE> together with these
   definitions, where <CODE>c = channel(h)</CODE>:
<P>
<PRE>
      snk(h)    = seq(c)
      snkCur(h) = w(c)
</PRE>
   In some implementations, a channel has a bounded buffer, so <CODE>write</CODE>
   may have to block.  If <CODE>nr(channel(h)) = 0</CODE>, that is, no pipe can
   read <CODE>h</CODE>'s channel, <CODE>write</CODE> raises <CODE>OSError.E</CODE>.
<P>
   The call
<P>
<PRE>
      h.status(stat)
</PRE>
   assigns <CODE>FileType</CODE> to <CODE>stat.type</CODE>.  Its effect on
   <CODE>stat.modificationTime</CODE> and <CODE>stat.size</CODE> is undefined.
<P>
   The call
<P>
<PRE>
      h.close()
</PRE>
   is equivalent to
<P>
<PRE>
      IF readable(h) THEN
        DEC(nr(channel(h)))
      ELSE
        DEC(nw(channel(h)))
      END;
      readable(h) := FALSE;
      writable(h) := FALSE
</PRE>
   The channel connecting a pair of pipes is necessarily monitored,
   since the purpose of the channel is to allow asynchronous
   communication via the pipes.  Nevertheless, an individual pipe
   should be treated as unmonitored, thus avoiding the question of the
   unit of atomicity for reads and writes.
<P>


</inInterface>
<HR>
<A NAME="x1">Pipe's implementation  is in:
</A><UL>
<LI><A HREF="Pipe.m3#0TOP0">os/src/Common/Pipe.m3</A>
<LI><A HREF="../POSIX/PipePosix.m3#0TOP0">os/src/POSIX/PipePosix.m3</A>
<LI><A HREF="../WIN32/PipeWin32.m3#0TOP0">os/src/WIN32/PipeWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Pipe.Open is in:
</A><UL>
<LI><A HREF="../POSIX/PipePosix.m3#Open">os/src/POSIX/PipePosix.m3</A>
<LI><A HREF="../WIN32/PipeWin32.m3#Open">os/src/WIN32/PipeWin32.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
