<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/Common/Process.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/Common/Process.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A process is the execution of a program by one or more threads within
   an address space.  A process may hold a variety of resources such as
   file handles. 

<P><PRE>INTERFACE <interface><A HREF="#x1">Process</A></interface>;

IMPORT <A HREF="File.i3">File</A>, <A HREF="OSError.i3">OSError</A>, <A HREF="Pathname.i3">Pathname</A>;

TYPE <A HREF="#x2">T</A> &lt;: REFANY;
</PRE><BLOCKQUOTE><EM> A <CODE>Process.T</CODE>, or process handle, provides access to a child process. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x3">Create</A>(
    cmd: Pathname.T;
    READONLY params: ARRAY OF TEXT;
    env: REF ARRAY OF TEXT := NIL;
    wd: Pathname.T := NIL;
    stdin, stdout, stderr: File.T := NIL): T
  RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Create a new process and cause it to execute the program with
   pathname <CODE>cmd</CODE>, parameters <CODE>params</CODE>, environment variables
   <CODE>env</CODE>, working directory <CODE>wd</CODE>, and standard file handles <CODE>stdin</CODE>,
   <CODE>stdout</CODE>, and <CODE>stderr</CODE>.  Return the handle of the new process. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>cmd</CODE> consists of a single (relative) arc name, then it is
   looked up in an operating-system dependent way (see below).
   Otherwise, <CODE>cmd</CODE> is looked up in the normal fashion as an absolute
   pathname or as a pathname relative to the current working directory
   (not <CODE>wd</CODE>).
<P>
   A process can examine its own parameters via the interface
   <CODE>Params</CODE>.  The parameter <CODE>params[i]</CODE> passed to <CODE>Create</CODE> will
   correspond to the value of <CODE>Params.Get(i+1)</CODE> in the newly created
   process (because <CODE>Params.Get(0)</CODE> returns the command name).  (See
   the <CODE>Params</CODE> interface for the way SRC Modula-3 treats parameters
   beginning with the characters <CODE>@M3</CODE>.)
   \index{parameters of a process}
   \index{process!parameters}
<P>
   If <CODE>env</CODE> is not <CODE>NIL</CODE>, it consists of a reference to an array of
   texts that must have the form <CODE>name=value</CODE>.  If <CODE>env</CODE> is <CODE>NIL</CODE>, it
   defaults to the environment variables of the caller's process.  A
   process can examine its own environment variables via the interface
   <CODE>Env</CODE>.
   \index{environment variables}
   \index{process!environment variables}
<P>
   If <CODE>wd</CODE> is <CODE>NIL</CODE>, it defaults to the working directory of the
   caller's process.
   \index{working directory}
   \index{process!working directory}
<P>
   If any of <CODE>stdin</CODE>, <CODE>stdout</CODE>, or <CODE>stderr</CODE> are <CODE>NIL</CODE>, the
   corresponding file handle of the new process is <CODE>NIL</CODE>.  A process
   can obtain its own standard file handles by calling the procedure
   <CODE>GetStandardFileHandles</CODE> defined later in this interface.
   \index{standard I/O!file handles}
   \index{process!standard I/O handles}
   \index{I/O!standard handles}
<P>
   The sharing established by passing a <CODE>File.T</CODE> to a new process
   requires care.  For example, seeks done by either process affect
   both, and passing a <CODE>Pipe.T</CODE> increments a reference count of the
   underlying channel.  See the end of this interface for an example
   of using <CODE>Create</CODE> with pipes.
<P>
   \paragraph*{POSIX.} <CODE>Create</CODE> forks a child process, which executes
   the specified command.  If <CODE>cmd</CODE> consists of a single (relative)
   arc name, <CODE>Create</CODE> searches each of the directories specified by
   the PATH environment variable for a file named <CODE>cmd</CODE> that is
   executable by the current (effective) user.  If the attempt to
   execute the command returns the Unix error ENOEXEC, then the child
   process executes <CODE>/bin/sh</CODE> with the original arguments prefixed by
   the pathname determined earlier.
<P>
   \paragraph*{Win32.} <CODE>Create</CODE> calls <CODE>Win32.CreateProcess</CODE>.  If <CODE>cmd</CODE>
   consists of a single (relative) arc name, <CODE>Win32.CreateProcess</CODE>
   first appends <CODE>.EXE</CODE> if <CODE>cmd</CODE> includes neither an extension nor a
   final period, and then searches for this name in the following
   sequence of directories: the working directory; the Windows system
   directory; the Windows directory; the directories listed in the
   PATH environment variable.


<P><PRE>TYPE ExitCode = [0 .. 16_7FFFFFFF];
</PRE> An exit code (or status) of zero normally means successful
   termination, and a non-zero value normally indicates an error, but
   the exact conventions vary between systems and programs. 

<P><PRE>PROCEDURE <A HREF="#x4">Wait</A>(p: T): ExitCode;
</PRE><BLOCKQUOTE><EM> Wait until the process with handle <CODE>p</CODE> terminates, then free the
   operating system resources associated with the process and return
   an exit code indicating the reason for its termination.  It is a
   checked runtime error to call <CODE>Wait</CODE> twice on the same process
   handle. </EM></BLOCKQUOTE><PRE>
</PRE> \paragraph*{POSIX.} The value returned by <CODE>Wait</CODE> is equal to the
   <CODE>status</CODE> result of the <CODE>wait</CODE> system call.
<P>
   \paragraph*{Win32.} The value returned by <CODE>Wait</CODE> is <CODE>c MOD
   (LAST(ExitCode) + 1)</CODE> where <CODE>c</CODE> is the value returned by
   <CODE>Win32.GetExitCodeProcess</CODE>. 

<P><PRE>PROCEDURE <A HREF="#x5">Exit</A>(n: ExitCode := 0);
</PRE><BLOCKQUOTE><EM> Call the registered exitors and terminate the program with exit
   code <CODE>n</CODE>.  Terminating a Modula-3 program by ``falling off the
   end'' is equivalent to calling <CODE>Exit(0)</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \index{terminating execution} 

<P><PRE>PROCEDURE <A HREF="#x6">Crash</A>(msg: TEXT);
</PRE><BLOCKQUOTE><EM> Call the registered exitors and terminate the program with the
   error message <CODE>msg</CODE>.  If possible, invoke a debugger or generate a
   core dump. </EM></BLOCKQUOTE><PRE>
</PRE> Modula-3 implementations that don't convert checked runtime errors
   into exceptions should call <CODE>Crash</CODE> to abort the program.
<P>
   Some Modula-3 implementations catch external events (e.g. Unix
   signals) or internal interrupts (e.g. floating-point underflow) and
   call <CODE>Crash</CODE>.  Consult your local installation guide for more
   information. 

<P><PRE>PROCEDURE <A HREF="#x7">RegisterExitor</A>(p: PROCEDURE());
</PRE><BLOCKQUOTE><EM> Register the procedure <CODE>p</CODE> to be called when <CODE>Exit</CODE> or <CODE>Crash</CODE> is
   called. </EM></BLOCKQUOTE><PRE>
</PRE> Each registered exitor is called at most once.  Exitors are called
   in reverse of the order they were registered.  A facility
   implementing a class of objects should register only a single
   exitor, which can consult a private data structure to determine
   which of its objects need cleanup. <CODE>RegisterExitor</CODE> should be
   called at module initialization time (not when the first object is
   created) to guarantee the correct registration order. 

<P><PRE>TYPE ID = [0 .. 16_7FFFFFFF];
CONST NullID: ID = 0;
</PRE> An <CODE>ID</CODE> or process identifier is assigned to each process when it
   is created.  At any moment, no two processes on the same computer
   have the same identifier, but identifiers can be reused over time.
   No process is ever assigned the identifier <CODE>NullID</CODE>. 

<P><PRE>PROCEDURE <A HREF="#x8">GetID</A>(p: T): ID;
</PRE><BLOCKQUOTE><EM> Return the process identifier of the process with handle <CODE>p</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \index{process!identifier} 

<P><PRE>PROCEDURE <A HREF="#x9">GetMyID</A>(): ID;
</PRE><BLOCKQUOTE><EM> Return the process identifier of the caller's process. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x10">GetStandardFileHandles</A>(
    VAR (*OUT*) stdin, stdout, stderr: File.T);
</PRE><BLOCKQUOTE><EM> Return the standard input/output handles that were supplied when
   this process was created. </EM></BLOCKQUOTE><PRE>
</PRE> \index{standard I/O!file handles}
   \index{process!standard I/O handles}
   \index{I/O!standard handles}


<P>
<P><PRE>PROCEDURE <A HREF="#x11">GetWorkingDirectory</A>(): Pathname.T
  RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Return an absolute pathname for the working directory of the
   caller's process. </EM></BLOCKQUOTE><PRE>
</PRE> \index{working directory}
   \index{process!working directory}


<P><PRE>PROCEDURE <A HREF="#x12">SetWorkingDirectory</A>(path: Pathname.T)
  RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Change the working directory of this process to <CODE>path</CODE>. </EM></BLOCKQUOTE><PRE>

END Process.
</PRE> \paragraph*{Example.} A typical use of <CODE>Create</CODE> is to run a filter
   process that reads from standard input and writes a transformed
   version to standard output.  The first step is to create two sets
   of pipes to carry the standard input and standard output of the new
   process.  (If desired, standard error can be handled in the same
   way as standard output.)
<P>
<PRE>
      VAR hrChild, hwChild, hrSelf, hwSelf: Pipe.T;
      BEGIN
        Pipe.Open(hr := hrChild, hw := hwSelf);
        Pipe.Open(hr := hrSelf, hw := hwChild);
</PRE>
   The next step is to create the process, passing the appropriate
   pipes, and then to close the original instances of these pipes.
   (The pipes must be closed to maintain the correct reference counts
   on the underlying channels.)
<P>
<PRE>
        WITH p = Process.Create(..., hrChild, hwChild, NIL) DO
          TRY
            TRY hrChild.close(); hwChild.close()
            EXCEPT OSError.E =&gt; (*SKIP

<PRE>|       END;

   Now comes the actual writing and reading, which is conveniently
   performed using I/O streams:

|       WITH wr = NEW(FileWr.T).init(hwSelf),
|            rd = NEW(FileRd.T).init(hrSelf) DO
|         `Write &quot;wr&quot; (and perhaps read &quot;rd&quot;)`

   Closing &quot;wr&quot; causes the filter to encounter end-of-file on its
   standard input, which should cause it to flush its standard output
   and terminate.  This in turn causes this process to read
   end-of-file.

|         TRY Wr.Close(wr)
|         EXCEPT Wr.Failure, Thread.Alerted =&gt; (*SKIP*)
|         END;
|         `Read &quot;rd&quot; to end-of-file`;
|         TRY Rd.Close(rd)
|         EXCEPT Rd.Failure, Thread.Alerted =&gt; (*SKIP*)
|         END
|       END

   The last step is to clean up the process.

|     FINALLY EVAL Process.Wait(p)
|     END
|   END
| END

*)
</PRE>
</inInterface>
<HR>
<A NAME="x1">Process's implementation  is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#0TOP0">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#0TOP0">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">opaque type Process.T is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#T">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#T">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure Process.Create is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#Create">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#Create">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure Process.Wait is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#Wait">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#Wait">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure Process.Exit is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#Exit">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#Exit">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure Process.Crash is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#Crash">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#Crash">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x7">procedure Process.RegisterExitor is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#RegisterExitor">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#RegisterExitor">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x8">procedure Process.GetID is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#GetID">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#GetID">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x9">procedure Process.GetMyID is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#GetMyID">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#GetMyID">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x10">procedure Process.GetStandardFileHandles is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#GetStandardFileHandles">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#GetStandardFileHandles">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x11">procedure Process.GetWorkingDirectory is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#GetWorkingDirectory">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#GetWorkingDirectory">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x12">procedure Process.SetWorkingDirectory is in:
</A><UL>
<LI><A HREF="../POSIX/ProcessPosix.m3#SetWorkingDirectory">os/src/POSIX/ProcessPosix.m3</A>
<LI><A HREF="../WIN32/ProcessWin32.m3#SetWorkingDirectory">os/src/WIN32/ProcessWin32.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
