<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/Common/RegularFile.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/Common/RegularFile.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>RegularFile.T</CODE>, or regular file handle, provides access to a
   persistent extensible sequence of bytes. 

<P><PRE>INTERFACE <interface><A HREF="RegularFile.m3">RegularFile</A></interface>;

IMPORT <A HREF="File.i3">File</A>, <A HREF="OSError.i3">OSError</A>;

TYPE
  T &lt;: Public;
  Public = File.T OBJECT METHODS
    seek(origin: Origin; offset: INTEGER): INTEGER
      RAISES {OSError.E};
    flush() RAISES {OSError.E};
    lock(): BOOLEAN RAISES {OSError.E};
    unlock() RAISES {OSError.E}
  END;
  Origin = {Beginning, Current, End};

VAR (*CONST*) FileType: File.Type;
</PRE><BLOCKQUOTE><EM> Equal to {\tt Atom.FromText("RegularFile").} </EM></BLOCKQUOTE><PRE>

END RegularFile.
</PRE> Like every <CODE>File.T</CODE>, a regular file handle <CODE>h</CODE> has the components
   <P>
<PRE>
      type(h)      <KBD>an atom, equal to </KBD>FileType<KBD></KBD>
      readable(h)  <KBD>a boolean</KBD>
      writable(h)  <KBD>a boolean</KBD>
</PRE>
   A regular file handle <CODE>h</CODE> also has the components
<P>
<PRE>
      cur(h)       <KBD>an integer, the index of the next byte to read or write</KBD>
      file(h)      <KBD>the identity of a regular file</KBD>
</PRE>
   There may be distinct regular file handles <CODE>h1</CODE> and <CODE>h2</CODE> with
   <CODE>file(h1)</CODE> equal to <CODE>file(h2)</CODE>, and more than one process may hold
   a single regular file handle (see <CODE>Process.Create</CODE>).
<P>
   A regular file (not a handle) <CODE>f</CODE> has the components
      <P>
<PRE>
      buffer(f)  <KBD>an extensible byte sequence</KBD>
      stable(f)  <KBD>an extensible byte sequence</KBD>
      mtime(f)   <KBD>a </KBD>Time.T<KBD>, the last modification time</KBD>
      locked(f)  <KBD>a </KBD>Process.ID<KBD></KBD>
</PRE>
   The sequences <CODE>buffer(f)</CODE> and <CODE>stable(f)</CODE> are zero-based and always
   have the same length.  <CODE>stable(f)</CODE> represents the contents of the
   file on the disk or other persistent storage medium, while
   <CODE>buffer(f)</CODE> represents write-behind caching performed by the
   operating system.  From time to time, a daemon performs
<P>
<PRE>
      WITH i = <KBD>some integer </KBD>i<KBD> in the range </KBD>[0..len(buffer(f))-1]<KBD></KBD> DO
        stable(f)[i] := buffer(f)[i]
      END
</PRE>
   The methods described in this interface are atomic with respect to
   the daemon.
<P>
   The meaning of the call
<P>
<PRE>
      h.read(b, mayBlock)
</PRE>
   is given by the specification of <CODE>File.T.read</CODE> together with
   these definitions, where <CODE>f = file(h)</CODE>:
<P>
<PRE>
      src(h)    = buffer(f)
      srcCur(h) = cur(h)
      srcEof(h) = TRUE
</PRE>
   Because <CODE>srcEof(h)</CODE> is always <CODE>TRUE</CODE>, <CODE>read</CODE> never blocks.
   However, a subsequent read can return more data if an interleaved
   write extends <CODE>buffer(f)</CODE>.  If <CODE>cur(h)</CODE> is negative (because of a
   prior seek), <CODE>read</CODE> raises <CODE>OSError.E</CODE>.
<P>
   The meaning of the call
<P>
<PRE>
      h.write(b)
</PRE>
   is given by the specification of <CODE>File.T.write</CODE> together with these
   definitions, where <CODE>f = file(h)</CODE>:
<P>
<PRE>
      snk(h)    = buffer(f)
      snkCur(h) = cur(h)
</PRE>
   In addition, <CODE>write</CODE> sets <CODE>mtime(file(h))</CODE> to the current time.  If
   <CODE>write</CODE> is called when <CODE>cur(h) &gt; size(f)</CODE> (because of a prior
   seek), it extends <CODE>f</CODE> with bytes of undefined value.  If <CODE>cur(h)</CODE>
   is negative, <CODE>write</CODE> raises <CODE>OSError.E</CODE>.
<P>
   The call
<P>
<PRE>
      h.status(stat)
</PRE>
   is equivalent to the following, in which <CODE>stat</CODE> is a local variable
   of type <CODE>Status</CODE>:
<P>
<PRE>
      stat.type := FileType;
      stat.modificationTime := mtime(file(h));
      stat.size := len(buffer(file(h)));
      RETURN stat
</PRE>
   The call
<P>
<PRE>
      h.seek(origin, offset)
</PRE>
   is equivalent to
   <P>
<PRE>
      CASE origin OF
        Origin.Beginning =&gt; cur(h) := offset
      | Origin.Current =&gt; cur(h) := cur(h)+offset
      | Origin.End =&gt; cur(h) := len(buffer(file(h)))+offset
      END;
      RETURN cur(h)
</PRE>
   Note that <CODE>seek</CODE> never changes the length of the file, although a
   subsequent write may do so.  Use the call <CODE>h.seek(Origin.Current,
   0)</CODE> to determine <CODE>cur(h)</CODE> without changing it.
<P>
   The call
<P>
<PRE>
      h.flush()
</PRE>
   is equivalent to
<P>
<PRE>
      WITH f = file(h) DO
        FOR i := 0 TO len(buffer(f))-1 DO
          stable(f)[i] := buffer(f)[i]
        END
      END
</PRE>
   The call
<P>
<PRE>
      h.close()
</PRE>
   extends the normal action of the <CODE>close</CODE> method with
<P>
<PRE>
      IF locked(file(h) = Process.GetMyID() THEN
        locked(file(h)) := Process.NullID
      END
   </PRE>
   The call
<P>
<PRE>
      h.lock()
</PRE>
   is equivalent to:
<P>
<PRE>
      IF locked(file(h)) = Process.NullID THEN
        locked(file(h)) := Process.GetMyID();
        RETURN TRUE
      END;
      RETURN FALSE
  </PRE>
   The call
<P>
<PRE>
      h.unlock()
</PRE>
is equivalent to:
<P>
<PRE>
      IF locked(file(h)) # Process.GetMyID() THEN
        RAISE OSError.E
      END;
      locked(file(h)) := Process.NullID
</PRE>
   Some implementations raise an exception if a process tries to read
   or write a file locked by another process.  You should treat this
   as a checked runtime error rather than writing code to catch and
   recover from the exception; the same applies to unlocking a file
   that you didn't lock.
<P>
   You lock a file with code like
<P>
<PRE>
      CONST
        MaxTry = 3;
        RetryInterval = 5.0D0;
      VAR try := 1;
      BEGIN
        WHILE NOT h.lock() DO
          IF try=MaxTry THEN <KBD>Give up</KBD> END;
          INC(try);
          Time.Pause(RetryInterval)
        END;
        TRY <KBD>Read or write </KBD>h<KBD></KBD> FINALLY h.unlock() END
      END
</PRE>
   The regular file underlying a regular file handle is monitored,
   thus allowing concurrent operations.  We leave unspecified the unit
   of atomicity for reads and writes, so a set of processes sharing a
   file that needs to be updated should use the <CODE>lock</CODE> and <CODE>unlock</CODE>
   methods.  A regular file handle itself should be treated as
   unmonitored.  A client thread typically needs to perform a <CODE>seek</CODE>
   followed by a <CODE>read</CODE> or <CODE>write</CODE> as an atomic unit, which can be
   implemented with a mutex in the client.
<P>
<P>


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
