<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/Common/Terminal.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/Common/Terminal.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>Terminal.T</CODE>, or terminal handle, is a file handle that provides
   access to a duplex communication channel usually connected to a
   user terminal.  

<P><PRE>INTERFACE <interface><A HREF="Terminal.m3">Terminal</A></interface>;

IMPORT <A HREF="File.i3">File</A>;

TYPE T &lt;: File.T;

VAR (*CONST*) FileType: File.Type;
</PRE><BLOCKQUOTE><EM> Equal to {\tt Atom.FromText("Terminal").} </EM></BLOCKQUOTE><PRE>

END Terminal.
</PRE> Like every <CODE>File.T</CODE>, a terminal handle <CODE>h</CODE> has the components
<P>
<PRE>
      type(h)      <KBD>an atom, equal to </KBD>FileType<KBD></KBD>
      readable(h)  <KBD>a boolean</KBD>
      writable(h)  <KBD>a boolean</KBD>
</PRE>
   A terminal handle is readable, or writable, or both (until it is
   closed).  If it is readable, it has the component
<P>
<PRE>
      srcTerm(h)   <KBD>a terminal device</KBD>
</PRE>
   If it is writable, it has the component
<P>
<PRE>
      snkTerm(h)   <KBD>a terminal device</KBD>
</PRE>
   A terminal device <CODE>t</CODE> has the components
<P>
<PRE>
      seq(t)   <KBD>a sequence of bytes</KBD>
      r(t)     <KBD>a non-negative integer, the index of the next byte to read</KBD>
      w(t)     <KBD>a non-negative integer, the index of the next byte to write</KBD>
      flag(t)  <KBD>a byte reserved to mark the end-of-file in </KBD>seq(t)<KBD></KBD>
</PRE>
   The meaning of the call
<P>
<PRE>
      h.read(b, mayBlock)
</PRE>
   is given by the specification of <CODE>File.T.read</CODE> together with these
   definitions, where <CODE>t = srcTerm(h)</CODE>, and <CODE>k</CODE> is the number of
   occurrences of <CODE>flag(t)</CODE> in <CODE>seq(t)</CODE> up to <CODE>r(t)-1</CODE>:
<P>
<PRE>
      src(h)    = <KBD>subsequence of </KBD>seq(t)<KBD> with all occurrences of </KBD>flag(t)<KBD></KBD>
                  <KBD>deleted</KBD>
      srcCur(h) = r(t)-k
      srcEof(h) = (seq(t)[r(t)] = flag(t))
</PRE>
   When end-of-file is reported, <CODE>r(t)</CODE> is also incremented.  This
   means subsequent reads can return further data in <CODE>seq(t)</CODE>.
<P>
   The meaning of the call
<P>
<PRE>
      h.write(b)
</PRE>
   is given by the specification of <CODE>File.T.write</CODE> together with these
   definitions, where <CODE>t = snkTerm(h)</CODE>:
<P>
<PRE>
      snk(h)    = seq(t)
      snkCur(h) = w(t)
</PRE>
   A specific implementation may provide one or more subtypes of
   <CODE>Terminal.T</CODE> with additional methods.
<P>
   The communication channel underlying a terminal handle is
   necessarily monitored, since the purpose of the channel is to allow
   asynchronous communication between a program and a user operating a
   terminal device.  However a terminal handle itself should be
   treated as unmonitored, thus avoiding the question of the unit of
   atomicity for reads and writes.
<P>


<P>
<P>
<P>
<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
