<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/POSIX/FilePosix.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/POSIX/FilePosix.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="FilePosix.i3">FilePosix</A></implements></module>;

IMPORT <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../Common/File.i3">File</A>, <A HREF="../Common/FS.i3">FS</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../Common/OSError.i3">OSError</A>, <A HREF="OSErrorPosix.i3">OSErrorPosix</A>, <A HREF="../Common/Pipe.i3">Pipe</A>,
  <A HREF="../Common/RegularFile.i3">RegularFile</A>, <A HREF="../../../thread/src/POSIX/SchedulerPosix.i3">SchedulerPosix</A>, <A HREF="../Common/Terminal.i3">Terminal</A>, <A HREF="#x1">Uerror</A>, <A HREF="#x2">Unix</A>, <A HREF="#x3">Ustat</A>, <A HREF="#x4">Uuio</A>,
  <A HREF="../../../word/src/Word.i3">Word</A>;

REVEAL
  File.<A NAME="T">T</A> = T BRANDED OBJECT OVERRIDES
    close := FileClose;
    status := FileStatus
  END;

TYPE IntermittentFile = File.T BRANDED OBJECT OVERRIDES
    read := IntermittentRead;
    write := IntermittentWrite
  END;

REVEAL
  Pipe.<A NAME="T">T</A> = IntermittentFile BRANDED OBJECT END;
  Terminal.<A NAME="T">T</A> = IntermittentFile BRANDED OBJECT END;
  RegularFile.<A NAME="T">T</A> = RegularFile.Public BRANDED OBJECT OVERRIDES
    read := RegularFileRead;
    write := RegularFileWrite;
    seek := RegularFileSeek;
    flush := RegularFileFlush;
    lock := RegularFileLock;
    unlock := RegularFileUnlock
  END;

PROCEDURE <A NAME="FileTypeFromStatbuf"><procedure>FileTypeFromStatbuf</procedure></A>(READONLY statbuf: Ustat.struct_stat)
  : File.Type =
  BEGIN
    CASE Word.And(statbuf.st_mode, Ustat.S_IFMT) OF
    | Ustat.S_IFCHR =&gt;
        IF IsDevNull(statbuf)
          THEN RETURN RegularFile.FileType
          ELSE RETURN Terminal.FileType
        END
    | Ustat.S_IFPIPE, Ustat.S_IFPORT, Ustat.S_IFSOCK =&gt;
        RETURN Pipe.FileType
    | Ustat.S_IFREG =&gt;
        RETURN RegularFile.FileType
    | Ustat.S_IFDIR =&gt;
        RETURN FS.DirectoryFileType
    ELSE
        RETURN RegularFile.FileType
    END
  END FileTypeFromStatbuf;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(fd: INTEGER; ds: DirectionSet): File.T RAISES {OSError.E} =
  VAR statbuf: Ustat.struct_stat; type: File.Type;
  BEGIN
    IF Ustat.fstat(fd, ADR(statbuf)) # 0 THEN OSErrorPosix.Raise() END;
    type := FileTypeFromStatbuf(statbuf);
    IF type = RegularFile.FileType THEN
      RETURN NEW(RegularFile.T, fd := fd, ds := ds)
    END;
    IF type = Terminal.FileType THEN
      RETURN NEW(Terminal.T, fd := fd, ds := ds)
    END;
    IF type = Pipe.FileType THEN
      RETURN NEW(Pipe.T, fd := fd, ds := ds)
    END;
    IF type = FS.DirectoryFileType THEN
      OSErrorPosix.Raise0(Uerror.EISDIR)
    END;
    (* Other... *)
    RETURN NEW(RegularFile.T, fd := fd, ds := ds)
  END New;

PROCEDURE <A NAME="NewPipe"><procedure>NewPipe</procedure></A>(fd: INTEGER; ds: DirectionSet): Pipe.T =
  BEGIN
    RETURN NEW(Pipe.T, fd := fd, ds := ds)
  END NewPipe;
</PRE>---------------------------File methods------------------------------------

<P><PRE>PROCEDURE <A NAME="FileClose"><procedure>FileClose</procedure></A>(h: File.T) RAISES {OSError.E} =
  BEGIN
    IF Unix.close(h.fd) &lt; 0 THEN OSErrorPosix.Raise() END
  END FileClose;

PROCEDURE <A NAME="FileStatus"><procedure>FileStatus</procedure></A>(h: File.T): File.Status RAISES {OSError.E} =
  VAR statBuf: Ustat.struct_stat;
    status: File.Status;
  BEGIN
    IF Ustat.fstat(h.fd, ADR(statBuf)) &lt; 0 THEN OSErrorPosix.Raise() END;
    TYPECASE h OF
    | RegularFile.T =&gt; status.type := RegularFile.FileType
    | Pipe.T =&gt; status.type := Pipe.FileType
    | Terminal.T =&gt; status.type := Terminal.FileType
    ELSE &lt;* ASSERT FALSE *&gt;
    END;
    status.modificationTime := FLOAT(statBuf.st_mtime, LONGREAL);
    status.size := statBuf.st_size;
    RETURN status
  END FileStatus;
</PRE>---------------------------RegularFile methods-----------------------------

<P><PRE>PROCEDURE <A NAME="RegularFileRead"><procedure>RegularFileRead</procedure></A>(
    h: RegularFile.T;
    VAR (*OUT*) b: ARRAY OF File.Byte;
    &lt;*UNUSED*&gt; mayBlock: BOOLEAN := TRUE)
  : INTEGER RAISES {OSError.E} =
  VAR p_b: ADDRESS := ADR(b[0]);
  BEGIN
    IF NOT(Direction.Read IN h.ds) THEN BadDirection(); END;
    WITH bytesRead = Uuio.read(h.fd, p_b, NUMBER(b)) DO
      IF bytesRead &lt; 0 THEN OSErrorPosix.Raise() END;
      RETURN bytesRead
    END
  END RegularFileRead;

PROCEDURE <A NAME="RegularFileWrite"><procedure>RegularFileWrite</procedure></A>(
    h: RegularFile.T;
    READONLY b: ARRAY OF File.Byte)
  RAISES {OSError.E} =
  VAR p_b: ADDRESS := ADR (b[0]);
  BEGIN
    IF NOT(Direction.Write IN h.ds) THEN BadDirection(); END;
    WITH bytesWritten = Uuio.write(h.fd, p_b, NUMBER(b)) DO
      IF bytesWritten &lt; 0 THEN OSErrorPosix.Raise() END;
      &lt;* ASSERT bytesWritten = NUMBER(b) *&gt;
    END
  END RegularFileWrite;

PROCEDURE <A NAME="RegularFileSeek"><procedure>RegularFileSeek</procedure></A>(
    h: RegularFile.T; origin: RegularFile.Origin; offset: INTEGER)
  : INTEGER RAISES {OSError.E} =
  BEGIN
    WITH result = Unix.lseek(h.fd, offset, ORD(origin)) DO
      IF result &lt; 0 THEN OSErrorPosix.Raise() END;
      RETURN result
    END
  END RegularFileSeek;

PROCEDURE <A NAME="RegularFileFlush"><procedure>RegularFileFlush</procedure></A>(h: RegularFile.T) RAISES {OSError.E} =
  BEGIN
    IF Unix.fsync(h.fd) &lt; 0 THEN OSErrorPosix.Raise() END
  END RegularFileFlush;

PROCEDURE <A NAME="RegularFileLock"><procedure>RegularFileLock</procedure></A>(h: RegularFile.T): BOOLEAN RAISES {OSError.E} =
  (* The following initialization is a bit sleazy.  It doesn't
     initialize all the fields.  We depend on each Unix.i3 giving
     a static initialization for any other fields.
     (e.g. freebsd-2/Unix.i3) *)
  VAR flock := Unix.struct_flock {
    l_type := Unix.F_WRLCK,
    l_whence := Unix.L_SET,
    l_start := 0,
    l_len := 0, (* i.e., whole file *)
    l_pid := 0}; (* don't care *)
  BEGIN
    IF Unix.fcntl(h.fd, Unix.F_SETLK, LOOPHOLE(ADR(flock), Ctypes.long)) &lt; 0
    THEN
      IF Uerror.errno = Uerror.EACCES THEN RETURN FALSE END;
      OSErrorPosix.Raise()
    END;
    RETURN TRUE
  END RegularFileLock;

PROCEDURE <A NAME="RegularFileUnlock"><procedure>RegularFileUnlock</procedure></A>(h: RegularFile.T) RAISES {OSError.E} =
  (* The following initialization is a bit sleazy.  It doesn't
     initialize all the fields.  We depend on each Unix.i3 giving
     a static initialization for any other fields.
     (e.g. freebsd-2/Unix.i3) *)
  VAR flock := Unix.struct_flock {
    l_type := Unix.F_UNLCK,
    l_whence := Unix.L_SET,
    l_start := 0,
    l_len := 0, (* i.e., whole file *)
    l_pid := 0}; (* don't care *)
  BEGIN
    IF Unix.fcntl(h.fd, Unix.F_SETLK, LOOPHOLE(ADR(flock), Ctypes.long)) &lt; 0
    THEN
      OSErrorPosix.Raise()
    END
  END RegularFileUnlock;
</PRE>---------------------IntermittentFile methods------------------------------

<P><PRE>PROCEDURE <A NAME="IntermittentRead"><procedure>IntermittentRead</procedure></A>(
    h: IntermittentFile;
    VAR (*OUT*) b: ARRAY OF File.Byte;
    mayBlock := TRUE)
  : INTEGER RAISES {OSError.E} =
  VAR
    status, errno: INTEGER;
    old_mode := Unix.fcntl(h.fd, Unix.F_GETFL, 0);
    new_mode := Word.Or(old_mode, Unix.M3_NONBLOCK);
    p_b: ADDRESS := ADR (b[0]);
  BEGIN
    IF NOT(Direction.Read IN h.ds) THEN BadDirection(); END;

    LOOP
      (* Make the read call non-blocking; we cannot set/reset the mode
         at creation/close time, because this may leave the file in an
         unexpected state in the case of a core dump elsewhere. *)

      IF Unix.fcntl(h.fd, Unix.F_SETFL, new_mode) # 0 THEN
	OSErrorPosix.Raise()
      END;

      status := Uuio.read(h.fd, p_b, NUMBER(b));
      errno := Uerror.errno;

      IF Unix.fcntl(h.fd, Unix.F_SETFL, old_mode) # 0 THEN
	OSErrorPosix.Raise()
      END;

      IF status &gt;= 0 THEN
        RETURN status
      ELSIF status = -1
         AND errno # Uerror.EWOULDBLOCK
         AND errno # Uerror.EAGAIN THEN
        OSErrorPosix.Raise()
      ELSIF NOT mayBlock THEN
        RETURN -1
      END;

      EVAL SchedulerPosix.IOWait(h.fd, TRUE)
    END
  END IntermittentRead;

PROCEDURE <A NAME="IntermittentWrite"><procedure>IntermittentWrite</procedure></A>(h: File.T; READONLY b: ARRAY OF File.Byte)
  RAISES {OSError.E} =
  VAR
    status, errno: INTEGER;
    old_mode := Unix.fcntl(h.fd, Unix.F_GETFL, 0);
    new_mode := Word.Or(old_mode, Unix.M3_NONBLOCK);
    p := LOOPHOLE (ADR(b[0]), Ctypes.char_star);
    n: Ctypes.int := NUMBER(b);
  BEGIN
    IF NOT(Direction.Write IN h.ds) THEN BadDirection (); END;

    LOOP
      (* Make the write call non-blocking; we cannot set/reset the mode
         at creation/close time, because this may leave the file in an
         unexpected state in the case of a core dump elsewhere. *)

      IF Unix.fcntl(h.fd, Unix.F_SETFL, new_mode) # 0 THEN
	OSErrorPosix.Raise()
      END;

      status := Uuio.write(h.fd, p, n);
      errno := Uerror.errno;

      IF Unix.fcntl(h.fd, Unix.F_SETFL, old_mode) # 0 THEN
	OSErrorPosix.Raise()
      END;

      IF status &gt;= 0 THEN
        p := LOOPHOLE(LOOPHOLE(p, INTEGER) + status, Ctypes.char_star);
        n := n - status;
        IF n = 0 THEN EXIT END
      ELSIF status = -1
         AND errno # Uerror.EWOULDBLOCK
         AND errno # Uerror.EAGAIN THEN
        OSErrorPosix.Raise()
      END;

      EVAL SchedulerPosix.IOWait(h.fd, FALSE)
    END
  END IntermittentWrite;
</PRE>-------------------------Support procedures--------------------------------

<P><PRE>VAR
  null_done := FALSE;
  null_stat: Ustat.struct_stat;
  null_fd: INTEGER;

PROCEDURE <A NAME="IsDevNull"><procedure>IsDevNull</procedure></A>(READONLY statbuf: Ustat.struct_stat): BOOLEAN RAISES {} =
  VAR result: INTEGER;
  BEGIN
    IF NOT null_done THEN
      null_done := TRUE;
      null_fd := Unix.open(
        M3toC.TtoS(&quot;/dev/null&quot;), Unix.O_RDONLY, Unix.Mrwrwrw);
      IF null_fd &lt; 0 THEN RETURN FALSE END;
      result := Ustat.fstat(null_fd, ADR(null_stat));
      EVAL Unix.close(null_fd);
      IF result # 0 THEN null_fd := -1 END
    END;
    RETURN null_fd &gt;= 0 AND statbuf.st_rdev = null_stat.st_rdev
  END IsDevNull;

EXCEPTION IllegalDirection;

PROCEDURE <A NAME="BadDirection"><procedure>BadDirection</procedure></A> () =
  &lt;*FATAL IllegalDirection*&gt;
  BEGIN
    RAISE IllegalDirection;
  END BadDirection;

BEGIN
END FilePosix.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Uerror is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uerror.i3#0TOP0">unix/src/aix-3-2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uerror.i3#0TOP0">unix/src/aix-ps2-1-2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uerror.i3#0TOP0">unix/src/freebsd-1/Uerror.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uerror.i3#0TOP0">unix/src/freebsd-2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uerror.i3#0TOP0">unix/src/hpux-7-0/Uerror.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uerror.i3#0TOP0">unix/src/ibm-4-3/Uerror.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uerror.i3#0TOP0">unix/src/irix-5.2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/linux/Uerror.i3#0TOP0">unix/src/linux/Uerror.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uerror.i3#0TOP0">unix/src/osf-1.generic/Uerror.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uerror.i3#0TOP0">unix/src/solaris-2-x/Uerror.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uerror.i3#0TOP0">unix/src/sunos-4-x/Uerror.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uerror.i3#0TOP0">unix/src/sysv-4.0/Uerror.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uerror.i3#0TOP0">unix/src/ultrix-3-1.generic/Uerror.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unix.i3#0TOP0">unix/src/freebsd-1/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unix.i3#0TOP0">unix/src/freebsd-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unix.i3#0TOP0">unix/src/irix-5.2/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Ustat is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Ustat.i3#0TOP0">unix/src/aix-3-2/Ustat.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Ustat.i3#0TOP0">unix/src/aix-ps2-1-2/Ustat.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Ustat.i3#0TOP0">unix/src/freebsd-1/Ustat.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Ustat.i3#0TOP0">unix/src/freebsd-2/Ustat.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Ustat.i3#0TOP0">unix/src/hpux-7-0/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Ustat.i3#0TOP0">unix/src/ibm-4-3/Ustat.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Ustat.i3#0TOP0">unix/src/irix-5.2/Ustat.i3</A>
<LI><A HREF="../../../unix/src/linux/Ustat.i3#0TOP0">unix/src/linux/Ustat.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Ustat.i3#0TOP0">unix/src/osf-1.generic/Ustat.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Ustat.i3#0TOP0">unix/src/solaris-2-x/Ustat.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Ustat.i3#0TOP0">unix/src/sunos-4-x/Ustat.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Ustat.i3#0TOP0">unix/src/sysv-4.0/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Ustat.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Ustat.i3#0TOP0">unix/src/ultrix-3-1.ARM/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Ustat.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Ustat.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Ustat.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Ustat.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Ustat.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Ustat.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Ustat.i3#0TOP0">unix/src/ultrix-3-1.VAX/Ustat.i3</A>
</UL>
<P>
<HR>
<A NAME="x4">interface Uuio is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uuio.i3#0TOP0">unix/src/aix-3-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uuio.i3#0TOP0">unix/src/aix-ps2-1-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uuio.i3#0TOP0">unix/src/freebsd-1/Uuio.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uuio.i3#0TOP0">unix/src/freebsd-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uuio.i3#0TOP0">unix/src/hpux-7-0/Uuio.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uuio.i3#0TOP0">unix/src/ibm-4-3/Uuio.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uuio.i3#0TOP0">unix/src/irix-5.2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/linux/Uuio.i3#0TOP0">unix/src/linux/Uuio.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uuio.i3#0TOP0">unix/src/osf-1.generic/Uuio.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uuio.i3#0TOP0">unix/src/solaris-2-x/Uuio.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uuio.i3#0TOP0">unix/src/sunos-4-x/Uuio.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uuio.i3#0TOP0">unix/src/sysv-4.0/Uuio.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uuio.i3#0TOP0">unix/src/ultrix-3-1.generic/Uuio.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
