<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/POSIX/PathnamePosix.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/POSIX/PathnamePosix.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>PathnamePosix</module> EXPORTS <A HREF="../Common/Pathname.i3"><implements>Pathname</A></implements>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;

CONST
  DirSepChar = '/'; ExtSepChar = '.';
  DirSepText = &quot;/&quot;; ExtSepText = &quot;.&quot;;

CONST Legal = SET OF CHAR {'\001' .. '\177'} - SET OF CHAR {DirSepChar};

PROCEDURE <A NAME="Valid"><procedure>Valid</procedure></A>(pn: T): BOOLEAN =
  PROCEDURE Ignore(&lt;* UNUSED *&gt; start, end: CARDINAL) = BEGIN END Ignore;
  BEGIN
    TRY EVAL ParsePosixPathname(pn, visit := Ignore)
    EXCEPT Invalid =&gt; RETURN FALSE
    END;
    RETURN TRUE
  END Valid;

TYPE Visit = PROCEDURE(start, end: CARDINAL);

PROCEDURE <A NAME="Decompose"><procedure>Decompose</procedure></A>(pn: T): Arcs RAISES {Invalid} =
  VAR
    arcs := NEW(Arcs).init();
    absolute := ParsePosixPathname(pn, visit := Add);
  PROCEDURE Add(start, end: CARDINAL) =
    BEGIN arcs.addhi(Text.Sub(pn, start, end - start)) END Add;
  BEGIN
    IF absolute THEN arcs.addlo(&quot;/&quot;)
    ELSE arcs.addlo(NIL)
    END;
    RETURN arcs
  END Decompose;

PROCEDURE <A NAME="Compose"><procedure>Compose</procedure></A>(a: Arcs): T RAISES {Invalid}=
  VAR n := a.size(); t: TEXT;
  BEGIN
    IF n = 0 THEN RAISE Invalid END;
    t := a.getlo();
    IF t # NIL THEN IF NOT Text.Equal(t, &quot;/&quot;) THEN RAISE Invalid END
    ELSE t := &quot;&quot;
    END;
    FOR i := 1 TO n-1 DO
      WITH arc = a.get(i) DO
	IF arc = NIL THEN RAISE Invalid END;
	FOR i := 0 TO Text.Length(arc) - 1 DO
	  IF NOT Text.GetChar(arc, i) IN Legal THEN RAISE Invalid END
	END;
	t := t &amp; arc
      END;
      IF i # n-1 THEN t := t &amp; DirSepText END
    END;
    RETURN t
  END Compose;

PROCEDURE <A NAME="Absolute"><procedure>Absolute</procedure></A>(pn: T): BOOLEAN =
  BEGIN
    RETURN Text.Length(pn) &gt; 0 AND Text.GetChar(pn, 0) = DirSepChar
  END Absolute;

PROCEDURE <A NAME="Prefix"><procedure>Prefix</procedure></A>(pn: T): T =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    IF baseLwb = 0 THEN RETURN &quot;&quot; END;
    IF baseLwb = 1 THEN RETURN &quot;/&quot; END;
    RETURN Text.Sub(pn, 0, baseLwb - 1)
  END Prefix;

PROCEDURE <A NAME="Last"><procedure>Last</procedure></A>(pn: T): T =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    RETURN Text.Sub(pn, baseLwb, extUpb - baseLwb)
  END Last;

PROCEDURE <A NAME="Base"><procedure>Base</procedure></A>(pn: T): T =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    IF baseUpb + 1 = extUpb THEN RETURN pn END;
    RETURN Text.Sub(pn, 0, baseUpb)
  END Base;

EXCEPTION CheckedRuntimeError; &lt;* FATAL CheckedRuntimeError *&gt;

PROCEDURE <A NAME="Join"><procedure>Join</procedure></A>(pn, base: T; ext: TEXT): T =
  VAR t: TEXT := base; l: CARDINAL;
  BEGIN
    IF pn # NIL THEN
      IF Absolute(base) THEN RAISE CheckedRuntimeError END;
      l := Text.Length(pn);
      IF l # 0 THEN
        IF Text.GetChar(pn, l - 1) # DirSepChar THEN
          pn := pn &amp; DirSepText
        END;
        t := pn &amp; t
      END
    END;
    IF ext # NIL THEN t := t &amp; ExtSepText &amp; ext END;
    RETURN t
  END Join;

PROCEDURE <A NAME="LastBase"><procedure>LastBase</procedure></A>(pn: T): T =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    IF baseUpb + 1 = extUpb THEN
      RETURN Text.Sub(pn, baseLwb, extUpb - baseLwb)
    END;
    RETURN Text.Sub(pn, baseLwb, baseUpb - baseLwb)
  END LastBase;

PROCEDURE <A NAME="LastExt"><procedure>LastExt</procedure></A>(pn: T): TEXT =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    IF extUpb # baseUpb THEN
      RETURN Text.Sub(pn, baseUpb + 1, extUpb - (baseUpb + 1))
    ELSE
      RETURN &quot;&quot;
    END
  END LastExt;

PROCEDURE <A NAME="ReplaceExt"><procedure>ReplaceExt</procedure></A>(pn: T; ext: TEXT): T =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    IF baseUpb = extUpb THEN RETURN pn END; (* nothing to replace *)
    RETURN Text.Sub(pn, 0, baseUpb) &amp; ExtSepText &amp; ext
  END ReplaceExt;
</PRE> Internal procedures. 

<P><PRE>PROCEDURE <A NAME="ParsePosixPathname"><procedure>ParsePosixPathname</procedure></A>(pn: T; visit: Visit): BOOLEAN RAISES {Invalid} =
  (* Call &quot;visit(s, e)&quot; for each arc name starting at character &quot;e&quot; within
     &quot;pn&quot; of length &quot;e-s&quot; characters; return &quot;TRUE&quot; iff &quot;pn&quot; is absolute. *)
  VAR
    absolute: BOOLEAN;
    s, e: CARDINAL; (* bounds of next arc to visit *)
  BEGIN
    WITH n = Text.Length(pn) DO
      IF n # 0 AND Text.GetChar(pn, 0) = DirSepChar THEN
        absolute := TRUE; s := 1
      ELSE
        absolute := FALSE; s := 0
      END;
      e := s;
      WHILE e &lt; n DO
        WITH c = Text.GetChar(pn, e) DO
          IF c = DirSepChar THEN
            visit(s, e);
            s := e + 1
          ELSIF NOT c IN Legal THEN
            RAISE Invalid
          END
        END;
        INC(e)
      END;
      (* We map &quot;/&quot; to [&quot;/&quot;] rather than [&quot;/&quot;, &quot;&quot;]. *)
      IF absolute AND n = 1 THEN (*SKIP*) ELSE visit(s, e) END;
      RETURN absolute
    END
  END ParsePosixPathname;

PROCEDURE <A NAME="NameSections"><procedure>NameSections</procedure></A>(
    pn: T;
    VAR baseLwb, baseUpb, extUpb: CARDINAL)
  RAISES {} =
</PRE><BLOCKQUOTE><EM> Perform the following assignments:
  baseLwb := the index of the first character of the last component of pn;
  baseUpb := the index of the character separating the extension and base
             of the last component of pn, or Length(pn) if there is no
             extension;
  extUpb  := Length(pn) </EM></BLOCKQUOTE><PRE>
  VAR pos: CARDINAL; ch: CHAR; extSepSeen := FALSE;
  BEGIN
    extUpb := Text.Length(pn);
    pos := extUpb;
    baseUpb := extUpb;
    LOOP
      IF pos &gt; 0 THEN
        DEC(pos);
        ch := Text.GetChar(pn, pos);
        IF ch = DirSepChar THEN
          baseLwb := pos + 1;
          EXIT
        ELSIF ch = ExtSepChar THEN
          IF NOT extSepSeen THEN
            baseUpb := pos; extSepSeen := TRUE
          END
        END
      ELSE
        baseLwb := 0;
        EXIT
      END
    END
  END NameSections;

BEGIN
  Parent := &quot;..&quot;;
  Current := &quot;.&quot;
END PathnamePosix.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
