<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/POSIX/ProcessPosix.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/POSIX/ProcessPosix.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module>ProcessPosix</module> EXPORTS <A HREF="../Common/Process.i3"><implements>Process</A></implements>;

IMPORT <A HREF="../../../atom/src/Atom.i3">Atom</A>, <A HREF="../../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../../params/src/Env.i3">Env</A>, <A HREF="../Common/File.i3">File</A>, <A HREF="FilePosix.i3">FilePosix</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../Common/OSError.i3">OSError</A>,
  <A HREF="OSErrorPosix.i3">OSErrorPosix</A>, <A HREF="../Common/Pathname.i3">Pathname</A>, <A HREF="../../../runtime/src/common/RTLinker.i3">RTLinker</A>, <A HREF="../../../runtime/src/common/RTProcess.i3">RTProcess</A>, <A HREF="../../../runtime/src/common/RTSignal.i3">RTSignal</A>,
  <A HREF="../../../thread/src/POSIX/SchedulerPosix.i3">SchedulerPosix</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="#x1">Unix</A>, <A HREF="#x2">Uerror</A>, <A HREF="#x3">Uexec</A>, <A HREF="#x4">Uprocess</A>, <A HREF="#x5">Ustat</A>,
  <A HREF="#x6">Utime</A>, <A HREF="#x7">Uugid</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

REVEAL <A NAME="T">T</A> = BRANDED REF RECORD
    pid: INTEGER;
    waitOk := TRUE
  END;

PROCEDURE <A NAME="Create"><procedure>Create</procedure></A>(
    cmd: Pathname.T;
    READONLY params: ARRAY OF TEXT;
    env: REF ARRAY OF TEXT := NIL;
    wd: Pathname.T := NIL;
    stdin, stdout, stderr: File.T := NIL)
  : T RAISES {OSError.E} =
  VAR
    argx: ArrCStr;
    envx: ArrCStr;
    envp: Ctypes.char_star_star;
    wdstr: Ctypes.char_star;
    oit, nit: Utime.struct_itimerval;
    forkResult, execResult: INTEGER;
    forkErrno, execErrno: Ctypes.int;
    waitStatus: Uexec.w_A;
  BEGIN
    WITH path = GetPathToExec(cmd) DO
      argx := AllocArgs(path, Pathname.Base(cmd), params)
    END;
    IF env # NIL THEN
      envx := AllocEnv(env^);
      envp := ADR(envx[0])
    ELSE
      envx := NIL;
      envp := LOOPHOLE(RTLinker.info.envp, Ctypes.char_star_star)
    END;
    IF wd # NIL AND NOT Text.Empty(wd) THEN
      wdstr := M3toC.TtoS(wd)
    ELSE
     wdstr := NIL
    END;

    (* Turn off the interval timer (so it won't be running in child). *)
    nit := Utime.struct_itimerval {
             it_interval := Utime.struct_timeval {0, 0},
             it_value    := Utime.struct_timeval {0, 0}};
    IF Utime.setitimer(Utime.ITIMER_VIRTUAL, nit, oit) &lt; 0 THEN
      &lt;* ASSERT FALSE *&gt;
    END;

    (* Disable the scheduler. *)
    SchedulerPosix.DisableSwitching ();

    execResult := 0;
    forkResult := Unix.vfork();
    IF forkResult = 0 THEN (* in the child *)
      ExecChild(argx, envp, wdstr, stdin, stdout, stderr);
     (* If ExecChild returns, the execve.  Let's leave try to a note
        for our parent, in case we're still sharing their address
        space. *)
      execResult := -1;
      execErrno := Uerror.errno;
      Unix.underscore_exit(99)
    END;

    (* Back in parent. *)

    forkErrno := Uerror.errno;

    (* Enable scheduler. *)
    SchedulerPosix.EnableSwitching ();

    (* Restore previous virtual timer. *)
    IF Utime.setitimer(Utime.ITIMER_VIRTUAL, oit, nit) &lt; 0 THEN
      &lt;* ASSERT FALSE *&gt;
    END;

    FreeArgs(argx);
    IF envx # NIL THEN FreeEnv(envx) END;

    IF forkResult &lt; 0 THEN OSErrorPosix.Raise0(forkErrno) END;

    (* The vfork succeeded.  Did the execve succeed? *)
    IF execResult &lt; 0 THEN
      (* No, clean up child process. *)
      EVAL Uexec.waitpid(forkResult, ADR(waitStatus), 0);
      OSErrorPosix.Raise0(execErrno)
    END;

    RETURN NEW(T, pid := forkResult)
  END Create;

TYPE ArrCStr = UNTRACED REF ARRAY OF Ctypes.char_star;

PROCEDURE <A NAME="GetPathToExec"><procedure>GetPathToExec</procedure></A>(pn: Pathname.T): Pathname.T RAISES {OSError.E} =
</PRE><BLOCKQUOTE><EM> Return the filename to execute given <CODE>base</CODE> and the value of the <CODE>PATH</CODE>
   environment variable. Based on Mike Burrows's preexec(). </EM></BLOCKQUOTE><PRE>
  VAR
    path, prog: TEXT;
    start, i, end, result, uid, gid: INTEGER;
    statBuf: Ustat.struct_stat;
  CONST MaskXXX = Ustat.S_IEXEC + Ustat.S_GEXEC + Ustat.S_OEXEC;
  BEGIN
    IF Text.FindChar(pn, '/') &lt; 0 THEN
      path := Env.Get(&quot;PATH&quot;);
      IF path = NIL THEN path := &quot;:/bin:/usr/bin&quot; END;
      uid := -1; gid := -1;
      start := 0;
      LOOP
        i := Text.FindChar(path, ':', start);
        IF i &lt; 0 THEN end := Text.Length(path) ELSE end := i END;
        prog := Pathname.Join(
          Text.Sub(path, start, end - start),
          pn,
          NIL);
        result := Ustat.stat(M3toC.TtoS(prog), ADR(statBuf));
        IF result = 0 THEN
          statBuf.st_mode := Word.And(statBuf.st_mode, MaskXXX);
          IF statBuf.st_mode # 0 THEN
            IF statBuf.st_mode = MaskXXX THEN RETURN prog END;
            IF uid &lt; 0 THEN uid := Uugid.geteuid() END;
            IF uid = statBuf.st_uid THEN
	      statBuf.st_mode := Word.And(statBuf.st_mode, Ustat.S_IEXEC)
            ELSE
              IF gid &lt; 0 THEN gid := Uugid.getegid() END;
              IF gid = statBuf.st_gid THEN
                statBuf.st_mode := Word.And(statBuf.st_mode, Ustat.S_GEXEC)
              ELSE
        	statBuf.st_mode := Word.And(statBuf.st_mode, Ustat.S_OEXEC)
              END
            END;
            IF statBuf.st_mode # 0 THEN RETURN prog END
          END;
	END;
	IF i &lt; 0 THEN EXIT END;
	start := i + 1
      END;
      OSErrorPosix.Raise0(Uerror.ENOENT)
    ELSE (* pn contains '/' *)
      IF Ustat.stat(M3toC.TtoS(pn), ADR(statBuf)) &lt; 0 THEN
        OSErrorPosix.Raise()
      END
    END;
    RETURN pn
  END GetPathToExec;

PROCEDURE <A NAME="AllocArgs"><procedure>AllocArgs</procedure></A>(path, base: TEXT; READONLY args: ARRAY OF TEXT): ArrCStr =
</PRE><BLOCKQUOTE><EM> Return an array of pointers, say <CODE>a</CODE>, with:
<PRE>
         a[0] = path
         a[1] = &quot;sh&quot;
         a[2] = base
         a[3+i] = args[i] for i = 0,...,LAST(args)
         a[n] = NIL for n = NUMBER(args) + 3
</EM></BLOCKQUOTE><PRE>
  VAR argx := NEW(ArrCStr, NUMBER(args) + 4);
  BEGIN
    argx[0] := M3toC.CopyTtoS(path);
    argx[1] := Sh;
    argx[2] := M3toC.CopyTtoS(base);
    FOR i := 0 TO LAST(args) DO argx[3 + i] := M3toC.CopyTtoS(args[i]) END;
    argx[LAST(argx^)] := NIL;
    RETURN argx
  END AllocArgs;

PROCEDURE <A NAME="FreeArgs"><procedure>FreeArgs</procedure></A>(VAR argx: ArrCStr) =
</PRE><BLOCKQUOTE><EM> Free all elements except <CODE>argx[1]</CODE>, which equals <CODE>Sh</CODE>.  Note that
   <CODE>ExecChild</CODE> may swap <CODE>argx[0]</CODE> and <CODE>argx[2]</CODE>. </EM></BLOCKQUOTE><PRE>
  BEGIN
    FOR i := 0 TO LAST(argx^) - 1 DO
      IF i # 1 THEN M3toC.FreeCopiedS(argx[i]) END
    END;
    &lt;* ASSERT argx[LAST(argx^)] = NIL *&gt;
    DISPOSE(argx)
  END FreeArgs;

PROCEDURE <A NAME="AllocEnv"><procedure>AllocEnv</procedure></A>(READONLY env: ARRAY OF TEXT): ArrCStr =
  VAR envx := NEW(ArrCStr, NUMBER(env) + 1);
  BEGIN
    FOR i := 0 TO LAST(env) DO envx[i] := M3toC.CopyTtoS(env[i]) END;
    envx[LAST(envx^)] := NIL;
    RETURN envx
  END AllocEnv;

PROCEDURE <A NAME="FreeEnv"><procedure>FreeEnv</procedure></A>(VAR envx: ArrCStr) =
  BEGIN
    FOR i := 0 TO LAST(envx^) - 1 DO
      M3toC.FreeCopiedS(envx[i])
    END;
    &lt;* ASSERT envx[LAST(envx^)] = NIL *&gt;
    DISPOSE(envx)
  END FreeEnv;

VAR (*CONST*)
  BinSh := M3toC.TtoS(&quot;/bin/sh&quot;);
  Sh := M3toC.TtoS(&quot;sh&quot;);

PROCEDURE <A NAME="ExecChild"><procedure>ExecChild</procedure></A>(
    argx: ArrCStr; (* see &quot;AllocArgs&quot; for layout *)
    envp: Ctypes.char_star_star;
    wdstr: Ctypes.char_star;
    stdin, stdout, stderr: File.T)
  RAISES {} =
</PRE><BLOCKQUOTE><EM> Modify Unix state using <CODE>stdin</CODE>, ..., and invoke execve using
   <CODE>argx</CODE> and <CODE>envp</CODE>.  Do not invoke scheduler, allocator, or
   exceptions.  Return only if a fatal Unix error is encountered, in
   which case Uerror.errno is set. </EM></BLOCKQUOTE><PRE>
  PROCEDURE SetFd(fd: INTEGER; h: File.T): BOOLEAN =
  (* Make file descriptor &quot;fd&quot; refer to file &quot;h&quot;, or set &quot;fd&quot;'s
     close-on-exec flag if &quot;h=NIL&quot;.  Return &quot;TRUE&quot; if succesful. *)
    BEGIN
      IF h # NIL THEN RETURN NOT Unix.dup2(h.fd, fd) &lt; 0 END;
      RETURN NOT Unix.fcntl(fd, Unix.F_SETFD, 1) &lt; 0
    END SetFd;
  VAR res := 0; t: Ctypes.char_star;
  BEGIN
    IF wdstr # NIL THEN
      IF Unix.chdir(wdstr) &lt; 0 THEN RETURN END
    END;
    IF NOT (SetFd(0, stdin) AND SetFd(1, stdout) AND SetFd(2, stderr)) THEN
      RETURN
    END;
    FOR fd := 3 TO Unix.getdtablesize() - 1 DO
      EVAL Unix.close(fd) (* ignore errors *)
    END;
    (* Modula-3 ignores SIGPIPE, but most programs don't expect that: *)
    RTSignal.RestoreHandlers();
    res := Unix.execve((*path*)argx[0], ADR(argx[2]), envp);
    &lt;* ASSERT res &lt; 0 *&gt;
    IF Uerror.errno = Uerror.ENOEXEC THEN
      t := argx[0]; argx[0] := argx[2]; argx[2] := t;
      res := Unix.execve(BinSh, ADR(argx[1]), envp);
      &lt;* ASSERT res &lt; 0 *&gt;
    END
  END ExecChild;

EXCEPTION WaitAlreadyCalled;

PROCEDURE <A NAME="Wait"><procedure>Wait</procedure></A>(p: T): ExitCode = &lt;* FATAL WaitAlreadyCalled *&gt;
  VAR result: Ctypes.int;  status: Uexec.w_A;
  CONST Delay = 0.2D0;
  BEGIN
    IF NOT p.waitOk THEN RAISE WaitAlreadyCalled END;
    p.waitOk := FALSE;
    (* By rights, the SchedulerPosix interface should have a WaitPID
       procedure that is integrated with the thread scheduler. *)
    LOOP
      result := Uexec.waitpid(p.pid, ADR(status), Uexec.WNOHANG);
      IF result # 0 THEN EXIT END;
      Thread.Pause(Delay)
    END;
    &lt;* ASSERT result &gt; 0 *&gt;
    IF Word.And(status, LAST(ExitCode)) = status THEN
      RETURN status
    ELSE
      RETURN LAST(ExitCode)
    END
  END Wait;

PROCEDURE <A NAME="Exit"><procedure>Exit</procedure></A>(n: ExitCode) =
  BEGIN
    RTProcess.Exit(n)
  END Exit;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>(msg: TEXT) =
  BEGIN
    RTProcess.Crash(msg)
  END Crash;

PROCEDURE <A NAME="RegisterExitor"><procedure>RegisterExitor</procedure></A>(p: PROCEDURE()) =
  BEGIN
    RTProcess.RegisterExitor(p)
  END RegisterExitor;

PROCEDURE <A NAME="GetID"><procedure>GetID</procedure></A>(p: T): ID =
  BEGIN
    RETURN p.pid
  END GetID;

PROCEDURE <A NAME="GetMyID"><procedure>GetMyID</procedure></A>(): ID =
  BEGIN
    RETURN Uprocess.getpid()
  END GetMyID;

PROCEDURE <A NAME="GetStandardFileHandles"><procedure>GetStandardFileHandles</procedure></A>(VAR stdin, stdout, stderr: File.T) =
  BEGIN
    stdin := stdin_g; stdout := stdout_g; stderr := stderr_g
  END GetStandardFileHandles;

VAR
  wdCacheMutex := NEW(MUTEX);
  wdCache: Pathname.T := NIL; (* NIL =&gt; unknown *)
</PRE><BLOCKQUOTE><EM> The main purpose for this cache is speeding up FS.Iterate when it
   is called with a relative pathname. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="GetWorkingDirectory"><procedure>GetWorkingDirectory</procedure></A>(): Pathname.T RAISES {OSError.E} =
  VAR
    buffer: ARRAY [0..Unix.MaxPathLen] OF Ctypes.char;
    rc: Ctypes.char_star;
  BEGIN
    LOCK wdCacheMutex DO
      IF wdCache = NIL THEN
        rc := Unix.getwd(ADR(buffer[0]));
        IF rc = NIL THEN
          RAISE OSError.E(
            NEW(AtomList.T,
              head := Atom.FromText(M3toC.CopyStoT(ADR(buffer[0]))),
              tail := NIL))
        END;
        wdCache := M3toC.CopyStoT(ADR(buffer[0]))
      END;
      RETURN wdCache
    END
  END GetWorkingDirectory;

PROCEDURE <A NAME="SetWorkingDirectory"><procedure>SetWorkingDirectory</procedure></A>(pn: Pathname.T) RAISES {OSError.E} =
  BEGIN
    LOCK wdCacheMutex DO
      IF Unix.chdir(M3toC.TtoS(pn)) &lt; 0 THEN OSErrorPosix.Raise() END;
      wdCache := NIL
    END
  END SetWorkingDirectory;
</PRE> Initialization 

<P><PRE>PROCEDURE <A NAME="GetFileHandle"><procedure>GetFileHandle</procedure></A>(fd: INTEGER; ds: FilePosix.DirectionSet): File.T =
  VAR f: File.T := NIL;
  BEGIN
    TRY f := FilePosix.New(fd, ds);
    EXCEPT
    | OSError.E =&gt; (* not available *)
    END;
    RETURN f
  END GetFileHandle;

VAR stdin_g, stdout_g, stderr_g: File.T;

BEGIN
  stdin_g := GetFileHandle(0, FilePosix.Read);
  stdout_g := GetFileHandle(1, FilePosix.Write);
  stderr_g := GetFileHandle(2, FilePosix.Write)
END ProcessPosix.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unix.i3#0TOP0">unix/src/freebsd-1/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unix.i3#0TOP0">unix/src/freebsd-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unix.i3#0TOP0">unix/src/irix-5.2/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Uerror is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uerror.i3#0TOP0">unix/src/aix-3-2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uerror.i3#0TOP0">unix/src/aix-ps2-1-2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uerror.i3#0TOP0">unix/src/freebsd-1/Uerror.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uerror.i3#0TOP0">unix/src/freebsd-2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uerror.i3#0TOP0">unix/src/hpux-7-0/Uerror.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uerror.i3#0TOP0">unix/src/ibm-4-3/Uerror.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uerror.i3#0TOP0">unix/src/irix-5.2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/linux/Uerror.i3#0TOP0">unix/src/linux/Uerror.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uerror.i3#0TOP0">unix/src/osf-1.generic/Uerror.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uerror.i3#0TOP0">unix/src/solaris-2-x/Uerror.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uerror.i3#0TOP0">unix/src/sunos-4-x/Uerror.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uerror.i3#0TOP0">unix/src/sysv-4.0/Uerror.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uerror.i3#0TOP0">unix/src/ultrix-3-1.generic/Uerror.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Uexec is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uexec.i3#0TOP0">unix/src/aix-3-2/Uexec.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uexec.i3#0TOP0">unix/src/aix-ps2-1-2/Uexec.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uexec.i3#0TOP0">unix/src/freebsd-1/Uexec.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uexec.i3#0TOP0">unix/src/freebsd-2/Uexec.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uexec.i3#0TOP0">unix/src/hpux-7-0/Uexec.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uexec.i3#0TOP0">unix/src/ibm-4-3/Uexec.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uexec.i3#0TOP0">unix/src/irix-5.2/Uexec.i3</A>
<LI><A HREF="../../../unix/src/linux/Uexec.i3#0TOP0">unix/src/linux/Uexec.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uexec.i3#0TOP0">unix/src/osf-1.generic/Uexec.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uexec.i3#0TOP0">unix/src/solaris-2-x/Uexec.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uexec.i3#0TOP0">unix/src/sunos-4-x/Uexec.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uexec.i3#0TOP0">unix/src/sysv-4.0/Uexec.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Uexec.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Uexec.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Uexec.i3#0TOP0">unix/src/ultrix-3-1.ARM/Uexec.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Uexec.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Uexec.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Uexec.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Uexec.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Uexec.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Uexec.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Uexec.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Uexec.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Uexec.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Uexec.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Uexec.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Uexec.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Uexec.i3#0TOP0">unix/src/ultrix-3-1.VAX/Uexec.i3</A>
</UL>
<P>
<HR>
<A NAME="x4">interface Uprocess is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uprocess.i3#0TOP0">unix/src/aix-3-2/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uprocess.i3#0TOP0">unix/src/aix-ps2-1-2/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uprocess.i3#0TOP0">unix/src/freebsd-1/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uprocess.i3#0TOP0">unix/src/freebsd-2/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uprocess.i3#0TOP0">unix/src/hpux-7-0/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uprocess.i3#0TOP0">unix/src/ibm-4-3/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uprocess.i3#0TOP0">unix/src/irix-5.2/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/linux/Uprocess.i3#0TOP0">unix/src/linux/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uprocess.i3#0TOP0">unix/src/osf-1.generic/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uprocess.i3#0TOP0">unix/src/solaris-2-x/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uprocess.i3#0TOP0">unix/src/sunos-4-x/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uprocess.i3#0TOP0">unix/src/sysv-4.0/Uprocess.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uprocess.i3#0TOP0">unix/src/ultrix-3-1.generic/Uprocess.i3</A>
</UL>
<P>
<HR>
<A NAME="x5">interface Ustat is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Ustat.i3#0TOP0">unix/src/aix-3-2/Ustat.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Ustat.i3#0TOP0">unix/src/aix-ps2-1-2/Ustat.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Ustat.i3#0TOP0">unix/src/freebsd-1/Ustat.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Ustat.i3#0TOP0">unix/src/freebsd-2/Ustat.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Ustat.i3#0TOP0">unix/src/hpux-7-0/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Ustat.i3#0TOP0">unix/src/ibm-4-3/Ustat.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Ustat.i3#0TOP0">unix/src/irix-5.2/Ustat.i3</A>
<LI><A HREF="../../../unix/src/linux/Ustat.i3#0TOP0">unix/src/linux/Ustat.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Ustat.i3#0TOP0">unix/src/osf-1.generic/Ustat.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Ustat.i3#0TOP0">unix/src/solaris-2-x/Ustat.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Ustat.i3#0TOP0">unix/src/sunos-4-x/Ustat.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Ustat.i3#0TOP0">unix/src/sysv-4.0/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Ustat.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Ustat.i3#0TOP0">unix/src/ultrix-3-1.ARM/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Ustat.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Ustat.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Ustat.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Ustat.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Ustat.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Ustat.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Ustat.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Ustat.i3#0TOP0">unix/src/ultrix-3-1.VAX/Ustat.i3</A>
</UL>
<P>
<HR>
<A NAME="x6">interface Utime is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Utime.i3#0TOP0">unix/src/aix-3-2/Utime.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Utime.i3#0TOP0">unix/src/aix-ps2-1-2/Utime.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Utime.i3#0TOP0">unix/src/freebsd-1/Utime.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Utime.i3#0TOP0">unix/src/freebsd-2/Utime.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Utime.i3#0TOP0">unix/src/hpux-7-0/Utime.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Utime.i3#0TOP0">unix/src/ibm-4-3/Utime.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Utime.i3#0TOP0">unix/src/irix-5.2/Utime.i3</A>
<LI><A HREF="../../../unix/src/linux/Utime.i3#0TOP0">unix/src/linux/Utime.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Utime.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utime.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Utime.i3#0TOP0">unix/src/osf-1.DS3100/Utime.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Utime.i3#0TOP0">unix/src/solaris-2-x/Utime.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Utime.i3#0TOP0">unix/src/sunos-4-x/Utime.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Utime.i3#0TOP0">unix/src/sysv-4.0/Utime.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Utime.i3#0TOP0">unix/src/ultrix-3-1.generic/Utime.i3</A>
</UL>
<P>
<HR>
<A NAME="x7">interface Uugid is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uugid.i3#0TOP0">unix/src/aix-3-2/Uugid.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uugid.i3#0TOP0">unix/src/aix-ps2-1-2/Uugid.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uugid.i3#0TOP0">unix/src/freebsd-1/Uugid.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uugid.i3#0TOP0">unix/src/freebsd-2/Uugid.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uugid.i3#0TOP0">unix/src/hpux-7-0/Uugid.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uugid.i3#0TOP0">unix/src/ibm-4-3/Uugid.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uugid.i3#0TOP0">unix/src/irix-5.2/Uugid.i3</A>
<LI><A HREF="../../../unix/src/linux/Uugid.i3#0TOP0">unix/src/linux/Uugid.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uugid.i3#0TOP0">unix/src/osf-1.generic/Uugid.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uugid.i3#0TOP0">unix/src/solaris-2-x/Uugid.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uugid.i3#0TOP0">unix/src/sunos-4-x/Uugid.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uugid.i3#0TOP0">unix/src/sysv-4.0/Uugid.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uugid.i3#0TOP0">unix/src/ultrix-3-1.generic/Uugid.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
