<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/WIN32/FileWin32.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/WIN32/FileWin32.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="FileWin32.m3">FileWin32</A></interface>;

IMPORT <A HREF="../Common/File.i3">File</A>, <A HREF="../Common/OSError.i3">OSError</A>, <A HREF="../Common/Pipe.i3">Pipe</A>, <A HREF="../../../win32/src/WinNT.i3">WinNT</A>;
</PRE> In this interface we reveal that every Win32 <CODE>File.T</CODE> has a handle
   field, <CODE>handle</CODE>. 

<P><PRE>TYPE T = File.Public OBJECT
    handle: WinNT.HANDLE
  END;

REVEAL File.T &lt;: T;

TYPE
  Direction = {Read, Write};
  DirectionSet = SET OF Direction;

CONST
  Read = DirectionSet{Direction.Read};
  Write = DirectionSet{Direction.Write};
  ReadWrite = DirectionSet{Direction.Read, Direction.Write};

PROCEDURE <A HREF="FileWin32.m3#New">New</A>(h: WinNT.HANDLE; ds: DirectionSet): File.T RAISES {OSError.E};
</PRE><BLOCKQUOTE><EM> Create the appropriate subtype of <CODE>File.T</CODE>, based on the
   characteristics of the opened file handle <CODE>h</CODE> and directions <CODE>ds</CODE>.
   If <CODE>WinBase.GetFileType(h) returns </CODE>FILE_TYPE_UNKNOWN<CODE>, the result
   will be </CODE>NIL<CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FileWin32.m3#NewPipe">NewPipe</A>(h: WinNT.HANDLE; ds: DirectionSet): Pipe.T;
</PRE><BLOCKQUOTE><EM> Create a <CODE>Pipe.T</CODE> based on <CODE>h</CODE> and <CODE>ds</CODE>.  It is an unchecked (but safe)
   error if <CODE>h</CODE> is not <CODE>WinBase.FILE_TYPE_PIPE</CODE>. </EM></BLOCKQUOTE><PRE>

END FileWin32.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
