<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/WIN32/FileWin32.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/WIN32/FileWin32.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module><implements><A HREF="FileWin32.i3">FileWin32</A></implements></module>;

IMPORT <A HREF="../Common/File.i3">File</A>, <A HREF="../Common/RegularFile.i3">RegularFile</A>, <A HREF="../Common/Terminal.i3">Terminal</A>, <A HREF="../Common/Pipe.i3">Pipe</A>, <A HREF="../Common/OSError.i3">OSError</A>;
IMPORT <A HREF="../../../win32/src/WinDef.i3">WinDef</A>, <A HREF="../../../win32/src/WinError.i3">WinError</A>, <A HREF="../../../win32/src/WinNT.i3">WinNT</A>, <A HREF="../../../win32/src/WinBase.i3">WinBase</A>;
IMPORT <A HREF="OSErrorWin32.i3">OSErrorWin32</A>, <A HREF="../../../time/src/WIN32/TimeWin32.i3">TimeWin32</A>;

REVEAL
  File.<A NAME="T">T</A> = T BRANDED OBJECT
    ds: DirectionSet;
  OVERRIDES
    write := FileWrite;
    close := FileClose;
    status := FileStatus
  END;

  Pipe.<A NAME="T">T</A> = File.T BRANDED OBJECT
  OVERRIDES
    read := PipeRead
  END;

  Terminal.<A NAME="T">T</A> = File.T BRANDED OBJECT
  OVERRIDES
    read := RegularFileRead
  END;

  RegularFile.<A NAME="T">T</A> = RegularFile.Public BRANDED OBJECT
  OVERRIDES
    read := RegularFileRead;
    seek := RegularFileSeek;
    flush := RegularFileFlush;
    lock := RegularFileLock;
    unlock := RegularFileUnlock
  END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(handle: WinNT.HANDLE; ds: DirectionSet)
  : File.T RAISES {OSError.E}=
  VAR
    ft := WinBase.GetFileType(handle);
  BEGIN
    CASE ft OF
    | WinBase.FILE_TYPE_DISK =&gt;
        RETURN NEW(RegularFile.T, handle := handle, ds := ds)
    | WinBase.FILE_TYPE_CHAR =&gt;
        RETURN NEW(Terminal.T, handle := handle, ds := ds)
    | WinBase.FILE_TYPE_PIPE =&gt; RETURN NewPipe(handle, ds)
    ELSE (* includes FILE_TYPE_UNKNOWN, FILE_TYPE_REMOTE *)
      OSErrorWin32.Raise0(WinError.ERROR_INVALID_HANDLE);
      &lt;*ASSERT FALSE*&gt;
    END;
  END New;

PROCEDURE <A NAME="NewPipe"><procedure>NewPipe</procedure></A>(handle: WinNT.HANDLE; ds: DirectionSet): Pipe.T =
  BEGIN
    RETURN NEW(Pipe.T, handle := handle, ds := ds)
  END NewPipe;
</PRE>---------------------------File methods------------------------------------

<P><PRE>PROCEDURE <A NAME="FileWrite"><procedure>FileWrite</procedure></A>(h: File.T; READONLY b: ARRAY OF File.Byte)
  RAISES {OSError.E} =
  VAR nWritten: INTEGER;
  BEGIN
    IF NOT(Direction.Write IN h.ds) THEN BadDirection(); END;
    IF WinBase.WriteFile(h.handle, ADR(b[0]), NUMBER(b),
                         ADR(nWritten), NIL) = 0 THEN
      OSErrorWin32.Raise()
    END;
    &lt;*ASSERT nWritten = NUMBER(b) *&gt;
  END FileWrite;

PROCEDURE <A NAME="FileClose"><procedure>FileClose</procedure></A>(h: File.T) RAISES {OSError.E} =
  BEGIN
    IF WinBase.CloseHandle(h.handle) = 0 THEN OSErrorWin32.Raise() END
  END FileClose;

PROCEDURE <A NAME="FileStatus"><procedure>FileStatus</procedure></A>(h: File.T): File.Status  RAISES {OSError.E}=
  VAR
    ffd: WinBase.BY_HANDLE_FILE_INFORMATION;
    status: File.Status;
    ft := WinBase.GetFileType(h.handle);
  BEGIN
    CASE ft OF
    | WinBase.FILE_TYPE_DISK =&gt;
        IF WinBase.GetFileInformationByHandle(h.handle, ADR(ffd)) = 0 THEN
          OSErrorWin32.Raise();
        END;
        status.type := RegularFile.FileType;
        status.modificationTime := TimeWin32.FromFileTime(ffd.ftLastWriteTime);
        status.size := ffd.nFileSizeLow
    | WinBase.FILE_TYPE_CHAR =&gt; status.type := Terminal.FileType
    | WinBase.FILE_TYPE_PIPE =&gt; status.type := Pipe.FileType
    ELSE (* includes FILE_TYPE_UNKNOWN, FILE_TYPE_REMOTE *)
      &lt;* ASSERT FALSE *&gt;
    END;
    RETURN status
  END FileStatus;
</PRE>------------------------------Pipe methods---------------------------------

<P><PRE>PROCEDURE <A NAME="PipeRead"><procedure>PipeRead</procedure></A>(
    h: Pipe.T;
    VAR (*out*) b: ARRAY OF File.Byte;
    mayBlock: BOOLEAN := TRUE)
  : INTEGER RAISES {OSError.E} =
  VAR numToRead: WinDef.DWORD := NUMBER(b); numAvail, numRead: WinDef.DWORD;
  BEGIN
    IF NOT(Direction.Read IN h.ds) THEN BadDirection(); END;
    IF NOT mayBlock THEN
      IF WinBase.PeekNamedPipe(
         hNamedPipe := h.handle,
         lpBuffer := NIL,
         nBufferSize := 0,
         lpBytesRead := NIL,
         lpTotalBytesAvail := ADR(numAvail),
         lpBytesLeftThisMessage := NIL) = 0 THEN
        OSErrorWin32.Raise()
      END;
      IF numAvail = 0 THEN RETURN -1 END;
      numToRead := MIN(numAvail, numToRead)
    END;
    IF WinBase.ReadFile(
       h.handle, ADR(b[0]), numToRead, ADR(numRead), NIL) = 0 THEN
      IF WinBase.GetLastError() = WinError.ERROR_BROKEN_PIPE THEN RETURN 0 END;
        (* *** What about ERROR_NO_DATA -- &quot;The pipe is being closed.&quot;
           or ERROR_PIPE_NOT_CONNECTED -- &quot;No process is on the other
           end of the pipe.&quot;? *)
      OSErrorWin32.Raise()
    END;
    RETURN numRead
  END PipeRead;
</PRE>---------------------------RegularFile methods-----------------------------

<P><PRE>PROCEDURE <A NAME="RegularFileRead"><procedure>RegularFileRead</procedure></A>(h: (*Regular*)File.T;
    VAR (*out*) b: ARRAY OF File.Byte;
    &lt;* UNUSED *&gt;mayBlock: BOOLEAN := TRUE): INTEGER RAISES {OSError.E} =
  VAR numRead: INTEGER;
  BEGIN
    IF NOT(Direction.Read IN h.ds) THEN BadDirection(); END;
    IF WinBase.ReadFile(h.handle, ADR(b[0]), NUMBER(b),
                        ADR(numRead), NIL) = 0 THEN
      OSErrorWin32.Raise()
    END;
    RETURN numRead
  END RegularFileRead;

PROCEDURE <A NAME="RegularFileSeek"><procedure>RegularFileSeek</procedure></A>(
    h: RegularFile.T; origin: RegularFile.Origin; offset: INTEGER)
  : INTEGER RAISES {OSError.E} =
  BEGIN
    WITH res = WinBase.SetFilePointer(h.handle, offset, NIL, ORD(origin)) DO
      IF res &lt; 0 THEN OSErrorWin32.Raise() END;
      RETURN res
    END
  END RegularFileSeek;

PROCEDURE <A NAME="RegularFileFlush"><procedure>RegularFileFlush</procedure></A>(h: RegularFile.T) RAISES {OSError.E}=
  BEGIN
    IF WinBase.FlushFileBuffers(h.handle) = 0 THEN OSErrorWin32.Raise() END
  END RegularFileFlush;

PROCEDURE <A NAME="RegularFileLock"><procedure>RegularFileLock</procedure></A>(h: RegularFile.T): BOOLEAN RAISES {OSError.E}=
  BEGIN
    IF WinBase.LockFile(
         hFile := h.handle,
         dwFileOffsetLow := 0,
         dwFileOffsetHigh := 0,
         nNumberOfBytesToLockLow := LAST(WinDef.DWORD),
         nNumberOfBytesToLockHigh := LAST(WinDef.DWORD)) = 0 THEN
      IF WinBase.GetLastError() = WinError.ERROR_LOCK_VIOLATION THEN
        RETURN FALSE
      END;
      OSErrorWin32.Raise()
    END;
    RETURN TRUE
  END RegularFileLock;

PROCEDURE <A NAME="RegularFileUnlock"><procedure>RegularFileUnlock</procedure></A>(h: RegularFile.T) RAISES {OSError.E}=
  BEGIN
    IF WinBase.UnlockFile(
         hFile := h.handle,
         dwFileOffsetLow := 0,
         dwFileOffsetHigh := 0,
         nNumberOfBytesToUnlockLow := LAST(WinDef.DWORD),
         nNumberOfBytesToUnlockHigh := LAST(WinDef.DWORD)) = 0 THEN
      OSErrorWin32.Raise()
    END;
  END RegularFileUnlock;
</PRE>------------------------------------------------ checked runtime errors ---

<P><PRE>EXCEPTION IllegalDirection;

PROCEDURE <A NAME="BadDirection"><procedure>BadDirection</procedure></A> () =
  &lt;*FATAL IllegalDirection*&gt;
  BEGIN
    RAISE IllegalDirection;
  END BadDirection;

BEGIN
END FileWin32.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
