<HTML>
<HEAD>
<TITLE>SRC Modula-3: os/src/WIN32/PathnameWin32.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>os/src/WIN32/PathnameWin32.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>PathnameWin32</module> EXPORTS <A HREF="../Common/Pathname.i3"><implements>Pathname</A></implements>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>;

CONST
  DirSepChar = '\\'; DirSepText = &quot;\\&quot;;
  DriveSepChar = ':';
  ExtSepChar = '.';  ExtSepText = &quot;.&quot;;

CONST Legal = SET OF CHAR {'\001' .. '\177'} - SET OF CHAR {DirSepChar, ':'};
  (* *** This should be as permissive as any NT file system. *)

TYPE Visit = PROCEDURE(start, len: INTEGER);

PROCEDURE <A NAME="Valid"><procedure>Valid</procedure></A>(pn: T): BOOLEAN =
  PROCEDURE Ignore(&lt;* UNUSED *&gt; start, len: INTEGER) = BEGIN END Ignore;
  BEGIN
    TRY ParsePN(pn, visit := Ignore)
    EXCEPT Invalid =&gt; RETURN FALSE
    END;
    RETURN TRUE
  END Valid;

PROCEDURE <A NAME="Decompose"><procedure>Decompose</procedure></A>(pn: T): Arcs RAISES {Invalid} =
  VAR arcs := NEW(Arcs).init();
  PROCEDURE Add(start, len: INTEGER) =
    BEGIN
      IF start &gt;= 0 THEN arcs.addhi(Text.Sub(pn, start, len))
      ELSE arcs.addhi(NIL)
      END
    END Add;
  BEGIN
    ParsePN(pn, visit := Add);
    RETURN arcs
  END Decompose;

PROCEDURE <A NAME="Compose"><procedure>Compose</procedure></A>(a: Arcs): T RAISES {Invalid} =
  VAR t: TEXT;
  BEGIN
    WITH n = a.size() DO
      IF n = 0 THEN RAISE Invalid END;
      t := a.getlo();
      IF t # NIL THEN
        WITH nRoot = Text.Length(t) DO
          IF ParseRoot(t) # nRoot THEN RAISE Invalid END;
          IF Text.GetChar(t, 0) = DirSepChar AND
             Text.GetChar(t, nRoot - 1) # DirSepChar THEN
            t := t &amp; DirSepText
          END
        END
      ELSE t := &quot;&quot;
      END;
      FOR i := 1 TO n-1 DO
        WITH arc = a.get(i) DO
          IF arc = NIL THEN RAISE Invalid END;
          FOR i := 0 TO Text.Length(arc) - 1 DO
            IF NOT Text.GetChar(arc, i) IN Legal THEN RAISE Invalid END
          END;
          t := t &amp; arc
        END;
        IF i # n-1 THEN t := t &amp; DirSepText END
      END;
      RETURN t
    END
  END Compose;

PROCEDURE <A NAME="Absolute"><procedure>Absolute</procedure></A>(pn: T): BOOLEAN =
  BEGIN
    TRY RETURN ParseRoot(pn) # 0
    EXCEPT Invalid =&gt; RETURN TRUE (* started with \ *)
    END
  END Absolute;

PROCEDURE <A NAME="Prefix"><procedure>Prefix</procedure></A>(pn: T): T =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    IF baseLwb = 0 THEN RETURN &quot;&quot; END;
    TRY
      WITH nRoot = ParseRoot(pn) DO
        IF baseLwb &lt;= nRoot THEN baseLwb := nRoot + 1 END
      END
    EXCEPT Invalid =&gt; RETURN pn
    END;
    RETURN Text.Sub(pn, 0, baseLwb - 1)
  END Prefix;

PROCEDURE <A NAME="Last"><procedure>Last</procedure></A>(pn: T): T =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    TRY
      WITH nRoot = ParseRoot(pn) DO
        IF baseLwb &lt;= nRoot THEN baseLwb := nRoot END
      END
    EXCEPT Invalid =&gt; RETURN &quot;&quot;
    END;
    RETURN Text.Sub(pn, baseLwb, extUpb - baseLwb)
  END Last;

PROCEDURE <A NAME="Base"><procedure>Base</procedure></A>(pn: T): T =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    RETURN Text.Sub(pn, 0, baseUpb)
  END Base;

EXCEPTION CheckedRuntimeError; &lt;* FATAL CheckedRuntimeError *&gt;

PROCEDURE <A NAME="Join"><procedure>Join</procedure></A>(pn, base: T; ext: TEXT): T =
  VAR t := base;
  BEGIN
    IF pn # NIL THEN
      IF Absolute(base) THEN RAISE CheckedRuntimeError END;
      WITH n = Text.Length(pn) DO
        IF n # 0 THEN
          WITH c = Text.GetChar(pn, n - 1) DO
            IF c # DirSepChar AND c # DriveSepChar THEN
              pn := pn &amp; DirSepText
            END
          END;
          t := pn &amp; t
        END
      END
    END;
    IF ext # NIL THEN t := t &amp; ExtSepText &amp; ext END;
    RETURN t
  END Join;

PROCEDURE <A NAME="LastBase"><procedure>LastBase</procedure></A>(pn: T): T =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    RETURN Text.Sub(pn, baseLwb, baseUpb - baseLwb)
  END LastBase;

PROCEDURE <A NAME="LastExt"><procedure>LastExt</procedure></A>(pn: T): TEXT =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    IF baseUpb = extUpb THEN RETURN &quot;&quot; END;
    RETURN Text.Sub(pn, baseUpb + 1, extUpb - (baseUpb + 1))
  END LastExt;

PROCEDURE <A NAME="ReplaceExt"><procedure>ReplaceExt</procedure></A>(pn: T; ext: TEXT): T =
  VAR baseLwb, baseUpb, extUpb: CARDINAL;
  BEGIN
    NameSections(pn, baseLwb, baseUpb, extUpb);
    IF baseUpb = extUpb THEN RETURN pn END; (* nothing to replace *)
    RETURN Text.Sub(pn, 0, baseUpb) &amp; ExtSepText &amp; ext
  END ReplaceExt;
</PRE> Internal procedures. 

<P><PRE>PROCEDURE <A NAME="ParseRoot"><procedure>ParseRoot</procedure></A>(t: TEXT): CARDINAL RAISES {Invalid} =
  (* Return the length of the longest prefix of &quot;t&quot; that has the form:
       \
       \\server\share
       drive:\
       drive:
     or raise &quot;Pathname.Invalid&quot; if &quot;t&quot; begins with something malformed. *)
  BEGIN
    WITH n = Text.Length(t) DO
      IF n = 0 THEN RETURN 0 END;
      WITH c = Text.GetChar(t, 0) DO
        IF c = DirSepChar THEN
          IF n = 1 OR Text.GetChar(t, 1) # DirSepChar THEN RETURN 1 END;
          VAR seenName, seenShare := FALSE; BEGIN
            FOR i := 2 TO n - 1 DO
              WITH cc = Text.GetChar(t, i) DO
                IF cc = DirSepChar THEN
                  IF seenShare THEN
                    IF seenName THEN RETURN i + 1 END;
                    RAISE Invalid
                  END;
                  seenShare := TRUE; seenName := FALSE
                ELSE
                  IF NOT cc IN Legal THEN RAISE Invalid END;
                  seenName := TRUE
                END
              END
            END;
            IF NOT seenShare OR NOT seenName THEN RAISE Invalid END;
          END;
          RETURN n
        END;
        IF ('a' &lt;= c AND c &lt;= 'z' OR 'A' &lt;= c AND c &lt;= 'Z') AND
           n &gt; 1 AND Text.GetChar(t, 1) = DriveSepChar THEN
          IF n &gt; 2 AND Text.GetChar(t, 2) = DirSepChar THEN RETURN 3 END;
          RETURN 2
        END;
        RETURN 0
      END
    END
  END ParseRoot;

PROCEDURE <A NAME="ParsePN"><procedure>ParsePN</procedure></A>(pn: T; visit: Visit) RAISES {Invalid} =
  (* Call &quot;visit(s, n)&quot; for each arc name (including root) within &quot;pn&quot;
     starting at character &quot;s&quot; of length &quot;n&quot; characters. Special case:
     call &quot;visit(-1, 0)&quot; to indicate NIL root of relative pathname. *)
  VAR
    nRoot: CARDINAL; (* length of root, or zero if &quot;pn&quot; is relative *)
    s, e: CARDINAL; (* bounds of next arc to visit *)
  BEGIN
    WITH n = Text.Length(pn) DO
      nRoot := ParseRoot(pn);
      IF nRoot # 0 THEN visit(0, nRoot) ELSE visit(-1, 0) END;
      s := nRoot; e := s;
      WHILE e &lt; n DO
        WITH c = Text.GetChar(pn, e) DO
          IF c = DirSepChar THEN
            visit(s, e - s);
            s := e + 1
          ELSIF NOT c IN Legal THEN
            RAISE Invalid
          END
        END;
        INC(e)
      END;
      IF nRoot # 0 AND nRoot = n THEN
        (* Map DirSepText to [DirSepText] rather than [DirSepText, &quot;&quot;]. *)
        (*SKIP*)
      ELSE visit(s, e - s) END
    END
  END ParsePN;

PROCEDURE <A NAME="NameSections"><procedure>NameSections</procedure></A>(
    pn: T;
    VAR baseLwb, baseUpb, extUpb: CARDINAL)
  RAISES {} =
</PRE><BLOCKQUOTE><EM> Perform the following assignments:
  baseLwb := the index of the first character of the last component of pn;
  baseUpb := the index of the character separating the extension and base
             of the last component of pn, or Length(pn) if there is no
             extension;
  extUpb  := Length(pn) </EM></BLOCKQUOTE><PRE>
  VAR pos: CARDINAL; ch: CHAR;
  BEGIN
    extUpb := Text.Length(pn);
    pos := extUpb;
    baseUpb := extUpb;
    LOOP
      IF pos &gt; 0 THEN
        DEC(pos);
        ch := Text.GetChar(pn, pos);
        IF ch = DirSepChar OR ch = DriveSepChar THEN
          baseLwb := pos + 1;
          EXIT
        ELSIF ch = ExtSepChar THEN
          baseUpb := pos
        END
      ELSE
        baseLwb := 0;
        EXIT
      END
    END
  END NameSections;

BEGIN
  Parent := &quot;..&quot;;
  Current := &quot;.&quot;
END PathnameWin32.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
