<HTML>
<HEAD>
<TITLE>SRC Modula-3: params/src/Env.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>params/src/Env.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="Env.i3">Env</A></implements></module>;

IMPORT <A HREF="../../C/src/Common/Cstdlib.i3">Cstdlib</A>, <A HREF="../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../../runtime/src/common/RTArgs.i3">RTArgs</A>, <A HREF="../../text/src/Text.i3">Text</A>;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(nm: TEXT): TEXT =
  VAR cRes := Cstdlib.getenv(M3toC.TtoS(nm));
  BEGIN
    IF cRes = NIL THEN
      RETURN NIL
    ELSE
      RETURN M3toC.CopyStoT(cRes)
    END
  END Get;

EXCEPTION FatalError; &lt;* FATAL FatalError *&gt;

PROCEDURE <A NAME="GetNth"><procedure>GetNth</procedure></A>(n: CARDINAL; VAR (*OUT*) nm, val: TEXT) =
  VAR
    env: TEXT;
    i: CARDINAL;
  BEGIN
    IF n &gt;= Count THEN RAISE FatalError END;
    env := RTArgs.GetEnv(n);
    i := 0;
    WHILE Text.GetChar(env, i) # '=' DO INC(i) END;
    nm := Text.Sub(env, 0, i);
    val := Text.Sub(env, i + 1, Text.Length(env)-(i+1));
  END GetNth;

BEGIN
  Count := RTArgs.EnvC();
END Env.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
